<?php

/*

YapBB, a fully functional bulletin board system
Copyright (C) 2000/01  Arno van der Kolk
http://yapbb.sourceforge.net/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/


//=====================================================================================================================
// Basic configuration: (you *HAVE* to make sure these values are correct!)
//=====================================================================================================================

	//	Power switch :)

		$cfgBoardDisabled			= FALSE;				// When true, all operations on the board are disabled.


	//	SETUP - User is required to alter these values to make sure they are correct
	//	note: the '-->' means 'will generate' or 'becomes'

		$cfgAnonymousUser			= "Guest";				// Setting this to "" (empty), disables the anonymous user.
															// Make sure this string always has the correct name of the anonymous user.
															// Also, this user is expected to have NO password (ie: empty)

		$cfgValidateSettings		= TRUE;					// This will check some of the values you enter here.
															// Set it to false to speed things up a bit and if you're sure
															// everything works like it should.

		$cfgSiteHomeURL				= 'http://www.yoursite.com/';	// the link that leads to 'home' (ie: the site on which the forum is installed)
		$cfgDocumentRoot			= '/home/www/forum/';	// directory to YapBB on the server (eg: C:/Program Files/Apache Group/Apache/htdocs/YapBB/)
		$cfgBaseDirectory			= '/forum/';			// root URL of YapBB on the server (eg: /YapBB/) (--> http://yoursite/YapBB/)

		$cfgForumTitle				= "Yoursite Forums";	// title of the forum
		$cfgSiteTitle				= "Yoursite";			// title of the site hosting the forum (will be included at the bottom of each page)
		$cfgEmail					= 'admin@yoursite.com';	// email of the web master/forum admin (will be included at the bottom of each page)
		$cfgSiteHostName			= '';					// Site where this forum resides (ONLY a hostname or IP) - leave empty if you don't run into any trouble
		$cfgSiteHostPort			= '';					// Port of website on the site - leave empty for default port (80)


	// MySQL CONFIGURATION

		$cfgServerHost				= 'localhost';			// hostname
		$cfgServerPort				= '';					// port - leave blank for default port (3306)
		$cfgServerUser				= 'root';				// user
		$cfgServerPassword			= '';					// password

		$cfgDatabase['database']	= 'yapbb';				// name of MySQL database containing YapBB database


//=====================================================================================================================
// Tweaking the forum: (we recommend that you review these settings and only change them when needed)
//=====================================================================================================================

	//	CONFIGURATION - Change the workings of the forums

		$cfgServerTimezone			= -8;					// Assume server is located in PST zone (Pacific Standard Time)
																// Specify hours relative to GMT (Greenwich Mean Time)
		$cfgAllowUserToDeletePost	= FALSE;				// Allow users to delete their own posts
		$cfgAllowDangerousHTML		= FALSE;				// disable <!-- and <SCRIPT> tags even when HTML is on
		$cfgAllowHTMLinProfile		= FALSE;				// when disabled, all HTML in user profiles will be filtered
		$cfgAllowHTMLinSignature 	= FALSE;				// when disabled, all HTML in signatures will be filtered
		$cfgProcessSmilies			= TRUE;					// convert certain keycodes to the appropriate emoticons
		$cfgShowUserStatus			= TRUE;					// display the achieved status of regular users (may degrade performance a bit)
		$cfgCountViews				= TRUE;					// keep track of how many times a topic has been viewed (may degrade performance a bit)
		$cfgCountUsers				= TRUE;					// keep track of how many users there are online (may degrade performance a bit)
		$cfgDisplayPostsWhenPosting = FALSE;				// display the list of posts in a topic when replying (not implemented yet)
		$cfgDisplayPostsWhenEditing = FALSE;				// display the list of posts in a topic when editing a post (not implemented yet)
		$cfgAllowUserNickChange		= FALSE;				// prevents users from altering their nicknames
		$cfgShowMySQLFalseErrors	= FALSE;				// (leave this as it is, unless required otherwise!) occasionally, MySQL generates an error, without any description
															// set this to TRUE to show these errors
		$cfgUseCompression			= FALSE;				// determines whether or not to use GZ compression when the browser accepts it
		$cfgSubscriptionMailInterval= 20;					// mail a thread subscription email (when needed) every X minutes
		$cfgAdvancedTemplateEngine  = FALSE;				// You can set this to true if you have writing privileges in the directory
																// to which $cfgTemplateDirectory points.
																// There's a siginificant speed advantage when using the new engine.
		$cfgIgnoreNicknameCase		= FALSE;				// When set to TRUE, users can register using a new nickname, when one already exists, but with different case
																// eg. when the user 'dummy' exists and this is set to TRUE
																// others can register using 'Dummy', or 'DUMMY'
																// Set to FALSE to disable
		$cfgCookiePrefix			= "yapbb1_";			// The prefix to use for identifying cookies. This is only meaningful when there are 2 or
																// more installed YapBB's on the same webserver.


	//	DEFAULT USER PREFERENCES - These settings are subject to user's taste

		$cfgClientTimezone			= +1;					// Assume user is in CET zone (Central European Time)
																// Specify hours relative to GMT (Greenwich Mean Time)
		$cfgTopicSortWhichPost		= FALSE;				// sort by first post in topic (vs last post)
		$cfgTopicSortWhichWay		= TRUE;					// sort descending newest items first (vs oldest items - ascending)
		$cfgPostSortWhichWay		= FALSE;				// sort by time descending (vs ascending)
		$cfgTopicsOnLastDays		= 0;					// specify topics of how many seconds old are shown
																// valid values are: (ie: NO CUSTOM VALUES!)
																// 86400 = Last day
																// 172800 = Last 2 days
																// 259200 = Last 3 days
																// 604800 = Last week
																// 1209600 = Last 2 weeks
																// 2678400 = Last month
																// 5356800 = Last 2 months
																// 8035200 = Last 3 months
																// 16070400 = Last 6 months
																// 32140800 = Last year
																// 64281600 = Last 2 years
																// 0 = no limit
		$cfgRefreshInterval			= 0;					// in minutes
		$cfgThreadsPerPage			= 50;					// 0 = no limit
		$cfgPostsPerPage			= 25;					// 0 = no limit
		$cfgDateFormat				= "DMY";				// Date format
																// valid values are: DMY, MDY, YDM, YMD
		$cfgPageSizeInPixels		= TRUE;					// use absolute size (in stead of relative size - in %)
		$cfgPageSizeWidth			= "750";				// in pixels or % (depends on $cfgPageSizeInPixels)
		$cfgTemplateName			= 'Default';			// name of your template (case sensitive!)
		$cfgShowForumDescriptions	= TRUE;					// Enables or disables the descriptive comments (if available)
		$cfgAnnouncementCount		= 5;					// Entering a 0 will disable announcements. Sticky announcements will always be displayed (unless equals 0)
		$cfgShowSignatures			= TRUE;					// Enables or disables the user-signatures
		$cfgShowAvatars				= TRUE;					// Enables or disables the user-avatars


//=====================================================================================================================
// Advanced configuration: (only change these settings if you know what you are doing)
//=====================================================================================================================

	//	SETUP - User is required to alter these values to make sure they are correct
	//	note: the '-->' means 'will generate' or 'becomes'

		$cfgIncludeDirectory		= 'include/';			// (do not alter, unless required otherwise!) is a subdirectory of $cfgDocumentRoot ! (--> /home/www/YapBB/include/)
		$cfgTemplateDirectory		= 'templates/';			// (do not alter, unless required otherwise!) is a subdirectory of $cfgDocumentRoot ! (--> /home/www/YapBB/templates/)
		$cfgTmpDirectory			= 'tmp/';				// (do not alter, unless required otherwise!) is a subdirectory of $cfgDocumentRoot ! (--> /home/www/YapBB/tmp/)
		$cfgImageDirectory			= 'images/';			// (do not alter, unless required otherwise!) is a subdirectory of $cfgBaseDirectory ! (--> http://yoursite/YapBB/images/)
		$cfgAvatarDirectory			= 'avatars/';			// (do not alter, unless required otherwise!) is a subdirectory of $cfgImageDirectory ! (--> http://yoursite/YapBB/images/avatars/)
		$cfgSmiliesDirectory		= 'smilies/';			// (do not alter, unless required otherwise!) is a subdirectory of $cfgImageDirectory ! (--> http://yoursite/YapBB/images/avatars/)


	// MySQL CONFIGURATION

	//	Optionally, you can alter these table names:
		$cfgDatabase['announcement']= 'forum_announcement';	// Name for table 'announcement';
		$cfgDatabase['avatar']		= 'forum_avatar';		// Name for table 'avatar';
		$cfgDatabase['bannedemail']	= 'forum_bannedemail';	// Name for table 'bannedemail';
		$cfgDatabase['category']	= 'forum_category';		// Name for table 'category';
		$cfgDatabase['forum']		= 'forum_forum';		// Name for table 'forum';
		$cfgDatabase['ipban']		= 'forum_ipban';		// Name for table 'ipban';
		$cfgDatabase['moderator']	= 'forum_moderator';	// Name for table 'moderator';
		$cfgDatabase['post']		= 'forum_post';			// Name for table 'post';
		$cfgDatabase['search_index']= 'forum_search_index';	// Name for table 'search_index';
		$cfgDatabase['session']		= 'forum_session';		// Name for table 'session';
		$cfgDatabase['status']		= 'forum_status';		// Name for table 'status';
		$cfgDatabase['subscription']= 'forum_subscription';	// Name for table 'subscription';
		$cfgDatabase['topic']		= 'forum_topic';		// Name for table 'topic';
		$cfgDatabase['user']		= 'forum_user';			// Name for table 'user';
		$cfgDatabase['useronline']	= 'forum_useronline';	// Name for table 'useronline';
		$cfgDatabase['user_vars']	= 'forum_user_vars';	// Name for table 'user_vars';


	//	CONFIGURATION - Change the workings of the forums (we recommend that you leave these values unaltered)

//		$cfgTemplateOpenTag			= '{';					// Specify how to recognize tags in the templates
//		$cfgTemplateCloseTag		= '}';					// Specify how to recognize tags in the templates
		$cfgMaxLengthNickname		= 25;					// Nicknames can't be longer than this many characters
		$cfgMaxLengthPassword		= 13;					// Passwords can't be longer than this many characters
		$cfgMinLengthNickname		= 1;					// Nicknames can't be shorter than this many characters
		$cfgMinLengthPassword		= 6;					// Passwords can't be shorter than this many characters
		$cfgOnlineTime				= 10;					// in minutes. This keeps track of users who have been on the board during the last X minutes
		$cfgFloodTime				= 30;					// in seconds. Specify how many time there must be between 2 posts of the same user
		$cfgPHP3compatibility		= FALSE;				// with this set to true, certain PHP4 functions are disabled or emulated (may slow down a bit)
																// (this setting is ignored when run on PHP3 systems)


	// SPECIAL

		$cfgAdminPage				= "admin.php";	// The admin page. If you change it's name (which you are
															// encouraged to do), you have to change the name here as
															// well, or you'll won't be able to administer the forum on
															// the admin pages when the board has been 'turned off'
															// (see $cfgBoardDisabled).


//=====================================================================================================================
// End of configuration
// !!! DO NOT CHANGE THE FOLLOWING: !!!
//=====================================================================================================================

		$includeBit = TRUE;
		require($cfgIncludeDirectory . "global.php");

?>