<?php require("./config.inc.php");

/*

YapBB, a fully functional bulletin board system
Copyright (C) 2000/01  Sven Vintges
http://yapbb.sourceforge.net/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

//=====================================================================================================================
// Description: find posts and users
//=====================================================================================================================


//=====================================================================================================================
// Choose course of action
//=====================================================================================================================
$topicBool = $HTTP_POST_VARS["choice"]=="topic";
$userBool = $HTTP_POST_VARS["choice"]=="user";
$postBool = $HTTP_POST_VARS["choice"]=="post";
$userpostBool = !empty($HTTP_GET_VARS["userID"]);
$anyBool = $topicBool || $userBool || $postBool || $userpostBool;

if($topicBool)
{

//=====================================================================================================================
// Action-branch: find thread
//=====================================================================================================================
	$topicQuery = new MySQL;
	$topRes = $topicQuery->select("SELECT p.date, t.postid, t.description, t.id, t.forumid, t.active, f.name FROM " . $cfgDatabase['post'] ." AS p, ".$cfgDatabase['topic']." AS t, " . $cfgDatabase['forum'] .  " AS f WHERE t.forumid = f.id AND p.id = t.postid AND t.description LIKE '" . addSlashes("%" . $HTTP_POST_VARS["lijst"] . "%") . "' GROUP BY t.id ORDER BY t.description");
	$kleur = 1;
	$topic = array(array());
	for ($teller = 0; $teller < $topicQuery->rows; $teller++)
	{

//topic-info
		$topic[$teller]["Color"] = $teller % 2 + 1;
		$topic[$teller]["topicID"] = $topRes[$teller]["id"];
		$topic[$teller]["topicDescription"] = htmlspecialchars(stripslashes($topRes[$teller]["description"]));

//Forum-info
		$topic[$teller]['forumID'] = $topRes[$teller]['forumid'];
		$topic[$teller]['forumName'] = htmlspecialchars(stripslashes($topRes[$teller]['name']));

		$topic[$teller]["topicActive"] = "<img alt='active' width='14' src=\"" . $cfgImageURL;
		if($topRes[$teller][active] == 1) // Rij is actief!!
			$topic[$teller]["topicActive"] .= "open.gif\" height='12'>";
		else
			$topic[$teller]["topicActive"] .= "closed.gif\" height='15'>";

//post-inf
		$topic[$teller]["lastPostDate"] = getDateTime($topRes[$teller]['date']);
	}
	unset($topicQuery);
	unset($topRes);
}
else if($userBool)
{

//=====================================================================================================================
// Action-branch: find user
//=====================================================================================================================
	$userQuery = new MySQL;
	$usrRes = $userQuery->select("SELECT * FROM ".$cfgDatabase['user']." WHERE nickname LIKE '" .addSlashes("%".$HTTP_POST_VARS["lijst"]."%"). "'");
	$kleur = 1;
	$user = array(array());
	for ($teller = 0; $teller < $userQuery->rows; $teller++)
	{
		$user[$teller]["Color"] = $teller % 2 + 1;
		$user[$teller]["userID"] = $usrRes[$teller]["id"];
		$user[$teller]["userName"] = htmlspecialchars(stripslashes($usrRes[$teller]["nickname"]));
	}
	unset($userQuery);
	unset($usrRes);
}
else if($postBool)
{

//=====================================================================================================================
// Action-branch: find thread (search in contents)
//=====================================================================================================================
//	$postQuery = new MySQL;
//	$postRes = $postQuery->select("SELECT t.description, u.nickname, p.* FROM " . $cfgDatabase['topic'] . " AS t, ".$cfgDatabase['post']." AS p, " . $cfgDatabase['user'] . " AS u WHERE t.id = p.topicid AND p.posterid = u.id AND p.text LIKE '" .addSlashes("%".$HTTP_POST_VARS["lijst"]."%"). "' GROUP BY t.id ORDER BY t.description");
	$searcher = new Searcher();
	$postRes = $searcher->search_topic(explode(" ", $HTTP_POST_VARS['lijst']), FALSE);
	$count = count($postRes);
	$kleur = 1;
	$post = array(array());
	for ($teller = 0; $teller < $count; $teller++)
	{
		$post[$teller]["Color"] = $teller % 2 + 1;
		$post[$teller]["topicId"] = $postRes[$teller]["topicid"];
		$post[$teller]["date"] = getDateTime($postRes[$teller]["date"]);

		$post[$teller]["userId"] = $postRes[$teller]["posterid"];
		$post[$teller]["nickName"] = htmlspecialchars(stripslashes($postRes[$teller]["nickname"]));

		$post[$teller]["topicDesc"] = htmlspecialchars(stripslashes($postRes[$teller]["description"]));
	}
	unset($postQuery);
	unset($postRes);
}
else if ($userpostBool)
{

//=====================================================================================================================
// Action-branch: find history of user posts
//=====================================================================================================================
	// todo: nice navigational controls
	$postQuery = new MySQL;
//	$postRes = $postQuery->select("SELECT p.date, t.id, t.description, u.nickname FROM " . $cfgDatabase['post'] . " AS p, " . $cfgDatabase['topic'] . " AS t, " . $cfgDatabase['user'] . " AS u WHERE t.postid = p.id AND p.posterid = $userID AND u.id = p.posterid GROUP BY p.topicid ORDER BY p.date DESC LIMIT 50");
	$postRes = $postQuery->select("SELECT p.date, t.id, t.description, u.nickname FROM " . $cfgDatabase['post'] . " AS p, " . $cfgDatabase['topic'] . " AS t, " . $cfgDatabase['user'] . " AS u WHERE t.id = p.topicid AND p.posterid = $userID AND u.id = p.posterid GROUP BY p.topicid ORDER BY p.date DESC LIMIT 50");
	$post = array(array());
	for ($i = 0; $i < $postQuery->rows; $i++)
	{
		$post[$i]["Color"] = $i % 2 + 1;
		$post[$i]["topicId"] = $postRes[$i]['id'];
		$post[$i]["nickName"] = htmlspecialchars(stripslashes($postRes[$i]['nickname']));
		$post[$i]["topicDesc"] = htmlspecialchars(stripslashes($postRes[$i]['description']));
		$post[$i]["date"] = getDateTime($postRes[$i]['date']);
	}
	unset($postQuery);
}
/*else
{
	sendError("pe: error in find.php: wrong boolean");
}*/


//=====================================================================================================================
// Template stuff
//=====================================================================================================================
if(!$template->load_file($templateHandler,"$cfgTemplateDirectory$cfgTemplateName/find.ybt"))
	if(!$template->load_file($templateHandler,$cfgTemplateDirectory."Default/find.ybt"))
		sendError("pe: Could not load Template (find.ybt)!");
$template->parse($templateHandler);
if ($userBool != false) $template->parse_loop($templateHandler,"user");
if ($topicBool != false) $template->parse_loop($templateHandler,"topic");
if ($postBool != false) $template->parse_loop($templateHandler,"post");
if ($userpostBool != false) $template->parse_loop($templateHandler,"post");
echo $template->return_file($templateHandler);
if ($cfgUseCompression) gzdocout();

require($cfgIncludeDirectory . "cleanup.php");
?>
