<?php require("./config.inc.php");

/*

YapBB, a fully functional bulletin board system
Copyright (C) 2000/01  Arno van der Kolk
http://yapbb.sourceforge.net/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

//=====================================================================================================================
// Description: Display list of topics in forum ($forumID)
//=====================================================================================================================

$forumID++; $forumID--;



//=====================================================================================================================
// Legacy code
//=====================================================================================================================

if ($forumID <= 0)
{
	header("Location: " . $cfgBaseURL . "frontpage.php?" . getenv('QUERY_STRING'));
	exit;
}


//=====================================================================================================================
// Authenticate user
//=====================================================================================================================

	$forumQuery = new MySQL;
	$forRes = $forumQuery->select("SELECT password, name FROM " . $cfgDatabase['forum'] . " WHERE id = $forumID");
	if ($forumQuery->rows == 0)
		sendError("ue: Invalid forum");

	$forumResultRow = $forRes[0];
	require($cfgIncludeDirectory . "forumpassword.php");
	unset($forumResultRow);

	$auth = getModeratorValidation($forumID);

//=====================================================================================================================
// Template stuff
//=====================================================================================================================

	$PAGE_TITLE = $forRes[0]['name'];

	if (!$template->load_file($templateHandler, "$cfgTemplateDirectory$cfgTemplateName/topicList.ybt"))
		if (!$template->load_file($templateHandler, $cfgTemplateDirectory . "Default/topicList.ybt"))
			sendError("pe: Could not load template (topicList.ybt)!");
	$loop = "tops";


//=====================================================================================================================
// Get all topics in this forum ($forumID)
//=====================================================================================================================

	$topicQuery = new MySQL;
	$topRes = $topicQuery->select("SELECT t.*, p.posterid AS lastPostPosterID, p.date AS lastPostDate, u.nickname AS lastPostNickname FROM " . $cfgDatabase['post'] . " AS p, " . $cfgDatabase['topic'] . " as t, " . $cfgDatabase['user'] . " AS u WHERE t.forumid = $forumID AND " . (($cfgTopicSortWhichPost)?"t.postid":"t.lastpostid") . " = p.id AND u.id = p.posterid " . (($cfgTopicsOnLastDays > 0)?"AND p.date > " . (string)(time() - $cfgTopicsOnLastDays) . " ":"") . "ORDER BY p.date " . (($cfgTopicSortWhichWay)?"DESC":"ASC"));


//=====================================================================================================================
// Calculate '<< Previous' and 'Next >>' markers (if applicable)
//=====================================================================================================================

	$count = $cfgThreadsPerPage;
	if ($count > $topicQuery->rows || $count <= 0) $count = $topicQuery->rows;

	$tmp = $begin;
	if ($tmp > $topicQuery->rows) $tmp = $topicQuery->rows;
	$begin = 1;
	while ($begin + $count <= $tmp && $begin <= $topicQuery->rows)
		$begin += $count;

//	$topicNavigation .= "<option value='0' class='empty'>" . ($topicQuery->rows % $count == 0?$topicQuery->rows / $count:(1 + Floor($topicQuery->rows / $count))) . " " . $lang['pages'] . "</option>";
	if ($areNext = ($begin + $count <= $topicQuery->rows && $begin > 0))		// if there are more topics in the list (next page)
	{
		$topicNavigation .= "<option value='" . ($begin + $count) . "' class='empty'>";
		$topicNavigation .= $lang['next'] . " $langPage";
		$topicNavigation .= "</option>";
	}
	if ($arePrev = ($begin > 1 && $begin <= $topicQuery->rows))				// if there are more topics in the list (previous page)
	{
		$topicNavigation .= "<option value='" . ($begin - $count) . "' class='empty'>";
		$topicNavigation .= $lang['previous'] . " $langPage";
		$topicNavigation .= "</option>";
	}
	if ($areNext || $arePrev)
		$topicNavigation .= "<option value='0' class='seperator'>------</option>";
	$pageCounter = 0;
	for ($i = 1; $i <= $topicQuery->rows; $i = $i + $count)
	{
		$pageCounter++;
		$topicNavigation .= "<option value='$i' class='empty'>";
		$topicNavigation .= ucfirst($lang['page']) . " " . $pageCounter;//((($i - 1) / $count) + 1);
		$topicNavigation .= "</option>";
	}
	if ($pageCounter == 0) $pageCounter++;
	$topicNavigation = "<option value='0' class='empty'>" . ucfirst($lang['page']) . " " . ($count > 0 ? (($begin - 1) / $count) + 1 : 1) . " / $pageCounter</option>" .
						"<option value='0' class='seperator'>------</option>" . $topicNavigation;

//=====================================================================================================================
// Process topics
//=====================================================================================================================

	${$loop} = array();
	for ($teller = 0; $begin + $teller <= $topicQuery->rows && $teller < $count; $teller++)
	{
		$topRes[$teller + $begin - 1]['lastPostNickname'] = stripslashes($topRes[$teller + $begin - 1]['lastPostNickname']);
		$topRes[$teller + $begin - 1]['description'] = stripslashes($topRes[$teller + $begin - 1]['description']);

//=====================================================================================================================
// Information on first post
//=====================================================================================================================

		// get first post in topic

		$postQuery = new MySQL;
		$postRes = $postQuery->select("SELECT p.id, p.posterid, u.nickname FROM " . $cfgDatabase['post'] . " AS p, " . $cfgDatabase['user'] . " AS u WHERE p.id = " . $topRes[$teller + $begin - 1]['postid'] ." AND p.posterid = u.id AND p.reactionto = 0");
		if ($postQuery->rows != 1)
			sendError("pe: Error!<br>Possible cause: the original poster of this topic nolonger exists.");

		// get user data of post

		$username = $postRes[0]['nickname'] = stripslashes($postRes[0]['nickname']);
		$userid = $postRes[0]['posterid'];


//=====================================================================================================================
// Gather basic information on topic
//=====================================================================================================================

//		$postQuery = new MySQL;										//get reply count
		$postRes = $postQuery->select("SELECT COUNT(*) AS count FROM " . $cfgDatabase['post'] . " WHERE topicid = " . $topRes[$teller + $begin - 1]['id']);
		if ($postQuery->rows < 1)
			sendError("pe: vwaaat");

		$lastPost['id'] = $topRes[$teller + $begin - 1]['lastpostid'];
		$lastPost['topicid'] = $topRes[$teller + $begin - 1]['id'];
		$lastPost['date'] = $topRes[$teller + $begin - 1]['lastPostDate'];
		$lastPost['user'] = $topRes[$teller + $begin - 1]['lastPostNickname'];	//already 'stripped'
		$lastPost['userid'] = $topRes[$teller + $begin - 1]['lastPostPosterID'];

		${$loop}[$teller]['TOPICDESCRIPTION'] = htmlspecialchars($topRes[$teller + $begin - 1]['description']);
		${$loop}[$teller]['TOPICID'] = $topRes[$teller + $begin - 1]['id'];


//=====================================================================================================================
// Coloring scheme
//=====================================================================================================================

		//alternating colors:
		$c = ($c + 1) % 2;
		${$loop}[$teller]['TOPICCOLOR'] = $c + 1;


//=====================================================================================================================
// Status icon
//=====================================================================================================================

		${$loop}[$teller]['TOPICIMG'] = "";
		${$loop}[$teller]['LOCKED'] = !($topRes[$teller + $begin - 1]['active']);
		${$loop}[$teller]['HASNEWPOSTS'] = ($HTTP_COOKIE_VARS[$cfgCookiePrefix . 'lastVisit2'] < $lastPost['date']);


//=====================================================================================================================
// Create the [1] [2] [3] ... page sections (if applicable)
//=====================================================================================================================

																		//min 1 to not count the startpost
		${$loop}[$teller]['TOPICREACTIONS'] = "<option value='0' class='empty'> &nbsp; " . ($postRes[0]['count'] - 1) . " &nbsp; </option>";
		${$loop}[$teller]['TOPICREACTIONS'] .= "<option value='0'>----------</option>";

		$postCountQuery = new MySQL;
		$pcqRes = $postCountQuery->select("SELECT COUNT(*) AS count FROM " . $cfgDatabase['post'] .  " WHERE topicid = " . $topRes[$teller + $begin - 1]['id']);
		$tc = $pcqRes[0]['count'];
		$itemsPerPage = $cfgPostsPerPage;
		if ($itemsPerPage > $tc || $itemsPerPage < 0) $itemsPerPage = $tc;
		if ($itemsPerPage > 0 && $tc > $itemsPerPage)
		{
			$pageCounter = 0;
			for ($topicSplitCounter = 1; $topicSplitCounter <= $tc; $topicSplitCounter += $itemsPerPage)
			{
				$pageCounter++;
				${$loop}[$teller]['TOPICREACTIONS'] .= "<option value='$topicSplitCounter'>" . ucfirst($lang['page']) . " $pageCounter</option>";
			}
			unset($topicSplitCounter);
			unset($pageCounter);
		}
		else
		{
			${$loop}[$teller]['TOPICREACTIONS'] .= "<option value='1'>" . ucfirst($lang['page']) . " 1</option>";
		}

		unset($postCountQuery);
		unset($tc);
		unset($itemsPerPage);


//=====================================================================================================================
// Gather more basic information on topic
//=====================================================================================================================

		${$loop}[$teller]['TOPICSTARTERID'] = $userid;
		${$loop}[$teller]['TOPICSTARTERNICK'] = htmlspecialchars($username);

		${$loop}[$teller]['TOPICVIEWS'] = $topRes[$teller + $begin - 1]['views'];

		${$loop}[$teller]['TOPICLASTPOSTPOSTID'] = $lastPost['id'];
		${$loop}[$teller]['TOPICLASTPOSTUSERID'] = $lastPost['userid'];
		${$loop}[$teller]['TOPICLASTPOSTTOPICID'] = $lastPost['topicid'];
		${$loop}[$teller]['TOPICLASTPOSTUSERNICK'] = htmlspecialchars($lastPost['user']);
		${$loop}[$teller]['TOPICLASTPOSTDATE'] = getDateTime($lastPost['date']);
	}


//=====================================================================================================================
// Template stuff
//=====================================================================================================================

	$templateIsInForum = true;
	$templateShowFolderIcons = true;
	$template->register($templateHandler, "topicNavigation, forumID");
	$template->parse($templateHandler);
	$template->parse_loop($templateHandler, $loop);

//=====================================================================================================================
// Send output to client
//=====================================================================================================================

echo $template->return_file($templateHandler);
if ($cfgUseCompression) gzdocout();

require($cfgIncludeDirectory . "cleanup.php");
?>
