<?php require("./config.inc.php");

/*

YapBB, a fully functional bulletin board system
Copyright (C) 2000/01  Arno van der Kolk
http://yapbb.sourceforge.net/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

//=====================================================================================================================
// Description: Display forum index
//=====================================================================================================================

	$arrs = array("cats", "fors", "ansmnts");
	for ($i = 0; $i < sizeof($arrs); $i++)
		${$arrs[$i]} = array();


//=====================================================================================================================
// Template stuff
//=====================================================================================================================

	if (!$template->load_file($templateHandler, "$cfgTemplateDirectory$cfgTemplateName/forumList.ybt"))
		if (!$template->load_file($templateHandler, $cfgTemplateDirectory . "Default/forumList.ybt"))
			sendError("pe: Could not load template (forumList.ybt)!");


//=====================================================================================================================
// Get all announcements
//=====================================================================================================================

	$annQuery = new MySQL;
	$annRes = $annQuery->select("SELECT a.sticky, p.posterid, u.nickname, p.date, t.active, f.name, f.id AS forumid, t.id AS topicid, t.description FROM " . $cfgDatabase['user'] . " AS u, " . $cfgDatabase['forum'] . " AS f, " . $cfgDatabase['topic'] . " AS t, " . $cfgDatabase['announcement'] . " AS a, " . $cfgDatabase['post'] . " AS p WHERE t.id = a.topicid AND p.id = t.postid AND t.forumid = f.id AND u.id = p.posterid ORDER BY a.sticky ASC, p.date DESC");
	$HASANNOUNCEMENTS = $annQuery->rows > 0 && $cfgAnnouncementCount > 0;

	$sticky = $nonsticky = array();
	if ($HASANNOUNCEMENTS)
	{
		for ($i = 0; $i < $annQuery->rows; $i++)	// sort announcements
		{
			if ($annRes[$i]['sticky'])
				$sticky[] = $annRes[$i];
			else
				$nonsticky[] = $annRes[$i];
		}

		$total = 0;
		for ($y = 0; $y < 2; $y++)
		{
			if ($y == 0)
				$data = $sticky;					// first display all sticky announcements (while room left)
			else
				$data = $nonsticky;					// then display all non-sticky announcements (while room left)

			$count = count($data);
			for ($i = 0; $i < $count && $total < $cfgAnnouncementCount; $i++)
			{
				${$arrs[2]}[$total]['topicid'] = $data[$i]['topicid'];
				${$arrs[2]}[$total]['description'] = htmlspecialchars(stripslashes($data[$i]['description']));
				${$arrs[2]}[$total]['name'] = htmlspecialchars(stripslashes($data[$i]['name']));
				${$arrs[2]}[$total]['forumid'] = $data[$i]['forumid'];
				${$arrs[2]}[$total]['date'] = getDateTime($data[$i]['date']);
				${$arrs[2]}[$total]['posterid'] = $data[$i]['posterid'];
				${$arrs[2]}[$total]['nickname'] = htmlspecialchars(stripslashes($data[$i]['nickname']));
				$total++;
			}
		}
	}


/*	// old code, doesn't seem to work very well :(
	for ($i = 0, $total = 0, $nonsticky = 0; $HASANNOUNCEMENTS && $i < $annQuery->rows && $total < $cfgAnnouncementCount; $i++)
	{
		if ($annRes[$i]['sticky'] || $nonsticky < $cfgAnnouncementCount)
		{
			${$arrs[2]}[$total]['topicid'] = $annRes[$i]['topicid'];
			${$arrs[2]}[$total]['description'] = htmlspecialchars(stripslashes($annRes[$i]['description']));
			${$arrs[2]}[$total]['name'] = htmlspecialchars(stripslashes($annRes[$i]['name']));
			${$arrs[2]}[$total]['forumid'] = $annRes[$i]['forumid'];
			${$arrs[2]}[$total]['date'] = getDateTime($annRes[$i]['date']);
			${$arrs[2]}[$total]['posterid'] = $annRes[$i]['posterid'];
			${$arrs[2]}[$total]['nickname'] = htmlspecialchars(stripslashes($annRes[$i]['nickname']));
			if (!$annRes[$i]['sticky']) $nonsticky++;										// do not increase counter if this one is sticky
			$total++;
		}
	}*/


//=====================================================================================================================
// Get all categories
//=====================================================================================================================

	$categoryDB = new MySQL;
	$catRes = $categoryDB->select("SELECT id, description FROM " . $cfgDatabase['category'] . " ORDER BY position ASC, id ASC");

	for ($curCat = 0; $curCat < $categoryDB->rows; $curCat++)		//list all categories
	{
		$catRes[$curCat]['description'] = stripslashes($catRes[$curCat]['description']);


//=====================================================================================================================
// Gather basic information on category
//=====================================================================================================================

		${$arrs[0]}[$curCat]['CATEGORYID'] = $catRes[$curCat]['id'];
		${$arrs[0]}[$curCat]['CATEGORYDESCRIPTION'] = htmlspecialchars($catRes[$curCat]['description']);
		${$arrs[0]}[$curCat]['curCat'] = $curCat;


//=====================================================================================================================
// Get all forums in the appropriate categories
//=====================================================================================================================

		$forumDB = new MySQL;
		$forRes = $forumDB->select("SELECT password, id, name, description FROM " . $cfgDatabase['forum'] . " WHERE category = " . $catRes[$curCat]['id'] . " ORDER BY position ASC, id ASC");

		for ($curFor = 0; $curFor < $forumDB->rows; $curFor++)			//list all forums in this category
		{
			$forRes[$curFor]['name'] = stripslashes($forRes[$curFor]['name']);
			$forRes[$curFor]['description'] = stripslashes($forRes[$curFor]['description']);


//=====================================================================================================================
// Gather basic information on forum
//=====================================================================================================================

			${$arrs[1] . $curCat}[$curFor]['FORUMID'] = $forRes[$curFor]['id'];
			${$arrs[1] . $curCat}[$curFor]['FORUMNAME'] = htmlspecialchars($forRes[$curFor]['name']);
			${$arrs[1] . $curCat}[$curFor]['FORUMDESCRIPTION'] = (trim($forRes[$curFor]['description']) == "" ? "&nbsp;" : nl2br(htmlspecialchars($forRes[$curFor]['description'])));
			${$arrs[1] . $curCat}[$curFor]['FORUMGROUP'] = ($forRes[$curFor]['password'] > 1);

			$threadCountQuery = new MySQL;
// first get the ACTUAL count
			$tcqRes = $threadCountQuery->select("SELECT COUNT(*) AS count FROM " . $cfgDatabase['topic'] . " WHERE forumid = " . $forRes[$curFor]['id']);
			$tmp = $tcqRes[0]['count'];

// next get the relevant count
			$tcqRes = $threadCountQuery->select(
					"SELECT COUNT(t.id) AS count
					FROM " . $cfgDatabase['topic'] . " AS t,
						" . $cfgDatabase['post'] ." AS p
					WHERE t.forumid = " . $forRes[$curFor]['id'] . "
						AND t.postid = p.id" .
						(
							($cfgTopicsOnLastDays > 0) ? "
								AND p.date > " . (time() - $cfgTopicsOnLastDays)
							:
								""
							)
						);

			if ($tmp != $tcqRes[0]['count'])
				$tmp = $tcqRes[0]['count'] . " ($tmp)";
			${$arrs[1] . $curCat}[$curFor]['FORUMTHREADCOUNT'] = $tmp;
			unset($tmp);

			$postCountQuery = new MySQL;								//count ALL postings in this forum
			$pcqRes = $postCountQuery->select("SELECT COUNT(p.id) AS count FROM " . $cfgDatabase['post'] . " AS p, " . $cfgDatabase['topic'] . " AS t WHERE p.topicid = t.id AND t.forumid = " . $forRes[$curFor]['id']);
			${$arrs[1] . $curCat}[$curFor]['FORUMPOSTCOUNT'] = $pcqRes[0]['count'];


//=====================================================================================================================
// Create the [1] [2] [3] ... page sections (if applicable)
//=====================================================================================================================

			$threadCount = $tcqRes[0]['count'];
			$count = $cfgThreadsPerPage;
			if ($count > $threadCount || $count < 0) $count = $threadCount;
			${$arrs[1] . $curCat}[$curFor]['FORUMHASMOREPAGES'] = false;
			if ($count > 0 && $threadCount > $count)
			{
				${$arrs[1] . $curCat}[$curFor]['FORUMHASMOREPAGES'] = true;
				$pageCounter = 0;
				${$arrs[1] . $curCat}[$curFor]['FORUMPAGES'] = "";
				for ($forumSplitCounter = 1; $forumSplitCounter <= $threadCount; $forumSplitCounter += $cfgThreadsPerPage)
				{
					$pageCounter++;
					${$arrs[1] . $curCat}[$curFor]['FORUMPAGES'] .= "<option value='$forumSplitCounter'>" . ucfirst($lang['page']) . " $pageCounter</option>";
				}
				${$arrs[1] . $curCat}[$curFor]['FORUMPAGES'] = "<option value='0'>$pageCounter " . $lang['pages'] . "</option>"
																. "<option value='0'>-------</option>"
																. ${$arrs[1] . $curCat}[$curFor]['FORUMPAGES'];
				unset($forumSplitCounter);
				unset($pageCounter);
			}
			unset($count);
			unset($threadCount);


//=====================================================================================================================
// Retrieve last post in this forum
//=====================================================================================================================

			${$arrs[1] . $curCat}[$curFor]['FORUMLASTPOST'] = false;
			$postQuery = new MySQL;
			$postRes = $postQuery->select("SELECT u.nickname, p.* FROM " . $cfgDatabase['user'] . " AS u, " . $cfgDatabase['post'] . " AS p, " . $cfgDatabase['topic'] . " AS t WHERE p.posterid = u.id AND p.topicid = t.id AND t.forumid = " . $forRes[$curFor]['id'] . " ORDER BY p.date DESC LIMIT 1");
			if ($postQuery->rows == 1)
			{
				${$arrs[1] . $curCat}[$curFor]['FORUMLASTPOST'] = true;
				$postRes[0]['nickname'] = stripslashes($postRes[0]['nickname']);
				${$arrs[1] . $curCat}[$curFor]['FORUMLASTPOSTPOSTID'] = $postRes[0]['id'];
				${$arrs[1] . $curCat}[$curFor]['FORUMLASTPOSTTOPICID'] = $postRes[0]['topicid'];
				${$arrs[1] . $curCat}[$curFor]['FORUMLASTPOSTDATE'] = getDateTime($postRes[0]['date']);
				${$arrs[1] . $curCat}[$curFor]['FORUMLASTPOSTUSERNICK'] = htmlspecialchars($postRes[0]['nickname']);
				${$arrs[1] . $curCat}[$curFor]['FORUMLASTPOSTUSERID'] =$postRes[0]['posterid'];


//=====================================================================================================================
// Get status icon of this forum
//=====================================================================================================================

				$new = ($HTTP_COOKIE_VARS[$cfgCookiePrefix . 'lastVisit2'] < $postRes[0]['date']);	//compare to last post
			}
			else
				$new = false;

			${$arrs[1] . $curCat}[$curFor]['HASNEW'] = $new;


//=====================================================================================================================
// Get moderators in this forum
//=====================================================================================================================

			${$arrs[1] . $curCat}[$curFor]['FORUMMODERATORS'] = "";
			$forumDB2 = new MySQL;
			$for2Res = $forumDB2->select("SELECT u.id, u.nickname FROM " . $cfgDatabase['user'] . " AS u, " . $cfgDatabase['moderator'] . " AS m WHERE m.userid = u.id AND m.forumid = " . $forRes[$curFor]['id'] . " AND u.groupid > 1 ORDER BY u.nickname");
			for ($i = 0; $i < $forumDB2->rows; $i++)
			{
				$for2Res[$i]['nickname'] = stripslashes($for2Res[$i]['nickname']);
				${$arrs[1] . $curCat}[$curFor]['FORUMMODERATORS'] .= '<a target="viewProfile" href="' . $cfgBaseURL . 'viewProfile.php?userID=' . $for2Res[$i]['id'] . "\">\n" . htmlspecialchars($for2Res[$i]['nickname']) . "</a>\n";
				if ($i < $forumDB2->rows - 1) ${$arrs[1] . $curCat}[$curFor]['FORUMMODERATORS'] .= " /\n";
			}
			if ($forumDB2->rows == 0)
				${$arrs[1] . $curCat}[$curFor]['FORUMMODERATORS'] = $lang['unmoderated'];
		}
	}


//=====================================================================================================================
// Template stuff
//=====================================================================================================================

	$template->parse($templateHandler);
	if ($HASANNOUNCEMENTS) $template->parse_loop($templateHandler, $arrs[2]);	// announcements
	$template->parse_loop($templateHandler, $arrs[0]);	// categories
	for ($i = 0; $i < sizeof($$arrs[0]); $i++)
		$template->parse_loop($templateHandler, $arrs[1] . $i);	// forums in categories

echo $template->return_file($templateHandler);
if ($cfgUseCompression) gzdocout();

require($cfgIncludeDirectory . "cleanup.php");
?>
