<?php

/*

YapBB, a fully functional bulletin board system
Copyright (C) 2000/01  Arno van der Kolk
http://yapbb.sourceforge.net/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

class Option
{
	var $classname = "Option";	/* for serialize */
	var $value;
	var $description;

	function Option()
	{
		$this->description = "";
		$this->value = "";
	}

	function Option($d, $v)
	{
		$this->description = $d;
		$this->value = $v;
	}
}

class Select
{
	// these are privates:
	var $classname = "Select";	/* for serialize */
	var $name;
	var $selected;
	var $store;

	function is_option($in)
	{
		$tmp = @is_int($in->value + $in->description)
			|| false;
		return $tmp;
	}

	function Select($name)
	{
		$this->name = $name;
		$this->store = new loopedArray;
	}

	function add($in)
	{
		if ($this->is_option($in))
			$this->store->add($in);
	}

	function setSelected($item) //uses VALUE
	{
		$this->selected = $item;
	}

	function getSelected() // user DESCRIPTION
	{
		for ($i = 0; $i < $this->store->numelements(); $i++)
		{
			$op = $this->store->elementat($i);
			if ($op->value == $this->selected)
				return $op->description;
		}
		return "N/A";//$this->selected;
	}

	function getList()
	{
		$tmp = "";
		for ($i = 0; $i < $this->store->numelements(); $i++)
		{
			$op = $this->store->elementat($i);
			$tmp .= "<option value='" . $op->value . "'" . ($op->value == $this->selected?" selected":"") . ">" . $op->description . "</option>\n";
		}
		return $tmp;
	}

	function getSelect()
	{
		return "<select name='" . $this->name . "'>\n" . getList() . "</select>\n";
	}
}

?>