<?php

/************************************************
*************************************************
**                                             **
**  loopedArray (C) 2000 Robert Peake          **
**  Released under GNU Lesser Public Licesne   **
**                                             **
*************************************************
************************************************/

class loopedArray {

		var $classname = "loopedArray";	/* for serialize */
        var $theArray = array();
        var $initialized = false;

// If initialize is given an array, it will use the array
// as the basis for the loopedArray,
// otherwise it will attempt to add what it is given
// to the loopedArray.

        function initialize($initValue) {
                if(is_array($initValue)){
                  $this->theArray = $initValue;
                } else {
                  $this->add($initValue);
                }
        $this->initialized = true;
        }

// add adds the given variable to the end of the array

        function add($addValue) {
                $this->theArray[$this->numelements()] = $addValue;
                reset($this->theArray);
        }

// removeElement removes the first matching element found from the array

        function removeElement($element) {
                return($this->removeIndex($this->indexof($element)));
                reset($this->theArray);
        }

// removeAllElement removes all instances the element from the array
// returns true if at least one instance of the element is found,
// returns false otherwise.

        function removeAllElement($removeValue) {
                $returnValue = false;
                $bufferArray = array();
                for($i=0; $i<sizeof($this->theArray); $i++) {
                        if($this->theArray[$i] != $removeValue) {
                          $bufferArray[] = $this->theArray[$i];
                        } else {
                          $returnValue = true;
                        }
                }
                if($returnValue) {
                  $this->theArray = $bufferArray;
                }
                return $returnValue;
                reset($this->theArray);
        }

// removeIndex removes the element at the given index from the array
// returns true if element exists at index, false otherwise

        function removeIndex($removeIndex) {
                $returnValue = false;
                $bufferArray = array();
                while($removeIndex < 0 && $this->initialized) {
                        $removeIndex += sizeof($this->theArray);
                }
                $modindex = $index % $this->numelements();
                for($i=0; $i<sizeof($this->theArray); $i++) {
                        if($i != $modindex) {
                          $bufferArray[] = $this->theArray[$i];
                        } else {
                          $returnValue = true;
                        }
                }
                if($returnValue) {
                  $this->theArray = $bufferArray;
                }
                return $returnValue;
                reset($this->theArray);
        }
// indexof returns the first index of the given element in the
// loopedArray, -1 if the element does not exist in the loopedArray.

        function indexof($element) {
                $returnValue = -1;
                for($i=0; $i<sizeof($this->theArray); $i++) {
                        if($this->theArray[$i] == $element) {
                        $returnValue = $i;
                        }
                }
                return $returnValue;
        }

// numelements returns the number of elements in the loopedArray

        function numelements() {
                return count($this->theArray);
        }

// elementat returns the element at the index of the loopedArray, looping
// such that (n*sizeof(loopedArray) + k) returns the same element as  k
// for all integers k, n. Returns false if loopedArray is empty.

        function elementat($index) {
            if($this->numelements() > 0) {
                while($index < 0 && $this->initialized) {
                        $index += sizeof($this->theArray);
                }
                $modindex = $index % $this->numelements();
                return $this->theArray[$modindex];
            }   else { return false; }
        }


// after returns the next element after the given element in the loop
// or false if the element does not exist in the loopedArray

        function after($element) {
                $theIndex = $this->indexof($element);
                return $this->elementat($theIndex + 1);
        }
// before returns the element before the given element in the loop

        function before($element) {
                $theIndex = $this->indexof($element);
                return $this->elementat($theIndex - 1);
        }

// printAll outputs all elements in the array, separated by a delimiter

        function printAll($delimiter) {
                for($i=0; $i<sizeof($this->theArray); $i++) {
                  if($this->theArray[$i + 1]) {
                    echo($this->theArray[$i].$delimiter);
                  } else {
                    echo($this->theArray[$i]);
                  }
                }
        reset($this->theArray);
        }
}

?>