<?php

/**
* PSPCooker 0.2
*
* PSPCooker is a new, JSP-like template engine for PHP
* Copyright (C) 2001  Arno van der Kolk
* http://yapbb.sourceforge.net/PSPCooker/
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
*
* Public interface:
* -----------------
*
* - PSPCooker($storage_directory = "/tmp/", $repository = "pspcooker_repository.php")
*	 constructor (with target location for data files and repository filename)
*
* - load_file($handle, $filename)
*	 assigns the contents of file with name $filename to this template handle
*
* - register($handle, $variable, $value = "\0")
*	 register a variable (string or 2-dimensional array) to this template handle
*   (optionally, you can immediately register the value as well)
*
* - execute($handle, $exitAfterEcho = false)
*	 parse and display the template
*
*
* <code>-----------
* Common use:
* -----------</code>
*
* $template = new PSPCooker("/tmp/");
* $template->load_file("sampleHandle", "/home/www/templates/sample.txt");
* $template->load_file("sampleHeader", "/home/www/templates/header.txt");
* $template->register("sampleHandle", "nameOfVariable");
* $template->register("sampleHandle", "nameOfArray");
* $template->register("sampleHandle", "nameOfVariable", "withAStaticValue");
* $template->register("sampleHandle", "nameOfArray", Array(Array("key1" => "value1"), Array("key2" => "value2"), Array("key3" => "value3")));
* $template->execute("sampleHandle", true);
*
*
* <code>----------------------------
* Structure of template files:
* ----------------------------</code>
*
* - Fields are displayed in this manner:
*
*     {fieldName}
*
*     Note that a variable must already be registerd under this name. Else this field will not be parsed.
*     (fieldName is case sensitive.)
*
* - Comments can be added (much like the regular <!-- and -->):
*
*     {-- this is a comment and won't be seen --}
*
* - Conditional blocks are build like this:
*
*     <CONDITTION NAME="varName"> text </CONDITTION NAME="varName">
*
*     $varName can be any kind of variable. A simple if($varName) statement will be used to evaluate it.
*     (varName is case sensitive.)
*
* - To negate a condition, simply add an exclamation mark to the front of the varName:
*
*     <CONDITTION NAME="!varName"> text </CONDITTION NAME="!varName">
*
*     Again, $varName can be any kind of variable. A simple if(!$varName) statement will be used to evaluate it.
*     (varName is case sensitive.)
*
* - A loop construct looks as follows:
*
*     <LOOP NAME="arrayName"> text and arrayName.someField </LOOP NAME="arrayName">
*
*     $arrayName must be a globally accessible array in the form of
*     Array(Array("field1" => "value1"), Array("field2" => "value2"), Array("field3" => "value3"))
*     So, it's a 2-dimensional array with a counter as the first index, and fields as the second index.
*     (arrayName is case sensitive.)
*
* - Loop fields can simply be displayed this way:
*
*     <LOOP NAME="arrayName">
*       {arrayName.field}
*     </LOOP NAME="arrayName">
*
* - Conditions based on fields of an array can also be used in a loop:
*
*     <LOOP NAME="arrayName">
*       text
*
*       <CONDITION NAME="arrayName.someBooleanField">
*         $arrayName[$index]['someBooleanField'] evaluates to TRUE
*       </CONDITION NAME="arrayName.someBooleanField">
*
*       <CONDITION NAME="!arrayName.someBooleanField">
*         $arrayName[$index]['someBooleanField'] evaluates to FALSE
*       </CONDITION NAME="!arrayName.someBooleanField">
*
*       more text
*     </LOOP NAME="arrayName">
*
*     (arrayName and someBooleanField are both case sensitive.)
*
* - You can specify an alternate string in case the array for a loop is empty:
*
*     <LOOP NAME="arrayName">
*
*       <NOITEMS>
*         Nothing found!
*       </NOITEMS>
*
*       Value is: {arrayName.field}
*
*     </LOOP NAME="arrayName">
*
* - To include other sections:
*
*     <INCLUDE HANDLE="handleName">
*
*     (handleName is case sensitive.)
*
*
* <code>------
* Notes:
* ------</code>
*
* o If the string '<include handle="sampleHeader">' would occur in 'sample.txt' in the
*   above example, it would automatically be replaced by the contents of 'header.txt'.
*
* o Any registered variables are automatically registered to included sections as well.
*
* o PHP must be able to write in the specified storage directory.
*
* o Tags (LOOP, CONDITION, INCLUDE) are case INSENSITIVE.
*
* o At present, this class REQUIRES PHP4.0.2 or better to run properly.
*
*
* <code>------
* To do:
* ------</code>
*
* o Since < PHP4.0.2 does not support the limit value in preg_replace,
*   this will have to be emulated some how (line 794).
*
* o In order to ultimately make this run on PHP3 as well, the bits that
*   use pointers (variable assignments using &$variable) will have to be
*   altered as well. Note that additional corrections may have to be performed.
*   This is certainly not a biggy, but WILL impact performance negatively.
*
* o When using subloops, performance may degrade as these fragments cannot fully be 'compiled'.
*
*     <LOOP NAME="loopA">
*
*       Text and {loopA.anotherField}
*
*       <LOOP NAME="loop{loopA.aField}">
*
*         Some field: {loop{loopA.aField}.someField}
*
*       </LOOP NAME="loop{loopA.aField}">
*
*     </LOOP NAME="loopA">
*
* o Fix bug: when a template file contains the sequence \" (slash quote),
*            it is converted to " (quote).
*
*
* <code>--------
* Changes:
* --------</code>
*
* o New in 0.2:
*   x Added PHPDoc comments (http://www.phpdoc.de)
*   x Updated this documentation a bit
*   x Removed the 'special' PHP3 support, as it seems it was nolonger required
*   x Optimized some of the code a bit
*   x Removed some redundant code
* o New in 0.1:
*   x Initial release
*   x It's basically a more advanced version of the class available here:
*     http://www.heyes-computing.net/scripts/
*
*
* @author		Arno van der Kolk <tuinhark@users.sourceforge.net>
* @link			http://yapbb.sourceforge.net/PSPCooker/		PSPCooker Home Page
* @link			http://yapbb.sourceforge.net/				YapBB Website (originating project)
* @link			http://freshmeat.net/projects/PSPCooker/	PSPCooker on freshmeat.net
* @link			http://www.heyes-computing.net/scripts/		PSPCooker is backwards compatible with this template class
* @version		0.2
* @access		public
* @final
* @copyright	&copy; 2001  Arno van der Kolk
*/
class PSPCooker
{
	/**
	* For serialize
	*
	* @access	public
	* @final
	* @static
	* @since	0.1
	* @link		http://www.php.net/serialize	<code>serialize</code> on www.php.net
	*/
	var $classname = "PSPCooker";

	/**
	* Path to repository file
	*
	* This attribute is set through the constructor
	*
	* @access	private
	* @var		$_repository	string
	* @since	0.1
	* @see
	*/
	var $_repository;

	/**
	* Contains texts of template-handles
	*
	* This attribute used throughout the entire class, but set
	* in <code>_load_file()</code>.
	*
	* @access	private
	* @since	0.1
	* @see		_load_file()
	*/
	var $_files = array();

	/**
	* Is text of templates parsed ?
	*
	* Since it is not a Good Thing (&trade;) to parse templates more than once,
	* this array will keep score.
	*
	* @access	private
	* @since	0.1
	*/
	var $_is_parsed = array();

	/**
	* Path to data directory
	*
	* This is the dir that parsed PSPTemplate classes and repository are stored in
	*
	* @access	private
	* @var		$_storage_directory	string
	* @since	0.1
	*/
	var $_storage_directory;

	/**
	* Execute these evals before creating template PHP
	*
	* Internal storage of commands to execute before parse.
	*
	* @access	private
	* @since	0.1
	*/
	var $_evals = array();

	/**
	* Path to original template file
	*
	* Normally there is no need to keep track of these, but
	* they are used to retrieve the modification date. This
	* is used to determine whether or not the template needs
	* to be recompiled.
	*
	* @access	private
	* @since	0.1
	*/
	var $_template_files = array();

	/**
	* Check handles for validity?
	*
	* Setting this to TRUE may slow down the process. Normally handles may only
	* consist of simple texts, that can be used as keys for arrays. This check
	* makes sure they pass.
	*
	* @access	private
	* @since	0.1
	*/
	var $_check = false;

	/**
	* Open tag for fields (not yet used)
	*
	* @access	private
	* @since	0.1
	*/
	var $_start = '{';

	/**
	* Close tag for fields (not yet used)
	*
	* @access	private
	* @since	0.1
	*/
	var $_end = '}';

	/**
	* Store names of includes in here
	*
	* This array contains the handles (for each handle) that are included
	* in the respective handle.
	*
	* @access	private
	* @since	0.1
	*/
	var $_included_handles = array();



	/**
	* Constructor (specify data storage directory and repository filename)
	*
	* @access	public
	* @param	string	$store		The storage directory (has to end with /)
	* @param	string	$repository	The repository file
	*
	* This has to be a filename only. It will be stored in the directory
	* specified by <code>$store</code>.
	* @return	object	PSPCooker
	* @since	0.1
	*/
	function PSPCooker($store = "/tmp/", $repository = "pspcooker_repository.php")
	{
		if (!is_array($GLOBALS["pspcooker_include_bits"]))		// lazy/static initializer
			$GLOBALS["pspcooker_include_bits"] = array();

/*	// some directory checks (not really needed though)
		$patterns = array("^/(.*)", "\.\.+/");
		$replacements = array("\./\\1", "\./");
		$this->_storage_directory = ereg_replace($patterns, $replacements, $storage_directory);
*/
		$this->_storage_directory = $store;
		$this->_repository = $this->_storage_directory . $repository;
	} // end constructor


	/**
	* Reads an entire file
	* (no longer in normal use)
	*
	* @deprecated
	* @access		private
	* @static
	* @param		string	$fileName	The file to open
	* @return		string				The contents of the file
	* @since		0.1
	*/
	function _getFile($fileName)
	{
		$error = FALSE;
		$tmp = "";
		$fh = @fopen($fileName,"r") or $error = TRUE;
		if (!$error)
		{
			$tmp = fread($fh, filesize($fileName));
			fclose($fh);
		}
		unset($error);
		unset($fh);
		return $tmp;
	} // end func _getFile


	/**
	* Register variables/loops (and optionally accept actual values)
	*
	* @access	public
	* @param	mixed	$handle		The handle to register this variable to
	* @param	string	$variable	The name of the variable/field
	* @param	string	$value		The actual value
	*
	* If none is given, then no value will be assigned an the value will be
	* retrieved when the handle is executed.
	* @since	0.1
	*/
	function register($handle, $variable, $value = "\0")									// accepts simple strings as well as arrays[index][fields]
	{
		if (is_long(strpos($variable, ",")))
			$variable = explode(",", $variable);

		if (is_array($variable))
		{
			for (reset($variable); list(,$var) = each($variable);)
				$this->register($handle, trim($var));
			return;
		}

		if ($this->_check) if (!preg_match("!\w+!", $variable)) die("<P>ERROR: Invalid variable: '$variable'</P>");

		if ($value == "\0")
		{
			$isArray = is_array($GLOBALS[$variable]);
			$value = "\$GLOBALS[\"$variable\"]";											// make sure actual value will be retrieved
		}
		else
		{
			// NOT TESTED MUCH:

			$value = (($isArray = is_array($value)) ? $value : addslashes($value));
			$value = "\"$value\"";

/*			// old redundant code:
			if ($isArray)
				$value = "\"$value\"";														// pass the array as value (it works magically)
			else
				$value = '"' . addslashes($value) . '"';*/
		}

		// the variable '$instance' will be used in 'execute()' to point to the instance
		$this->_evals[$handle][] = '$instance->register' . ($isArray ? "_loop" : "") . "(\"$variable\", $value);";
	} // end func register


	/**
	* Loads template
	*
	* @access	public
	* @param	mixed	$handle		Assign the template to this handle
	* @param	string	$filename	The template file to load
	* @return	boolean				This value indicates whether or not the load has succeeded or not
	* @since	0.1
	*/
	function load_file($handle, $filename)													// possibly postpone the loading of the contents
	{																						// until _parse($handle)
		if ($this->_check) if (!preg_match("!\w+!", $handle)) die("<P>ERROR: Invalid variable: '$handle'</P>");

		if ($exist = file_exists($filename))
		{
			$this->_files[$handle] = addslashes(fread($fp = fopen($filename, 'r'), filesize($filename)));
			$this->_template_files[$handle] = $filename;
			fclose($fp);
		}
		return $exist;
	} // end func load_file


	/**
	* Parse and output text associated with $handle
	*
	* @access	public
	* @param	mixed	$handle			The handle to process
	* @param	string	$mode			Indicate which action to take (RUN, GETTEXT, GETINSTANCE, NOOP)
	*
	* RUN:			Normal operation - Parse and echo the result (return empty string)
	* GETTEXT:		Normally internal operation only - Parse and return the result
	* GETINSTANCE:	Special internal operation only - Parse and return the respective PSPTemplate object
	* @param	boolean	$exitAfterEcho	When "RUN" is the specified action and this is set to TRUE,
	*									this script terminates.
	* @return	mixed					Depending on the $mode, some value is returned
	* @since	0.1
	*/
	function execute($handle, $mode = "RUN", $exitAfterEcho = false)
	{
		if ($this->_check) if (!preg_match("!\w+!", $handle)) die("<P>ERROR: Invalid variable: '$handle'</P>");

		if (empty($GLOBALS["cooker_include_bits"][$handle]))								// check if already included in this request
		{																					// this is merely a performance issue
			$filename = $this->_parse($handle);												// because the included file also checks
			include($filename);
		}

		$this->_prepare_instance($handle);													// make sure the instance is ready
		$instance = &$GLOBALS[$handle . "_cooker_instance"];

		for (reset($instance->_included_handles); list(, $var) = each($instance->_included_handles);)
			$this->execute($var, "NOOP", $exitAfterEcho);									// prepare includes

		for ($i = 0; $i < sizeof($this->_evals[$handle]); $i++)								// actually register variables and such
			eval($this->_evals[$handle][$i]);												// to THIS instance

		$tmp = "";																			// select course of action
		if ($mode == "RUN")																	// parse, save and echo
			$instance->run($exitAfterEcho);
		else if ($mode == "GETTEXT")														// parse, save and return text
			$tmp = $instance->get_text();
		else if ($mode == "GETINSTANCE")													// parse, save and return instance
			$tmp = $instance;
		else if ($mode == "NOOP")															// parse and save only
			;
		else																				// error ?
			eval("X");

		return $tmp;
	} // end func execute


	/**
	* Internal function (called from _execute)
	* parse the text associated with $handle
	*
	* @access	private
	* @param	mixed	$handle	Parse the specified handle
	* @return	string			Filename associated with this handle (for later processing)
	* @since	0.1
	*/
	function _parse($handle)
	{
		if ($this->_check) if (!preg_match("!\w+!", $handle)) die("<P>ERROR: Invalid variable: '$handle'</P>");

		$filename = $this->_storage_directory . $handle . "_cooker_class.php";
		$text = &$this->_files[$handle];													// make a pointer to work with

		if (!is_file($this->_repository))													// build new (empty) repository
			$repository = array();
		else																				// retrieve repository
			$repository = explode(',', implode("\n", file(($this->_repository))));

		$count = count($repository);														// validate repository
		if ($count < 2 || ($count % 2 == 1 && $repository[$count - 1] != ""))
		{
			$repository = array();															// reconstruct repository
			$repository[] = $filename;
			$repository[] = 0;
			$count = 2;	//count($repository);
		}

		$newRepository = array();															// build new (empty) repository
		$updateRepository = false;															// (in case we need to update the current one)
		$isInRepository = FALSE;
		$time = filemtime($this->_template_files[$handle]);

		for ($i = 0; $i < $count - 1; $i += 2)
		{
			if ($repository[$i] == $filename)												// does current page exist in repository?
			{
				$isInRepository = TRUE;
				if ($repository[$i + 1] != $time)											// does it need updating?
				{
					$text = $this->_parse_text($handle, $text);
					$this->_write_class($handle, $filename);

					$updateRepository = true;												// update repository next
					$repository[$i + 1] = $time;
				}
			}
			$newRepository[] = $repository[$i];
			$newRepository[] = $repository[$i + 1];
		}

		if (!$isInRepository)																// page does not exist in repository
		{
			$text = $this->_parse_text($handle, $text);
			$this->_write_class($handle, $filename);

			$updateRepository = true;														// update repository next
			$newRepository[] = $filename;
			$newRepository[] = $time;
		}

		if ($updateRepository)																// perform repository update
		{
			$fh = fopen($this->_repository, "w");
			fwrite($fh, implode(',', $newRepository) . ',');
			fclose($fh);
		}

		return $filename;																	// this will be used by execute
	} // end func _parse


	/**
	* Internal function (called from _parse, execute)
	* writes out the newly parsed class
	*
	* @access	private
	* @param	mixed	$handle		Write a PSPTemplate subclass for this handle
	* @param	string	$filename	Using this filename
	* @return	boolean				Indicates success or failure
	* @since	0.1
	*/
	function _write_class($handle, $filename)
	{
		if ($this->_check) if (!preg_match("!\w+!", $handle)) die("<P>ERROR: Invalid variable: '$handle'</P>");

		$text = '<' . '?php
/**
 * PSPCooker Class
 *
 * This file was created by PSPCooker, a new JSP-like template engine for PHP.
 * PSPCooker is available at: http://yapbb.sourceforge.net/PSPCooker/
 *
 * Please do not modify
 * Created on: ' . date("D j M Y, h:i:s A") . '
 */


if (!$GLOBALS["cooker_include_bits"]["' . $handle . '"])
{
	$GLOBALS["cooker_include_bits"]["' . $handle . '"] = TRUE;


	class ' . $handle . '_cooker_class extends PSPTemplate
	{
		var $classname = "' . $handle . '_cooker_class";					/* for serialize */

		function ' . $handle . '_cooker_class($store = "./", $headers = false) {				/* constructor */
			$this->_set_headers = $headers;
			$this->_storage_directory = $store;
			$this->_included_handles = array(' . $this->_get_included_handles($handle) . ');
		}

		function _set_text()												/* overwrite parent */
		{
			$this->_text = "' . $this->_files[$handle] . '";
			$this->_text = str_replace("\\' . "'" . '", "' . "'" . '", $this->_text);
		}
	}

}
?' . '>';

		$fh = fopen($filename, "w");									// write page
		if ($fh != false)
		{
			fwrite($fh, $text);
			fclose($fh);
		}
		unset($text);
		return $fh;
	} // end func _write_class


	/**
	* Internal function (called from _write_class, _parse, execute)
	* returns a comma-seperated list of all occurances
	*
	* @access	private
	* @param	mixed	$handle	Specify to retrieve the includes for this handle
	* @return	string			The found includes (comma-seperated list)
	* @since	0.1
	*/
	function _get_included_handles($handle)
	{
		$arr = &$this->_included_handles[$handle];
		if (is_array($arr))
		{
/*			reset($arr);
			for ($tmp = ""; list(, $var) = each($arr);)
				$tmp .= "\"$var\", ";
			return substr($tmp, 0, -2);
*/
			return implode(", ", $arr);
		}
		else
			return "";
	} // end func _get_included_handles


	/**
	* Internal function (called from _parse, execute)
	* handle loops, includes, comments and conditional blocks
	*
	* @access	private
	* @param	mixed	$handle		The handle to parse
	* @param	string	$text		The associated text of this handle
	* @return	string				Parsed version of $text
	* @since	0.1
	*/
	function _parse_text($handle, $text)
	{
																							// handle loops
		$expression = '!' . quotemeta('<loop name=\"') . '(\w+)' . quotemeta('\">') . '(.*)' . quotemeta('</loop name=\"') . '\\1' . quotemeta('\">') . '!Uis';
		$replacement = '" . ($this->_parse_loop("\\1", "\\2")) . "';
		$text = preg_replace($expression, $replacement, $text);

																							// handle included files
		$expression = '!' . quotemeta('<include handle=\"') . '(.+)' . quotemeta('\">') . '!ie';
		$replacement = '$this->_parse_include($handle, "\\1")';
		$text = preg_replace($expression, $replacement, $text);

																							// strip comments
		$expression = '!' . quotemeta('{--') . '(.+)' . quotemeta('--}') . '!Uis';
		$replacement = "";
		$text = preg_replace($expression, $replacement, $text);

																							// handle conditional blocks
		$expression = '!' . quotemeta('<condition name=\"') . '(\!?)(\w+)' . quotemeta('\">') . '(.*)' . quotemeta('</condition name=\"') . '\\1\\2' . quotemeta('\">') . '!Uis';
		$replacement = '" . ( \\1$GLOBALS["\\2"] ? "\\3" : "" ) . "';
		for ($oldText = !$text; $oldText != $text;)											// make sure all nested blocks are processed too
		{
			$oldText = $text;
			$text = preg_replace($expression, $replacement, $text);
		}

		return $text;
	} // end func _parse_text


	/**
	* Internal function (called from _parse_text, _parse, _execute)
	* prepare a call to an included instance
	*
	* @access	private
	* @param	mixed	$mainHandle		Add the included handle to this handle
	* @parem	mixed	$includeHandle	Add this handle to the main handle
	* @return	string					A string (based on $includeHandle) for use in eval()
	* @since	0.1
	*/
	function _parse_include($mainHandle, $includeHandle)
	{
		$this->_included_handles[$mainHandle][] = $includeHandle;
		return '" . $GLOBALS["' . $includeHandle . '_cooker_instance"]->get_text() . "';
	} // end func _parse_include


	/**
	* Internal function (called from execute)
	* lazy initialization of instances (static function actually)
	*
	* @access	private
	* @param	mixed	$handle	Create a new PSPTemplate instance for this handle (lazy initialization)
	* @since	0.1
	*/
	function _prepare_instance($handle)
	{
		if ($GLOBALS[$handle . "_cooker_instance"] == "")
			eval("\$GLOBALS['" . $handle . "_cooker_instance'] = new " . $handle . '_cooker_class(/*"' . $this->_storage_directory . '", */false);');		// instantiate new PSPTemplate object
	} // end func _prepare_instance
}



/**
* Super class for new template pages
*
* @author		Arno van der Kolk <tuinhark@users.sourceforge.net>
* @link			http://yapbb.sourceforge.net/PSPCooker/		PSPCooker Home Page
* @link			http://yapbb.sourceforge.net/				YapBB Website (originating project)
* @link			http://freshmeat.net/projects/PSPCooker/	PSPCooker on freshmeat.net
* @copyright	&copy; 2001  Arno van der Kolk
* @version		0.2
* @since		0.1
* @access		public
* @abstract
*/
class PSPTemplate
{
	/**
	* Holds actual text
	*
	* @access	protected
	* @var		string		$_text
	*/
	var $_text;

	/**
	* For keeping track of the loops
	*
	* @access	private
	*/
	var $_loopvars = array();

	/**
	* For keeping track of variables
	*
	* @access	private
	*/
	var $_vars = array();

	/**
	* Set content type and length before output?
	*
	* @access	protected
	*/
	var $_set_headers = false;

	/**
	* Has this template already been parsed?
	*
	* @access	private
	*/
	var $_parsed = false;

	/**
	* For serialize
	*
	* @access	private
	* @final
	*/
	var $classname = "PSPTemplate";

	/**
	* Here is where the includes can be found
	*
	* @deprecated
	* @access		protected
	* @var			string		$_storage_directory
	*/
	var $_storage_directory;

	/**
	* For external use; keep track of included pages
	*
	* @access	protected
	*/
	var $_included_handles = array();



	/**
	* Constructor (will be overwritten anyway)
	*
	* Normally this class is ONLY instantiated by the PSPCooker class
	* and not by user scripts.
	*
	* @access	package
	* @param	string	$store		...
	* @param	boolean	$headers	...
	* @return	object	PSPTemplate	...
	*/
	function PSPTemplate(/*$store = "./", */$headers = false) {
		$this->_set_headers = $headers;
//		$this->_storage_directory = $store;
	}


	/**
	* Echo the text
	*
	* Normally this function is ONLY called by the PSPCooker class
	* and not by user scripts.
	*
	* @access	package
	* @final
	* @param	boolean	exitScript	...
	*/
	function run($exitScript = false) {
		$this->_parse();
		if ($this->_set_headers)
		{
			header("Content-Type: text/html");
			header("Content-Length: " . strlen($this->_text));
		}
		echo $this->_text;
		if ($exitScript) exit;
	}


	/**
	* Returns the file, without echoing it
	*
	* Normally this function is ONLY called by the PSPCooker class
	* and not by user scripts.
	*
	* @access	package
	* @final
	* @return	string	The text represented by this instance
	*/
	function get_text() {
		$this->_parse();
		return $this->_text;
	}


	/**
	* Register a var
	*
	* Normally this function is ONLY called by the PSPCooker class
	* and not by user scripts.
	*
	* @access	package
	* @final
	* @param	string	$key	...
	* @param	string	$value	...
	*/
	function register($key, $value) {
		$this->_vars[$key] = $value;
	}


	/**
	* Register a loop
	*
	* Normally this function is ONLY called by the PSPCooker class
	* and not by user scripts.
	*
	* @access	package
	* @final
	* @param	string	$key	...
	* @param	string	$value	...
	*/
	function register_loop($key, $value) {
		$this->_loopvars[$key] = $value;
	}


	/**
	* Actually iterate some text
	*
	* @access	protected
	* @final
	* @param	array	$arr		...
	* @param	text	$loopText	...
	* @return	string				...
	*/
	function _parse_loop($arr, $loopText) {
		$actArr = $this->_loopvars[$arr];
		$result = "";
		if (is_array($actArr)) {
			$count = count($actArr);

			if ($count == 0 || ($count == 1 && count($actArr[0]) == 0))	/* no items in array, display 'noitems' thingy */
			{
				$returnNoItems = true;
			}
			else														/* filter out 'noitems' thingy */
			{
				$expression = "!" . quotemeta('<noitems>') . ".*?" . quotemeta('</noitems>') . "!is";
				$replacement = "";
				$loopText = preg_replace($expression, $replacement, $loopText, 1);
			}

			for ($i = 0; $i < $count; $i++)								/* iterate: */
			{
				$tmp = $loopText;
				reset($actArr);
				while (list($key, $value) = each($actArr[$i]))
					$tmp = str_replace("\{$arr.$key}", $value, $tmp);

																		/* parse conditions */
				$expression = '!' . quotemeta('<condition name="') . '((\!?)(' . $arr . ')\.(\w+))' . quotemeta('">') . '(.*)' . quotemeta('</condition name="') . '\\1' . quotemeta('">') . '!Uise';
//				$expression = "!" . quotemeta('<condition name=\"') . "((\!?)(" . quotemeta($arr) . ")" . quotemeta('.') . '(\w+))' . '\">' . "(.*)" . quotemeta('</condition name=\"') . "\\1" . quotemeta('\">') . "!Uise";
				$replacement = '$this->_parse_loop_condition("\\2", $actArr[' . $i . '], "\\4", "\\5")';
				for ($oldText = !$tmp; $oldText != $tmp;)
				{
					$oldText = $tmp;
					$tmp = preg_replace($expression, $replacement, $tmp);
				}
				$result .= $tmp;
			}
			unset($tmp);
			unset($oldText);
		}
		else
			$returnNoItems = true;										/* not an array, display 'noitems' thingy */

		if ($returnNoItems)
		{
			$expression = "!(.*)" . quotemeta('<noitems>') . "(.*?)" . quotemeta('</noitems>') . "(.*)!is";
			$replacement = "\\2";

//	old:
//			$result = preg_replace($expression, $replacement, $loopText);
//			if ($loopText == $result) $result = "";

			preg_match_all($expression, $loopText, $matches);
			$result = $matches[2][0];
		}
		return $this->_parse_sub_loop($result);
	}


	/**
	* @access	protected
	* @final
	* @param	string	$text	...
	* @return	string			...
	*/
	function _parse_sub_loop($text) {									/* aux. function for _parse_loop */
		$expression = '!' . quotemeta('<loop name="') . '(\w+)' . quotemeta('">') . '(.*)' . quotemeta('</loop name="') . '\\1' . quotemeta('">') . '!Uise';
		$replacement = '$this->_parse_loop("\\1", stripslashes("\\2"))';
		return preg_replace($expression, $replacement, $text);
	}


	/**
	* @access	protected
	* @static
	* @final
	* @param	boolean	$negate	Negate the condition or not
	* @param	array	$array	Evaluate a field in this array
	* @param	string	$field	Use this field of the array
	* @param	string	$text	If TRUE, return this, else ""
	* @return	string			Based on ($negate $array[$field]) return $text or ""
	*/
	function _parse_loop_condition($negate, $array, $field, $text) {	/* aux. function for _parse_loop */
		if ($negate == "!") $array[$field] = !$array[$field];
		return ($array[$field] ? stripslashes($text) : "");
	}


	/**
	* This is where the text will be initialized
	*
	* @access	protected
	* @abstract
	*/
	function _set_text() {
		// do nothing (is abstract)
	}


	/**
	* Parse the text
	*
	* Replaces all registered {markers} with actual values
	*
	* @access	protected
	* @final
	*/
	function _parse() {
		if ($this->_parsed) return;
		$this->_parsed = TRUE;
		$this->_set_text();
		for (reset ($this->_vars); list($key, $value) = each($this->_vars);)
			$this->_text = str_replace("\{$key}", $value, $this->_text);
	}

}

?>