<?php

/*

YapBB, a fully functional bulletin board system
Copyright (C) 2000/01  Arno van der Kolk
http://yapbb.sourceforge.net/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

//=====================================================================================================================
// Description: contains (static only) functions for storing search terms and searching
// (Cannot operate independantly, requires YapBB)
//=====================================================================================================================
class Searcher
{
	var $_noise_words = array();

//=====================================================================================================================
// Constructor, required by PHP3
//=====================================================================================================================
	function Searcher()
	{
	}

//=====================================================================================================================
// $resultset: returns an array of topics that contain posts with the specified keywords, sorted by relevance
// $querywords has to be an array of search terms
//=====================================================================================================================
	function search_topic($querywords, $stripslashes = TRUE)
	{
		global $cfgDatabase;

		if (!is_array($querywords))
			echo "\n\nWarning: invalid argument \$querywords";

		$tmp = "";
		for (reset($querywords); list(, $val) = each($querywords);)
			//$tmp .= "'" . addslashes($val) . "', ";
			$tmp .= "s.word LIKE '%" . str_replace('%', '\%', str_replace('_', '\_', addslashes($val))) . "%' OR ";
			
//		$querywords = substr($tmp, 0, -2);
		$querywords = substr($tmp, 0, -4);
		unset($tmp);

		$query = new MySQL();
		$res = $query->select(
			"SELECT COUNT(s.word) AS score, t.description, p.*, u.nickname " .
			"FROM " . $cfgDatabase['search_index'] . " AS s, " . $cfgDatabase['topic']. " AS t, " . $cfgDatabase['post'] . " AS p, " . $cfgDatabase['user'] . " AS u " .
//			"WHERE p.id = s.qid AND p.topicid = t.id AND u.id = p.posterid AND s.word IN ($querywords) " .
			"WHERE p.id = s.qid AND p.topicid = t.id AND u.id = p.posterid AND ($querywords) " .
			"GROUP BY p.topicid " .
			"ORDER BY score DESC"
		);

		if ($stripslashes)
			for ($i = 0; $i < $query->rows; $i++)
				for (reset($res[$i]); list($key, $val) = each($res[$i]);)
					$res[$i][$key] = stripslashes($val);

		return $res;
	}

//=====================================================================================================================
// void: Delete and re-index a message
// $text is the text to be indexed, $postid is the message id, which this text belongs to
//=====================================================================================================================
	function update_post($text, $postid)
	{
		$this->delete_post($postid);
		$this->insert_post($text, $postid);
	}

//=====================================================================================================================
// void: Delete all indexed word for this message
// $postid is the message id
//=====================================================================================================================
	function delete_post($postid)
	{
		global $cfgDatabase;
		$query = new MySQL();
		$query->query("DELETE FROM " . $cfgDatabase['search_index'] . " WHERE qid = $postid");
	}

//=====================================================================================================================
// void: Delete all posts associated to this topic
// $topicid is the topic of which to delete all message indexes
//=====================================================================================================================
	function delete_topic($topicid)
	{
		global $cfgDatabase;
		$query = new MySQL();
		$res = $query->select("SELECT id FROM " . $cfgDatabase['post'] . " WHERE topicid = $topicid");
		$sql = "";
		for ($i = 0; $i < $query->rows; $i++)
			$sql .= $res[$i]['id'] . ", ";
		$sql = substr($sql, 0, -2);
		$query->query("DELETE FROM " . $cfgDatabase['search_index'] . " WHERE qid IN ($sql)");
	}

//=====================================================================================================================
// void: Add a new index of a specified text
// $text is te text to index, $postid is the associated message id
//=====================================================================================================================
	function insert_post($text, $postid)
	{
		global $cfgDatabase, $cfgIncludeDirectory;

	    /* Open the noise words into an array */

	    //$noise_words = $this->_noise_words();
	    $count = count($this->_noise_words);
	    if ($count == 0)
	    {
	    	$this->_noise_words = file($cfgIncludeDirectory . "noise_words.txt");
	    	$count = count($this->_noise_words);
	    }

	    /*      Got to put a space before the first word in the
	        body, so that we can
	        recognize the word later
	    */
	    $text = ereg_replace("^", " ", $text);

	    /*      Now we suck out all the noisewords, and transform
	        whats left into an array
	    */

	    /* Brought to you by poor ereg coding! */
	    for ($i = 0; $i < $count; $i++) {
	        $filterword = trim($this->_noise_words[$i]);
	        $text = eregi_replace(" $filterword ", " ", $text);
	    }

	    $text = trim($text);
	    $text = addslashes($text);
	    $querywords = ereg_replace(",", "", $text);
	    $querywords = ereg_replace(" ", ",", $querywords);
	    $querywords = ereg_replace("\?", "", $querywords);
	    $querywords = ereg_replace("\(", "", $querywords);
	    $querywords = ereg_replace("\)", "", $querywords);
	    $querywords = ereg_replace("\.", "", $querywords);
	    $querywords = ereg_replace(",", "','", $querywords);
	    $querywords = ereg_replace("^", "'", $querywords);
	    $querywords = ereg_replace("$", "'", $querywords);

	    /*      We should now have something that looks like
	        'Word1','Word2','Word3' so lets turn it into an array
	    */
	    $eachword = explode(",", $querywords);

	    /*      and finally lets go through the array, and place each
	        word into the database, along with its identifier
	    */


		/*      Filter out double words and make sure they are in this
		    format: ^'[A-Z]+[A-Z0-9]*'$
		*/
		$newArray = array();
		$query = new MySQL();
		$count = count($eachword);
	    for ($k = 0; $k < $count; $k++)
	    	if (eregi("^'[A-Z]+[A-Z0-9]*'$", $eachword[$k]) && !$this->in_array($eachword[$k], $newArray))
	    		$newArray[] = $eachword[$k];

		/*      Actually insert the words */
		$count = count($newArray);
		for ($k = 0; $k < $count; $k++)
			$query->query("INSERT INTO " . $cfgDatabase['search_index'] . " VALUES ($newArray[$k], $postid)");
	}

//=====================================================================================================================
// PHP4 emulation
//=====================================================================================================================
	function in_array($needle, $haystack)
	{
		if (function_exists("in_array")) return in_array($needle, $haystack);
		$count = count($haystack);
		for ($i = 0; $i < $count && $haystack[$i] != $needle; $i++);
		return $i != $count;
	}

/*
	function _noise_words()
	{
		return array(
			"a",
			"about",
			"after",
			"ago",
			"all",
			"almost",
			"along",
			"also",
			"am",
			"an",
			"and",
			"answer",
			"any",
			"anybody",
			"anywhere",
			"are",
			"aren't",
			"around",
			"as",
			"ask",
			"at",
			"bad",
			"be",
			"been",
			"before",
			"being",
			"best",
			"better",
			"between",
			"big",
			"but",
			"by",
			"can",
			"can't",
			"come",
			"could",
			"couldn't",
			"day",
			"did",
			"didn't",
			"do",
			"does",
			"don't",
			"down",
			"each",
			"either",
			"else",
			"even",
			"ever",
			"every",
			"everybody",
			"everyone",
			"far",
			"find",
			"for",
			"found",
			"from",
			"get",
			"go",
			"going",
			"gone",
			"good",
			"got",
			"had",
			"has",
			"have",
			"haven't",
			"having",
			"her",
			"here",
			"hers",
			"him",
			"his",
			"home",
			"how",
			"href",
			"I",
			"if",
			"in",
			"into",
			"is",
			"isn't",
			"it",
			"its",
			"know",
			"large",
			"less",
			"like",
			"little",
			"looking",
			"look",
			"many",
			"me",
			"more",
			"most",
			"must",
			"my",
			"near",
			"never",
			"new",
			"news",
			"no",
			"none",
			"not",
			"nothing",
			"of",
			"off",
			"often",
			"old",
			"on",
			"once",
			"only",
			"or",
			"other",
			"our",
			"ours",
			"out",
			"over",
			"page",
			"please",
			"question",
			"rather",
			"recent",
			"she",
			"should",
			"sites",
			"small",
			"so",
			"some",
			"something",
			"sometime",
			"somewhere",
			"than",
			"true",
			"thank",
			"that",
			"the",
			"their",
			"theirs",
			"them",
			"then",
			"there",
			"these",
			"they",
			"this",
			"those",
			"though",
			"through",
			"thus",
			"time",
			"times",
			"to",
			"too",
			"under",
			"until",
			"untrue",
			"up",
			"upon",
			"use",
			"users",
			"version",
			"very",
			"via",
			"want",
			"was",
			"way",
			"web",
			"were",
			"what",
			"when",
			"where",
			"which",
			"who",
			"whom",
			"whose",
			"why",
			"wide",
			"will",
			"with",
			"within",
			"without",
			"world",
			"worse",
			"worst",
			"would",
			"www",
			"yes",
			"yet",
			"you",
			"your",
			"yours",
			"How"
		);
	}
*/
}

?>