<?php
/*							sqlsession

a MySQL based session management and variable registration system
joshua macadam, 2000
josh@onestop.net

Modified by Arno van der Kolk for YapBB, 2001
http://yapbb.sourceforge.net/

Now in class form and dependant on YapBB's MySQL class

*/

class SqlSession
{

	var $MAX_UNAUTH_IDLE = 42300;	//How long may an unauthorized user be idle (just to clean up out session table!)
	var $MAX_AUTH_IDLE = 600;		//If you are logged in, how long for?
//	var $_sess_db_hand;
//	var $DB_HOST;
//	var $DB_LOGIN;
//	var $DB_PASS;
//	var $DB_NAME;
	var $DB_T_SESSION;
	var $DB_T_USER_VARS;
	var $sql;
	var $session;
	var $name = "PHPSESSID";
	var $module;
	var $cookie_lifetime = 0;
	var $cookie_path = "";
	var $cookie_domain = "";

	function SqlSession($session_table, $user_vars_table /*$host, $login, $pass, $db, $t_sess, $t_u_vars*/)
	{
		$this->sql = new MySQL();
		$this->DB_T_SESSION = $session_table;
		$this->DB_T_USER_VARS = $user_vars_table;

/*		$this->DB_HOST = $host;//		define(DB_HOST, $cfgServerHost . ((empty($cfgServerPort))?"":":$cfgServerPort"));
		$this->DB_LOGIN = $login;//define(DB_LOGIN, $cfgServerUser);
		$this->DB_PASSWORD = $pass;//define(DB_PASSWORD, $cfgServerPassword);
		$this->DB_NAME = $db;//define(DB_NAME, $cfgDatabase['database']);
		$this->$this->DB_T_SESSION = $t_sess;//define($this->DB_T_SESSION, $cfgDatabase['session']);
		$this->$this->DB_T_USER_VARS = $t_u_vars;//define($this->DB_T_USER_VARS, $cfgDatabase['user_vars']);

		if (!$this->_sess_db_hand) {
			@$this->_sess_db_hand = mysql_pconnect($this->DB_HOST, $this->DB_LOGIN, $this->DB_PASSWORD)
				or sendError($lang['errorNoConnection'] . " ".mysql_error(), true);//die($lang['errorNoConnection'] . ". " . mysql_error());
			if (!$this->_sess_db_hand){
				echo "FATAL:Couldn't connect to db.<br>";
				exit;
			}
			mysql_select_db($this->DB_NAME, $this->_sess_db_hand);
		}

		//AUTOMATIC SESSION DEMAND. If you do not wish to have to call s_demand_session
		//in every script, uncomment the following line:

		if ($cfgPHP3compatibility) s_demand_session();
	*/
	}

	function s_killold()
	{
		//$debug = 1;

		// figure out who all we're about to delete for being too old!
		$Query = "SELECT vars.id FROM " . $this->DB_T_SESSION . " as sess, " . $this->DB_T_USER_VARS . " as vars WHERE sess.id = vars.session AND LastAction < '";
		$Query .= date("Y-m-d H:i:s", (time() - $this->MAX_UNAUTH_IDLE));
		$Query .= "'";

		$sql = new MySQL();
		$res = $this->sql->select($Query);
		$tmp = "";
		if (($c = $this->sql->rows) > 0)
		{
			for ($i = 0; $i < $c; $i++)
				$tmp .= $res[$i][0] . ", ";
	
			$tmp = substr($tmp, 0, -2);
			$this->sql->query("DELETE FROM " . $this->DB_T_USER_VARS . " WHERE id in ($tmp)");
		}

/*		$result = mysql_query($Query, $this->_sess_db_hand);

		// delete variables associated with the sessions we're about to DELETE
		while($res = mysql_fetch_row($result)){
			$Query="DELETE FROM " . $this->DB_T_USER_VARS . " WHERE id=$res[0]";
			mysql_query($Query, $this->_sess_db_hand);
		}*/

		// kill IDs after 12 hours for the sake of resources!
		$Query = "DELETE FROM " . $this->DB_T_SESSION . " WHERE LastAction < '";
		$Query .= date("Y-m-d H:i:s", (time() - $this->MAX_UNAUTH_IDLE));
		$Query .= "'";
//		mysql_query($Query, $this->_sess_db_hand);
		$this->sql->query($Query);

		if ($debug) printf("Query=%s.<br>", $Query);

		// log users out if idle for 5 minutes
		// time problems resolved but
		// was noting ocassionally: 5 increments per second?

		$Query = "UPDATE " . $this->DB_T_SESSION . " SET userID = NULL WHERE LastAction < '";
		$Query .= date("Y-m-d H:i:s", (time() - $this->MAX_AUTH_IDLE));
		$Query .= "'";
//		mysql_query($Query, $this->_sess_db_hand);
		$this->sql->query($Query);

		if ($debug) printf("Query=%s.<br>", $Query);
		if ($debug) printf("Current Time=%s.<br>",date("Y-m-d H:i:s"));
	}

	function s_touch($sess)
	{
		//$debug = 1;
		$Query = "UPDATE " . $this->DB_T_SESSION . " SET LastAction = now() WHERE id = '$sess'";
//		mysql_query($Query, $this->_sess_db_hand);
		$this->sql->query($Query);

		if ($debug) printf("Query=%s.<br>", $Query);
	}

	function s_valid_session($sess)
	{
		//$debug = 1;

		$this->s_killold();

		if ($debug) printf("VALID: Recieved session=%s.<br>", $sess);

		if (!$sess)
			return 0;

		$Query = "SELECT * FROM " . $this->DB_T_SESSION . " WHERE id = '$sess'";
		if ($debug) printf("Query=%s.(validsess)<br>", $Query);

//		$result = mysql_query($Query, $this->_sess_db_hand);
//		$status = mysql_fetch_row($result);
		$res = $this->sql->select($Query);
		$status = $res[0];

		return $status;
	}

	function s_get_var($varname)
	{
		//$debug = 1;

		$Query = "SELECT * FROM " . $this->DB_T_USER_VARS . " WHERE session = '" . $this->session . "' AND name = '$varname'";
		if ($debug) printf("Query=%s.(reg var)<br>", $Query);

/*		$result = mysql_query($Query, $this->_sess_db_hand);
		if (!$result) return 0;
		$obj = mysql_fetch_object($result);
		if (!$obj->intval) return $obj->strval;
		else return $obj->intval;*/

		$result = $this->sql->select($Query);
		if ($this->sql->rows == 0) return 0;
		if (!$result[0]['intval']) return $result[0]['strval'];
		else return $result[0]['intval'];
	}

	function s_is_registered($varname)
	{
		// $debug=1;

		$Query = "SELECT * FROM " . $this->DB_T_USER_VARS . " WHERE session = '" . $this->session . "' AND name = '$varname'";
		if ($debug) printf("Query=%s.(is regged)<br>", $Query);

/*		$result = mysql_query($Query, $this->_sess_db_hand);
		$rows = mysql_num_rows($result);
		return $rows;*/

		$this->sql->select($Query);
		return $this->sql->rows;
	}

	function s_set_var($varname, $type, $value)
	{
		//$debug = 1;

		$Query = "SELECT name FROM " . $this->DB_T_USER_VARS . " WHERE session = '" . $this->session . "' AND name = '$varname'";
		if ($debug) printf("Query=%s.(is regged)<br>", $Query);
//		$result = mysql_query($Query, $this->_sess_db_hand);
//		$rows = mysql_num_rows($result);
		$this->sql->select($Query);
		$rows = $this->sql->rows;

		switch($type)
		{
			case "INT":
				$intval = $value;
				$strval = "NULL";
				break;
			case "STRING":
				$intval = "NULL";
				$strval = $value;
				break;
		}

		if ($rows)
			$Query = "UPDATE " . $this->DB_T_USER_VARS . " SET intval = $intval, strval = '$strval' WHERE session = '" . $this->session . "' AND name = '$varname'";
		else
			$Query = "INSERT INTO " . $this->DB_T_USER_VARS . " values('$varname', '" . $this->session . "', $intval, '$strval', NULL)";

//		$result = mysql_query($Query, $this->_sess_db_hand);
		$this->sql->query($Query);
		if ($debug) printf("Query=%s.(set var)<br>", $Query);

		return true;
	}

	//lookey lookey! persistant DATA!!!!!
	function s_loadvars($session)
	{
		$Query = "SELECT * FROM " . $this->DB_T_USER_VARS . " WHERE session = '$session'";
/*		$result = mysql_query($Query, $this->_sess_db_hand);
		// echo "q=$Query";
		if ($result)
		{
			while($data = mysql_fetch_object($result)){
				//	echo "load=$data->name<br>";
				if ($data->intval)
					$GLOBALS[$data->name] = $data->intval;
				else
					$GLOBALS[$data->name] = $data->strval;
			}
		}*/

		global $HTTP_SESSION_VARS;
		if (!is_array($HTTP_SESSION_VARS))
			$HTTP_SESSION_VARS = array();

		$res = $this->sql->select($Query);
		for ($i = 0; $i < $this->sql->rows; $i++)
		{
			if ($res[$i]['intval'])
			{
				$HTTP_SESSION_VARS[$res[$i]['name']] = $res[$i]['intval'];
				$GLOBALS[$res[$i]['name']] = $res[$i]['intval'];
			}
			else
			{
				$HTTP_SESSION_VARS[$res[$i]['name']] = $res[$i]['strval'];
				$GLOBALS[$res[$i]['name']] = $res[$i]['strval'];
			}
		}
	}

	function s_demand_session()
	{
		global $HTTP_COOKIE_VARS;
		$this->session = $HTTP_COOKIE_VARS[$this->name];
		//$debug = 1;

		if ($debug) printf("Recieved session=%s<br>", $this->session);

		if (!$this->s_valid_session($this->session))
		{
			$this->session = $this->s_begin_session();
		}
		else
		{
			$this->s_loadvars($this->session);
		}

		define("SID", $this->name . "=" . $this->session);
		$this->s_touch($this->session);

		return true;
	}

	function s_login($userID)
	{
		//$debug = 1;
		$this->s_demand_session();

		$Query= "UPDATE " . $this->DB_T_SESSION . " SET userID = '$userID' WHERE id = '" . $this->session . "'";
//		mysql_query($Query, $this->_sess_db_hand);
		$this->sql->query($Query);

		if ($debug) printf("Query=%s.(s_login)<br>", $Query);
	}

	function s_gencode()
	{
		$session_code_length = 32;	// PHP4's session system uses MD5 hashes, which are 32 bytes long

		$this->s_killold();

		srand(time());

		$Puddle = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";

		for($index = 0; $index < $session_code_length; $index++){
			$sid .= substr($Puddle, (rand()%(strlen($Puddle))), 1);
		}

		//If by some miracle this id exists, return 0. It will not pass
		//when it is checked next.
		if ($this->s_valid_session($sid)) $sid = 0;

		return $sid;
	}

	function s_begin_session()
	{
		global $REMOTE_ADDR;

		if (empty($REMOTE_ADDR))
			$REMOTE_ADDR = getenv("REMOTE_ADDR");

		//!!!Displaying anything before outputing setcookie will cause the
		//header generation (and thus the cookie bake) to fail!!!
		//$debug = 1;

		while (!($sesscode = $this->s_gencode()));
		if ($debug) printf("Codemade=%s<br>", $sesscode);

		$Query = "INSERT INTO " . $this->DB_T_SESSION . " VALUES ('$sesscode', now(), '$REMOTE_ADDR', NULL)";

		if ($debug) printf("Query=%s.<br>", $Query);

//		mysql_query($Query, $this->_sess_db_hand);
		$this->sql->query($Query);

		setcookie($this->name, $sesscode, $this->cookie_lifetime, $this->cookie_path, $this->cookie_domain);

		return $sesscode;
	}

	function s_return_var($variable)
	{
		$Query = "SELECT $variable FROM " . $this->DB_T_SESSION . " WHERE id = '" . $this->session . "'";

		if ($debug) printf("Query=%s.<br>", $Query);

/*		$result = mysql_query($Query, $this->_sess_db_hand);
		$status = mysql_fetch_row($result);
		return $status[0];*/
		$result = $this->sql->select($Query);
		return $result[0][0];
	}

	//Checks to see if user is logged in and if so returns userID
	//----------------------------------------------------------------------------------
	function s_logged_in()
	{
		$this->s_killold();

		$this->s_demand_session();

		$Query = "SELECT userID FROM " . $this->DB_T_SESSION . " WHERE id = '" . $this->session . "'";

/*		$result = mysql_query($Query, $this->_sess_db_hand);
		$status = mysql_fetch_row($result);
		return $status[0];*/
		$result = $this->sql->select($Query);
		return $result[0][0];
	}

	function s_destroy()
	{
		$this->s_del_allvars();
		setcookie($this->name);
		return true;
	}

	function s_del_var($varname)
	{
		$Query = "DELETE FROM " . $this->DB_T_USER_VARS . " WHERE session = '" . $this->session . "' AND name = '$varname'";
		if ($debug) printf("Query=%s.(reg var)<br>", $Query);

//		$result = mysql_query($Query, $this->_sess_db_hand);
		$this->sql->query($Query);

		return true;
	}

	function s_del_allvars()
	{
		$Query = "DELETE FROM " . $this->DB_T_USER_VARS . " WHERE session = '" . $this->session . "'";
		if ($debug) printf("Query=%s.(reg var)<br>", $Query);

//		$result = mysql_query($Query, $this->_sess_db_hand);
		$this->sql->query($Query);

		return true;
	}

	function s_get_cookie_params()
	{
		return array(
			0 => $this->cookie_lifetime,
			1 => $this->cookie_path,
			2 => $this->cookie_domain,
			"lifetime" => $this->cookie_lifetime,
			"path" => $this->cookie_path,
			"domain" => $this->cookie_domain
		);
	}

	function s_set_cookie_params($lifeint, $path, $domain)
	{
		$this->cookie_path = $path;
		$this->cookie_lifetime = $lifeint;
		$this->cookie_domain = $domain;
		return 1;
	}

	function s_encode()
	{
		// to do
		return "true";
	}

	function s_decode($data)
	{
		// to do
		return true;
	}

	function s_name($name = "\0")
	{
		$tmp = $this->name;
		if ($name != "\0" && trim($name) != "") $this->name = $name;
		return $tmp;
	}

	function s_mod_name($module = "\0")
	{
		$tmp = $this->module;
		if ($module != "\0") $this->module = $module;
		return $tmp;
	}

	function s_id($id = "\0")
	{
		$tmp = $this->session;
		if ($id != "\0") $this->session = $id;
		return $tmp;
	}
}
?>