<?php
/***************************************
** Title........: Template class
** Filename.....: class.template.inc
** Author.......: Richard Heyes
** Editor.......: Arno van der Kolk
** Version......: 1.4.2
** Notes........: Function types:
**      basic    - use these
**      internal - don't use these
**      extended - for your convenience
** Last changed.: 01 Mar 2001
** Last change..:
**      Added a function for returning
**        an array of all registered
**        variables to a handle.
**      Added a function for removing
**        a registered handle.
**
**
**      Fixed a small offset bug when
**        two conditions follow eachother
**        directly.
**      Cleaned up code a bit,
**      modified comments,
**      added a _ to the front of names
**        of internal functions,
**      fixed parse_loop bug,
**      added the 'condition' tag,
**      added a constructor,
**      load_file returns true if load
**        succeeded,
**      added an HTML compressor
** Download original class from:
**   http://www.heyes-computing.net/scripts/
***************************************/

class template{

/***************************************
** These are _INTERNAL_ variables only:
***************************************/

	var $classname = "template";	/* for serialize */
	var $var_names = array();
	var $files = array();
	var $replaceCondition = "";
	var $start = '{';
	var $end = '}';
	var $stack = 0;

/***************************************
** These are public variables:
***************************************/

	var $optimize = FALSE;

/***************************************
** Constructor (needed for PHP3).
** Function added by Arno van der Kolk.
***************************************/

function template() {}

/***************************************
** Function to load a template into
** the class. (basic function)
***************************************/
	function load_file($file_id, $filename){
		if ($exist = file_exists($filename))
		{
			$this->files[$file_id] = fread($fp = fopen($filename, 'r'), filesize($filename));
			fclose($fp);
		}
		return $exist;
	}

/***************************************
** Function to set the tag identifiers
** into the class. (basic function)
***************************************/
	function set_identifiers($start, $end){
		$this->start = $start;
		$this->end = $end;
	}

/***************************************
** This function is used only by the
** register() method, for going through
** arays and extracting the values.
** (internal function)
***************************************/
	function _traverse_array($file_id, $array){
		while(list(,$value) = each($array)){
			if(is_array($value)) $this->_traverse_array($file_id, $value);
			else $this->var_names[$file_id][] = $value;
		}
	}

/***************************************
** Function to register a variable(s).
** (basic function)
***************************************/
	function register($file_id, $var_name){
		if(is_array($var_name)){
			$this->_traverse_array($file_id, $var_name);
		}elseif($var_name != ''){
			if(is_long(strpos($var_name, ',')) == TRUE){
				$var_name = explode(',', $var_name);
				for(reset($var_name); $current = current($var_name); next($var_name)) $this->var_names[$file_id][] = trim($current);
			}else{
				$this->var_names[$file_id][] = $var_name;
			}
		}
	}

/***************************************
** Function to include another file.
** eg. A header/footer.
** (basic/internal function)
***************************************/
	function include_file($file_id, $filename){
		if(file_exists($filename)){
			$include = fread($fp = fopen($filename, 'r'), filesize($filename));
			fclose($fp);
		}else $include = '[ERROR: "'.$filename.'" does not exist.]';

		$tag = substr($this->files[$file_id], strpos(strtolower($this->files[$file_id]), '<include filename="'.$filename.'">'), strlen('<include filename="'.$filename.'">'));
		$this->files[$file_id] = str_replace($tag, $include, $this->files[$file_id]);
	}

/***************************************
** Function for reading and parsing the
** html file for normal variables. Also
** now checks for include tags and if
** necessary calls include_file()
** (basic function)
***************************************/
	function parse($file_id){
		$file_ids = explode(',', $file_id);
		for(reset($file_ids); $file_id = trim(current($file_ids)); next($file_ids)){

/*			$pos = 0;
			while(is_long($pos = strpos(strtolower($this->files[$file_id]), '<include filename="'))){
				$pos += 19;
				$endpos = strpos($this->files[$file_id], '">', $pos);
				$filename = substr($this->files[$file_id], $pos, $endpos - $pos);
				$this->include_file($file_id, $filename);
			}*/

//Added by Arno van der Kolk:
			$pos = 0;
			while(is_long($pos = strpos(strtolower($this->files[$file_id]), '<include handle="', $pos))){
				$pos += 17;
				$endpos = strpos($this->files[$file_id], '">', $pos);
				$filename = substr($this->files[$file_id], $pos, $endpos - $pos);
				$this->files[$file_id] = substr($this->files[$file_id], 0, $pos - 17) . $this->pget($filename) . substr($this->files[$file_id], $endpos + 2);
			}

//Added by Arno van der Kolk (slow-mo):
/*			for ($i = 0; $i < sizeof($this->var_names[$file_id]); $i++)
			{
				reset($this->files);
				while (list ($key, $val) = each ($this->files))
				{
//					echo $key, " - ", $this->var_names[$file_id][$i], "<br>\n";
					if ($this->var_names[$file_id][$i] == $key)
					{
//						echo "Match<br><hr>$val<hr>\n";
						$this->files[$file_id] = str_replace("\{$key}", $this->pget($key), $this->files[$file_id]);
					}
				}
			}*/

//Added by Arno van der Kolk:
			$text = $this->files[$file_id];
			$text = $this->filterTemplateComments($text);
			$pos = -1;

//			$openTag = '<condition id="';
//			$closeTag = '</condition id="';
			$openTag = '<condition name="';
			$closeTag = '</condition name="';

			while(is_long($pos = strpos(strtolower($text), $openTag, $pos + 1))){
				$endpos = strpos($text, '">', $pos + strlen($openTag));
				$name = substr($text, $pos + strlen($openTag), $endpos - ($pos + strlen($openTag)));
				if (strpos($name, ".") == 0)			// make sure it is not a LOOP variable
				{
					if (substr($name, 0, 1) == "!"){
						$neg = TRUE;
						$name = substr($name, 1);
					}else{
						$neg = FALSE;
					}

					$pos2 = $endpos;
					while (is_long($pos2 = strpos(strtolower($text), $closeTag, $pos2 + 1))){
						$endpos2 = strpos($text, '">', $pos2 + strlen($closeTag));
						$name2 = substr($text, $pos2 + strlen($closeTag), $endpos2 - ($pos2 + strlen($closeTag)));
						if (substr($name2, 0, 1) == "!"){						//check if 'negative' condition
							$neg2 = TRUE;
							$name2 = substr($name2,1);
						}else{
							$neg2 = FALSE;
						}

						if ($name == $name2 && $neg == $neg2){
							$$name = $GLOBALS[$name];
							$condition = (isset($$name) && $$name);
							if ($neg) $condition = !$condition;					//for 'negative' conditions
							if ($condition){
								$text = substr_replace($text, "", $pos, $endpos + 2 - $pos);
//								$text = substr($text, 0, $pos) . substr($text, $endpos + 2);
								$tmp = (($neg)?1:0);
								$pos2 = $pos2 - (strlen($openTag) + 2 + strlen($name) + $tmp);//strpos(strtolower($text), '</condition name="', $endpos);
								$endpos2 = 1 + $endpos2 - (strlen($closeTag) + 2 + strlen($name) + $tmp);	//strpos($text, '">', $pos2+18);
								$text = substr_replace($text, "", $pos2, $endpos2 + 2 - $pos2);
//								$text = substr($text, 0, $pos2) . substr($text, $endpos2 + 2);
							}else{
								$text = substr_replace($text, $this->replaceCondition, $pos, $endpos2 + 2 - $pos);
//								$text = substr($text, 0, $pos) . $this->replaceCondition . substr($text, $endpos2 + 2);
							}
							$pos--;
							break;
						}else{
//							echo "NOMATCH"; 									// (probably a 'nested' condition)
						}
					}
				}
			}
			$this->files[$file_id] = $text;
//End

			if(isset($this->var_names[$file_id]) AND count($this->var_names[$file_id]) > 0){
				for($i=0; $i<count($this->var_names[$file_id]); $i++){
					$temp_var = $this->var_names[$file_id][$i];
//					global $$temp_var;
					$this->files[$file_id] = str_replace($this->start.$temp_var.$this->end, $GLOBALS[$temp_var], $this->files[$file_id]);
				}
			}
		}
	}

/***************************************
** Function for parsing an array.
** (basic function)
**
** Note: DOES NOT WORK WHEN $array_name
** CONTAINS AN UPPERCASE NAME!!!
***************************************/
	function parse_loop($file_id, $array_name, $array = "\0"){
		$$array_name = $array;
		if ($array == "\0")
			$$array_name = $GLOBALS[$array_name];

		if (count($$array_name) == 0 || count(${$array_name}[0]) == 0) // to make sure this is a proper 2 dimensional array
			$$array_name = array();

		$loop_code = '';
//		$file = explode(chr(10), $this->files[$file_id]);

		$start_pos = strpos(strtolower($this->files[$file_id]), '<loop name="'.$array_name.'">') + strlen('<loop name="'.$array_name.'">');
		$end_pos = strpos(strtolower($this->files[$file_id]), '</loop name="'.$array_name.'">');

// text to be looped
		$org_code = substr($this->files[$file_id], $start_pos, $end_pos - $start_pos);
		$loop_code = " $org_code"; 	// this will make sure that the 'noitems-text' is not at position 0

// find text for '0' items
		$zero_items_text = "";
		if ($start_pos = strpos(strtolower($loop_code), '<noitems>'))
			if ($end_pos = strpos(strtolower($loop_code), '</noitems>'))
			{
				$add = strlen('<noitems>');
				$zero_items_text = substr($loop_code, $start_pos + $add, $end_pos - ($start_pos + $add));	// get noitems text
				$loop_code = substr($loop_code, 0, $start_pos) . substr($loop_code, $end_pos + ($add + 1));	// filter out noitems text
			}

		$loop_code = substr($loop_code, 1);	// strip prepended space

		$start_tag = substr($this->files[$file_id], strpos(strtolower($this->files[$file_id]), '<loop name="'.$array_name.'">'),strlen('<loop name="'.$array_name.'">'));
		$end_tag = substr($this->files[$file_id], strpos(strtolower($this->files[$file_id]), '</loop name="'.$array_name.'">'),strlen('</loop name="'.$array_name.'">'));

		if($loop_code != ''){
			$new_code = '';
			for($i=0; $i<count($$array_name); $i++){
				$temp_code = $loop_code;
				while(list($key) = each(${$array_name}[$i])){
					$temp_code = str_replace($this->start . "$array_name.$key" . $this->end, ${$array_name}[$i][$key], $temp_code);
				}

				$text = $temp_code;
				$pos = -1;

	//			$openTag = '<condition id="';
	//			$closeTag = '</condition id="';
				$openTag = '<condition name="';
				$closeTag = '</condition name="';

				while(is_long($pos = strpos(strtolower($text), $openTag, $pos + 1))){
					$endpos = strpos($text, '">', $pos + strlen($openTag));
					$name = substr($text, $pos + strlen($openTag), $endpos - ($pos + strlen($openTag)));

					if (substr($name, 0, 1) == "!"){
						$neg = TRUE;
						$name = substr($name, 1);
					}else{
						$neg = FALSE;
					}

					if (substr($name, 0, strlen("$array_name.")) == "$array_name.")			// is not a LOOP variable
					{
						$pos2 = $endpos;
						while (is_long($pos2 = strpos(strtolower($text), $closeTag, $pos2 + 1))){
							$endpos2 = strpos($text, '">', $pos2 + strlen($closeTag));
							$name2 = substr($text, $pos2 + strlen($closeTag), $endpos2 - ($pos2 + strlen($closeTag)));
							if (substr($name2, 0, 1) == "!"){						//check if 'negative' condition
								$neg2 = TRUE;
								$name2 = substr($name2,1);
							}else{
								$neg2 = FALSE;
							}

							if ($name == $name2 && $neg == $neg2){
								//global $$name;
								$$name = ${$array_name}[$i][substr($name, strpos($name, ".") + 1)];
								$condition = (isset($$name) && $$name);
								if ($neg) $condition = !$condition;					//for 'negative' conditions
								if ($condition){
									$text = substr_replace($text, "", $pos, $endpos + 2 - $pos);
//									$text = substr($text, 0, $pos) . substr($text, $endpos + 2);
									$tmp = (($neg)?1:0);
									$pos2 = $pos2 - (strlen($openTag) + 2 + strlen($name) + $tmp);
									$endpos2 = 1 + $endpos2 - (strlen($closeTag) + 2 + strlen($name) + $tmp);
									$text = substr_replace($text, "", $pos2, $endpos2 + 2 - $pos2);
//									$text = substr($text, 0, $pos2) . substr($text, $endpos2 + 2);
								}else{
									$text = substr_replace($text, $this->replaceCondition, $pos, $endpos2 + 2 - $pos);
//									$text = substr($text, 0, $pos) . $this->replaceCondition . substr($text, $endpos2 + 2);
								}
								$pos--;
								break;
							}else{
	//							echo "NOMATCH"; 									// (probably a 'nested' condition)
							}
						}
					}
				}
				$temp_code = $text;

				$new_code .= $temp_code;
			}
			if (count($$array_name) == 0)
				$new_code = $zero_items_text;
			$this->files[$file_id] = str_replace($start_tag.$org_code.$end_tag, $new_code, $this->files[$file_id]);
			//echo $start_tag.$loop_code.$end_tag."<hr>";
			//echo $new_code."<hr>";
			//echo $this->files[$file_id]."<hr>";
		}
	}

/***************************************
** Function for parsing a Mysql result
** set. (basic function)
***************************************/
	function parse_sql($file_id, $result_name){
		global $$result_name;
		$loop_code = '';

		$start_pos = strpos(strtolower($this->files[$file_id]), '<loop name="'.$result_name.'">') + strlen('<loop name="'.$result_name.'">');
		$end_pos = strpos(strtolower($this->files[$file_id]), '</loop name="'.$result_name.'">');

		$loop_code = substr($this->files[$file_id], $start_pos, $end_pos - $start_pos);

		$start_tag = substr($this->files[$file_id], strpos(strtolower($this->files[$file_id]), '<loop name="'.$result_name.'">'),strlen('<loop name="'.$result_name.'">'));
		$end_tag = substr($this->files[$file_id], strpos(strtolower($this->files[$file_id]), '</loop name="'.$result_name.'">'),strlen('</loop name="'.$result_name.'">'));

		if($loop_code != ''){
			$new_code = '';
			$field_names = array();
			for($i=0; $i<mysql_num_fields($$result_name); $i++) $field_names[] = mysql_field_name($$result_name,$i);
			while($row_data = mysql_fetch_array($$result_name, MYSQL_ASSOC)){
				$temp_code = $loop_code;
				for($i=0; $i<count($field_names); $i++){
					$temp_code = str_replace($this->start.$field_names[$i].$this->end, $row_data[$field_names[$i]], $temp_code);
				}
				$new_code.= $temp_code;
			}
			$this->files[$file_id] = str_replace($start_tag.$loop_code.$end_tag, $new_code, $this->files[$file_id]);
		}
	}

/***************************************
** Function for parsing a Postgres result
** set. (basic function)
***************************************/
	function parse_pgsql($file_id, $result_name){
		global $$result_name;
		$loop_code = '';

		$start_pos = strpos(strtolower($this->files[$file_id]), '<loop name="'.$result_name.'">') + strlen('<loop name="'.$result_name.'">');
		$end_pos = strpos(strtolower($this->files[$file_id]), '</loop name="'.$result_name.'">');

		$loop_code = substr($this->files[$file_id], $start_pos, $end_pos - $start_pos);

		$start_tag = substr($this->files[$file_id], strpos(strtolower($this->files[$file_id]), '<loop name="'.$result_name.'">'),strlen('<loop name="'.$result_name.'">'));
		$end_tag = substr($this->files[$file_id], strpos(strtolower($this->files[$file_id]), '</loop name="'.$result_name.'">'),strlen('</loop name="'.$result_name.'">'));

		if($loop_code != ''){
			$new_code = '';
			$field_names = array();
			for($i=0; $i<pg_numfields($$result_name); $i++) $field_names[] = pg_fieldname($$result_name,$i);
			for($i=0; $i<pg_numrows($$result_name) AND $row_data = pg_fetch_array($$result_name, $i); $i++){
				$temp_code = $loop_code;
				for($j=0; $j<count($field_names); $j++){
					$temp_code = str_replace($this->start.$field_names[$j].$this->end, $row_data[$field_names[$j]], $temp_code);
				}
				$new_code.= $temp_code;
			}
			$this->files[$file_id] = str_replace($start_tag.$loop_code.$end_tag, $new_code, $this->files[$file_id]);
		}
	}

/***************************************
** Function for printing the resulting
** file(s). (basic function)
***************************************/
	function print_file($file_id){
		if(is_long(strpos($file_id, ',')) == TRUE){
			$file_id = explode(',', $file_id);
			for(reset($file_id); $current = current($file_id); next($file_id)) echo $this->files[trim($current)];
		}else{
			echo $this->files[$file_id];
		}
	}

/***************************************
** Function for returning the resulting
** file(s). (basic function)
***************************************/
	function return_file($file_id){
		$ret = '';
		if(is_long(strpos($file_id, ',')) == TRUE){
			$file_id = explode(',', $file_id);
			for(reset($file_id); $current = current($file_id); next($file_id)) $ret .= $this->files[trim($current)];
		}else{
			$ret .= $this->files[$file_id];
		}
		return $this->_optimizeHTML($ret);
	}

/***************************************
** Parses and then immediately prints
** the file. This function added by
** Bruce Christensen.
** (extended function)
***************************************/
	function pprint($file_id, $replacements = ''){
		$this->register($file_id, $replacements);
		$this->parse($file_id);
		$this->print_file($file_id);
	}

/***************************************
** Parses and then immediately returns
** the file's contents. Function added
** by Bruce Christensen.
** (extended function)
***************************************/
	function pget($file_id, $replacements = ''){
		$this->register($file_id, $replacements);
		$this->parse($file_id);
		return $this->return_file($file_id);
	}

/***************************************
** Loads a file, parses it, and prints it.
** This function added by Bruce Christensen.
** (extended function)
***************************************/
	function pprint_file($filename, $replacements = ''){
		for($file_id=1; isset($this->files[$file_id]); $file_id++);
		$this->load_file($file_id, $filename);
		$this->pprint($file_id, $replacements);
		unset($this->files[$file_id]);
	}

/***************************************
** Loads, parses and then immediately
** returns the file's contents.
** Function added by Bruce Christensen.
** (extended function)
***************************************/
	function pget_file($filename, $replacements = ''){
		for($file_id=1; isset($this->files[$file_id]); $file_id++);
		$this->load_file($file_id, $filename);
		return $this->pget($file_id, $replacements);
	}

/***************************************
** Optimizes the HTML of a template.
** Function added by Arno van der Kolk.
** (basic/internal function)
***************************************/
	function _optimizeHTML($text){
		if (!$this->optimize) return $text;
		preg_match_all("/<pre>.*<\/pre>/is", $text, $out);
		preg_match_all("/<textarea>.*<\/textarea>/is", $text, $out2);
//		$pos = -1;// $pos2 = -1;
//		while (is_long($pos = strpos($text, '<!--', $pos+1)) && is_long($pos2 = strpos($text, '-->', $pos)))
//		{	$text = substr_replace($text, '', $pos, $pos2 - $pos + 3);	}
		$expression = "!(<script( .*)?".">.*){0}<\!--.*-->(.*</script>){0}!Uis";
		$replacement = "";
		$text = preg_replace($expression, $replacement, $text);
//		$pos = -1;// $pos2 = -1;
//		while (is_long($pos = strpos($text, '<'.'?', $pos+1)) && is_long($pos2 = strpos($text, '?'.'>', $pos)))
//		{	$text = substr_replace($text, '', $pos, $pos2 - $pos + 2);	}
		$q = quotemeta("?");
		$expression = "!<" . $q . ".*" . $q . ">!Uis";
		$replacement = "";
		$text = preg_replace($expression, $replacement, $text);
		$text = str_replace("\r", " ", $text);
		$text = str_replace("\n", " ", $text);
		$text = str_replace("\t", " ", $text);
		$text = str_replace("\0", " ", $text);
		//$text = str_replace("> ", ">", $text);
		//$text = str_replace(" <", "<", $text);
		//$text = str_replace("> <", "><", $text);
		while (is_long(strpos($text, "  ")))
			$text = str_replace("  ", " ", $text);
		for ($i = 1; $i < sizeof($out); $i++)
			$text = preg_replace("/<pre>.*<\/pre>/is", $out[$i][0], $text);
		for ($i = 1; $i < sizeof($out2); $i++)
			$text = preg_replace("/<textarea>.*<\/textarea>/is", $out2[$i][0], $text);
		unset($q);
		unset($expression);
		unset($replacement);
		unset($pos);
		unset($pos2);
		unset($out);
		unset($out2);
		unset($i);
		return trim($text);
	}

/***************************************
** Sets the template text.
** Function added by Arno van der Kolk.
** (basic function)
***************************************/
	function set_template($file_id, $text){
		$this->files[$file_id] = $text;
	}

/***************************************
** Returns all set variables.
** Function added by Arno van der Kolk.
** (basic function)
***************************************/
	function get_vars($file_id){
		return $this->var_names[$file_id];
	}

/***************************************
** Removes all set variables.
** Function added by Arno van der Kolk.
** (basic function)
***************************************/
	function clear_vars($file_id){
		unset($this->var_names[$file_id]);
		unset($this->files[$file_id]);
	}

/*	function parse_condition($file_id, $offset = -1, $loopname = "")
	{
		$openTag = '<condition name="';
		$closeTag = '</condition name="';
		$pos = $offset;
		$text = &$this->files[$file_id];

		if (is_long($pos = strpos(strtolower($text), $openTag, $pos + 1)))
		{
		}







		if (is_long($pos = strpos(strtolower($text), $openTag, $pos + 1)))
		{
			$this->stack++;
			do_condition($file_id, $pos + 1);
		}
		else if ($this->stack > 0)
		{
				$endpos = strpos($text, '">', $pos + strlen($openTag));
				$name = substr($text, $pos + strlen($openTag), $endpos - ($pos + strlen($openTag)));
				if (strpos($name, ".") == 0)			// make sure it is not a LOOP variable
				{
					if (substr($name, 0, 1) == "!"){
						$neg = TRUE;
						$name = substr($name, 1);
					}else{
						$neg = FALSE;
					}

					$pos2 = $endpos;
					while (is_long($pos2 = strpos(strtolower($text), $closeTag, $pos2 + 1))){
						$endpos2 = strpos($text, '">', $pos2 + strlen($closeTag));
						$name2 = substr($text, $pos2 + strlen($closeTag), $endpos2 - ($pos2 + strlen($closeTag)));
						if (substr($name2, 0, 1) == "!"){						//check if 'negative' condition
							$neg2 = TRUE;
							$name2 = substr($name2,1);
						}else{
							$neg2 = FALSE;
						}

						if ($name == $name2 && $neg == $neg2){
							$$name = $GLOBALS[$name];
							$condition = (isset($$name) && $$name);
							if ($neg) $condition = !$condition;					//for 'negative' conditions
							if ($condition){
								$text = substr_replace($text, "", $pos, $endpos+2-$pos);
								$tmp = (($neg)?1:0);
								$pos2 = $pos2 - (strlen($openTag) + 2 + strlen($name) + $tmp);//strpos(strtolower($text), '</condition name="', $endpos);
								$endpos2 = 1 + $endpos2 - (strlen($closeTag) + 2 + strlen($name) + $tmp);	//strpos($text, '">', $pos2+18);
								$text = substr_replace($text, "", $pos2, $endpos2 + 2 - $pos2);
							}else{
								$text = substr_replace($text, $this->replaceCondition, $pos, $endpos2 + 2 - $pos);
							}
							$pos--;
							break;
						}else{
//							echo "NOMATCH"; 									// (probably a 'nested' condition)
						}
					}
				}
		}
	}*/

	function filterTemplateComments($text)
	{
		$open = $this->start . "--";
		$close = "--" . $this->end;
		if (floor(phpversion()) < 4)
		{
			$match = true;
			while ($match && $pos = strpos($text, $open))
			{
				$match = false;
				if ($pos2 = strpos($text, $close, $pos + strlen($open)))
				{
					$text = substr($text, 0, $pos) . substr($text, $pos2 + strlen($close));
					$match = true;
				}
			}
		}
		else
		{
			$text = preg_replace("/" . quotemeta($open) . "(\n|\r|.)*" . quotemeta($close) . "/Ui", "", $text);
		}
		return $text;
	}

} // End of class

?>