<?php

/*

YapBB, a fully functional bulletin board system
Copyright (C) 2000/01  Arno van der Kolk
http://yapbb.sourceforge.net/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

require($cfgIncludeDirectory . "class_pspcooker" . (floor(phpversion()) < 4 ? "_php3" : "") . ".php");

class YapBBCooker extends PSPCooker
{
	var $classname = "YapBBCooker";	// for serialize

//=====================================================================================================================
// For the sake of PHP3 we have to explicitly add this constructor :(
//=====================================================================================================================
	function YapBBCooker($store = "/tmp/", $repository = "pspcooker_repository.php")
	{
		if (!is_array($GLOBALS["pspcooker_include_bits"]))		// lazy/static initializer
			$GLOBALS["pspcooker_include_bits"] = array();

		$this->_storage_directory = $store;
		$this->_repository = $this->_storage_directory . $repository;
	} // end constructor

//=====================================================================================================================
// Obsolete stuff actually, should not be used
//=====================================================================================================================
	function set_identifiers($start, $end) {
		// not allowed
	}

	function parse_loop($handle, $array) {
		$this->register($handle, $array);
	}

	function print_file($handle) {
		$this->execute($handle);
	}

	function return_file($handle) {
		return $this->execute($handle, "GETTEXT");;
	}

	function pprint($handle, $replacements = '') {
		$this->register($handle, $replacements);
		$this->execute($handle);
	}

	function pget($handle, $replacements = '') {
		$this->register($handle, $replacements);
		return $this->execute($handle, "GETTEXT");
	}

	function pprint_file($filename, $replacements = '') {
		for($file_id=1; isset($this->_files[$file_id]); $file_id++);
		$this->load_file($file_id, $filename);
		$this->pprint($file_id, $replacements);
		unset($this->_files[$file_id]);
	}

	function pget_file($filename, $replacements = '') {
		for($file_id=1; isset($this->_files[$file_id]); $file_id++);
		$this->load_file($file_id, $filename);
		return $this->pget($file_id, $replacements);
		unset($this->_files[$file_id]);
	}

	function set_template($handle, $text) {
		$this->_files[$handle] = addslashes($text);
		$this->_files[$handle] = str_replace("\'", "'", $this->_files[$handle]);
		$this->_template_files[$handle] = "";
	}

	function get_vars($handle) {
		return Array();
	}

	function clear_vars($handle) {
		// not allowed
	}

	function parse($handle) {
		// not allowed
	}
}

?>