<?php if (!$GLOBALS['includeBit']) exit();

/*

YapBB, a fully functional bulletin board system
Copyright (C) 2000/01  Arno van der Kolk
http://yapbb.sourceforge.net/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/


//=====================================================================================================================
// Check if the underlying PHP interpreter is of the right version
//=====================================================================================================================

$cfgPHP3compatibility = $cfgPHP3compatibility || floor(phpversion()) < 4;

/*$versie = floor(phpversion());
if ($versie == 4)	;//do nothing
elseif ($versie == 3) die("<h1>This board does not yet work with PHP3</h1>");
elseif ($versie < 3) die("<h1>PHP $versie is not supported</h1>");
else die("<h1>Unable to determine version of PHP$versie</h1>");
unset($versie);*/

if (floor(phpversion()) == 3)
{
	function trigger_error($msg, $type = "\0") {
		sendError($msg . ($type != "\0" ? " ($type)" : ""));
	}
	function set_error_handler($name) {
	}
	function ob_start()	{
	}
	function ob_end_clean() {
	}
	function ob_get_contents() {
	}
	function ob_end_flush() {
	}
// the following generates a compile error :(
//	function highlight_string () {
//	}
}


//=====================================================================================================================
// Initializers
//=====================================================================================================================

function myErrorHandler($errno, $errstr, $errfile, $errline, $errcontext)
{
	if ($errno == (E_ERROR | E_WARNING | E_PARSE | E_USER_ERROR))
	{
		if (error_reporting() == 0)
			; // an @ was used
		sendError("An error ($errno) has occured on line $errline (context: $errcontext) in file <small>$errfile</small>:<br><br>$errstr");
	}
}

if (function_exists("set_time_limit") && !get_cfg_var('safe_mode'))
	set_time_limit(180);

//error_reporting(E_ERROR | E_WARNING | E_PARSE | E_USER_ERROR);	// 7 + 256
//set_error_handler("myErrorHandler");
//http://www.php.net/manual/en/function.set-error-handler.php

$templateStartTime = microtime();	// Set start time (for performance measuring)
/*$templateStartTime = time();
function getTemplateStopTime() {require($cfgIncludeDirectory . "cleanup.php");}
register_shutdown_function("getTemplateStopTime");*/


//=====================================================================================================================
// String: PHP3 versions of PHP4 native functions
//=====================================================================================================================
//if (floor(phpversion()) < 4)
if (!function_exists("substr_replace"))
{
	function substr_replace($text, $replacement, $start, $length)
	{
		$org = $text;
		$text = substr($org, 0, $start) . $replacement . substr($org, $start + $length);
		return $text;
	}
}

if (!function_exists("array_values"))
{
	function array_values ($arr) {
		$t = array();
		while (list($k, $v) = each ($arr))
			$t[] = $v;
		return $t;
	}
}

if (!function_exists("array_keys"))
{
	function array_keys($arr, $term = "")
	{
		$t = array();
		while (list($k,$v) = each($arr))
		{
			if ($term && $v != $term)
				continue;
			$t[] = $k;
		}
		return $t;
	}
}


//=====================================================================================================================
// void: in stead of 'die'-ing, use this function to 'gracefully' report the error ($msg)
//=====================================================================================================================
function sendError($msg, $fatal = FALSE)
{
	global $cfgBaseURL, $cfgImageURL, $cfgForumTitle, $cfgEmail;
	$refererurl = getenv("HTTP_REFERER");
	if ($refererurl == "")
		$refererurl = $cfgBaseURL . "frontpage.php";
	$text = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/REC-html40/loose.dtd">' . "\t
	<html>
	<head>
	<meta name='MSSmartTagsPreventParsing' content='TRUE'>
	<LINK HREF='" . $cfgBaseURL . "style.php' rel='styleSheet' TYPE='text/css'>
	<title>$cfgForumTitle - Error</title>
	</head>
	<body id='all'>
		<table class='darkBox' width='425' border='0' cellpadding='2' cellspacing='0' align='center'>
		<tr class='header'>
		<td colspan='2'>&nbsp;</td>
		</tr>
		<tr class='alternate1'>
		<td><img alt='Error' src='" . $cfgImageURL . "error.gif'></td>
		<td align='center'>
		<h2>$msg</h2>
		</td>
		</tr>".(!$fatal?"
		<tr class='alternate1'>
		<td align='center' colspan='2' class='bigFont'>
		<a href='$refererurl'>Back to the board</a>
		</td>
		</tr>
		<tr class='alternate1'>
		<td align='center' colspan='2' class='bigFont'>
		Report errors to <a href='mailto:$cfgEmail'>$cfgEmail</a>
		</td>
		</tr>":"")."
		</table>
	</body>
	</html>
	";
	print($text);
	exit();
}

//=====================================================================================================================
// int: returns the number of rows in table with name '$table'
//=====================================================================================================================
function getRowCount($table)
{
	if (trim($table) == "") return 0;

	$db = new MySQL;
	$res = $db->select("SELECT COUNT(*) AS count FROM $table");
	if ($db->rows < 1)
		sendError("pe: No users!");
	$i = (int)($res[0]['count']);
	unset($db);
	unset($res);
	return $i;
}

//=====================================================================================================================
// String: returns the status of the intended user in $userQueryRow
//         ($userQueryRow is an array, containing the appropriate row)
//         if $longInfo is true and the rank of the user equals moderator, a list of all forums is appended
//=====================================================================================================================
function getUserStatus($userQueryRow, $longInfo = FALSE)
{
	global $cfgBaseURL, $cfgShowUserStatus, $cfgStrOperator, $cfgDatabase;
	if ($cfgShowUserStatus)
	{
		$db = new MySQL;
		$dbRes = $db->select("SELECT description, requirements FROM " . $cfgDatabase['status'] . " ORDER BY requirements ASC");
		for ($i = 0; $i < $db->rows; $i++)
		{
			if ($userQueryRow['posts'] >= $dbRes[$i]['requirements'])
				$userStatus = stripslashes($dbRes[$i]['description']);
		}
		unset($db);
		unset($dbRes);
	}
	else
		$userStatus = $cfgStrOperator[0];

	$tmp = (int)($userQueryRow['groupid']);
	if ($tmp > 1)
		$userStatus = $cfgStrOperator[$tmp - 1];
	if ($tmp == 2 && $longInfo)
	{
		$forumQuery = new MySQL;
		$forRes = $forumQuery->select("SELECT f.id, f.name FROM " . $cfgDatabase['forum'] . " AS f, " . $cfgDatabase['moderator'] . " AS m, " . $cfgDatabase['user'] . " AS u WHERE f.id = m.forumid AND m.userid = " . $userQueryRow['id'] . " AND u.id = m.userid AND u.groupid > 1");
		if ($forumQuery->rows > 0)
		{
			$userStatus .= " of<ul>";
			for ($i = 0; $i < $forumQuery->rows; $i++)
			{
				$forRes[$i]['name'] = stripslashes($forRes[$i]['name']);
				$userStatus .= '<li><a href="' . $cfgBaseURL . 'forumDisplay.php?forumID=' . $forRes[$i]['id'] . '">';
				$userStatus .= $forRes[$i]['name'] . "</a>\n";
			}
			$userStatus .= "</ul>";
		}
		unset($forumQuery);
		unset($forRes);
	}
	return $userStatus;
}

//=====================================================================================================================
// String: returns a navigational path, ready to be included into the header and footer of all pages
//=====================================================================================================================
function getLocation($forumID = 0, $topicID = 0)
{
	global $cfgBaseURL, $cfgDatabase, $lang;

	if ($forumID == 0 && $topicID > 0) $forumID = getForumID($topicID);
	$returnString = "";
	$returnString .= $lang['navigation'] . ": \n";
	$returnString .= '<a href="' . $cfgBaseURL . 'frontpage.php">' . $lang['index'] . "</a>\n";

	$query = "";
	if ($forumID > 0)
		$query = "SELECT name FROM " . $cfgDatabase['forum'] . " WHERE id = $forumID";
	if ($topicID > 0)
		$query = "SELECT f.name, t.description FROM " . $cfgDatabase['topic'] . " AS t, " . $cfgDatabase['forum'] . " AS f WHERE t.id = $topicID AND f.id = t.forumid";

	if ($query != "")
	{
		$dbQuery = new MySQL;
		$res = $dbQuery->select($query);

		if ($dbQuery->rows == 1)
		{
			if ($forumID > 0)
			{
				$returnString .= " \ \n";
				$returnString .= '<a href="' . $cfgBaseURL . "forumDisplay.php?forumID=$forumID\">" . htmlspecialchars(stripslashes($res[0]['name'])) . "</a>\n";
				if ($topicID > 0)
				{
					$returnString .= " \ \n";
					$returnString .= '<a href="' . $cfgBaseURL . "topicDisplay.php?topicID=" . $topicID . '">' . htmlspecialchars(stripslashes($res[0]['description'])) . "</a>\n";
				}
			}
		}
		else
		{
			sendError("pe: int summin");
		}

		unset($dbQuery);
		unset($res);
	}

	unset($query);
	return $returnString;
}

//=====================================================================================================================
// int: returns parent forum of $topicID
//=====================================================================================================================
function getForumID($topicID)
{
	global $cfgDatabase;
	$topicQuery = new MySQL;
	$topRes = $topicQuery->select("SELECT forumid FROM " . $cfgDatabase['topic'] . " WHERE id = $topicID");
	if ($topicQuery->rows != 1)
		sendError("ue: Invalid topicid: $topicID #" . $topicQuery->rows);
	$forumID = $topRes[0]['forumid'];
	unset($topicQuery);
	unset($topRes);
	return (int)$forumID;
}

//=====================================================================================================================
// bool: return true if $IP is a banned one
//=====================================================================================================================
function checkIPban($IP)
{	global $cfgDatabase;								//mod: to accept * and ?
	$query = new MySQL;
	$query->select("SELECT id FROM " . $cfgDatabase['ipban'] . " WHERE ip = '$IP'");
	$bool = $query->rows > 0;
	unset($query);
	return $bool;
}

//=====================================================================================================================
// int array: returns logged in userCcount {0 = memberCount, 1 = guestCount}
//=====================================================================================================================
function getVisitors()
{
	global $cfgOnlineTime,
	$sessionUserID,
	$cfgDatabase,
	$cfgCountUsers,
	$templateLoggedIn;

	$query = new MySQL;

	if ($cfgCountUsers)
	{
		if ($templateLoggedIn && $sessionUserID != "")
			$tmp = $sessionUserID;
		else
			$tmp = 0;
		$query->query("INSERT INTO " . $cfgDatabase['useronline'] . " (userid, date, ip) VALUES ($tmp, " . time() . ", '" . addslashes(getenv('REMOTE_ADDR')) . "')");
	}

	$tijd = time() - $cfgOnlineTime;
	$query->query("DELETE FROM " . $cfgDatabase['useronline'] . " WHERE date < $tijd");
	$query->select("SELECT DISTINCT userid FROM " . $cfgDatabase['useronline'] . " WHERE userid > 0");
	$i1 = 0 + $query->rows;
	$query->select("SELECT DISTINCT ip FROM " . $cfgDatabase['useronline'] . " WHERE userid = 0");
	$i2 = 0 + $query->rows;
	unset($tmp);
	unset($query);
	return array($i1, $i2);
}

//=====================================================================================================================
// String: returns the date and time of $tijd (seconds since 1970)
//=====================================================================================================================
function getDateTime($tijd)
{
	return getDateOnly($tijd) . " " . getTimeOnly($tijd);
}

//=====================================================================================================================
// String: returns the time of $tijd (seconds since 1970)
//=====================================================================================================================
function getTimeOnly($tijd)
{
	global $cfgDateFormat, $cfgServerTimezone, $cfgClientTimezone;
	$tijd = $tijd + (($cfgClientTimezone - $cfgServerTimezone) * 60 * 60);		//adjust timezone;
	return date("G:i", $tijd);
/*	$tmp3 = getdate($tijd);
	$hours = $tmp3['hours'];
	$minutes = $tmp3['minutes'];
	$seconds = $tmp3['seconds'];
	if (strlen($hours) == 1) $hours = "&nbsp;" . $hours;
	if (strlen($minutes) == 1) $minutes = "0" . $minutes;
	if (strlen($seconds) == 1) $seconds = "0" . $seconds;
	if (strlen($months) == 1) $months = "0" . $months;
	if (strlen($days) == 1) $days = "0" . $days;
	$tmp3 = $hours . ":" . $minutes ;//. ":" . $seconds;
	unset($hours);
	unset($minutes);
	unset($seconds);
	return $tmp3;*/
}

//=====================================================================================================================
// String: returns the date of $tijd (seconds since 1970)
//=====================================================================================================================
function getDateOnly($tijd)
{
	global $cfgDateFormat, $cfgServerTimezone, $cfgClientTimezone;
	$tijd = $tijd + (($cfgClientTimezone - $cfgServerTimezone) * 60 * 60);		//adjust timezone;
	$cfgDateFormat = str_replace("D", "d", $cfgDateFormat);
	$cfgDateFormat = str_replace("M", "m", $cfgDateFormat);
	return date(substr($cfgDateFormat, 0, 1) . "-" . substr($cfgDateFormat, 1, 1) . "-" . substr($cfgDateFormat, 2, 1), $tijd);
/*	$tmp3 = getdate($tijd);
	$months = $tmp3['mon'];
	$days = $tmp3['mday'];
	$year = $tmp3['year'];
	if (strlen($months) == 1) $months = "0" . $months;
	if (strlen($days) == 1) $days = "0" . $days;
	$tmp2 = "";
	for ($i = 0; $i < strlen($cfgDateFormat); $i++)
	{
		if (substr($cfgDateFormat, $i, 1) == "D")
			$t = $days;
		elseif (substr($cfgDateFormat, $i, 1) == "M")
			$t = $months;
		elseif (substr($cfgDateFormat, $i, 1) == "Y")
			$t = $year;
		else
			/ *echo "BOE!"* /;
		$tmp2 .= $t;
		if ($i < strlen($cfgDateFormat) - 1)
			$tmp2 .= "-";
	}
	$tmp3 = $tmp2;
	unset($tmp2);
	unset($days);
	unset($months);
	unset($year);
	return $tmp3;*/
}

//=====================================================================================================================
// String: returns a list of all available categories and forums, ready to be included at the bottom of every page
//=====================================================================================================================
function getForumHopper($forumID = "00")
{
	$returnString ="";
	global $cfgBaseURL, $cfgDatabase, $lang;
	$categoryQuery = new MySQL;
	$catRes = $categoryQuery->select("SELECT id, description FROM " . $cfgDatabase['category'] . " ORDER BY position ASC, id ASC");
	if ($categoryQuery->rows > 0)
	{
		$returnString .= "<option value='0' class='category'>" . $lang['index'] . "</option>";
		$returnString .= '<option value="-1" class="seperator">------------------</option>';

		$loosTellertje = 0;
		$forumQuery = new MySQL;
		for ($cI = 0; $cI < $categoryQuery->rows; $cI++)
		{
			$catRes[$cI]['description'] = strtoupper(stripslashes($catRes[$cI]['description']));
			$forRes = $forumQuery->select("SELECT id, name FROM " . $cfgDatabase['forum'] . " WHERE category = " . $catRes[$cI]['id'] . " ORDER BY position ASC, id ASC");
			$returnString .= '<option value="-1" class="category">' . ($cI + 1) . " " .$catRes[$cI]['description'] . "</option>";
			for ($fI = 0; $fI < $forumQuery->rows; $fI++)
			{
				$forRes[$fI]['name'] = stripslashes($forRes[$fI]['name']);
				$returnString .= "<option class='forum' " . (($forumID == $forRes[$fI]['id'])?"selected":"") . ' value="' . $forRes[$fI]['id'] . "\">&nbsp;  " . $forRes[$fI]['name'] . "</option>";
			}
			$returnString .= '<option value="-1" class="empty">&nbsp;</option>';
		}
	}
	else
		$returnString .= "<option value='-1' class='empty'>" . $lang['none'] . "</option>";
	unset($categoryQuery);
	unset($loosTellertje);
	unset($forumQuery);
	unset($forRes);
	unset($catRes);
	return $returnString;
}

//=====================================================================================================================
// String: returns an encoded version of $rot13text
//=====================================================================================================================
function ROT13($rot13text)
{
	$rot13text_rotated = "";

//	for ($i = 0; $i <= strlen($rot13text); $i++)
	for ($i = 0; $i < strlen($rot13text); $i++)
	{
		$k = ord(substr($rot13text, $i, 1));

		if ($k >= 97 and $k <= 109) {
			$k = $k + 13;
		} elseif ($k >= 110 and $k <= 122) {
			$k = $k - 13;
		} elseif ($k >= 65 and $k <= 77) {
			$k = $k + 13;
		} elseif ($k >= 78 and $k <= 90) {
			$k = $k - 13;
		}

		$rot13text_rotated = $rot13text_rotated . Chr($k);
	}

//	return substr($rot13text_rotated, 0, strlen($rot13text));
	return $rot13text_rotated;
}

//=====================================================================================================================
// String: returns an encoded version of $OrigString with $CipherVal as some 'seed'
//=====================================================================================================================
function encode($OrigString, $CipherVal)
{
	//$Ref="0123456789abcdefghijklmnopqrstuvwxyz._~ABCDEFGHIJKLMNOPQRSTUVWXYZ";
	for ($i = 32; $i < 256; $i++)
		$Ref .= chr($i);
	$Temp="";

	for ($Count=0; $Count < strlen($OrigString); $Count++)
	{
		$TempChar = substr(OrigString,$Count, $Count+1);
		$Conv = strpos($Ref, $TempChar);
		$Cipher=$Conv^$CipherVal;
		$Cipher=substr($Ref, $Cipher, $Cipher+1);
		$Temp .= $Cipher;
	}

	unset($TempChar);
	unset($Conv);
	unset($Cipher);
	unset($Ref);
	unset($i);
	return ($Temp);
}

//=====================================================================================================================
// String: returns a complete form to include into the template
//         used by the register and profile pages
//=====================================================================================================================
function getProfileForm($msg, $mode, $data)
{
	global $cfgAllowUserNickChange, $cfgAllowHTMLinProfile, $cfgAllowHTMLinSignature, $cfgBaseURL,
		$cfgMaxLengthNickname, $cfgTemplateDirectory, $cfgTemplateName;
	global $templateCommons, $template;

	//conditions
	$GLOBALS["no_msg"] = ($msg == "");
	$GLOBALS["profile_mode"] = ($mode == "profile");
	$GLOBALS["register_mode"] = ($mode == "register");
	$GLOBALS["enter_nickname"] = ($cfgAllowUserNickChange || $mode == "register");

	//values
	$GLOBALS["regUserPass"] = "";	//$data->userPass1;
	$GLOBALS["regUserName"] = htmlspecialchars($data->userName);
	$GLOBALS["regEmail"] = htmlspecialchars($data->email);
	$GLOBALS["regICQ"] = $data->ICQ;
	$GLOBALS["regHomepage"] = $data->homepage;
	$GLOBALS["regShowEmail"] = $data->showEmail;
	$GLOBALS["regShowProfile"] = $data->showProfile;
	$GLOBALS["regLocation"] = htmlspecialchars($data->location);
	$GLOBALS["regBio"] = htmlspecialchars($data->bio);
	$GLOBALS["regSignature"] = htmlspecialchars($data->signature);
	$GLOBALS["regAvatarurl"] = $data->avatarurl;

	//strings
	$GLOBALS["mode"] = $mode;
	$GLOBALS["msg"] = $msg;
	$GLOBALS["regShowEmail1"] = (($data->showEmail == 1)?"checked":"");
	$GLOBALS["regShowEmail2"] = (($data->showEmail == 0)?"checked":"");
	$GLOBALS["regShowProfile1"] = (($data->showProfile == 1)?"checked":"");
	$GLOBALS["regShowProfile2"] = (($data->showProfile  == 0)?"checked":"");

	$profileHandler = "PROFILE_H";
	if (!$template->load_file($profileHandler, "$cfgTemplateDirectory$cfgTemplateName/profileForm.ybt"))
		if (!$template->load_file($profileHandler, $cfgTemplateDirectory . "Default/profileForm.ybt"))
			sendError("pe: Could not load template (profileForm.ybt)!");

	$template->register($profileHandler, "msg, mode, regShowEmail1, regShowEmail2, regShowProfile1, regShowProfile2, cfgMaxLengthPassword, cfgMaxLengthNickname");
	$template->register($profileHandler, "regUserPass, regUserName, regEmail, regICQ, regHomepage, regShowEmail, regShowProfile, regLocation, regBio, regSignature, regAvatarurl");
	$template->register($profileHandler, $templateCommons);

	$text = $template->pget($profileHandler);

	unset($GLOBALS["regShowEmail1"]);
	unset($GLOBALS["regShowEmail2"]);
	unset($GLOBALS["regShowProfile1"]);
	unset($GLOBALS["regShowProfile2"]);
	unset($GLOBALS["regUserPass"]);
	unset($GLOBALS["regUserName"]);
	unset($GLOBALS["regEmail"]);
	unset($GLOBALS["regICQ"]);
	unset($GLOBALS["regHomepage"]);
	unset($GLOBALS["regShowEmail"]);
	unset($GLOBALS["regShowProfile"]);
	unset($GLOBALS["regLocation"]);
	unset($GLOBALS["regBio"]);
	unset($GLOBALS["regSignature"]);
	unset($GLOBALS["regAvatarurl"]);
	unset($GLOBALS["no_msg"]);
	unset($GLOBALS["profile_mode"]);
	unset($GLOBALS["register_mode"]);
	unset($GLOBALS["enter_nickname"]);

	return $text; //$template->return_file($profileHandler);
}

//=====================================================================================================================
// String: generates a random character-sequence with $s as a base
//=====================================================================================================================
function randomPassword($s)
{
	/* Change these from the defaults to make it slightly harder to fake the check word */
	//$mod = 1589156;
	$mod = 8133477;
	$seed = time();
	$i = 0;
	$v = $seed;
	while ($i < strlen($s)):
		$c = substr($s,$i,1);
		$v = ((Ord($c)+1) * $v) % $mod;
		$i++;
	endwhile;
	$v = sprintf("%06x", ($v % 16777216));
	unset($mod);
	unset($seed);
	unset($i);
	return($v);
}

//=====================================================================================================================
// String: gets the full URL to the forum
//=====================================================================================================================
function getFullForumURL()
{
	$host = getenv("HTTP_HOST");
	if (empty($host)) $host = getenv("SERVER_NAME");
	if (empty($host)) $host = $HTTP_ENV_VARS['HTTP_HOST'];
	if (empty($host)) $host = $HTTP_ENV_VARS['SERVER_NAME'];
	$port = getenv("SERVER_PORT");
	if (empty($port)) $port = $HTTP_ENV_VARS['SERVER_PORT'];

	if (!empty($host) && !empty($port))
	{
		$pos = strrpos($PHP_SELF, '/');
		$dir = substr($PHP_SELF, 0, $pos);
		$forumUrl = "http://$host" . ($port != 80 ? ":$port" : "") . "$dir/";

		unset($pos);
		unset($dir);
	}

	return $forumUrl;
}

//=====================================================================================================================
// bool: sends out a registration email to $regUserName <$regEmail> with a $password and activation $key
//       returns true if succeeded
//
// note: On some systems the mail() function never returns true. If so, make this function always return true.
//=====================================================================================================================
function sendRegMail($regUserName, $regEmail, $password, $key = "")
{
	global $cfgEmail, $cfgForumTitle, $cfgBaseURL, $cfgTemplateDirectory, $cfgTemplateName, $cfgIncludeDirectory, $HTTP_ENV_VARS, $PHP_SELF, $lang;

	$forumUrl = getFullForumURL();
	$error = false;
	$filename = $cfgIncludeDirectory . "regmail.txt";
	if ($exist = file_exists($filename))
	{
		$msg = fread($fp = fopen($filename, 'r'), filesize($filename));
		fclose($fp);
	}
	else
		sendError("Error opening $filename - Please correct \$cfgIncludeDirectory in config.inc.php");

	if ($key == "") $key = "<" . $lang['none'] . ">";

	$extraInfoWB = getenv("HTTP_USER_AGENT");
	$extraInfoIP = getenv("REMOTE_ADDR");
	$extraInfoDT = getDateTime(time());

	$msg = str_replace("{cfgForumTitle}", $cfgForumTitle, $msg);
	$msg = str_replace("{regUserName}", $regUserName, $msg);
	$msg = str_replace("{regEmail}", $regEmail, $msg);
	$msg = str_replace("{password}", $password, $msg);
	$msg = str_replace("{key}", $key, $msg);
	$msg = str_replace("{forumUrl}", $forumUrl, $msg);
	$msg = str_replace("{extraInfoWB}", $extraInfoWB, $msg);
	$msg = str_replace("{extraInfoIP}", $extraInfoIP, $msg);
	$msg = str_replace("{extraInfoDT}", $extraInfoDT, $msg);

	$subj = "Registration at $cfgForumTitle";
	$headers = "To: $regEmail\nFrom: $cfgEmail\nReply-To: $cfgEmail\nX-Mailer: YapBB @ $cfgForumTitle, PHP/" . phpversion() . "\nX-From: $forumUrl";

	$ret = mail($regEmail, $subj, $msg, $headers);
	unset($extraInfoWB);
	unset($extraInfoIP);
	unset($extraInfoDT);
	unset($tmp);
	unset($msg);
	unset($subj);
	unset($headers);
	unset($mailTemplate);
	unset($handler);
	unset($host);
	unset($port);
	unset($forumUrl);
	return $ret;
}

//=====================================================================================================================
// bool: check if a moderator ($sessionUserID) is allowed to moderate topics in forum ($forumID)
//=====================================================================================================================
function getModeratorValidation($forumID)
{
	global $sessionUserGroup, $sessionUserID, $cfgDatabase;
	$auth = FALSE;
	if (sess_is_registered("sessionUserGroup") && sess_is_registered("sessionUserID") && !empty($sessionUserID) && !empty($sessionUserGroup))
	{
		if ($sessionUserGroup == 1)
			$auth = FALSE;
		elseif ($sessionUserGroup == 2)
		{
			$query = new MySQL;
//			$query->select("SELECT m.forumid FROM " . $cfgDatabase['topic'] . " AS t, " . $cfgDatabase['moderator'] . " AS m, " . $cfgDatabase['user'] . " AS u WHERE m.userid = $sessionUserID AND $forumID = m.forumid AND u.id = $sessionUserID AND u.groupid > 1");

// Composed by johnny appleseed:
			$query->select("SELECT u.groupid FROM " . $cfgDatabase['user'] . " AS u, " .  $cfgDatabase['moderator'] . " AS m WHERE u.id = $sessionUserID AND u.groupid > 1  AND m.userid = $sessionUserID  AND m.forumid = $forumID");

			if ($query->rows == 1)
				$auth = TRUE;
			unset($query);
		}
		elseif ($sessionUserGroup >= 3)
			$auth = TRUE;
	}
	return $auth;
}

//=====================================================================================================================
// String: return a reade-to-be-included string containing the proposed width for the main tables
//=====================================================================================================================
function getPageWidth()
{
	global $cfgPageSizeWidth, $cfgPageSizeInPixels;
	return $cfgPageSizeWidth . (($cfgPageSizeInPixels)?"":"%");
}

//=====================================================================================================================
// bool: return true if $email is in valid form
//       if $check_dns is also true, it will additionally check if the hostname truly exists
//=====================================================================================================================
function check_email($email, $check_dns = false)
{
  if(
	  (eregi('(@.*@)|(\.\.)|(@\.)|(\.@)|(^\.)', $email))	 //from here: by chids @ www.zend.com
	  ||
	  (eregi('^.+\@(\[?)[a-zA-Z0-9\-\.]+\.([a-zA-Z]{2,3}|[0-9]{1,3})(\]?)$', $email))
	  ||
 	  (preg_match("/^\S+@\S+(\.\S+)+$/i", $email))
	)
  {
	if($check_dns)
	{
	  $host = explode('@', $email);
	  // Check for MX record
	  if( checkdnsrr($host[1], 'MX') ) return true;
	  // Check for A record
	  if( checkdnsrr($host[1], 'A') ) return true;
	  // Check for CNAME record
	  if( checkdnsrr($host[1], 'CNAME') ) return true;
    }
	else
	{
	  return true;
	}
  }
  return false;
}

//=====================================================================================================================
// String: return the contents of $fileName
//=====================================================================================================================
function getFile($fileName)
{
	$error = FALSE;
	$tmp = "";
	$fh = @fopen($fileName,"r") or $error = TRUE;
	if (!$error)
	{
		$tmp = fread($fh, filesize($fileName));
		fclose($fh);
	}
	unset($error);
	unset($fh);
	return $tmp;
}

//=====================================================================================================================
// String: return a list of <OPTIONS> with all names of the available templates
//=====================================================================================================================
function getTemplateList()
{
	global $cfgTemplateDirectory, $cfgTemplateName;
	$templateNameList = (array)$templateNameList;
	$templates = dir($cfgTemplateDirectory);
	while ($entry = $templates->read())
		if ((is_dir("$cfgTemplateDirectory$entry/") || is_dir("$cfgTemplateDirectory$entry"))&& $entry != "." && $entry != ".." && is_file("$cfgTemplateDirectory$entry/config.php"))
			$templateNameList[] = "<option value='$entry' " . ($entry == $cfgTemplateName?"selected":"") . ">$entry</option>";
	if (floor(phpversion()) >= 4)
		sort($templateNameList, SORT_STRING);
	else
		sort($templateNameList);
	$tmp = "";
	for ($i = 0; $i < sizeof($templateNameList); $i++)
		$tmp .= $templateNameList[$i];
	return $tmp;
}

//=====================================================================================================================
// bool: returns position of first occurance of $needle in $haystack, else if not exists -1
//=====================================================================================================================
function isInStr($haystack, $needle, $ignoreCase = false)
{
	if ($ignoreCase)
	{
		$needle = strtolower($needle);
		$haystack = strotolower($haystack);
	}

	if (
		!(
			($pos = strpos($haystack, $needle)) == 0
			&&
			substr($haystack, 0, strlen($needle)) != $needle
		)
	) {
		return $pos;
	} else {
		return -1;
	}

/*	$v = floor(phpversion());
	if ($v < 4)
	{
		// in versions older than 4.0b3:
		$pos = strpos ($haystack, $needle);
		return  !(is_string ($pos) && !$pos);
	}
	else if ($v >= 4)
	{
		$pos = strpos ($haystack, $needle);
		return !($pos === false);
	}*/
}

//=====================================================================================================================
//	void: disable cache
//=====================================================================================================================

function disable_cache()
{
	header("Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0");
	header("Expires: Thu, 19 Nov 1981 08:52:00 GMT");
	header("Pragma: no-cache");
	header("Last-Modified: " . gmdate("D, d M Y H:i:s") . "GMT");
}

//=====================================================================================================================
//	void: login a particular user (might use globally set variables)
//        In case of 'login.php', globals are used, else the 'persistence cookie' is used and the globals are filled.
//=====================================================================================================================

function login_user()
{
	global $HTTP_COOKIE_VARS, $cfgDatabase, $cfgCookiePrefix;

	if ($tmp = $HTTP_COOKIE_VARS[$cfgCookiePrefix . 'persistentlogin'])
	{
		if (   empty($GLOBALS['sessionUser'])
			&& empty($GLOBALS['sessionPass'])
			&& empty($GLOBALS['sessionUserID'])
			&& empty($GLOBALS['sessionUserEmail'])
			&& empty($GLOBALS['sessionUserGroup'])
		)
		{
			$id = 0 + substr($tmp, 32);
			$query = new MySQL();
			$res = $query->select("SELECT nickname, password, email, groupid FROM " . $cfgDatabase['user'] . " WHERE id = $id");
			if (count($res) != 1)
			{
				// illegal cookie, so do not login
				return false;
			}
			else
			{
				$GLOBALS['sessionUser'] = $res[0]['nickname'];
				$GLOBALS['sessionPass'] = $res[0]['password'];
				$GLOBALS['sessionUserEmail'] = $res[0]['email'];
				$GLOBALS['sessionUserGroup'] = $res[0]['groupid'];
				$GLOBALS['sessionUserID'] = $id;
				if ((md5($GLOBALS['sessionUser'] . $GLOBALS['sessionPass']) . $GLOBALS['sessionUserID']) != $tmp)
				{
					// illegal cookie, so do not login
					return false;
				}
				else
				{
					// proceed with login, use data from cookie
				}
			}
		}
		else
		{
			// disregard cookie, use already set globals
		}
	}
	else
	{
		// cookie not set, use already set globals
	}

	// either no cookie, or cookie checks out ok
	if (
		$GLOBALS['sessionUser'] != ""
		&& $GLOBALS['sessionPass'] != ""
		&& $GLOBALS['sessionUserID'] != ""
		&& $GLOBALS['sessionUserEmail'] != ""
		&& $GLOBALS['sessionUserGroup'] != ""
	)
	{
		sess_register("sessionUser");
		sess_register("sessionPass");
		sess_register("sessionUserID");
		sess_register("sessionUserEmail");
		sess_register("sessionUserGroup");
	}

	unset($id);
	unset($tmp);
	unset($query);
	unset($res);

	return true;
}

//=====================================================================================================================
//	void: logout a particular user (might use globally set variables)
//=====================================================================================================================

function logout_user()
{
	global $cfgDatabase, $cfgCookiePrefix;
	$userID = 0 + $GLOBALS['sessionUserID'];
	sess_unregister("sessionUser");
	sess_unregister("sessionPass");
	sess_unregister("sessionUserID");
	sess_unregister("sessionUserEmail");
	sess_unregister("sessionUserGroup");
	sess_unset();
	$query = new MySQL;
	$query->query("DELETE FROM " . $cfgDatabase['useronline'] . " WHERE userid = $userID OR ip = '" . addslashes(getenv("REMOTE_ADDR")) . "'");

	setcookie($cfgCookiePrefix . "persistentlogin");
}

//=====================================================================================================================
// String: return a parsed variant of $text
//=====================================================================================================================
/*function static_template_parse($text)
{
	return $text;
	global $template, $templateCommons;
	$template->clear_vars("temp");
	$template->register("temp", $templateCommons);
	$template->set_template("temp", $text);
	return $template->pget("temp");
}*/


//=====================================================================================================================
//	DATA - WARNING: ONLY CHANGE THE FOLLOWING CODE (UNTIL END OF THIS FILE) IF YOU KNOW WHAT YOU'RE DOING!!
//=====================================================================================================================

/*	doesn't work yet:
if (!get_cfg_var("short_open_tag"))
	sendError("Error: support for the short open tag &lt;? is not enabled!");
if (!((get_cfg_var("SMTP") && get_cfg_var("sendmail_from")) || get_cfg_var("sendmail_path")))
	sendError("Error: this server does NOT have emailing capabilities!");
*/

if ($cfgBoardDisabled
	&& $cfgAdminPage != substr($PHP_SELF, 0 - strlen($cfgAdminPage))
	&& substr($PHP_SELF, -14) != "outOfOrder.php"
	&& substr($PHP_SELF, -9) != "style.php"
	&& substr($PHP_SELF, -9) != "setup.php"
	)
{
	header("Location: " . $cfgBaseURL . "outOfOrder.php");
	exit();
}

//disable_cache();


//=====================================================================================================================
// Adjust $PHP_SELF for Win32 systems with PHP as CGI installed
//=====================================================================================================================

if ($tmp = getenv('SCRIPT_NAME'))
	$PHP_SELF = eregi_replace($tmp . "(/.*)", "\\1", $PHP_SELF);
else
	$PHP_SELF = eregi_replace("(/.*)*/php.exe/(.*)", "/\\2", $PHP_SELF);


//=====================================================================================================================
// Validate config-settings
//=====================================================================================================================

if ($cfgValidateSettings)
{
	if (substr($cfgDocumentRoot, -1, 1) != '/') $cfgDocumentRoot .= '/';
	while (substr($cfgBaseDirectory, 0, 1) != '/') $cfgBaseDirectory = '/' . $cfgBaseDirectory;
	if (substr($cfgBaseDirectory, -1, 1) != '/') $cfgBaseDirectory .= '/';
//	if (substr($cfgSiteHomeURL, -1, 1) != '/') $cfgSiteHomeURL .= '/';
	while (substr($cfgIncludeDirectory, 0, 1) == '/') $cfgIncludeDirectory = substr($cfgIncludeDirectory, 1);
	while (substr($cfgTemplateDirectory, 0, 1) == '/') $cfgTemplateDirectory = substr($cfgTemplateDirectory, 1);
	while (substr($cfgTmpDirectory, 0, 1) == '/') $cfgTmpDirectory = substr($cfgTmpDirectory, 1);
	while (substr($cfgImageDirectory, 0, 1) == '/') $cfgImageDirectory = substr($cfgImageDirectory, 1);
	while (substr($cfgAvatarDirectory, 0, 1) == '/') $cfgAvatarDirectory = substr($cfgAvatarDirectory, 1);
	while (substr($cfgSmiliesDirectory, 0, 1) == '/') $cfgSmiliesDirectory = substr($cfgSmiliesDirectory, 1);
	if (substr($cfgIncludeDirectory, -1, 1) != '/') $cfgIncludeDirectory .= '/';
	if (substr($cfgTemplateDirectory, -1, 1) != '/') $cfgTemplateDirectory .= '/';
	if (substr($cfgTmpDirectory, -1, 1) != '/') $cfgTmpDirectory .= '/';
	if (substr($cfgImageDirectory, -1, 1) != '/') $cfgImageDirectory .= '/';
	if (substr($cfgAvatarDirectory, -1, 1) != '/') $cfgAvatarDirectory .= '/';
	if (substr($cfgSmiliesDirectory, -1, 1) != '/') $cfgSmiliesDirectory .= '/';
}


//=====================================================================================================================
// Building 'API' variables
//=====================================================================================================================

$cfgAvatarDirectory		= $cfgImageDirectory . $cfgAvatarDirectory;
$cfgSmiliesDirectory	= $cfgImageDirectory . $cfgSmiliesDirectory;
$cfgIncludeDirectory	= $cfgDocumentRoot . $cfgIncludeDirectory;
$cfgTemplateDirectory	= $cfgDocumentRoot . $cfgTemplateDirectory;
$cfgTmpDirectory		= $cfgDocumentRoot . $cfgTmpDirectory;
$cfgHomeURL = "";
if ($cfgSiteHostName != "")
{
	$cfgHomeURL = "http://$cfgHostName";
	if ($cfgSiteHostPort != "")
		$cfgHomeURL .= ":$cfgSiteHostPort";
}
$cfgBaseURL				= $cfgHomeURL . $cfgBaseDirectory;
$cfgImageURL			= $cfgBaseURL . $cfgImageDirectory;
$cfgAvatarURL			= $cfgBaseURL . $cfgAvatarDirectory;
$cfgSmiliesURL			= $cfgBaseURL . $cfgSmiliesDirectory;
$cfgRefreshInterval		= abs($cfgRefreshInterval * 60);
$cfgOnlineTime			= $cfgOnlineTime * 60;
$cfgFloodTime			= abs($cfgFloodTime);
//$cfgBaseDirectory = "/";	// to do: yapbb's cookies don't work if this is left out!

require($cfgIncludeDirectory . "constants.php");


//=====================================================================================================================
// Instantiate version object
//=====================================================================================================================

require($cfgIncludeDirectory . "class_PHPVersion.php");
$PHPVer = new PHPVer();


//=====================================================================================================================
// Set language strings and initialize template engine
//=====================================================================================================================

if ($cfgAdvancedTemplateEngine && $PHPVer->compare("4.0.2") < 1)	// check version
{
	if (!file_exists($cfgIncludeDirectory . "class_yapbbcooker.php"))
		die("<b>Fatal error</b>: Failed opening required '" . $cfgIncludeDirectory . "class_yapbbcooker.php' in <b>include/global.php</b> on line <b>880</b>");
	include($cfgIncludeDirectory . "class_yapbbcooker.php");
	$template = new YapBBCooker($cfgTmpDirectory);		// YapBB cooker is a special subclass of PSPCooker, so that the old-style interface can be used
}
else
{
	require($cfgIncludeDirectory . "class_template.php");
	$template = new template();
}

if (empty($cfgTemplateName)) $cfgTemplateName = 'Default';

include($cfgTemplateDirectory . "Default/config.php");				//to make sure that all variables are covered
if ($cfgTemplateName != 'Default')									// ....
	include("$cfgTemplateDirectory$cfgTemplateName/config.php");	//when a new template does not cover all of them


//=====================================================================================================================
// Including all required files
//=====================================================================================================================

if ($cfgUseCompression) {require($cfgIncludeDirectory . "gzdoc.php");}
require($cfgIncludeDirectory . "class_sql.php");
require($cfgIncludeDirectory . "class_YBBtags.php");
require($cfgIncludeDirectory . "smilies.php");
require($cfgIncludeDirectory . "class_html_objects.php");
require($cfgIncludeDirectory . "class_loopedArray.php");
require($cfgIncludeDirectory . "class_searcher.php");


//=====================================================================================================================
// Session stuff
//=====================================================================================================================

if ($NODB[0] != "notfalse")			// quick and dirty hack for speeding up non-main pages
{

	require($cfgIncludeDirectory . "yapbb_session.php");

	sess_name($cfgCookiePrefix . "PHPSESSID");
	sess_set_cookie_params(0, $cfgBaseDirectory, $cfgSiteHostName);
	sess_start();
	login_user();					// check if the persistancy cookie is available
}


//=====================================================================================================================
// Get cookie values - to do: change to make all others reference $cookieBlah... iso $cfgBlah...
//=====================================================================================================================

$COOKIES = unserialize(stripslashes($HTTP_COOKIE_VARS[$cfgCookiePrefix . 'yapbbcookie']));
if (is_array($COOKIES))
{
	if (isset($COOKIES['topicSortWhichPost'])   ) $cfgTopicSortWhichPost    = $COOKIES['topicSortWhichPost'];
	if (isset($COOKIES['topicSortWhichWay'])    ) $cfgTopicSortWhichWay     = $COOKIES['topicSortWhichWay'];
	if (isset($COOKIES['postSortWhichWay'])     ) $cfgPostSortWhichWay      = $COOKIES['postSortWhichWay'];
	if (isset($COOKIES['threadsPerPage'])       ) $cfgThreadsPerPage        = $COOKIES['threadsPerPage'];
	if (isset($COOKIES['postsPerPage'])         ) $cfgPostsPerPage          = $COOKIES['postsPerPage'];
	if (isset($COOKIES['topicsOnLastDays'])     ) $cfgTopicsOnLastDays      = $COOKIES['topicsOnLastDays'];
	if (isset($COOKIES['refreshInterval'])      ) $cfgRefreshInterval       = $COOKIES['refreshInterval'];
	if (isset($COOKIES['dateFormat'])           ) $cfgDateFormat            = $COOKIES['dateFormat'];
	if (isset($COOKIES['pageSizeInPixels'])     ) $cfgPageSizeInPixels      = $COOKIES['pageSizeInPixels'];
	if (isset($COOKIES['pageSizeWidth'])        ) $cfgPageSizeWidth         = $COOKIES['pageSizeWidth'];
	if (isset($COOKIES['templateName'])         ) $cfgTemplateName          = $COOKIES['templateName'];
	if (isset($COOKIES['clientTimezone'])       ) $cfgClientTimezone        = $COOKIES['clientTimezone'];
	if (isset($COOKIES['showForumDescriptions'])) $cfgShowForumDescriptions = $COOKIES['showForumDescriptions'];
	if (isset($COOKIES['announcementCount'])    ) $cfgAnnouncementCount     = $COOKIES['announcementCount'];
	if (isset($COOKIES['showSignatures'])       ) $cfgShowSignatures        = $COOKIES['showSignatures'];
	if (isset($COOKIES['showAvatars'])          ) $cfgShowAvatars           = $COOKIES['showAvatars'];
}

//	<META HTTP-EQUIV="expires" CONTENT="Tue, 24 Oct 2000 21:20:26 CET">

if (!isset($HTTP_COOKIE_VARS[$cfgCookiePrefix . 'currentVisit']))
{
	setcookie($cfgCookiePrefix . "currentVisit", time(), 0, $cfgBaseDirectory, $cfgSiteHostName, 0);
	setcookie($cfgCookiePrefix . "lastVisit2", $HTTP_COOKIE_VARS[$cfgCookiePrefix . 'lastVisit1'], time() + (365 * 24 * 60 * 60), $cfgBaseDirectory, $cfgSiteHostName, 0);
	setcookie($cfgCookiePrefix . "lastVisit1", time(), time() + (365 * 24 * 60 * 60), $cfgBaseDirectory, $cfgSiteHostName, 0);
}


if ($NODB[0] != "notfalse")			// quick and dirty hack for speeding up non-main pages
{

//=====================================================================================================================
// Building timezones (client-/server-side)
// See also: http://www.timeanddate.com/time/abbreviations.html
//=====================================================================================================================

	$timezone = new Select("timezone");
// switch comments to use verbose list (not nice for layout :* )
/*
	$timezone->add(new Option("(GMT -12:00 hours) Eniwetok, Kwajalein", "-12"));
	$timezone->add(new Option("(GMT -11:00 hours) Midway Island, Samoa", "-11"));
	$timezone->add(new Option("(GMT -10:00 hours) Hawaii", "-10"));
	$timezone->add(new Option("(GMT -9:00 hours) Alaska", "-9"));
	$timezone->add(new Option("(GMT -8:00 hours) Pacific Time (US & Canada)", "-8"));
	$timezone->add(new Option("(GMT -7:00 hours) Mountain Time (US & Canada)", "-7"));
	$timezone->add(new Option("(GMT -6:00 hours) Central Time (US & Canada), Mexico City", "-6"));
	$timezone->add(new Option("(GMT -5:00 hours) Eastern Time (US & Canada), Bogota, Lima, Quito", "-5"));
	$timezone->add(new Option("(GMT -4:00 hours) Atlantic Time (Canada), Caracas, La Paz", "-4"));
	$timezone->add(new Option("(GMT -3:30 hours) Newfoundland", "-3.5"));
	$timezone->add(new Option("(GMT -3:00 hours) Brazil, Buenos Aires, Georgetown", "-3"));
	$timezone->add(new Option("(GMT -2:00 hours) Mid-Atlantic", "-2"));
	$timezone->add(new Option("(GMT -1:00 hours) Azores, Cape Verde Islands", "-1"));
	$timezone->add(new Option("(GMT) Western Europe Time, London, Lisbon, Casablanca, Monrovia", "0"));
	$timezone->add(new Option("(GMT +1:00 hours) CET(Central Europe Time), Brussels, Copenhagen, Madrid, Paris", "1"));
	$timezone->add(new Option("(GMT +2:00 hours) EET(Eastern Europe Time), Kaliningrad, South Africa", "2"));
	$timezone->add(new Option("(GMT +3:00 hours) Baghdad, Kuwait, Riyadh, Moscow, St. Petersburg, Volgograd, Nairobi", "+3"));
	$timezone->add(new Option("(GMT +3:30 hours) Tehran", "3.5"));
	$timezone->add(new Option("(GMT +4:00 hours) Abu Dhabi, Muscat, Baku, Tbilisi", "4"));
	$timezone->add(new Option("(GMT +4:30 hours) Kabul", "4.5"));
	$timezone->add(new Option("(GMT +5:00 hours) Ekaterinburg, Islamabad, Karachi, Tashkent", "5"));
	$timezone->add(new Option("(GMT +5:30 hours) Bombay, Calcutta, Madras, New Delhi", "5.5"));
	$timezone->add(new Option("(GMT +6:00 hours) Almaty, Dhaka, Colombo", "6"));
	$timezone->add(new Option("(GMT +7:00 hours) Bangkok, Hanoi, Jakarta", "7"));
	$timezone->add(new Option("(GMT +8:00 hours) Beijing, Perth, Singapore, Hong Kong, Chongqing, Urumqi, Taipei", "8"));
	$timezone->add(new Option("(GMT +9:00 hours) Tokyo, Seoul, Osaka, Sapporo, Yakutsk", "9"));
	$timezone->add(new Option("(GMT +9:30 hours) Adelaide, Darwin", "9.5"));
	$timezone->add(new Option("(GMT +10:00 hours) EAST(East Australian Standard), Guam, Papua New Guinea, Vladivostok", "10"));
	$timezone->add(new Option("(GMT +11:00 hours) Magadan, Solomon Islands, New Caledonia", "11"));
	$timezone->add(new Option("(GMT +12:00 hours) Auckland, Wellington, Fiji, Kamchatka, Marshall Island", "12"));
*/
	$timezone->add(new Option("-12", "-12"));
	$timezone->add(new Option("-11", "-11"));
	$timezone->add(new Option("-10 (HST)", "-10"));
	$timezone->add(new Option("-9 (AKST)", "-9"));
	$timezone->add(new Option("-8 (PST)", "-8"));
	$timezone->add(new Option("-7 (MST)", "-7"));
	$timezone->add(new Option("-6 (CST)", "-6"));
	$timezone->add(new Option("-5 (EST)", "-5"));
	$timezone->add(new Option("-4 (AST)", "-4"));
	$timezone->add(new Option("-3", "-3"));
	$timezone->add(new Option("-2", "-2"));
	$timezone->add(new Option("-1", "-1"));
	$timezone->add(new Option("0 (GMT, UTC, WET)", "0"));
	$timezone->add(new Option("+1 (CET, BST, IST)", "1"));
	$timezone->add(new Option("+2 (EET)", "2"));
	$timezone->add(new Option("+3 (MSK)", "3"));
	$timezone->add(new Option("+4", "4"));
	$timezone->add(new Option("+5", "5"));
	$timezone->add(new Option("+6", "6"));
	$timezone->add(new Option("+7", "7"));
	$timezone->add(new Option("+8 (WST)", "8"));
	$timezone->add(new Option("+9", "9"));
	$timezone->add(new Option("+10 (EST)", "10"));
	$timezone->add(new Option("+11", "11"));
	$timezone->add(new Option("+12", "12"));

	$sTimezone = $timezone;
	$sTimezone->setSelected($cfgServerTimezone);	// make a 'server-side' timezone
	$cTimezone = $timezone;
	$cTimezone->setSelected($cfgClientTimezone);	// make a 'client-side' timezone
	$templateTimezone = $cTimezone->getSelected();		// this is displayed in the templates


//=====================================================================================================================
// Templating stuff - preparation & initialization of Template 'API' variables
//=====================================================================================================================

	$PAGE_REFRESH = ($cfgRefreshInterval > 0)?"<meta http-equiv='refresh' content='$cfgRefreshInterval;'>":"";
	if ($cfgTemplateOpenTag != "" && $cfgTemplateCloseTag != "") $template->set_identifiers($cfgTemplateOpenTag, $cfgTemplateCloseTag);

	$templateLoggedIn = (
						sess_is_registered("sessionUser") &&
						sess_is_registered("sessionPass") &&
						sess_is_registered("sessionUserID") &&
						sess_is_registered("sessionUserGroup") &&
						sess_is_registered("sessionUserEmail") &&
						!empty($sessionUser) &&
						!empty($sessionPass) &&
						!empty($sessionUserID) &&
						!empty($sessionUserEmail) &&
						!empty($sessionUserGroup)
					);

	$tmp = getVisitors();
	$templateLogInCount = $tmp[0];
	$templateGuestCount = $tmp[1];
	unset($tmp);
	$templateMemberCount = getRowCount($cfgDatabase['user']);
	$templateTopicCount = getRowCount($cfgDatabase['topic']);
	$templatePostCount = getRowCount($cfgDatabase['post']);
	$templateDateFormat = "";
	for ($i = 0; $i < strlen($cfgDateFormat); $i++)
	{
		if (substr($cfgDateFormat, $i, 1) == "D") $templateDateFormat .= $lang['day'];
		elseif (substr($cfgDateFormat, $i, 1) == "M") $templateDateFormat .= $lang['month'];
		elseif (substr($cfgDateFormat, $i, 1) == "Y") $templateDateFormat .= $lang['year'];
		else /*echo "BOE!"*/;
		if ($i < strlen($cfgDateFormat) - 1) $templateDateFormat .= ", ";
	}
	unset($i);
	$templateLocation = getLocation($forumID, $topicID);
	if (!isset($tmpTopicID) && !isset($tmpForumID))
	{
		$tmpTopicID = $topicID;
		$tmpForumID = $forumID;
	}

	if (!isset($tmp2ForumID))						//check if forum is accessible - this is for when in a topic (and $forumID is not set)
	{
		if ($topicID > 0 && $forumID == 0) $tmp2ForumID = getForumID($topicID);
		else $tmp2ForumID = $forumID;
	}

//<!--- THIS IS CODE FROM topicDisplay --->//
	if ($topicID > 0)
	{
		$topicQuery = new MySQL;
		$topRes = $topicQuery->select("SELECT description, active FROM " . $cfgDatabase['topic'] . " WHERE id = $topicID");
		if ($topicQuery->rows == 1)
		{
			$PAGE_TITLE = $topRes[0]['description'] = stripslashes($topRes[0]['description']);
			$isActive = $topRes[0]['active'];	/////mod: deze moet eigenlijk worden gecombineerd met isTopicActive (1 kwery minder)
			$templateIsTopicActive = ($tmpTopicID > 0 && $tmpForumID == 0 && $isActive);
			//isactive moet al eerder worden geset!!
		}
		else
			sendError("ue: Invalid topic");
	}
//<!--- THIS IS CODE FROM topicDisplay --->//

//	$templateIsTopicActive = ($tmpTopicID > 0 && $tmpForumID == 0 && $isActive);	//isActive for topicDisplay.php!
	$templateIsForumActive = ($tmp2ForumID > 0);
	$templatePageSize = getPageWidth();
	$templateTime = getTimeOnly(time());
	if ($forumID == 0 && $topicID > 0) $forumID = getForumID($topicID);
	$templateForumHop = getForumHopper($forumID);

	$templateYapBBhomeURL = YAPBB_HOME_URL;
	$templateYapBBversion = YAPBB_VERSION;
	$QUERY_STRING = htmlentities(getenv('QUERY_STRING'));
	$templateIsAdmin = $sessionUserGroup >= 4 && $templateLoggedIn;


//=====================================================================================================================
// Templating stuff - Preparation
//=====================================================================================================================

	$templateHandler = "_YAPBB_" . preg_replace("!\W+!", '_', getenv('PATH_INFO'));
	$templateHeaderHandler = "PAGE_HEADER";					//names of the tags in your templates
	$templateFooterHandler = "PAGE_FOOTER";
	$templateBannerHandler = "PAGE_BANNER";

	$templateCommons = array("cfgBaseURL", "templatePageSize", "sessionUser", "sessionUserID",
						"cfgSiteTitle", "cfgEmail", "cfgSiteHomeURL", "cfgForumTitle", "cfgImageURL",
						"PHP_SELF", "cfgAvatarURL", "cfgSmiliesURL", "templateTime", "PAGE_TITLE",
						"templateForumHop", "PAGE_REFRESH", "QUERY_STRING", "templateLocation");

//=====================================================================================================================
// Templating stuff - Load 'fetch' dialog (will be inserted into main)
//=====================================================================================================================
/*	if (!$template->load_file("FETCH", "$cfgTemplateDirectory$cfgTemplateName/fetch.ybt"))
		if (!$template->load_file("FETCH", $cfgTemplateDirectory . "Default/fetch.ybt"))
			sendError("pe: Could not load template (fetch.ybt)!");*/

//=====================================================================================================================
// Templating stuff - Load banner (will be inserted into header)
//=====================================================================================================================
	if (!$template->load_file($templateBannerHandler, "$cfgTemplateDirectory$cfgTemplateName/banner.ybt"))
		if (!$template->load_file($templateBannerHandler, $cfgTemplateDirectory . "Default/banner.ybt"))
			sendError("pe: Could not load template (banner.ybt)!");

//=====================================================================================================================
// Templating stuff - Load header (will be inserted into main)
//=====================================================================================================================
	if (!$template->load_file($templateHeaderHandler, "$cfgTemplateDirectory$cfgTemplateName/header.ybt"))
		if (!$template->load_file($templateHeaderHandler, $cfgTemplateDirectory . "Default/header.ybt"))
			sendError("pe: Could not load template (header.ybt)!");
//	$template->register($templateHeaderHandler, array("templateLocation"));

//=====================================================================================================================
// Templating stuff - Load footer (will be inserted into main)
//=====================================================================================================================
	if (!$template->load_file($templateFooterHandler, "$cfgTemplateDirectory$cfgTemplateName/footer.ybt"))
		if (!$template->load_file($templateFooterHandler, $cfgTemplateDirectory . "Default/footer.ybt"))
			sendError("pe: Could not load template (footer.ybt)!");
	$template->register($templateFooterHandler, array("templateDateFormat", "templateTimezone", "templateLogInCount",
														"templateMemberCount", "templateGuestCount", "templateTopicCount",
														"templatePostCount", "templateYapBBhomeURL", "templateYapBBversion"));

//=====================================================================================================================
// Templating stuff - Register commons to general template
//=====================================================================================================================
	$template->register($templateHandler, $templateCommons);

}	// #END: if ($NODB[0] != "notfalse")			// quick and dirty hack for speeding up non-main pages
?>