<?php if (!$GLOBALS['includeBit']) exit();
/*
** Title.........: PHP4 HTTP Compression Speeds up the Web
** Version.......: 1.20
** Author........: catoc <catoc@163.net>
** Filename......: gzdoc.php
** Last changed..: 18/10/2000
** Requirments...: PHP4 >= 4.0.1
**                 PHP was configured with --with-zlib[=DIR]
** Notes.........: Dynamic Content Acceleration compresses
**                 the data transmission data on the fly
**                 code by sun jin hu (catoc) <catoc@163.net>
**                 Most newer browsers since 1998/1999 have
**                 been equipped to support the HTTP 1.1
**                 standard known as "content-encoding."
**                 Essentially the browser indicates to the
**                 server that it can accept "content encoding"
**                 and if the server is capable it will then
**                 compress the data and transmit it. The
**                 browser decompresses it and then renders
**                 the page.
**
**                 Modified by John Lim (jlim@natsoft.com.my)
**                  based on ideas by Sandy McArthur, Jr
**
**                 Modified by Arno van der Kolk to make
**                  it PHP4.0.4+ compatible
**                  http://yapbb.sf.net/
**
**                 Integrated into YapBB by Arno van der Kolk (Dec 2000)
** Usage........:
**                 No space before the beginning of the first '<?' tag.
**                 ------------Start of file----------
**                 |<?
**                 | include('gzdoc.php');
**                 |?>
**                 |<HTML>
**                 |... the page ...
**                 |</HTML>
**                 |<?
**                 | gzdocout();
**                 |?>
**                 -------------End of file-----------
*/
if (floor(phpversion()) >= 4) {
	ob_start();
	ob_implicit_flush(0);
}

function CheckCanGzip(){
    if ((floor(phpversion()) < 4) || !function_exists("gzcompress")) return 0;
    global $HTTP_ACCEPT_ENCODING;
    if (headers_sent() || connection_status() == (1|2) || connection_aborted()){
        return 0;
    }
//    if (!isInStr($HTTP_ACCEPT_ENCODING, 'x-gzip')) return "x-gzip";
//    if (!isInStr($HTTP_ACCEPT_ENCODING,'gzip')) return "gzip";
    if (!preg_match('!x-gzip!i', $HTTP_ACCEPT_ENCODING)) return "x-gzip";
    if (!preg_match('!gzip!i', $HTTP_ACCEPT_ENCODING)) return "gzip";
    return 0;
}
/* $level = compression level 0-9, 0=none, 9=max */
function GzDocOut($level=9,$debug=0){
    $ENCODING = CheckCanGzip();
    if ($ENCODING){
        print "\n<!-- Use compress $ENCODING -->\n";
        $Contents = ob_get_contents();
        ob_end_clean();
        if ($debug){
            $s = "<p>Not compress length: ".($u=strlen($Contents));
            $s .= "<br>Compressed length: ".($c=strlen(gzcompress($Contents,$level)));
            $s .= "<br>Ratio: ".round($c/$u*100,2)."%";
            $Contents .= $s;
        }
        $Size = strlen($Contents);
        $Crc = crc32($Contents);
        header("Content-Encoding: $ENCODING");
		//header("Content-Length: " . strlen($Size));
        print "\x1f\x8b\x08\x00\x00\x00\x00\x00";
        $Contents = gzcompress($Contents,$level);
        $Contents = substr($Contents, 0, strlen($Contents) - 4);
        print $Contents;
        print pack('V',$Crc);
        print pack('V',$Size);
        exit;
    }else{
        ob_end_flush();
        exit;
    }
}
?>