<?php if (!$GLOBALS['includeBit']) exit();

/*

YapBB, a fully functional bulletin board system
Copyright (C) 2000/01  Arno van der Kolk
http://yapbb.sourceforge.net/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

require($cfgIncludeDirectory . "class_sqlsession.php");

$GLOBALS['s_PHPversion'] = floor(phpversion());
if ($GLOBALS['s_PHPversion'] < 4 || $cfgPHP3compatibility)
	$GLOBALS['session_handler'] = new SqlSession($cfgDatabase['session'], $cfgDatabase['user_vars']);

function sess_start(){
	global $cfgPHP3compatibility;
	if ($GLOBALS['s_PHPversion'] >= 4 && !$cfgPHP3compatibility)
		return session_start();
	else
		return $GLOBALS['session_handler']->s_demand_session();
}

function sess_destroy(){
	global $cfgPHP3compatibility;
	if ($GLOBALS['s_PHPversion'] >= 4 && !$cfgPHP3compatibility)
		return session_destroy();
	else
		return $GLOBALS['session_handler']->s_destroy();
}

function sess_name($name = "\0"){
	global $cfgPHP3compatibility;
	if ($GLOBALS['s_PHPversion'] >= 4 && !$cfgPHP3compatibility)
		if ($name == "\0")
			return session_name();
		else
			return session_name($name);
	else
		if ($name == "\0")
			return $GLOBALS['session_handler']->s_name();
		else
			return $GLOBALS['session_handler']->s_name($name);
}

function sess_module_name($name = "\0"){
	global $cfgPHP3compatibility;
	if ($GLOBALS['s_PHPversion'] >= 4 && !$cfgPHP3compatibility)
		if ($name == "\0")
			return session_module_name();
		else
			return session_module_name($name);
	else
		if ($name == "\0")
			return $GLOBALS['session_handler']->s_mod_name();
		else
			return $GLOBALS['session_handler']->s_mod_name($name);
}

function sess_save_path($name = "\0"){
	global $cfgPHP3compatibility;
	if ($GLOBALS['s_PHPversion'] >= 4 && !$cfgPHP3compatibility)
		if ($name == "\0")
			return session_save_path();
		else
			return session_save_path($name);
	else
		if ($name == "\0")
			return;
		else
			return $name;
}

function sess_id($name = "\0"){
	global $cfgPHP3compatibility, $cfgBaseDirectory, $cfgCookiePrefix;
	if ($GLOBALS['s_PHPversion'] >= 4 && !$cfgPHP3compatibility)
		if ($name == "\0")
			return session_id();
		else
			return session_id($name);
	else
		if ($name == "\0")
			return $GLOBALS['session_handler']->s_id();
		else
			return $GLOBALS['session_handler']->s_id($name);
}

function sess_register($name){
	global $cfgPHP3compatibility;
	if ($GLOBALS['s_PHPversion'] >= 4 && !$cfgPHP3compatibility)
		return session_register($name);
	else
	{
		if (is_int($GLOBALS[$name]))
			$type = "INT";
		else
			$type = "STRING";
		return $GLOBALS['session_handler']->s_set_var($name, $type, $GLOBALS[$name]);
	}
}

function sess_unregister($name){
	global $cfgPHP3compatibility;
	if ($GLOBALS['s_PHPversion'] >= 4 && !$cfgPHP3compatibility)
		return session_unregister($name);
	else
		return $GLOBALS['session_handler']->s_del_var($name);
}

function sess_unset(){
	global $cfgPHP3compatibility;
	if ($GLOBALS['s_PHPversion'] >= 4 && !$cfgPHP3compatibility)
		return session_unset();
	else
		return $GLOBALS['session_handler']->s_del_allvars();
}

function sess_is_registered($name){
	global $cfgPHP3compatibility;
	if ($GLOBALS['s_PHPversion'] >= 4 && !$cfgPHP3compatibility)
		return session_is_registered($name);
	else
		return $GLOBALS['session_handler']->s_is_registered($name);
}

function sess_get_cookie_params(){
	global $cfgPHP3compatibility;
	if ($GLOBALS['s_PHPversion'] >= 4 && !$cfgPHP3compatibility)
		return session_get_cookie_params();
	else
		return $GLOBALS['session_handler']->s_get_cookie_params();
}

function sess_set_cookie_params($lifeint, $path, $domain){
	global $cfgPHP3compatibility;
	if ($GLOBALS['s_PHPversion'] >= 4 && !$cfgPHP3compatibility)
		return session_set_cookie_params($lifeint, $path, $domain);
	else
		return $GLOBALS['session_handler']->s_set_cookie_params($lifeint, $path, $domain);
}

function sess_decode($data){
	global $cfgPHP3compatibility;
	if ($GLOBALS['s_PHPversion'] >= 4 && !$cfgPHP3compatibility)
		return session_decode($data);
	else
		return $GLOBALS['session_handler']->s_decode($data);
}

function sess_encode(){
	global $cfgPHP3compatibility, $session;
	if ($GLOBALS['s_PHPversion'] >= 4 && !$cfgPHP3compatibility)
		return session_encode();
	else
		return $GLOBALS['session_handler']->s_encode();
}

?>