<?php require("./config.inc.php");

/*

YapBB, a fully functional bulletin board system
Copyright (C) 2000/01  Arno van der Kolk
modified by Sven Vintges to fit templates
http://yapbb.sourceforge.net/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

//=====================================================================================================================
// Description: login a user
//=====================================================================================================================


//=====================================================================================================================
// Preliminary checks
//=====================================================================================================================
if (isset($HTTP_POST_VARS['set'])) $set = $HTTP_POST_VARS['set']; else unset($set);
if (isset($HTTP_POST_VARS['authUser'])) $authUser = $HTTP_POST_VARS['authUser']; else unset($authUser);
if (isset($HTTP_POST_VARS['authPass'])) $authPass = $HTTP_POST_VARS['authPass']; else unset($authPass);
if (isset($HTTP_POST_VARS['persistent'])) $persistent = $HTTP_POST_VARS['persistent']; else unset($persistent);

if ($ingelogd = isset($set))
{
//=====================================================================================================================
// User has submitted info, process
//=====================================================================================================================


//=====================================================================================================================
// Check ban
//=====================================================================================================================
	$IP = getenv("REMOTE_ADDR");
	if (checkIPban($IP))
		sendError("You have been banned from this board. Contact the administrator &lt;$cfgEmail&gt; if you believe this to be in error.");

	$authPass = ROT13($authPass);
	$authKey = ROT13($authKey);


//=====================================================================================================================
// Authenticate user
//=====================================================================================================================
	if ($cfgAnonymousUser != "" && $authUser == $cfgAnonymousUser)
		sendError("Guests can't login");

	$query = new MySQL;
	$res = $query->select("SELECT activated, activationkey, active, email, id, nickname, password, groupid FROM " . $cfgDatabase['user'] . " WHERE nickname = '" . addslashes($authUser) . "' AND password = '" . addslashes($authPass) . "'");
	$userOK = FALSE;
	for ($i = 0; $i < $query->rows; $i++)
	{
		$res[$i]['password'] = stripslashes($res[$i]['password']);
		$res[$i]['email'] = stripslashes($res[$i]['email']);
		$res[$i]['nickname'] = stripslashes($res[$i]['nickname']);
		if ($res[$i]['password'] == $authPass && $res[$i]['nickname'] == $authUser)
		{
			$userOK = TRUE;
			break;
		}
	}
	$results = $res[$i];


//=====================================================================================================================
// Validate user
//=====================================================================================================================
	if (!$userOK)
		sendError($lang['errorLogin']);
	if ($results['active'] == 0)
		sendError($lang['ban']);
	if ($results['activated'] == 0)
		if ($authKey == "")
			sendError($lang['loginActivate']);
		else if ($results['activationkey'] != $authKey)
			sendError($lang['errorLogin']);
		else
			$query->query("UPDATE " . $cfgDatabase['user'] . " SET activated = 1 WHERE id = " . $results['id']);


//=====================================================================================================================
// Setup session
//=====================================================================================================================
	$sessionUser = $authUser;
	$sessionPass = $authPass;
	$sessionUserID = $results['id'];
	$sessionUserEmail = $results['email'];
	$sessionUserGroup = $results['groupid'];

	if ($persistent)
		setcookie($cfgCookiePrefix . "persistentlogin", md5($sessionUser . $sessionPass) . $sessionUserID, 365 * 25 * 60 * 60 + time());
	else
		setcookie($cfgCookiePrefix . "persistentlogin");

	$HTTP_COOKIE_VARS[$cfgCookiePrefix . 'persistent'] = "";
	login_user();

	$query->query("INSERT INTO " . $cfgDatabase['useronline'] . " (userid, date, ip) VALUES ('$sessionUserID', '" . time() . "', '" . addslashes(getenv("REMOTE_ADDR")) . "')");
//	$query->query("UPDATE " . $cfgDatabase['user'] . " SET registerdate = " . time() . " WHERE registerdate = 0 AND id = $sessionUserID");
	$query->query("DELETE FROM " . $cfgDatabase['useronline'] . " WHERE ip = '" . addslashes(getenv("REMOTE_ADDR")) . "' AND userid = 0");
}
else
{
//=====================================================================================================================
// User has arrived onto this page, show form
//=====================================================================================================================


//=====================================================================================================================
// Calculate refering URL
//=====================================================================================================================
	$refererurl = getenv("HTTP_REFERER");
	if ($refererurl == "" ||
		!(
		   ereg("/frontpage.php", $refererurl)
		|| ereg("/forumDisplay.php", $refererurl)
		|| ereg("/topicDisplay.php", $refererurl)
		)
	)
		$refererurl = $cfgBaseURL . "frontpage.php";
	else
	{
		$pos = strrpos($refererurl, '/');
		if ($pos != 0)
		{
			$file = substr($refererurl, $pos + 1);
			$pos = strrpos($PHP_SELF, '/');
			if ($pos != 0)
				if (ereg(quotemeta($PHP_SELF), $file))//(substr($PHP_SELF, $pos + 1) == $file)
					$refererurl = $cfgBaseURL . "frontpage.php";
		}
	}
}


//=====================================================================================================================
// Template stuff
//=====================================================================================================================
if (!$template->load_file($templateHandler, "$cfgTemplateDirectory$cfgTemplateName/login.ybt"))
	if (!$template->load_file($templateHandler, $cfgTemplateDirectory . "Default/login.ybt"))
		sendError("pe: Could not load template (login.ybt)!");

$template->register($templateHandler, "refererurl");
$template->parse($templateHandler);
echo $template->return_file($templateHandler);

if ($cfgUseCompression) gzdocout();

require($cfgIncludeDirectory . "cleanup.php");
?>
