<?php require("./config.inc.php");

/*

YapBB, a fully functional bulletin board system
Copyright (C) 2000/01  Arno van der Kolk
http://yapbb.sourceforge.net/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

function _sendMail($toEmail, $msg)
{
	global $sessionUser, $sessionUserID, $sessionUserEmail, $cfgEmail, $cfgForumTitle, $cfgServerTimezone, $cfgClientTimezone;

	return mail($toEmail, "Email from $cfgForumTitle", $msg,
"To: $toEmail
From: $cfgEmail <$cfgForumTitle Mail System>
Reply-To: $sessionUserEmail
Sender-Name: $sessionUser
Sender-UserID: $sessionUserID
Sender-IP: " . getenv("REMOTE_ADDR") . "
Sender-LocalTime: " . getDateTime(time()) . "
Sender-ServerTime: " . getDateTime(time() - (($cfgClientTimezone - $cfgServerTimezone) * 60 * 60)) . "
Sender-UserAgent: " . getenv("HTTP_USER_AGENT") . "
Report-Abuse: $cfgEmail
X-Mailer: YapBB @ $cfgForumTitle, PHP/" . phpversion() . "
X-Mailer-home: " . getFullForumURL() . "
");
}

$acceptEmail = true;
if ($templateLoggedIn)												// you have to be logged in
{
	$query = new MySQL();
	if (!empty($userID) && $userID > 0)								// show mail-user page
	{
		$res = $query->select("SELECT showemail, email, nickname FROM " . $cfgDatabase['user'] . " WHERE id = $userID");
		if (count($res) != 1)
			sendError("ue: Invalid user id");
		else
		{
			if ($res[0]['showemail'])
			{
				$USERNAME = htmlspecialchars(stripslashes($res[0]['nickname']));
				$USERID = $userID;
				$template->register($templateHandler, "USERNAME, USERID");

				if (!empty($HTTP_POST_VARS['message']) && !empty($HTTP_POST_VARS['userID']))
				{
					$submitted = TRUE;
					// send email
					_sendMail(stripslashes($res[0]['email']), stripslashes($HTTP_POST_VARS['message']));
				}
				else
				{
					$submitted = FALSE;
					// show input form
				}
			}
			else
				$acceptEmail = false;
		}
	}
	else if (!empty($topicID) && $topicID > 0)						// show mail a friend page
	{
		$res = $query->select("SELECT description FROM " . $cfgDatabase['topic'] . " WHERE id = $topicID");
		if (count($res) != 1)
			sendError("ue: Invalid topic id");
		else
		{
			$FULLURL = getFullForumURL() . "topicDisplay.php?topicID=$topicID";
			$TOPIC = htmlspecialchars(stripslashes($res[0]['description']));
			$template->register($templateHandler, "TOPIC, FULLURL");

			if (!empty($HTTP_POST_VARS['email']) && !empty($HTTP_POST_VARS['message']))
			{
				$submitted = TRUE;
				// send email
				if (empty($HTTP_POST_VARS['pmessage']))
					$HTTP_POST_VARS['pmessage'] = $lang['none'];
				_sendEmail($HTTP_POST_VARS['email'], $HTTP_POST_VARS['message'] . $HTTP_POST_VARS['pmessage']);
			}
			else
			{
				$submitted = FALSE;
				// show input form
			}
		}
	}
	else															// show list of moderators/admins/etc page
	{
		$res = $query->select("SELECT id, groupid, nickname FROM " . $cfgDatabase['user'] . " WHERE groupid > 1");
		$crew = array();
		$crew[] = array("ID" => "0", "NAME" => $lang['boardadmin'] . " ($cfgEmail)");
		for ($i = 0; $i < $query->rows; $i++)
			$crew[] = array(
				"ID" => $res[$i]['id'],
				"NAME" => htmlspecialchars(stripslashes($res[$i]['nickname'])) .  " (" . $cfgStrOperator[$res[$i]['groupid'] - 1] .  ")"
			);

		if (!empty($HTTP_POST_VARS['email']) && !empty($HTTP_POST_VARS['message']))
		{
			$submitted = TRUE;
			// send email
			_sendEmail($HTTP_POST_VARS['email'], $HTTP_POST_VARS['message']);
		}
		else
		{
			$submitted = FALSE;
			// show input form
		}
	}
}

if (!$template->load_file($templateHandler, "$cfgTemplateDirectory$cfgTemplateName/mail.ybt"))
	if (!$template->load_file($templateHandler, $cfgTemplateDirectory . "Default/mail.ybt"))
		sendError("pe: Could not load template (mail.ybt)!");

if (is_array($crew))
	$template->parse_loop($templateHandler, "crew");

echo $template->pget($templateHandler);

if ($cfgUseCompression) gzdocout();

require($cfgIncludeDirectory . "cleanup.php");
?>
