<?php require("./config.inc.php");

/*

YapBB, a fully functional bulletin board system
Copyright (C) 2000/01  Arno van der Kolk
http://yapbb.sourceforge.net/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

//=====================================================================================================================
// Description: show a list of users that are registered to this board
//=====================================================================================================================


//=====================================================================================================================
// Initialize
//=====================================================================================================================
$query = new MySQL;
//$range = substr(strtoupper($range . " "), 0, 1);
$whereclause = "";					//all
$showSummary = empty($range);

$admin = $templateLoggedIn && $sessionUserGroup >= 3;

//=====================================================================================================================
// Determine the range (if not in summary-mode)
//=====================================================================================================================
/*if ($range == ' ')
else*/ if ($range == '*')
{
	$whereclause = " 1 ";				// all
	$mode = $lang['all'];
}
else
{
	$whereclause = " u.nickname LIKE '" . $range . "%' ";
	$mode = $lang['nicknames'] . " " . $range;
}


if ($showSummary == false)
{
//=====================================================================================================================
// Action-branch: Show a specific list
//=====================================================================================================================


//=====================================================================================================================
// Gather information
//=====================================================================================================================
	if ($action == "online")
		$res = $query->select("SELECT u.* FROM " . $cfgDatabase['useronline'] . " AS uo, " . $cfgDatabase['user'] . " AS u WHERE " . $whereclause . " AND u.id = uo.userid GROUP BY uo.userid ORDER BY u.nickname");
	else
		$res = $query->select("SELECT * FROM " . $cfgDatabase['user'] . " AS u WHERE " . $whereclause . " ORDER BY u.nickname");
	$teller = 0;
	$kleur = 1;
	$user = array(array());
	if(!$admin)
	{
//=====================================================================================================================
// User is not an admin, simply show a list
//=====================================================================================================================
		for($i = 0; $i < $query->rows; $i++)
		{
			$kleur = ++$kleur % 2;
			$user[$teller]["Color"] = $kleur + 1;
			$user[$teller]["nickName"] = htmlspecialchars(stripslashes($res[$i]["nickname"]));
			$user[$teller]["id"] = $res[$i]["id"];
			$teller++;
		}
	}
	else
	{
//=====================================================================================================================
// User is an admin, show additional info
//=====================================================================================================================
		for ($i = 0; $i < $query->rows; $i++)
		{
			$kleur = ++$kleur % 2;
			$user[$teller]["Color"] = $kleur + 1;
			$user[$teller]["nickName"] = htmlspecialchars(stripslashes($res[$i]["nickname"]));
			$user[$teller]["id"] = $res[$i]["id"];
			$user[$teller]["email"] = htmlspecialchars(stripslashes($res[$i]["email"]));
			$user[$teller]["shown"] = ($res[$i]["showemail"]== 1)?"yes":"no";
			$user[$teller]["registerdate"] = getDateTime($res[$i]["registerdate"]);
			$user[$teller]["posts"] = $res[$i]["posts"];
			$user[$teller]["active"] = ($res[$i]["active"]== 1)?"checked":"";
			$user[$teller]["notes"] = nl2br(htmlspecialchars(stripslashes($res[$i]["notes"])));
			$user[$teller]["isAnonymous"] = $cfgAnonymousUser != "" && $res[$i]["nickname"] == $cfgAnonymousUser;
			$tmp = "";
//			$tmp = '<select class="inp" name="userGroupid">';
			for ($v = 0; $v < sizeof($cfgStrOperator); $v++)
//				$tmp .= '<option ' . (($v + 1 == $res[$i]['groupid'])?"selected":"") . ' value=' . ($v + 1) . '>' . $cfgStrOperator[$v] . '</option>';
				$tmp .= (($v + 1 == $res[$i]['groupid'])?$cfgStrOperator[$v]:"");
//			$tmp .= '</select>';
			$user[$teller]["group"] = $tmp;
			$user[$teller]["showProfile"] = ($res[$i]["displayprofile"]== 1)?"checked":"";
			$teller++;
		}
	}
}
else
//=====================================================================================================================
// Show summary (don't do anything specific anymore)
//=====================================================================================================================
	;


//=====================================================================================================================
// Template stuff
//=====================================================================================================================
$range = urlencode($range);
$template->register($templateHandler, "mode, range");
if(!$template->load_file($templateHandler,"$cfgTemplateDirectory$cfgTemplateName/members.ybt"))
	if(!$template->load_file($templateHandler,$cfgTemplateDirectory."Default/members.ybt"))
		sendError("pe: Could not load Template (members.ybt)!");
$template->parse($templateHandler);
if (!$showSummary) $template->parse_loop($templateHandler, "user");
echo $template->return_file($templateHandler);

if ($cfgUseCompression) gzdocout();

require($cfgIncludeDirectory . "cleanup.php");
?>
