<?php require("./config.inc.php");

/*

YapBB, a fully functional bulletin board system
Copyright (C) 2000/01  Arno van der Kolk
http://yapbb.sourceforge.net/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

//=====================================================================================================================
// Description: moderator functions - lock/unlock/delete/move threads/posts
//=====================================================================================================================

disable_cache();
$headerCalled = false;
$footerCalled = false;


//=====================================================================================================================
// Show header
//=====================================================================================================================
function mod_header()
{
	global $cfgForumTitle, $cfgBaseURL, $headerCalled;
	if ($headerCalled) return;
	echo '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/REC-html40/loose.dtd">
	<html>
	<head>
	<meta name="MSSmartTagsPreventParsing" content="TRUE">
	<META HTTP-EQUIV="Content-Script-Type" CONTENT="text/javascript">
	<title>' . $cfgForumTitle . ' - Moderate this topic</title>
	<LINK HREF="' . $cfgBaseURL . 'style.php" rel="styleSheet" TYPE="text/css">
	<LINK REL="SHORTCUT ICON" HREF="' . $cfgBaseURL . 'favicon.ico">
	</head>
	<body id="all">
	<hr>
	';
	$headerCalled = 1;
}


//=====================================================================================================================
// Show footer
//=====================================================================================================================
function mod_footer()
{
	global $footerCalled;
	if ($footerCalled) return;
	echo '
	<hr>
	</body>
	</html>
	';
	$footerCalled = 1;
}


//=====================================================================================================================
// Display thingie to return to referer
//=====================================================================================================================
function backRef()
{
	mod_header();
	global $ref, $topicid, $cfgBaseURL;
	if ($topicid == 0)
		$ref = $cfgBaseURL . "frontpage.php";
	echo "
	Done. - <a href='$ref'>Back</a>
	<script language='javascript' type='text/javascript'><!--
	setTimeout('document.location.href=\'$ref\'', 2000);
	//--></script>
	";
	mod_footer();
}


//=====================================================================================================================
// Initialize
//=====================================================================================================================
if ($ref == "")
	$ref = getenv("HTTP_REFERER");
if ($ref == "")
	$ref = $cfgBaseURL;
//header("Refresh: 2; $ref");
//unset($ref);

if (!isset($topicid) || $topicid <= 0)
	sendError("ue: Wrong id $topicid");


//=====================================================================================================================
// Authorize
//=====================================================================================================================
$auth = getModeratorValidation(getForumID($topicid));
if (!$auth && !($cfgAllowUserToDeletePost && $action == "delete_post")) // users MAY be able to delete posts
	sendError("ue: No admitance!");


//=====================================================================================================================
// Further initialization
//=====================================================================================================================
$topicQuery = new MySQL;
$topRes = $topicQuery->select("SELECT * FROM " . $cfgDatabase['topic'] . " WHERE id = $topicid");
if ($topicQuery->rows != 1)
	sendError("pe: Topic with id $topicid does no longer exist??");


//=====================================================================================================================
// Choose action
//=====================================================================================================================
switch ($action)
{

//=====================================================================================================================
// Get ip from Posting (by Merlijn aka johnny appleseed)
//=====================================================================================================================
	case "getip":
	{
		$getip = new MySQL;
		$getip_res = $getip->select("SELECT ip FROM " . $cfgDatabase['post'] . " WHERE id = $postid");
		mod_header();
		echo "Ip of posting $postid is: ". $getip_res[0]['ip'] . " - hostname: " . gethostbyaddr($getip_res[0]['ip']);
		mod_footer();
		break;
	}

//===================================================================================================================== 
// Delete selected post 
//===================================================================================================================== 
	case "delete_post": 
	{ 
		$query = new MySQL; 
		$res = $query->select("SELECT * FROM " . $cfgDatabase['post'] . " WHERE id = $postid"); 
		if ($query->rows != 1) sendError("ue: no-go"); 
		if ($res[0]['topicid'] != $topicid) sendError("ue: no-go."); 
		if ($res[0]['posterid'] == $sessionUserID) 
		{ 
			// ok 
		} 
		else 
		{ 
			if ($sessionUserGroup < 2) 
				sendError("You are not authorized to delete other people's posts."); 
			else
				; //ok (moderator validation already executed)
		} 
		if ($res[0]['reactionto'] == 0)			// delete entire topic, is root message 
		{ 
			header("Location: $PHP_SELF?action=delete_topic&topicid=$topicid"); 
			exit; 
		} 
		else									// only delete selected post 
		{ 
			// move all child-posts to parent
			$query->query("UPDATE " . $cfgDatabase['post'] . " SET reactionto = " . $res[0]['reactionto'] . " WHERE reactionto = $postid"); 
			// delete post
			$query->query("DELETE FROM " . $cfgDatabase['post'] . " WHERE id = $postid"); 
			if ($topRes[0]['lastpostid'] == $postid)	// in case we delete last post in topic, we need to update the topic info
			{ 
				$res2 = $query->select("SELECT * FROM " . $cfgDatabase['post'] . " WHERE topicid = $topicid ORDER BY date DESC LIMIT 1");
//				$res2 = $query->select("SELECT * FROM " . $cfgDatabase['post'] . " WHERE topicid = $topicid ORDER BY id DESC LIMIT 1"); 
				$query->query("UPDATE " . $cfgDatabase['topic'] . " SET lastpostid = " . $res2[0]['id'] . " WHERE id = $topicid"); 
			} 
		} 
		unset($query); 
		unset($res); 
		if ($ref == $cfgBaseURL)
			$ref = $cfgBaseURL . "topicDisplay.php?topicID=$topicid";
		backRef(); 
		break; 
	} 
/*
//=====================================================================================================================
// Delete selected post
//=====================================================================================================================
	case "delete_post":
	{
		$query = new MySQL;
		$res = $query->select("SELECT * FROM " . $cfgDatabase['post'] . " WHERE id = $postid");
		if ($query->rows != 1) sendError("ue: no-go");
		if ($res[0]['topicid'] != $topicid) sendError("ue: no-go.");
		if ($res[0]['posterid'] == $sessionUserID)
		{
			// ok
		}
		else
		{
			if ($sessionUserGroup < 2)
				sendError("You are not authorized to delete other people's posts.");
			else
				; //ok
		}
		if ($res[0]['reactionto'] == 0)		// delete entire topic, is root message
		{
			header("Location: $PHP_SELF?action=delete_topic&topicid=$topicid");
			exit;
		}
		else								// only delete selected post
		{
			$query->query("UPDATE " . $cfgDatabase['post'] . " SET reactionto = " . $res[0]['reactionto'] . " WHERE reactionto = $postid");
			$query->query("DELETE FROM " . $cfgDatabase['post'] . " WHERE id = $postid");
			if ($topRes[0]['lastpost'] == $postid)
			{
				// moved up ^^
			}
		}
		unset($query);
		unset($res);
		$topicid = 0;
		backRef();
		break;
	}
*/
//=====================================================================================================================
// Promote topic to announcement
//=====================================================================================================================
	case "announce":
	{
		$query = new MySQL;
		$res = $query->select("SELECT * FROM " . $cfgDatabase['announcement'] . " WHERE topicid = $topicid");
		if ($query->rows < 1)
			$query->query("INSERT INTO " . $cfgDatabase['announcement'] . " (topicid, sticky) VALUES ($topicid, 0)");
		else
			$query->query("DELETE FROM " . $cfgDatabase['announcement'] . " WHERE topicid = $topicid");
		unset($query);
		unset($res);
		backRef();
		break;
	}

//=====================================================================================================================
// Lock the specified topic
//=====================================================================================================================
	case "lock_topic":
	{
		$active = 1 - (int)($topRes[0]['active']);
		$query = new MySQL;
		$query->query("UPDATE " . $cfgDatabase['topic'] . " SET active = $active WHERE id = $topicid");
		unset($query);
		unset($active);
		backRef();
		break;
	}

//=====================================================================================================================
// Move the thread to another forum
//=====================================================================================================================
	case "move_topic":
	{
		if (!isset($newforumid))
		{
			mod_header();
			$forumQuery = new MySQL;
			$forRes = $forumQuery->select("SELECT * FROM " . $cfgDatabase['forum'] . " ORDER BY id ASC");
			$fors2 = "";
			for ($i = 0; $i < $forumQuery->rows; $i++)
			{
				$forRes[$i]['name'] = stripslashes($forRes[$i]['name']);
				$forRes[$i]['description'] = stripslashes($forRes[$i]['description']);
				$fors2 .= '<option ' . (($topRes[0]['forumid'] == $forRes[$i]['id'])?"selected":"") . ' value="' . $forRes[$i]['id'] . '">' . $forRes[$i]['name'] . "</option>\n";
				if ($forRes[$i]['id'] == $topRes[0]['forumid']) $forumParams = $forRes[$i];
			}
echo '
			<form action="' . $PHP_SELF . '" method="GET">
			<input type="hidden" name="action" value="move_topic">
			<input type="hidden" name="topicid" value="' . $topicid . '">
			<input type="hidden" name="ref" value="' . $ref . '">
			Choose new parent-forum for this topic:
			<select name="newforumid">
			' . $fors2 . '
			</select>
			<input type="submit" value="Go">
			<input type="reset" value="Reset">
			</form>
';
			mod_footer();
		}
		else
		{
			$query = new MySQL;
			$query->query("UPDATE " . $cfgDatabase['topic'] . " SET forumid = $newforumid WHERE id = $topicid");
			unset($query);
			backRef();
		}
		break;
	}

//=====================================================================================================================
// Delete the specified thread
//=====================================================================================================================
	case "delete_topic":
	{
		if ($verify != 1)
		{
			mod_header();
echo '
			Are you sure? This topic will be deleted along with all existing posts!
			<form action="' . $docself . '" method="GET">
			<input type="hidden" name="action" value="delete_topic">
			<input type="hidden" name="topicid" value="' . $topicid . '">
			<input type="hidden" name="verify" value="1">
			<input type="submit" value="Go">
			</form>
			<hr>
			<a href="' . $ref . '">Back</a>
';
			mod_footer();
		}
		else
		{
			$query = new MySQL;
//			echo "Locking all applicable topics<br>\n";
			flush();
			$query->query("UPDATE " . $cfgDatabase['topic'] . " SET active = 0 WHERE id = $topicid");
//			echo "Waiting 10 seconds for connections to close...<p>\n";
			flush();
			sleep(10);
			$query->query("DELETE FROM " . $cfgDatabase['post'] . " WHERE topicid = $topicid");
			$query->query("DELETE FROM " . $cfgDatabase['topic'] . " WHERE id = $topicid");
			unset($query);
			$topicid = 0;
			backRef();
		}
		break;
	}

//=====================================================================================================================
// Error
//=====================================================================================================================
	default:
	{
		sendError("ue: Wrong action");
		break;
	}
}

if ($cfgUseCompression) gzdocout();

require($cfgIncludeDirectory . "cleanup.php");
?>
