<?php require("./config.inc.php");

/*

YapBB, a fully functional bulletin board system
Copyright (C) 2000/01  Arno van der Kolk
http://yapbb.sourceforge.net/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/


/**
* Use this class to handle posting messages. A class is much, much nicer
* than a bunch of functions and some loose global variables. :)
*
* This class doesn't really have a public interface. Just instantiate
* it and things will go from there. See at the bottom of this file.
*/
class Post
{
	var $query;					// will contain a MySQL object
	var $table_post = "";		// information from $cfgDatabase will be copied into these vars
	var $table_topic = "";		// so there's no further need to 'global' $cfgDatabase
	var $table_forum = "";
	var $table_user = "";
	var $table_subscription = "";
	var $table_moderator = "";
	var $table_announcement = "";
	var $returnURL;				// the URL to return to when finished or cancel is pressed

	var $action = "";			// indicator for what action to perform
	var $A_DOPOST = "P";		// public static final (constant) indicating posting a new message
	var $A_DOTOPIC = "T";		// public static final (constant) indicating posting a new topic
	var $A_EDITPOST = "E";		// public static final (constant) indicating editing an existing message
	var $A_DOREPLY = "R";		// public static final (constant) indicating posting a new message, which is a reply to a specific message

	var $forumID = 0;			// these are request parameters
	var $topicID = 0;
	var $postID = 0;
	var $replyTO = 0;
	var $posted = FALSE;		// submit button pressed?

	var $authPass = "";
	var $authGroup = 1;
	var $userActive = 0;
	var $userActivated = 0;
	var $IP = "";
	var $subscribe = FALSE;		// user subscribed to thread?
	var $anonymously = FALSE;	// user posts anonymously?
	var $announcement = FALSE;	// topic is announcement?
	var $sticky = FALSE;		// announcement is sticky?
	var $topicTitle = "";

	var $text = "";
	var $authUser = "";
	var $userID = 0;
	var $smiley = 0;
	var $topicActive = 1;

	// used when editing or replying a post
	var $old_text = "";
	var $old_authUser = "";
	var $old_userID = 0;
	var $old_smiley = 0;
	var $old_date = "";

	var $PAGE_TITLE = "";
	var $BACKURL = "";


	/**
	* Constructor, no arguments
	*/
	function Post()
	{
		global $HTTP_GET_VARS, $HTTP_POST_VARS, $lang, $cfgBaseURL, $cfgDatabase;

		$this->query = new MySQL();

														// gather info
		$this->table_post = $cfgDatabase['post'];
		$this->table_topic = $cfgDatabase['topic'];
		$this->table_forum = $cfgDatabase['forum'];
		$this->table_user = $cfgDatabase['user'];
		$this->table_subscription = $cfgDatabase['subscription'];
		$this->table_moderator = $cfgDatabase['moderator'];
		$this->table_announcement = $cfgDatabase['announcement'];

		$this->forumID = 0 + $HTTP_GET_VARS['forumID'];
		$this->topicID = 0 + $HTTP_GET_VARS['topicID'];
		$this->postID = 0 + $HTTP_GET_VARS['postID'];
		$this->replyTO = 0 + $HTTP_GET_VARS['replyTO'];

		$this->determineAction();						// fill in $this->action, based on parameters

														// Set variables according to POSTed form (if any)
		$this->text = $HTTP_POST_VARS['text'];
		$this->topicTitle = $HTTP_POST_VARS['topicTitle'];
		$this->authUser = $HTTP_POST_VARS['authUser'];
		$this->authPass = $HTTP_POST_VARS['authPass'];
		$this->smiley = 0 + $HTTP_POST_VARS['smiley'];
		$this->subscribe = 0 + !empty($HTTP_POST_VARS['subscribe']);
		$this->posted = 0 + !empty($HTTP_POST_VARS['posted']);
		$this->anonymously = 0 + !empty($HTTP_POST_VARS['anonymously']);
		$this->announcement = 0 + !empty($HTTP_POST_VARS['announcement']);
		$this->sticky = 0 + !empty($HTTP_POST_VARS['sticky']);
		$this->IP = getenv("REMOTE_ADDR");

														// Set some more values
		$this->PAGE_TITLE = $lang['postMessage'];
		$this->BACKURL = getenv("HTTP_REFERER");
		if ($this->BACKURL == "") $this->BACKURL = $cfgBaseURL . "frontpage.php";

		$this->authenticateUser();

		if ($this->action != $this->A_DOTOPIC)
			$this->retrieveTopicInfo();
		else
			$this->topicActive = 1;

		if ($this->posted)								// user has submitted form
		{
			if (checkIPban($this->IP) || !$this->userActive)
				sendError($lang['ban']);
			if (!$this->userActivated)
				sendError($lang['loginActivate']);
	
			$this->checkEmptyFields();
			$this->filterText();

			$this->proceedAction();						// actually do some work on the DB

			$this->subscribeUser();						// send out subscription notifications and all
			$this->finishAction();						// redirect
		}
		else											// show input form
		{
			$id = 0;
			if ($this->action == $this->A_EDITPOST)
				$id = $this->postID;
			else if ($this->action == $this->A_DOREPLY)
				$id = $this->replyTO;

			if ($id > 0)								// retrieve old info in case of editing or replying to post
			{
				$res = $this->query->select("SELECT p.date, p.text, p.iconid, p.posterid, u.nickname FROM " . $this->table_post . " AS p, " . $this->table_user . " AS u WHERE p.posterid = u.id AND p.id = $id");
				if ($this->query->rows != 1)
					sendError("id error $id");

				$this->old_authUser = stripslashes($res[0]['nickname']);
				$this->old_smiley = $res[0]['iconid'];
				$this->old_text = stripslashes($res[0]['text']);
				$this->old_userID = $res[0]['posterid'];
				$this->old_date = $res[0]['date'];
			}
			unset($id);

			$this->showInputForm();
		}
	} // end constructor


	/**
	* In case of not adding a new topic, retrieve some info (topicID, forumID, topicDescription, topicActive)
	*/
	function retrieveTopicInfo()
	{
		$Query = "";											// in case we are NOT adding a new topic, retrieve info
		if ($this->action == $this->A_EDITPOST)
			$Query = "SELECT t.id, t.active, t.forumid, t.description FROM " . $this->table_topic . " AS t, " . $this->table_post . " AS p WHERE t.id = p.topicid AND p.id = " . $this->postID;
		else if ($this->action == $this->A_DOREPLY)
			$Query = "SELECT t.id, t.active, t.forumid, t.description FROM " . $this->table_topic . " AS t, " . $this->table_post . " AS p WHERE t.id = p.topicid AND p.id = " . $this->replyTO;
		else if ($this->action == $this->A_DOPOST)
			$Query = "SELECT id, active, forumid, description FROM " . $this->table_topic . " WHERE id = " . $this->topicID;

		if ($Query != "")
		{
			$res = $this->query->select($Query);
			if ($this->query->rows != 1)
				sendError("parameter error - $Query");

			$this->old_topicTitle = stripslashes($res[0]['description']);
			$this->topicActive = $res[0]['active'];
			$this->forumID = $res[0]['forumid'];
			$this->topicID = $res[0]['id'];
			unset($res);
		}
		unset($Query);

	} // end func retrieveTopicInfo


	/**
	* Determine course of action, based on parameters
	*
	* It is not a good idea to use multiple parameter,
	* as only one is used obviously. See below for the
	* exact order.
	*/
	function determineAction()
	{
		if ($this->replyTO > 0)						// DO REPLY
			$this->action = $this->A_DOREPLY;
		else if ($this->forumID > 0)				// DO TOPIC
			$this->action = $this->A_DOTOPIC;
		else if ($this->postID > 0)					// EDIT POST
			$this->action = $this->A_EDITPOST;
		else if ($this->topicID > 0)				// DO POST
			$this->action = $this->A_DOPOST;
	} // end func determineAction


	/**
	* Validate that all mandatory fields are filled
	*/
	function checkEmptyFields()
	{
		global $lang, $smilies;
		switch ($this->action)
		{
			case $this->A_DOTOPIC:
				if (trim($this->topicTitle) == "")
					$this->showInputForm($lang['errorNoTitle']);
			case $this->A_DOREPLY:
			case $this->A_DOPOST:
			case $this->A_EDITPOST:
				if (trim($this->text) == "")
					$this->showInputForm($lang['errorNoText']);
				$count = count($smilies);
				if ($count != 0 && ($this->smiley < 0 || $this->smiley >= $count))
					$this->showInputForm('Invalid smiley choice');
				break;
			default:
				sendError("pe: Unknown error in validation process");
		}
	} // end func checkEmptyFields


	/**
	* Form has been submitted, now take appropriate action
	*/
	function proceedAction()
	{
		if ($this->action == $this->A_DOREPLY)		// DO REPLY
		{
			$this->postID = 0;							// irrelevant, will be re-set by addPost()
			if ($this->topicID == 0)
			{
				$res = $this->query->select("SELECT topicid FROM " . $this->table_post . " WHERE id = " . $this->replyTO);
				if ($this->query->rows != 1 || $res[0]['topicid'] == 0)
					$this->showInputForm("Could not retrieve distinct topic id");

				$this->topicID = $res[0]['topicid'];	// important
			}
			$this->addPost();
		}
		else if ($this->action == $this->A_DOTOPIC)	// DO TOPIC
		{
			$this->addTopic();
		}
		else if ($this->action == $this->A_EDITPOST)// EDIT POST
		{
			$this->replyTO = 0;							// irrelevant, not used
			$this->editPost();
		}
		else if ($this->action == $this->A_DOPOST)	// DO POST
		{
			$this->replyTO = 0;							// important
			$this->addPost();
		}
	} // end func proceedAction


	/**
	* Add a new post to a topic
	*/
	function addPost()
	{
		global $lang, $cfgAnonymousUser;
		$this->checkLastUserPost();					//to avoid spamming, double posting

		$auth = $this->isAuth();
		if (!$this->topicActive && !$auth)
			$this->showInputForm($lang['editLocked']);

		if ($cfgAnonymousUser == "" && $this->authUser == $cfgAnonymousUser)
			$this->showInputForm($lang['errorNoGuestPost']);

		// insert new post and retrieve id
		$this->postID = $this->query->insert("INSERT INTO " . $this->table_post . " (text, topicid, posterid, date, ip, iconid, editorid, editdate, reactionto) VALUES ('" . addslashes($this->text) . "', '" . $this->topicID . "', '" . $this->userID . "', '" . time() . "', '" . $this->IP . "', '" . $this->smiley . "', '0', '0', '" . $this->replyTO . "')");
		if ($this->postID == 0)
		{
			$res = $this->query->select("SELECT id FROM " . $this->table_post . " WHERE text = '" . addslashes($this->text) . "' AND topicid = " . $this->topicID . " AND posterid = " . $this->userID . " AND date = '$time' AND ip = '" . $this->IP . "' AND iconid = " . $this->smiley . " AND editorid = 0 AND editdate = 0 AND reactionto = " . $this->replyTO);

			if ($this->query->rows != 1 || $res[0]['id'] == 0)
				sendError($lang['errorLinkPost'] . ", " . $this->query->rows . ", " . $res[0]['id']);
			$this->postID = $res[0]['id'];
		}

		$this->query->query("UPDATE " . $this->table_user . " SET posts = posts + 1 WHERE id = " . $this->userID);

		if ($this->action != $this->A_DOTOPIC) //($this->topicID > 0)
			$this->query->query("UPDATE " . $this->table_topic . " SET lastpostid = " . $this->postID . " WHERE id = " . $this->topicID);
		else
			; // we're adding a topic: addPost() was called from addTopic() - so, do not update lastpostid

		$this->BACKURL = $cfgBaseURL . "topicDisplay.php?topicID=" . $this->topicID . "&begin=-1";
	} // end func addPost


	/**
	* Edit an existing post
	*/
	function editPost()
	{
		global $cfgAnonymousUser, $lang;

		if ($this->authUser == $cfgAnonymousUser)
			$this->showInputForm($lang['errorNoGuestEdit']);

		$res = $this->query->select("SELECT * FROM " . $this->table_post . " WHERE id = " . $this->postID);
		if ($this->query->rows != 1)
			sendError("ue: Illegal id " . $this->postID);
		$this->old_userID = $res[0]['posterid'];

		$auth = $this->isAuth();

		if ($this->userID == $this->old_userID || $auth)
		{
			if ($this->topicActive || $auth)
				$this->query->query("UPDATE " . $this->table_post . " SET iconid = " . $this->smiley . ", text = '" . addslashes($this->text) . "', editorid = " . $this->userID . ", editdate = '" . time() . "', ip = '" . $this->IP . "' WHERE id = " . $this->postID);
			else
				$this->showInputForm($lang['editLocked']);
		}
		else
			$this->showInputForm($lang['errorEdit']);

		$this->BACKURL = $cfgBaseURL . "topicDisplay.php?topicID=" . $this->topicID . "&postID=" . $this->postID . "#" . $this->postID;
	} // end func editPost


	/**
	* Check whether the user is an admin or moderator of this forum
	*/
	function isAuth()
	{
		if ($this->authGroup >= 3)
			return true;
		else if ($this->authGroup == 2)
		{
			if ($this->topicID > 0)
				$Query = "SELECT m.userid FROM " . $this->table_moderator . " AS m, " . $this->table_user . " AS u WHERE m.userid = u.id AND m.forumid = " . $this->forumID . " AND u.id = " . $this->userID . " AND u.groupid > 1";
			else
				$Query = "SELECT m.userid FROM " . $this->table_post . " AS p, " . $this->table_topic . " AS t, " . $this->table_moderator . " AS m, " . $this->table_user . " AS u WHERE m.userid = u.id AND m.forumid = t.forumid AND t.id = p.topicid AND p.id = " . $this->postID . " AND u.id = " . $this->userID . " AND u.groupid > 1";
	
			$this->query->select($Query);
			return $this->query->rows == 1;
		}
		else
			return false;
	} // end func isAuth


	/**
	* Add a new topic to this forum
	*/
	function addTopic()
	{
		global $lang;
		$this->replyTO = 0;		// a topic's 1st post is a 'normal' post, not a reply
		$this->topicID = 0;		// should already be 0 :)

		$this->addPost();		// first add a new post

		$this->topicID = $this->query->insert("INSERT INTO " . $this->table_topic . " (description, postid, views, active, forumid, lastpostid) VALUES ('" . addslashes($this->topicTitle) . "', '" . $this->postID . "', '0', '1', '" . $this->forumID . "', '" . $this->postID . "')");
		if ($this->topicID == 0)
		{
			$res = $this->query->select("SELECT id FROM " . $this->table_topic . " WHERE description = '" . addslashes($this->topicTitle) . "' AND postid = " . $this->postID . " AND views = 0 AND active = 1 AND forumid = " . $this->forumID . " AND lastpostid = " . $this->postID);

			if ($this->query->rows == 0 || $res[0]['id'] == 0)
				sendError($lang['errorLinkTopic'] . ", " . $this->query->rows . ", " . $res[0]['id']);

			$this->topicID = $res[0]['id'];
		}

		$this->query->query("UPDATE " . $this->table_post . " SET topicid = " . $this->topicID  . " WHERE id = " . $this->postID);

		if ($this->announcement)
		{
			if ($this->authGroup > 1)
				$this->query->query("INSERT INTO " . $this->table_announcement . " (topicid, sticky) VALUES (" . $this->topicID. ", " . $this->sticky . ")");
			else
				;	// only moderators and up may post announcements - do not display error message
		}

		$this->BACKURL = $cfgBaseURL . "forumDisplay.php?forumID=" . $this->forumID;	// return to parent forum
		//$this->BACKURL = $cfgBaseURL . "topicDisplay.php?topicID=" . $this->topicID;	// return to new topic itself
	} // end func filterText


	/**
	* Filter out some possibly malicious pieces of text and add '/me' support
	*/
	function filterText()
	{
		$this->text = eregi_replace("/con( )*/con", "/concon", $this->text);
		$this->text = eregi_replace("\\\\con( )*\\\\con", "\\concon", $this->text);
		$this->text = eregi_replace("/nul( )*/nul", "/nulnul", $this->text);
		$this->text = eregi_replace("\\\\nul( )*\\\\nul", "\\nulnul", $this->text);

		// /me conversion (by Arien@gathering.tweakers.net)
		$expression = "!(^|[ \t])/me (.*)$!im";
		$replacement = "\\1[me=" . $this->authUser . "]\\2[/me]";
		$this->text = preg_replace($expression, $replacement, $this->text);
	} // end func filterText


	/**
	* Check whether or not user has recently posted a message
	*
	* This funtion is primarily used as a flood protection or
	* a protection for accidentally submitting twice.
	*/
	function checkLastUserPost()
	{
		global $cfgFloodTime;
		$res = $this->query->select("SELECT u.groupid, p.date FROM " . $this->table_post . " AS p, " . $this->table_user . " AS u WHERE u.id = p.posterid AND p.posterid = " . $this->userID . " ORDER BY p.date DESC LIMIT 1");
		if ((time() - $res[0]['date']) < $cfgFloodTime && $res[0]['groupid'] <= 1)
			$this->showInputForm("Warning: you can't post two messages within $cfgFloodTime seconds.\nIf you (accidentally) pressed the submit button twice, your original message got posted anyway.");
		unset($res);
		return TRUE;
	} // end func checkLastUserPost


	/**
	* Validate the current user
	*
	* Includes checks for anonymous users and all
	*/
	function authenticateUser()
	{
		global $HTTP_SESSION_VARS, $cfgAnonymousUser, $cfgIncludeDirectory, $lang;
		if (															// try to use session variables
			empty($HTTP_SESSION_VARS['sessionUser']) ||
			empty($HTTP_SESSION_VARS['sessionPass']) ||
			empty($HTTP_SESSION_VARS['sessionUserGroup']) ||
			empty($HTTP_SESSION_VARS['sessionUserID'])
		)
		{																// session variables are invalid
			if ($this->authUser == "" && $this->authPass == "")			// 
			{
				if ($cfgAnonymousUser != "")							// are we allowed anonymously ?
				{
					$this->anonymously = TRUE;
					$this->authUser = $cfgAnonymousUser;
				}
				else													// no, anonymously not allowed
				{
					if ($this->posted)
						$this->showInputForm($lang['errorLogin']);			// (or use $lang['errorNoGuestPost'] )
				}
			}
			else
			{
																		// do nothing, proceed with data specified in request/form
			}

			if ($this->posted)											// should we validate ?
			{
				$this->authPass = ROT13($this->authPass);
				$res = $this->query->select("SELECT active, activated, id, groupid FROM " . $this->table_user . " WHERE nickname = '" . addslashes($this->authUser) . "' AND password = '" . addslashes($this->authPass) . "'");
				if ($this->query->rows != 1)
					$this->showInputForm($lang['errorLogin']);

				$this->authGroup = $res[0]['groupid'];
				$this->userID = $res[0]['id'];
				$this->userActive = $res[0]['active'];
				$this->userActivated = $res[0]['activated'];
			}
			else														// no, just proceed as anonymous
			{
				$this->authGroup = 1;
				$this->userID = 0;
//				$this->userActive = 1;
//				$this->userActivated = 1;
			}
		}
		else															// use session variables
		{
			if ($this->anonymously)										// user opted for anonymous post
			{
				if ($cfgAnonymousUser != "")
				{
					$res = $this->query->select("SELECT id FROM " . $this->table_user . " WHERE nickname = '" . addslashes($cfgAnonymousUser) . "'");
					if ($this->query->rows != 1 || $res[0]['id'] == 0)
						sendError("pe: DB inconsistency");

					$this->userID = $res[0]['id'];
					$this->authUser = $cfgAnonymousUser;
					$this->authPass = "";
					$this->authGroup = 1;
					$this->userActive = 1;
					$this->userActivated = 1;
				}
				else													// anonymous posts not allowed
				{
					$this->showInputForm($lang['errorNoGuestPost']);
				}
			}
			else														// use session variables
			{
				$this->authUser = $HTTP_SESSION_VARS['sessionUser'];
				$this->authPass = $HTTP_SESSION_VARS['sessionPass'];
				$this->authGroup = $HTTP_SESSION_VARS['sessionUserGroup'];
				$this->userID = $HTTP_SESSION_VARS['sessionUserID'];

				$res = $this->query->select("SELECT active, activated FROM " . $this->table_user . " WHERE nickname = '" . addslashes($this->authUser) . "' AND password = '" . addslashes($this->authPass) . "'");
				if ($this->query->rows != 1)
					$this->showInputForm($lang['errorLogin']);

				$this->userActive = $res[0]['active'];
				$this->userActivated = $res[0]['activated'];
			}
		}

		// alright, user has properly submitted login info
		// now check is user may post in this forum

																		// are we allowed to enter this forum?
		if ($this->forumID > 0)
			$query = "SELECT password, name FROM " . $this->table_forum . " WHERE id = " . $this->forumID;
		else if ($this->topicID > 0)
			$query = "SELECT f.password, f.name FROM " . $this->table_forum . " AS f, " . $this->table_topic . " AS t WHERE f.id = t.forumid AND t.id = " . $this->topicID;
		else if (($id = $this->postID) > 0 || ($id = $this->replyTO) > 0)
			$query = "SELECT f.password, f.name FROM " . $this->table_forum . " AS f, " . $this->table_topic . " AS t, " . $this->table_post . " AS p WHERE f.id = t.forumid AND t.id = p.topicid AND p.id = $id";
		else
			sendError("Parameter error");

		$res = $this->query->select($query);

		if ($this->query->rows != 1)
			sendError("ue: Invalid forum");

		$forumResultRow = $res[0];
		require($cfgIncludeDirectory . "forumpassword.php");

		unset($forumResultRow);
		unset($res);
	} // end func authenticateUser


	/**
	* User has submitted post, redirect back
	*/
	function finishAction()
	{
		global $cfgBaseURL, $lang;
		die("
			<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\" \"http://www.w3.org/TR/REC-html40/loose.dtd\">
			<html>
			<head>
			<meta name='MSSmartTagsPreventParsing' content='TRUE'>
			<LINK HREF='" . $cfgBaseURL . "style.php' rel='styleSheet' TYPE='text/css'>
			<meta http-equiv='Refresh' content='1; URL=$cfgBaseURL" . $this->BACKURL . "'>
			</head>
			<body id='all'>
			<span style='display: block' class='bigFont'>" . $lang['thanksMessage'] . ", " . $lang['returnForum'] . ".</span>
			<br>
			<span style='display: block' class='smallFont'><a href='$cfgBaseURL" . $this->BACKURL . "'>" . $lang['clickNoWait'] . "</a></span>
			</body>
			</html>
			");
	} // end func finishAction


	/**
	* Send out subscription notices (if required)
	*
	* Also, register or unregister current user
	*/
	function subscribeUser()
	{
		global $cfgDatabase, $cfgTmpDirectory, $cfgSubscriptionMailInterval, $cfgForumTitle, $HTTP_ENV_VARS, $PHP_SELF, $cfgEmail, $cfgAnonymousUser;

//=====================================================================================================================
// Subscribe user
//=====================================================================================================================
		$res = $this->query->select("SELECT topicid FROM " . $this->table_subscription . " WHERE userid = " . $this->userID . " AND topicid = " . $this->topicID);
		if ($this->query->rows == 0)
			if ($this->subscribe)
				if ($this->authUser == $cfgAnonymousUser && $cfgAnonymousUser != "")
					;	// anonymous users cannot subscribe
				else
					$this->query->query("INSERT INTO " . $this->table_subscription . " (topicid, userid) VALUES (" . $this->topicID . ", " . $this->userID . ")");
			else
				;
		else
			if ($this->subscribe)
				;
			else
				$this->query->query("DELETE FROM " . $this->table_subscription . " WHERE topicid = " . $this->topicID . " AND userid = " . $this->userID);

		if (file_exists($cfgTmpDirectory . "mailsubscription.php"))
		{
			$text = file($cfgTmpDirectory . "mailsubscription.php");
			$body = trim($text[1]);
		}
		else
			$body = 0;


//=====================================================================================================================
// Check if sending out notification email is required
//=====================================================================================================================
		$ret = true;
		if ($body < time() && $cfgSubscriptionMailInterval > 0)
		{
			$res = $this->query->select("SELECT t.id AS topicid, t.description, u.id, u.nickname, u.email FROM " . $this->table_topic . " AS t, " . $this->table_user . " AS u, " . $this->table_subscription . " AS uo WHERE uo.topicid = " . $this->topicID . " AND uo.userid = u.id AND t.id = uo.topicid");
			$subj = "Thread update notification at $cfgForumTitle";
			$headers = "From: $cfgEmail\nReply-To: $cfgEmail\nX-Mailer: YapBB @ $cfgForumTitle, PHP/" . phpversion();
			$sendmail = true;
			$ret = false;

			for ($i = 0; $i < $this->query->rows && $sendmail; $i++)
			{
				if ($res[$i]['id'] == $this->userID) continue;			// do not send to the posted of the message :)

				$res[$i]['nickname'] = stripslashes($res[$i]['nickname']);
				$res[$i]['description'] = stripslashes($res[$i]['description']);
				$res[$i]['email'] = stripslashes($res[$i]['email']);

				$sendmail = false;

				$host = getenv("HTTP_HOST");
				if (empty($host)) $host = getenv("SERVER_NAME");
				if (empty($host)) $host = $HTTP_ENV_VARS['HTTP_HOST'];
				if (empty($host)) $host = $HTTP_ENV_VARS['SERVER_NAME'];

				$port = getenv("SERVER_PORT");
				if (empty($port)) $port = $HTTP_ENV_VARS['SERVER_PORT'];
				if ($port == 80)
					$port = "";
				else
					$post = ":$port";

				$msg = "Hi " . $res[$i]['nickname'] . ",\n";
				$msg .= "\n";
				$msg .= "Someone has posted a new message in the topic '" . $res[$i]['description'] . "'.";

				if (!empty($host) && !empty($port))
				{
					$pos = strrpos($PHP_SELF, '/');
					$dir = substr($PHP_SELF, 0, $pos);
					$msg .= " Check it out here:\n";
					$msg .= "http://$host$port$dir/topicDisplay.php?topicID=" . $res[$i]['topicid'] . "\n";
					$sendmail = true;

					unset($pos);
					unset($dir);
				}

				$headers = "To: " . $res[$i]['email'] . "\n$headers";

				if ($sendmail)
					$ret = mail($res[$i]['email'], $subj, $msg, $headers);

				unset($host);
				unset($port);
			}

//=====================================================================================================================
// Update marker file
//=====================================================================================================================
			$fh = @fopen($cfgTmpDirectory . "mailsubscription.php", "w") or false;
			if ($fh != false)
			{
				fwrite($fh, '<' . '?php /' . "*\n" . (time() + ($cfgSubscriptionMailInterval * 60)) . "\n*" . '/ ?' . '>');
				fclose($fh);
			}

			unset($fh);
			unset($subj);
			unset($headers);
			unset($sendmail);
			unset($msg);
		}
		unset($body);
		unset($text);

		return ret;
	} // end func subscribeUser


	/**
	* Basically, show the input form so that user can enter his text
	*/
	function showInputForm($errorMsg = "")
	{
		$GLOBALS["ERRORMSG"] = $errorMsg;
		global $template, $cfgTemplateName, $cfgTemplateDirectory, $templateHandler, $lang,
				$cfgIncludeDirectory, $smilies, $cfgProcessSmilies, $templateLoggedIn;

//=====================================================================================================================
// Retrieve/calculate information to display - Template stuff
//=====================================================================================================================

		$GLOBALS['DOTOPIC'] = $this->action == $this->A_DOTOPIC;
		$GLOBALS['DOPOST'] = $this->action == $this->A_DOPOST || $this->action == $this->A_DOREPLY || $this->action == $this->A_EDITPOST;
		$GLOBALS['EDITPOST'] = $this->action == $this->A_EDITPOST;

		if ($this->action != $this->A_DOTOPIC)
		{
			$res = $this->query->select("SELECT description, forumid FROM " . $this->table_topic . " WHERE id = " . $this->topicID);
			if ($this->query->rows != 1)
				sendError("ue: UH-OH! " . $this->topicID);
			$this->forumID = $res[0]['forumid'];										//attn: $forumID is re-set
			$GLOBALS['TOPICNAME'] = htmlspecialchars(stripslashes($res[0]['description']));
		}

		$res = $this->query->select("SELECT name, usehtml, useybb FROM " . $this->table_forum . " WHERE id = " . $this->forumID);
		if ($this->query->rows != 1)
			sendError("ue: UH-OH2!" . $this->forumID);
		$GLOBALS['FORUMNAME'] = htmlspecialchars($res[0]['name'] = stripslashes($res[0]['name']));
		$GLOBALS['USEHTML'] = $res[0]['usehtml'];
		$GLOBALS['USEYBB'] = $res[0]['useybb'];

		$GLOBALS['FIRSTPOSTINTOPIC'] = ($this->replyTO == 0 && $this->postID != 0);
		$GLOBALS['REMOTE_ADDR'] = getenv("REMOTE_ADDR");

		$GLOBALS['POSTPOSTERID'] = $this->userID;
		$GLOBALS['POSTPOSTERNICK'] = $this->authUser;
		$GLOBALS['POSTDATE'] = getDateTime($this->old_date);
		$GLOBALS['allowAnnouncements'] = $templateLoggedIn && $this->action == $this->A_DOTOPIC && $this->authGroup > 1;

		$GLOBALS['TOPICLOCKED'] = !$this->topicActive && !$this->isAuth();
		if ($GLOBALS["ERRORMSG"] == "" && $GLOBALS['TOPICLOCKED'])
		{
			$GLOBALS['ERRORMSG'] = $lang['editLocked'];
			$GLOBALS['SHOWFORM'] = false;
		}
		else
			$GLOBALS['SHOWFORM'] = true;
		$GLOBALS['ERRORMSG'] = htmlspecialchars($GLOBALS['ERRORMSG']);

//=====================================================================================================================
// Not ready yet! - Show the thread below this box, so users can actually see what they're replying to
//=====================================================================================================================



//=====================================================================================================================
// Determine page title/URL to return to
//=====================================================================================================================
		if ($GLOBALS['DOPOST'])
			$GLOBALS['PAGE_TITLE'] = $lang['postMessage'];
		if ($GLOBALS['EDITPOST'])
			$GLOBALS['PAGE_TITLE'] = $lang['editMessage'];
		if ($GLOBALS['DOTOPIC'])
			$GLOBALS['PAGE_TITLE'] = $lang['postTopic'];
		$GLOBALS['BACKURL'] = $this->BACKURL;
		$GLOBALS['PAGE_TITLE'] = htmlspecialchars($GLOBALS['PAGE_TITLE']);

//=====================================================================================================================
// Process text
//=====================================================================================================================
		if (!empty($this->text))					// case: we entered the text and a faulty password or something
		{
			$GLOBALS["text"] = stripslashes($this->text);
		}
		else
		{
			if ($this->action == $this->A_EDITPOST || $this->action == $this->A_DOREPLY) //(isset($postRes['text']))
			{
	////			$postRes[0]['text'] = stripslashes($postRes[0]['text']);
	//			$postRes[0]['text'] = eregi_replace("<(/)?textarea>", "< \\1textarea>", $postRes[0]['text']);	//hack protection
				// will be handled below (htmlentities)
			}

			if ($this->action == $this->A_EDITPOST)											//empty for new posts, original text when editing, else contains text of 'parent'
				$GLOBALS["text"] = $this->old_text;
			elseif ($this->action == $this->A_DOREPLY) //($postID == 0 && $replyTO > 0 && isset($postRes))	//this is a reply, so add original text
			{
				$text = trim($this->old_text);
				$text = preg_replace("!\[quote\](.*)\[/quote\]!Uis", "[...]\n", $text);	//filter out previous quotes
				$text = preg_replace("!\[img\](.*)\[/img\]!Uis", "[url=\\1]\\1[/url]\n", $text);	//filter out previous images

				$GLOBALS["text"] = "[quote][b]" . ucfirst($lang['on']) . " " . $GLOBALS['POSTDATE'] . " " . $this->old_authUser . " " . $lang['wrote'] . ":[/b]\n" . $text . "\n[/quote]\n\n";
			}
		}

		if (!empty($this->topicTitle))
			$GLOBALS['topicTitle'] = htmlspecialchars(stripslashes($this->topicTitle));


//=====================================================================================================================
// Build tables with smilies to display
//=====================================================================================================================
//		$postRes[0]['iconid'] = (isset($HTTP_POST_VARS['smiley']) ? $HTTP_POST_VARS['smiley'] : $postRes[0]['iconid']);
		if ($this->posted)
			$this->old_smiley = $this->smiley;

		$smiles1 = array();
		$smiles2 = array();

		if (sizeof($smilies) == 0)
		{
			$smiles1[0]['VALUE'] = "&nbsp;";
			$smiles2[0]['VALUE'] = "";
		}
		else
		{
			for (reset($smilies), $i = 0, $teller = 0; list($key, $value) = each($smilies); $i++)
			{
				$smiles1[$i]['VALUE'] = "<input type='radio' value='$i' name='smiley' " . (($this->old_smiley == $i)?"checked":"") . ">" .
										'<img alt="' . htmlentities($key) . '" src="' . $value . '">';
				if (($i + 1) % 9 == 0) $smiles1[$i]['VALUE'] .= "<br>";

				if ($key != "")
					$smiles2[$teller++]['VALUE'] = "<td class='normalFont' valign='top' align='center'><img src='$value' alt=''><br>" . htmlentities($key) . "</td>" . ((($teller + 1) % 15 == 0)?("</tr><tr>"):"");
			}

			unset($teller);
		}

		$GLOBALS['smiles1'] = $smiles1;
		$GLOBALS['smiles2'] = $smiles2;


//=====================================================================================================================
// Retrieve subscribtion status for $sessionUserID and $topicID combination
//=====================================================================================================================
		if (!empty($this->userID) && !empty($this->topicID))
		{
			$res = $this->query->select("SELECT COUNT(*) AS count FROM " . $this->table_subscription . " WHERE userid = " . $this->userID . " AND topicid = " . $this->topicID);

			$GLOBALS['isSubscribed'] = ($res[0]['count'] == 1);
		}
		else
			$GLOBALS['isSubscribed'] = false;
		$GLOBALS['isSubscribed'] = $GLOBALS['isSubscribed'] || $this->subscribe;


//=====================================================================================================================
// Correct text. Because htmlentities (&trade;, &copy;, etc) in <textarea>s are converted,
// we have to make sure the correct text will appear
//=====================================================================================================================
		$GLOBALS['text'] = htmlentities($GLOBALS['text']);


//=====================================================================================================================
// Template stuff
//=====================================================================================================================
		if ($this->action == $this->A_DOPOST)
		{
			$this->forumID = 0;
			$this->postID = 0;
			$this->replyTO = 0;
		}
		else if ($this->action == $this->A_DOREPLY)
		{
			$this->forumID = 0;
			$this->topicID = 0;
			$this->postID = 0;
		}
		else if ($this->action == $this->A_EDITPOST)
		{
			$this->forumID = 0;
			$this->topicID = 0;
			$this->replyTO = 0;
		}
		else if ($this->action == $this->A_DOTOPIC)
		{
			$this->topicID = 0;
			$this->postID = 0;
			$this->replyTO = 0;
		}

		// 'send back' corrected values
		$GLOBALS['forumID'] = $this->forumID;
		$GLOBALS['topicID'] = $this->topicID;
		$GLOBALS['postID'] = $this->postID;
		$GLOBALS['replyTO'] = $this->replyTO;

		if (!$template->load_file($templateHandler, "$cfgTemplateDirectory$cfgTemplateName/post.ybt"))
			if (!$template->load_file($templateHandler, $cfgTemplateDirectory . "Default/post.ybt"))
				sendError("pe: Could not load template (post.ybt)!");
		$template->register($templateHandler, "ERRORMSG, forumID, topicID, postID, REMOTE_ADDR, replyTO, FORUMNAME, TOPICNAME, cfgMaxLengthNickname, cfgMaxLengthPassword, POST_LIST, POSTPOSTERID, POSTPOSTERNICK, POSTDATE, BACKURL, text, topicTitle");
		$template->parse($templateHandler);
		$template->parse_loop($templateHandler, 'smiles1');
		if ($cfgProcessSmilies) $template->parse_loop($templateHandler, 'smiles2');
		echo $template->return_file($templateHandler);
		if ($cfgUseCompression) gzdocout();

		require($cfgIncludeDirectory . "cleanup.php");
		exit;
	} // end func showInputForm
} // end class Post


//=====================================================================================================================
// GO!
//=====================================================================================================================
$post = new Post();

?>
