<?php require("./config.inc.php");

/*

YapBB, a fully functional bulletin board system
Copyright (C) 2000/01  Arno van der Kolk
http://yapbb.sourceforge.net/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

//=====================================================================================================================
// Description: this page is used to allow users to alter their profile
//=====================================================================================================================

require($cfgIncludeDirectory . "class_profiledata.php");


//=====================================================================================================================
// Check to see if user is logged in
//=====================================================================================================================
if ($loggedIn = (sess_is_registered("sessionUser") && $sessionUser != "" && sess_is_registered("sessionUserID") && $sessionUserID != 0 && sess_is_registered("sessionPass") && $sessionPass != ""))
{

//=====================================================================================================================
// Yes
//=====================================================================================================================
	$reg = new ProfileData;
	if ($submitted = !empty($HTTP_POST_VARS['accept']))							//wijzigingen zijn ingevoerd
	{

//=====================================================================================================================
// User has submitted his profile for validation
//=====================================================================================================================
		$reg->userName = trim($regUserName);
		$reg->userPass1 = trim($regUserPass1);
		$reg->userPass2 = trim($regUserPass2);
		$reg->email = strtolower($regEmail);
		$reg->ICQ = $regICQ;
		$reg->homepage = $regHomepage;
		$reg->showEmail = $regShowEmail;
		$reg->showProfile = $regShowProfile;
		$reg->location = $regLocation;
		$reg->bio = $regBio;
		$reg->signature = $regSignature;
		$reg->avatarurl = $regAvatarurl;
		$pos = strpos($reg->email, "@");


//=====================================================================================================================
// Make all kinds of validation checks
//=====================================================================================================================
		if ($reg->userName != $sessionUser && !$cfgAllowUserNickChange)
		{
			$reg->userName = $sessionUser;
			$regForm = getProfileForm($lang['errorNoNameChange'], "profile", $reg);
			$submitted = false;
			//sendError("ue: Not allowed to change nickname");
		}
		elseif ($reg->userName == "")
		{
			$reg->userName = $sessionUser;
			$regForm = getProfileForm($lang['errorNickName'], "profile", $reg);
			$submitted = false;
		}
		elseif (strlen($reg->userName) < $cfgMinLengthNickname)
		{
			$reg->userName = $sessionUser;
			$regForm = getProfileForm($lang['errorNickNameTooShort'], "profile", $reg);
			$submitted = false;
		}
		elseif (strlen($reg->userName) > $cfgMaxLengthNickname)
		{
			$reg->userName = $sessionUser;
			$regForm = getProfileForm($lang['errorNickNameTooLong'], "profile", $reg);
			$submitted = false;
		}
/*		elseif ($reg->userPass1 == "")		// leave commented: this indicates the user does not want to change the password
		{
			$regForm = getProfileForm($lang['errorPassword'], "profile", $reg);
			$submitted = false;
		}*/
		elseif ($reg->userPass1 != $sessionPass && $reg->userPass1 != $reg->userPass2)
		{
			$regForm = getProfileForm($lang['errorPasswordMatch'], "profile", $reg);
			$submitted = false;
		}
		elseif ($reg->userPass1 != "" && strlen($reg->userPass1) < $cfgMinLengthPassword)
		{
			$regForm = getProfileForm($lang['errorPasswordTooShort'], "profile", $reg);
			$submitted = false;
		}
		elseif (strlen($reg->userPass1) > $cfgMaxLengthPassword)
		{
			$regForm = getProfileForm($lang['errorPasswordTooLong'], "profile", $reg);
			$submitted = false;
		}
		elseif (!check_email($reg->email)) //(!isset($reg->email) || trim($reg->email) == "" || ($pos === FALSE || (!is_string($pos) && !$pos)))
		{
			$regForm = getProfileForm($lang['errorEmailAddress'], "profile", $reg);
			$submitted = false;
		}
		else
		{

//=====================================================================================================================
// All checks out fine
//=====================================================================================================================
			$changePassword = ($reg->userPass1 != "" && $reg->userPass1 == $reg->userPass2 && $reg->userPass1 != $sessionPass);

			if ($reg->userPass1 == "")
				$reg->userPass1 = $sessionPass;

//possibly this can use $sessionEmail
	 		$query = new MySQL;
	 		$res = $query->select("SELECT email FROM " . $cfgDatabase['user'] . " WHERE id = $sessionUserID");

	 		if ($query->rows != 1)
	 			sendError("pe: wrong user or...");


//=====================================================================================================================
// Prepare notification email info
//=====================================================================================================================
	 		$res[0]['email'] = stripslashes($res[0]['email']);
	 		if ($sendMail = ($reg->email != $res[0]['email'] || $changePassword /*$reg->userPass1 != $sessionPass*/))
	 		{
	 			//$key = randomPassword($reg->email) . randomPassword($reg->userPass1) . randomPassword($reg->userName) . randomPassword(time());
				$key = randomPassword($reg->email) . randomPassword(time());
	 			$activated = 0;
	 		}
	 		else
	 		{
	 			$key = "";
	 			$activated = 1;
	 		}


//=====================================================================================================================
// Send notification email
//=====================================================================================================================
			if ($sendMail)
				$sent = sendRegMail($reg->userName, $reg->email, $reg->userPass1, $key);
			else
				$sent = FALSE;

			if ($sent || !$sendMail)
			{
				//transform $reg object to variables
				require($cfgIncludeDirectory . "preprofile.php");


//=====================================================================================================================
// Update table
//=====================================================================================================================
		 		$query->query("UPDATE " . $cfgDatabase['user'] . " SET " .
		 			($regUserName != $sessionUser && $cfgAllowUserNickChange ?
		 				" nickname = '" . addslashes($regUserName) . "' ,":
		 				"") .
		 			($changePassword ?
		 				"password = '" . addslashes($regUserPass1) . "' ,":
		 				"") .
		 			" icq = '" . $regICQ . "'" .
		 			", email = '" . addslashes($regEmail) . "'" .
		 			", showemail = " . $regShowEmail .
		 			", homepage = '" . addslashes($regHomepage) . "'" .
		 			", wherefrom = '" . addslashes($regLocation) . "'" .
		 			", bio = '" . addslashes($regBio) . "'" .
		 			", signature = '" . addslashes($regSignature) . "'" .
		 			", avatarurl = '" . addslashes($regAvatarurl) . "'" .
		 			", displayprofile = '" . $regShowProfile . "'" .
		 			", activated = $activated" .
//		 			", activated = 1" .
		 			", activationkey = '$key'" .
		 			" WHERE id = $sessionUserID");


//=====================================================================================================================
// Re-register the user info
//=====================================================================================================================
				$ug = $sessionUserGroup;
				$id = $sessionUserID;
				logout_user();

				if (!($sent && $sendMail))	// in case email could not be sent or no email was to be sent, re-login
				{
					$sessionUser = $regUserName;
					$sessionPass = $regUserPass1;
					$sessionUserEmail = $regEmail;
					$sessionUserGroup = $ug;
					$sessionUserID = $id;
					$HTTP_COOKIE_VARS[$cfgCookiePrefix . "persistent"] = "";
					login_user();
				}	// else, remain logged out
			}


//=====================================================================================================================
// Errors:
//=====================================================================================================================
		 	elseif (!$sent && $sendMail)
		 		$errorEmail = true;
		 	else
		 		sendError("pe: unexp");
		}
	}
	else
	{


//=====================================================================================================================
// Retrieve user's profile
//=====================================================================================================================
		$query = new MySQL;
		$res = $query->select("SELECT * FROM " . $cfgDatabase['user'] . " WHERE id = $sessionUserID");
		if ($query->rows != 1)
			sendError("pe: Wat een ongeloveloze faut!");
		$reg->userName = stripslashes($res[0]['nickname']);
		$reg->userPass = ROT13(stripslashes($res[0]['password']));
		$reg->email = stripslashes($res[0]['email']);
		$reg->ICQ = $res[0]['icq'];
		$reg->homepage = stripslashes($res[0]['homepage']);
		$reg->showEmail = $res[0]['showemail'];
		$reg->showProfile = $res[0]['displayprofile'];
		$reg->location = stripslashes($res[0]['wherefrom']);
		$reg->bio = stripslashes($res[0]['bio']);
		$reg->signature = stripslashes($res[0]['signature']);
		$reg->avatarurl = stripslashes($res[0]['avatarurl']);

		$msg = "Remember that if you change your email address, or alter your password<br>
		(which requires you to fill in the 2nd password field),<br>
		you will be required to re-activate your account.<br>
		The new activation code will then be emailed to you automatically.";
		$regForm = getProfileForm($msg, "profile", $reg);
	}
	$template->register($templateHandler, "regForm");
}
else
{
//=====================================================================================================================
// No, user has not logged in
//=====================================================================================================================
}


//=====================================================================================================================
// Template stuff
//=====================================================================================================================
if (!$template->load_file($templateHandler, "$cfgTemplateDirectory$cfgTemplateName/profile.ybt"))
	if (!$template->load_file($templateHandler, $cfgTemplateDirectory . "Default/profile.ybt"))
		sendError("pe: Could not load template (profile.ybt)!");

echo $template->pget($templateHandler);

if ($cfgUseCompression) gzdocout();

require($cfgIncludeDirectory . "cleanup.php");
?>
