<?php require("./config.inc.php");

/*

YapBB, a fully functional bulletin board system
Copyright (C) 2000/01  Arno van der Kolk
http://yapbb.sourceforge.net/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

//=====================================================================================================================
// Description: users register an account through this page
//=====================================================================================================================

require($cfgIncludeDirectory . "class_profiledata.php");


//=====================================================================================================================
// Returns a 'dataobject' containing all information
//=====================================================================================================================
function getDataObject()
{
	global $regUserPass1, $regUserPass2, $regUserName, $regEmail, $regICQ, $regHomepage, $regShowEmail, $regShowProfile, $regLocation, $regBio, $regSignature, $regAvatarurl;
	$reg = new ProfileData;
	$reg->userPass1 = $regUserPass1;
	$reg->userPass2 = $regUserPass2;
	$reg->userName = $regUserName;
	$reg->email = $regEmail;
	$reg->ICQ = $regICQ;
	$reg->homepage = $regHomepage;
	$reg->showEmail = $regShowEmail;
	$reg->showProfile = $regShowProfile;
	$reg->location = $regLocation;
	$reg->bio = $regBio;
	$reg->signature = $regSignature;
	$reg->avatarurl = $regAvatarurl;
	return $reg;
}


//=====================================================================================================================
// Calculate which page to display
//=====================================================================================================================
$step2 = $step == 2;									// user has accepted terms
$step3 = $step == 3;									// user has finished entering info
$step1 = $step == 1 || (!$step2 && !$step3 && !$step3);	// user has arrived on the page
$stepback = ($step != 1 && $step != 2 && $step != 3);	// user has pressed cancel

if ($stepBack)
{
	//nothing
}
else if ($step1)
{
//=====================================================================================================================
// User arrives to register
//=====================================================================================================================
}
else if ($step2)
{
//=====================================================================================================================
// User has accepted terms
//=====================================================================================================================
	$regShowEmail = 1;
	$regShowProfile = 1;
	$regUserPass = "";
	$regForm = getProfileForm("", "register", getDataObject());
	$template->register($templateHandler, "regForm");
}
else if ($step3)
{
//=====================================================================================================================
// User has submitted his info
//=====================================================================================================================
	$regUserName = trim($regUserName);
	$regEmail = strtolower($regEmail);
	$pos = strpos($regEmail, "@");
	$exist = 0;
	$query = new MySQL;

//=====================================================================================================================
// Validate user
//=====================================================================================================================
	$res = $query->select("SELECT nickname, email FROM " . $cfgDatabase['user'] . " WHERE nickname = '" . addslashes($regUserName) . "' OR email = '" . addslashes($regEmail) . "'");
	for ($i = 0; $i < $query->rows; $i++)
	{
		$res[$i]['nickname'] = stripslashes($res[$i]['nickname']);
		$res[$i]['email'] = stripslashes($res[$i]['email']);

		if ($cfgIgnoreNicknameCase)
			$condition = $res[$i]['nickname'] == $regUserName;
		else
			$condition = strtolower($res[$i]['nickname']) == strtolower($regUserName);

		if ($condition)
		{
			$exist = 1;
			break;
		}
		elseif ($res[$i]['email'] == $regEmail)
		{
			$exist = 2;
			break;
		}
		unset($condition);
	}
	$res = $query->query("SELECT host FROM " . $cfgDatabase['bannedemail'] . " WHERE '" . addslashes(substr($regEmail, $pos + 1)) . "' LIKE host");

//=====================================================================================================================
// Make all kinds of validation checks
//=====================================================================================================================
	if ($query->rows > 0)
	{
		$regForm = getProfileForm($lang['errorEmailDomain'], "register", getDataObject());
		$step3 = false;
		$step2 = true;
	}
	elseif ($regUserName == "")
	{
		$regForm = getProfileForm($lang['errorLoginName'], "register", getDataObject());
		$step3 = false;
		$step2 = true;
	}
	elseif (strlen($regUserName) < $cfgMinLengthNickname)
	{
		$regForm = getProfileForm($lang['errorLoginNameTooShort'], "register", getDataObject());
		$step3 = false;
		$step2 = true;
	}
	elseif (strlen($regUserName) > $cfgMaxLengthNickname)
	{
		$regForm = getProfileForm($lang['errorLoginNameTooLong'], "register", getDataObject());
		$step3 = false;
		$step2 = true;
	}
	elseif ($exist == 1)
	{
		$regForm = getProfileForm($lang['errorUserExists'], "register", getDataObject());
		$step3 = false;
		$step2 = true;
	}
	elseif ($exist == 2)
	{
		$regForm = getProfileForm($lang['errorEmailExists'], "register", getDataObject());
		$step3 = false;
		$step2 = true;
	}
	elseif ($regUserPass1 == "")
	{
		$regForm = getProfileForm($lang['errorPassword'], "register", getDataObject());
		$step3 = false;
		$step2 = true;
	}
	elseif ($regUserPass1 != $regUserPass2)
	{
		$regForm = getProfileForm($lang['errorPasswordMatch'], "register", getDataObject());
		$step3 = false;
		$step2 = true;
	}
	elseif (strlen($regUserPass1) < $cfgMinLengthPassword)
	{
		$regForm = getProfileForm($lang['errorPasswordTooShort'], "register", getDataObject());
		$step3 = false;
		$step2 = true;
	}
	elseif (strlen($regUserPass1) > $cfgMaxLengthPassword)
	{
		$regForm = getProfileForm($lang['errorPasswordTooLong'], "register", getDataObject());
		$step3 = false;
		$step2 = true;
	}
	elseif (!check_email($regEmail)) //(!isset($regEmail) || $regEmail == "" || ($pos === FALSE || (!is_string($pos) && !$pos)))
	{
		$regForm = getProfileForm($lang['errorEmailAddress'], "register", getDataObject());
		$step3 = false;
		$step2 = true;
	}
	else
	{
//=====================================================================================================================
// Everything is fine now, proceed
//=====================================================================================================================
		//$key = randomPassword($regEmail) . randomPassword($regUserPass1) . randomPassword($regUserName) . randomPassword(time());
		$key = randomPassword($regEmail) . randomPassword(time());

		$regmailSent = sendRegMail($regUserName, $regEmail, $regUserPass1, $key);

		$template->register($templateHandler, "regmailSent");
		if ($regmailSent)
		{
			$reg = getDataObject();									//transform $reg object to variables
			require($cfgIncludeDirectory . "preprofile.php");

	 		$query->query("INSERT INTO " . $cfgDatabase['user'] . " (id, nickname, password, icq, email, showemail, homepage, wherefrom, bio, registerdate, posts, active, notes, signature, avatarurl, groupid, displayprofile, activated, activationkey) " .
	 						"VALUES (" .
	 						"'', " .															// id
	 						"'" . addslashes($regUserName) . "', " .							// nickname
	 						"'" . addslashes($regUserPass1) . "', " .							// password
	 						"'$regICQ', " .														// icq
	 						"'" . addslashes($regEmail) . "', " .								// email
	 						"$regShowEmail, " .													// showemail
	 						"'" . addslashes($regHomepage) . "', " .							// homepage
	 						"'" . addslashes($regLocation) ."', " .								// wherefrom
	 						"'" . addslashes($regBio) . "', " .									// bio
	 						"'" . time() . "', " .												// registerdate
	 						"0, " .																// posts
	 						"1, " .																// active
	 						"'', " .															// notes
	 						"'" . addslashes($regSignature) . "', " .							// signature
	 						"'" . str_replace(" ", "%20", addslashes($regAvatarurl)) . "', " .	// avatarurl
	 						"1, " .																// groupid
	 						"$regShowProfile, " .												// displayprofile
	 						"0, " .																// activated
	 						"'" . addslashes($key) . "'" .										// activationkey
	 						")");
	 	}
//	 	else
//	 		sendError($lang['errorRegMail']);
	}
	$template->register($templateHandler, "regForm");
}
else
{
	//nothing
}


//=====================================================================================================================
// Extra validation
//=====================================================================================================================
if (!$stepBack && !$step1 && !$step2 && !$step3)
	sendError("ue: Invalid parameter");


//=====================================================================================================================
// Template stuff
//=====================================================================================================================
if (!$template->load_file($templateHandler, "$cfgTemplateDirectory$cfgTemplateName/register.ybt"))
	if (!$template->load_file($templateHandler, $cfgTemplateDirectory . "Default/register.ybt"))
		sendError("pe: Could not load template (register.ybt)!");

echo $template->pget($templateHandler);

if ($cfgUseCompression) gzdocout();

require($cfgIncludeDirectory . "cleanup.php");
?>
