<?php require("./config.inc.php");

/*

YapBB, a fully functional bulletin board system
Copyright (C) 2000/01  Arno van der Kolk
http://yapbb.sourceforge.net/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

//=====================================================================================================================
// Description: users can set their preferences with this page
//=====================================================================================================================


//=====================================================================================================================
// Initialize
//=====================================================================================================================
$time = time() + (60 * 60 * 24 * 365);
$submitted = !empty($HTTP_POST_VARS['accept']);
if ($submitted)
{

//=====================================================================================================================
//  User has submitted his settings
//=====================================================================================================================


//=====================================================================================================================
// Calculate settings
//=====================================================================================================================
	if ($topicSortWhichPost != 0 && $topicSortWhichPost != 1) $topicSortWhichPost = $cfgTopicSortWhichPost;
	if ($topicSortWhichWay != 0 && $topicSortWhichWay != 1) $topicSortWhichWay = $cfgTopicSortWhichWay;
	if ($postSortWhichWay != 0 && $postSortWhichWay != 1) $postSortWhichWay = $cfgPostSortWhichWay;
	if ($threadsPerPage < 0) $threadsPerPage = $cfgThreadsPerPage;
	if ($postsPerPage < 0) $postsPerPage = $cfgPostsPerPage;
	if ($topicsOnLastDays < 0) $topicsOnLastDays = $cfgTopicsOnLastDays;
	$refreshInterval = 60 * $refreshInterval;
	if ($refreshInterval < 0) $refreshInterval = $cfgRefreshInterval;
	if ($pageSizeInPixels != 0 && $pageSizeInPixels != 1) $pageSizeInPixels = $cfgPageSizeInPixels;
	if ($pageSizeWidth < 0) $pageSizeWidth = $cfgPageSizeWidth;
	if ($showForumDescriptions != 0 && $showForumDescriptions != 1) $showForumDescriptions = $cfgShowForumDescriptions;
	if ($announcementCount < 0) $announcementCount = $cfgAnnouncementCount;
	if ($showSignatures != 0 && $showSignatures != 1) $showSignatures = $cfgShowSignatures;
	if ($showAvatars != 0 && $showAvatars != 1) $showAvatars = $cfgShowAvatars;

	$COOKIES = array();
	$COOKIES["topicSortWhichPost"] = $topicSortWhichPost;
	$COOKIES["topicSortWhichWay"] = $topicSortWhichWay;
	$COOKIES["postSortWhichWay"] = $postSortWhichWay;
	$COOKIES["threadsPerPage"] = $threadsPerPage;
	$COOKIES["postsPerPage"] = $postsPerPage;
	$COOKIES["topicsOnLastDays"] = $topicsOnLastDays;
	$COOKIES["refreshInterval"] = $refreshInterval;
	$COOKIES["dateFormat"] = $dateFormat;
	$COOKIES["pageSizeInPixels"] = $pageSizeInPixels;
	$COOKIES["pageSizeWidth"] = $pageSizeWidth;
	$COOKIES["templateName"] = $templateName;
	$COOKIES["clientTimezone"] = $clientTimezone;
	$COOKIES["showForumDescriptions"] = $showForumDescriptions;
	$COOKIES["announcementCount"] = $announcementCount;
	$COOKIES["showSignatures"] = $showSignatures;
	$COOKIES["showAvatars"] = $showAvatars;
	setcookie($cfgCookiePrefix . "yapbbcookie", serialize($COOKIES), $time, "$cfgBaseDirectory", "", 0);
}
else
{

//=====================================================================================================================
// Retrieve default settings for display
//=====================================================================================================================
	if (!isset($COOKIES['topicSortWhichPost'])   ) $COOKIES['topicSortWhichPost']    = $cfgTopicSortWhichPost;
	if (!isset($COOKIES['topicSortWhichWay'])    ) $COOKIES['topicSortWhichWay']     = $cfgTopicSortWhichWay;
	if (!isset($COOKIES['postSortWhichWay'])     ) $COOKIES['postSortWhichWay']      = $cfgPostSortWhichWay;
	if (!isset($COOKIES['threadsPerPage'])       ) $COOKIES['threadsPerPage']        = $cfgThreadsPerPage;
	if (!isset($COOKIES['postsPerPage'])         ) $COOKIES['postsPerPage']          = $cfgPostsPerPage;
	if (!isset($COOKIES['topicsOnLastDays'])     ) $COOKIES['topicsOnLastDays']      = $cfgTopicsOnLastDays;
	if (!isset($COOKIES['refreshInterval'])      ) $COOKIES['refreshInterval']       = $cfgRefreshInterval;
	if (!isset($COOKIES['dateFormat'])           ) $COOKIES['dateFormat']            = $cfgDateFormat;
	if (!isset($COOKIES['pageSizeInPixels'])     ) $COOKIES['pageSizeInPixels']      = $cfgPageSizeInPixels;
	if (!isset($COOKIES['pageSizeWidth'])        ) $COOKIES['pageSizeWidth']         = $cfgPageSizeWidth;
	if (!isset($COOKIES['templateName'])         ) $COOKIES['templateName']          = $cfgTemplateName;
	if (!isset($COOKIES['clientTimezone'])       ) $COOKIES['clientTimezone']        = $cfgClientTimezone;
	if (!isset($COOKIES['showForumDescriptions'])) $COOKIES['showForumDescriptions'] = $cfgShowForumDescriptions;
	if (!isset($COOKIES['announcementCount'])    ) $COOKIES['announcementCount']     = $cfgAnnouncementCount;
	if (!isset($COOKIES['showSignatures'])       ) $COOKIES['showSignatures']        = $cfgShowSignatures;
	if (!isset($COOKIES['showAvatars'])          ) $COOKIES['showAvatars']           = $cfgShowAvatars;

	$cookieTopicSortWhichPost = $COOKIES['topicSortWhichPost'];
	$cookieTopicSortWhichWay = $COOKIES['topicSortWhichWay'];
	$cookiePostSortWhichWay = $COOKIES['postSortWhichWay'];
	$cookieThreadsPerPage = $COOKIES['threadsPerPage'];
	$cookiePostsPerPage = $COOKIES['postsPerPage'];
	$cookieTopicsOnLastDays = $COOKIES['topicsOnLastDays'];
	$cookieRefreshInterval = $COOKIES['refreshInterval'];
	$cookieDateFormat = $COOKIES['dateFormat'];
	$cookiePageSizeInPixels = $COOKIES['pageSizeInPixels'];
	$cookiePageSizeWidth = $COOKIES['pageSizeWidth'];
	$cookieTemplateName = $COOKIES['templateName'];
	$cookieClientTimezone = $COOKIES['clientTimezone'];
	$cookieShowForumDescriptions = $COOKIES['showForumDescriptions'];
	$cookieAnnouncementCount = $COOKIES['announcementCount'];
	$cookieShowSignatures = $COOKIES['showSignatures'];
	$cookieShowAvatars = $COOKIES['showAvatars'];
}


//=====================================================================================================================
// Template stuff
//=====================================================================================================================
if (!$template->load_file($templateHandler, "$cfgTemplateDirectory$cfgTemplateName/settings.ybt"))
	if (!$template->load_file($templateHandler, $cfgTemplateDirectory . "Default/settings.ybt"))
		sendError("pe: Could not load template (settings.ybt)!");

$cookieTopicsOnLastDays0 = ($cookieTopicsOnLastDays == 86400?"selected":"");
$cookieTopicsOnLastDays1 = ($cookieTopicsOnLastDays == 172800?"selected":"");
$cookieTopicsOnLastDays2 = ($cookieTopicsOnLastDays == 259200?"selected":"");
$cookieTopicsOnLastDays3 = ($cookieTopicsOnLastDays == 604800?"selected":"");
$cookieTopicsOnLastDays4 = ($cookieTopicsOnLastDays == 1209600?"selected":"");
$cookieTopicsOnLastDays5 = ($cookieTopicsOnLastDays == 2678400?"selected":"");
$cookieTopicsOnLastDays6 = ($cookieTopicsOnLastDays == 5356800?"selected":"");
$cookieTopicsOnLastDays7 = ($cookieTopicsOnLastDays == 8035200?"selected":"");
$cookieTopicsOnLastDays8 = ($cookieTopicsOnLastDays == 16070400?"selected":"");
$cookieTopicsOnLastDays9 = ($cookieTopicsOnLastDays == 32140800?"selected":"");
$cookieTopicsOnLastDays10 = ($cookieTopicsOnLastDays == 64281600?"selected":"");
$cookieTopicsOnLastDays11 = ($cookieTopicsOnLastDays == 0?"selected":"");

$cookieDateFormat0 = ($cookieDateFormat == "DMY"?"selected":"");
$cookieDateFormat1 = ($cookieDateFormat == "MDY"?"selected":""); 
$cookieDateFormat2 = ($cookieDateFormat == "YDM"?"selected":"");
$cookieDateFormat3 = ($cookieDateFormat == "YMD"?"selected":"");

$cookiePageSizeInPixels1 = ($cookiePageSizeInPixels == "1"?"checked":"");
$cookiePageSizeInPixels0 = ($cookiePageSizeInPixels == "0"?"checked":"");

$cookieRefreshInterval1 = $cookieRefreshInterval / 60;

$cookiePostSortWhichWay1 = ($cookiePostSortWhichWay == "1"?"checked":"");
$cookiePostSortWhichWay0 = ($cookiePostSortWhichWay == "0"?"checked":"");
$cookieTopicSortWhichWay1 = ($cookieTopicSortWhichWay == "1"?"checked":"");
$cookieTopicSortWhichWay0 = ($cookieTopicSortWhichWay == "0"?"checked":"");
$cookieTopicSortWhichPost1 = ($cookieTopicSortWhichPost == "1"?"checked":"");
$cookieTopicSortWhichPost0 = ($cookieTopicSortWhichPost == "0"?"checked":"");

$cookieShowForumDescriptions0 = ($cookieShowForumDescriptions == "1"?"checked":"");
$cookieShowForumDescriptions1 = ($cookieShowForumDescriptions == "0"?"checked":"");

$cookieShowSignatures0 = ($cookieShowSignatures == "1"?"checked":"");
$cookieShowSignatures1 = ($cookieShowSignatures == "0"?"checked":"");

$cookieShowAvatars0 = ($cookieShowAvatars == "1"?"checked":"");
$cookieShowAvatars1 = ($cookieShowAvatars == "0"?"checked":"");

$tmp = $timezone;
$tmp->setSelected($cookieClientTimezone);
$clientTimezoneList = $tmp->getList();

$templateNameList = getTemplateList();

$template->register($templateHandler, "cookieShowAvatars0, cookieShowAvatars1, cookieShowSignatures0, cookieShowSignatures1, cookieAnnouncementCount, cookieShowForumDescriptions0, cookieShowForumDescriptions1, clientTimezoneList, templateNameList, cookieThreadsPerPage, cookiePostsPerPage, cookiePageSizeWidth, cookieDateFormat0, cookieDateFormat1, cookieDateFormat2, cookieDateFormat3, cookiePageSizeInPixels1, cookiePageSizeInPixels0, cookieTopicsOnLastDays0, cookieTopicsOnLastDays1, cookieTopicsOnLastDays2, cookieTopicsOnLastDays3, cookieTopicsOnLastDays4, cookieTopicsOnLastDays5, cookieTopicsOnLastDays6, cookieTopicsOnLastDays7, cookieTopicsOnLastDays8, cookieTopicsOnLastDays9, cookieTopicsOnLastDays10, cookieTopicsOnLastDays11, cookieRefreshInterval1, cookieTopicSortWhichPost1, cookieTopicSortWhichPost0, cookieTopicSortWhichPost1, cookieTopicSortWhichPost0, cookieTopicSortWhichWay1, cookieTopicSortWhichWay0, cookiePostSortWhichView1, cookiePostSortWhichView0, cookiePostSortWhichWay1, cookiePostSortWhichWay0");
echo $template->pget($templateHandler);

if ($cfgUseCompression) gzdocout();

require($cfgIncludeDirectory . "cleanup.php");
?>
