<?php require("./config.inc.php");

/*

YapBB, a fully functional bulletin board system
Copyright (C) 2000/01  Arno van der Kolk
http://yapbb.sourceforge.net/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

//=====================================================================================================================
// Description: show the contents of a specified topic
//=====================================================================================================================


//=====================================================================================================================
// Initialize
//=====================================================================================================================
$topicID++; $topicID--;
$topicDescription = htmlspecialchars($PAGE_TITLE); // this one's set in global.php


//=====================================================================================================================
// Gather basic information on forum this topic is in
//=====================================================================================================================

$forumQuery = new MySQL;
$forRes = $forumQuery->select("SELECT f.id, f.usehtml, f.useybb, f.password, f.name FROM " . $cfgDatabase['forum'] . " AS f, " . $cfgDatabase['topic'] . " AS t WHERE f.id = t.forumid AND t.id = $topicID");
if ($forumQuery->rows != 1)
	sendError("ue: Invalid topic");
$forRes[0]['name'] = stripslashes($forRes[0]['name']);


//=====================================================================================================================
// Authenticate user
//=====================================================================================================================

$auth = getModeratorValidation($forRes[0]['id']);
$forumResultRow = $forRes[0];
require($cfgIncludeDirectory . "forumpassword.php");
unset($forumResultRow);


//=====================================================================================================================
// Validate $topicID
//=====================================================================================================================

//<!--- OLD CODE WAS HERE --->//
if ($topicID <= 0) sendError("VAUT!");
//<!--- OLD CODE WAS HERE --->//


//=====================================================================================================================
// Check if this topic is an announcement
//=====================================================================================================================

$topicQuery = new MySQL;
$topRes = $topicQuery->select("SELECT * FROM " . $cfgDatabase['announcement'] . " WHERE topicid = $topicID GROUP BY topicid");
if ($topicQuery->rows > 1) sendError("pe: Doubled");
$isAnnouncement = ($topicQuery->rows == 1);


//=====================================================================================================================
// Template stuff
//=====================================================================================================================

$loop = "msgs";
if (isset($HTTP_GET_VARS['templateName'])) $cfgTemplateName = $HTTP_GET_VARS['templateName'];
if (!$template->load_file($templateHandler, "$cfgTemplateDirectory$cfgTemplateName/postList.ybt"))
	if (!$template->load_file($templateHandler, $cfgTemplateDirectory . "Default/postList.ybt"))
		sendError("pe: Could not load template (postList.ybt)!");
$forumID = getForumID($topicID);


//=====================================================================================================================
// Rename topic (if new topic title has been submitted)
// Idea of this kewl rename function by johnny appleseed
//=====================================================================================================================

if (!empty($HTTP_POST_VARS['newTopicDescription']) && $auth)	//must be valid moderator/admin
{
	$topicDescription = $HTTP_POST_VARS['newTopicDescription'];
	$query = new MySQL();
	$query->query("UPDATE " . $cfgDatabase['topic'] . " SET description = '" . addslashes($topicDescription) .  "' WHERE id = $topicID");
	header("Location: $PHP_SELF?$QUERY_STRING");
	exit;
}


//=====================================================================================================================
// Process all posts in this topic
//=====================================================================================================================

$postQuery = new MySQL;
$postRes = $postQuery->select("SELECT p.*, u.avatarurl, u.signature, u.groupid, u.registerdate, u.posts, u.homepage, u.nickname, u.icq, u.email, u.showemail, u.displayprofile FROM " . $cfgDatabase['post'] . " AS p, " . $cfgDatabase['user'] . " AS u WHERE p.topicid = $topicID AND p.posterid = u.id ORDER BY p.date " . (($cfgPostSortWhichWay)?"DESC":"ASC"));
if ($postQuery->rows == 0)
	sendError("pe: Error - No posts!<br>Possible cause: invalid contents in " . $cfgDatabase['avatar'] . ", or<br>missing owner of post");
$reactieNr = -1;


//=====================================================================================================================
// Prepare '<< Previous' and 'Next >>' markers (if applicable)
//=====================================================================================================================

$count = $cfgPostsPerPage;													//use $count in stead of $cfgPostsPerPage
if ($count > $postQuery->rows || $count <= 0) $count = $postQuery->rows;	//checks

$tmp = $begin;
if ($tmp > $postQuery->rows || $tmp == -1) $tmp = $postQuery->rows;

$begin = 1;
if (!isset($postID))
{
	while ($begin + $count <= $tmp && $begin <= $postQuery->rows)			//get entry point
		$begin += $count;
}
else
{
	if ($postID <= 0)
		sendError("ue: Wrong postID: $postID");
	$found = FALSE;
	$begin = 1;
	for ($i = 0; !$found && $i < $postQuery->rows; $i++)					//get entry point
	{
		if ($postRes[$i]['id'] == $postID) $found = TRUE;
		if (($i + 1) % $count == 0 && $begin + $count <= $postQuery->rows)
			$begin += $count;
	}
	if ($found == FALSE) $begin = 1;
	unset($found);
}


//=====================================================================================================================
// Loop through the posts
//=====================================================================================================================

for ($teller = $begin - 1; $teller < $postQuery->rows && $teller - $begin + 1 < $count; $teller++)
{


//=====================================================================================================================
// Gather basic information
//=====================================================================================================================

	$postRes[$teller]['text'] = stripslashes($postRes[$teller]['text']);
	$postRes[$teller]['homepage'] = trim(stripslashes($postRes[$teller]['homepage']));
	$postRes[$teller]['avatarurl'] = stripslashes($postRes[$teller]['avatarurl']);
	$postRes[$teller]['email'] = stripslashes($postRes[$teller]['email']);
	$postRes[$teller]['nickname'] = stripslashes($postRes[$teller]['nickname']);
	$postRes[$teller]['signature'] = stripslashes($postRes[$teller]['signature']);

	$reactieNr++;
	${$loop}[$reactieNr]['POSTNUMBER'] = $reactieNr + 1;

// Color
	${$loop}[$reactieNr]['POSTCOLOR'] = $isActive ? $reactieNr % 2 + 1 : 1;

// User status
	switch ($postRes[$teller]['groupid'])
	{
		case 1: ${$loop}[$reactieNr]['USERCOLOR'] = "userNormal"; break;
		case 2: ${$loop}[$reactieNr]['USERCOLOR'] = "userMod"; break;
		case 3: ${$loop}[$reactieNr]['USERCOLOR'] = "userAdmin"; break;
		case 4: ${$loop}[$reactieNr]['USERCOLOR'] = "userSuper"; break;
	}

// Message icon
	$tmp = array_values($smilies);
	$tmp = $tmp[$postRes[$teller]['iconid']];
	if ($tmp == "")
	{
		reset($smilies);
		$tmp = current($smilies);
	}
	${$loop}[$reactieNr]['POSTICON'] = $tmp;

// Date of post
	${$loop}[$reactieNr]['POSTDATE'] = getDateTime($postRes[$teller]['date']);

// Profile
	${$loop}[$reactieNr]['USERDISPLAYPROFILE'] = $postRes[$teller]['displayprofile'];

// Poster ID
	${$loop}[$reactieNr]['POSTPOSTERID'] = $postRes[$teller]['posterid'];

// Email
	${$loop}[$reactieNr]['USERDISPLAYEMAIL'] = ($postRes[$teller]['displayprofile'] && $postRes[$teller]['showemail']);

// Home page
	${$loop}[$reactieNr]['USERDISPLAYHOMEPAGE'] = ($postRes[$teller]['displayprofile'] && $postRes[$teller]['homepage'] != "");
	$tmp = trim($postRes[$teller]['homepage']);
	if ($tmp != "" && !eregi("^((http(s)?|ftp)://)", $tmp)) $tmp = "http://$tmp";
	${$loop}[$reactieNr]['USERHOMEPAGE'] = $tmp;

// ICQ
	${$loop}[$reactieNr]['USERDISPLAYICQ'] = ($postRes[$teller]['displayprofile'] && $postRes[$teller]['icq'] != "" && $postRes[$teller]['icq'] > 0);
	${$loop}[$reactieNr]['USERICQ'] = $postRes[$teller]['icq'];


//=====================================================================================================================
// Work out 'Next, Prev, Edit, Top' thingie (POSTCONTROLS, per post specific)
//=====================================================================================================================

	${$loop}[$reactieNr]['POSTCONTROLSPREV'] = $reactieNr;
	${$loop}[$reactieNr]['POSTCONTROLSNEXT'] = ($reactieNr + 2);


//=====================================================================================================================
// Gather more basic information
//=====================================================================================================================

	if ($postRes[$teller]['nickname'] == $cfgAnonymousUser)
		${$loop}[$reactieNr]['USERSTATUS'] = $lang['guest'];
	else
		${$loop}[$reactieNr]['USERSTATUS'] = getUserStatus($postRes[$teller], FALSE);
	${$loop}[$reactieNr]['POSTID'] = $postRes[$teller]['id'];
	${$loop}[$reactieNr]['TOPICID'] = $postRes[$teller]['topicid'];
	${$loop}[$reactieNr]['USERREGISTERDATE'] = getDateOnly($postRes[$teller]['registerdate']);
	${$loop}[$reactieNr]['USERPOSTCOUNT'] = $postRes[$teller]['posts'];

	$query = new MySQL();
	$res = $query->select("SELECT COUNT(userid) AS count FROM " . $cfgDatabase['useronline'] . " WHERE userid = " . $postRes[$teller]['posterid']);
	${$loop}[$reactieNr]['USERISONLINE'] = $res[0]['count'] > 0;


//=====================================================================================================================
// Avatar URL's must be in this form: http://host.(subdomain1.sub-domain2.)domain/any-path
//=====================================================================================================================

	if ($cfgShowAvatars && eregi("^http://([A-Z0-9-]+\.)+[A-Z0-9-]+/.+", $postRes[$teller]['avatarurl']))
		${$loop}[$reactieNr]['USERAVATAR'] = $postRes[$teller]['avatarurl'];
	else
		${$loop}[$reactieNr]['USERAVATAR'] = "";


//=====================================================================================================================
// Process signature
//=====================================================================================================================

	$sig = trim($postRes[$teller]['signature']);
	if ($sig != "")
	{
		$YBB = new YBBtags($sig, $smilies, $cfgImageURL);
		$YBB->parse(
			(! $cfgAllowHTMLinSignature ?								// disable html
				$YBB->OP_NOHTML
			:
				""
			) .
			($cfgProcessSmilies ?										// enable smilies
				$YBB->OP_SMILIES
			:
				""
			) .
			($forRes[0]['useybb'] ?										// simple formatting
				$YBB->OP_SIMPLE
			:
				""
			) .
			$YBB->OP_URLS .												// convert hyperlinks
			$YBB->OP_NL2BR												// line breaks
		);
		$sig = $YBB->getText();

/*	// old code:
		if (! $cfgAllowHTMLinSignature) $sig = htmlspecialchars($sig);
		if ($cfgProcessSmilies) $sig = processSmilies($sig, $cfgAllowHTMLinSignature);
		$YBB = new YBBtags($sig);
		if ($forRes[0]['useybb'])
		{
			$YBB->processSimpleFormatting();
			$YBB->processLinks();
			//$YBB->processAll();
		}
		$sig = nl2br($YBB->getText());
*/
	}

	${$loop}[$reactieNr]['USERSIGNATURE'] = $sig;
	unset($sig);


//=====================================================================================================================
// Append 'edited-note'
//=====================================================================================================================

	if ($postRes[$teller]['editorid'] > 0)					//edited post
	{
		$query = new MySQL;
		$res = $query->select("SELECT nickname FROM " . $cfgDatabase['user'] . " WHERE id = " . $postRes[$teller]['editorid']);
		if ($query->rows == 1)
		{
			${$loop}[$reactieNr]['POSTEDITNOTESUSER'] = stripslashes($res[0]['nickname']);
			${$loop}[$reactieNr]['POSTEDITNOTESDATE'] = getDateTime($postRes[$teller]['editdate']);
		}
		else
			sendError("pe: Database Integrity Error! " . $postRes[$teller]['editorid']);
		unset($query);
		unset($res);
	}

	${$loop}[$reactieNr]['POSTEDITNOTESEDITED'] = ($postRes[$teller]['editorid'] > 0);


//=====================================================================================================================
// Process actual post text
//=====================================================================================================================

	$text = trim($postRes[$teller]['text']);
/*
	if (!$forRes[0]['usehtml'] || !$postRes[$teller]['usehtml'])	//no html
	{
		$text = htmlspecialchars($text);
	}
//	elseif (($forRes[0]['usehtml'] || !$postRes[$teller]['usehtml']) && !$cfgAllowDangerousHTML)
//	{
//		$text = htmlspecialchars($text);
//		$text = str_replace("&amp;", "&", $text);
//		$text = eregi_replace("&lt;img", "<img", $text);
//		$text = eregi_replace("&lt;hr", "<hr", $text);
//		$text = eregi_replace("&lt;a", "<a", $text);
//		$text = eregi_replace("&lt;b", "<b", $text);
//		$text = eregi_replace("&lt;u", "<u", $text);
//		$text = eregi_replace("&lt;i", "<i", $text);
//	}
	elseif (!$cfgAllowDangerousHTML)								//html on, but use safety
	{
		$text = str_replace("<!--", "&lt;!--", $text);
		$text = str_replace("-->", "--&gt;", $text);
		$text = preg_replace("!<((/)?((td|tr|table|th|script|div|meta|xmp|html|body|head|textarea)( .*)?)|([A-Z]+.*style=.*))>!Ui", "&lt;\\1&gt;", $text);
	}

	if ($cfgProcessSmilies && $postRes[$teller]['usesmilies'])			//process smilies
		$text = processSmilies($text, $forRes[0]['usehtml'] && $postRes[$teller]['usehtml']);	//specify whether or not to convert the < and > in smiley codes

	if ($forRes[0]['useybb'] && $postRes[$teller]['useybb'])		//process YBB
	{
		$YBB = new YBBtags($text);
		$text = $YBB->pgetText();
	}
	else
		$text = nl2br($text);
	$text = str_replace("{USERNICKNAME}", $postRes[$teller]['nickname'], $text);
*/

//////////////// NEW

	$YBB = new YBBtags($text, $smilies, $cfgImageURL, $sessionUser);
	$YBB->parse(
		( !$forRes[0]['usehtml'] || !$postRes[$teller]['usehtml'] ?							// completely disable HTML
			$YBB->OP_NOHTML
		:
			($cfgAllowDangerousHTML ?
				$YBB->OP_SAFEHTML															// only disable unsafe HTML
			:
				""																			// full HTML enabled
			)
		) .
		( $cfgProcessSmilies && $postRes[$teller]['usesmilies'] ?							// process smilies
			$YBB->OP_SMILIES
		:
			""
		) .
		( $forRes[0]['useybb'] && $postRes[$teller]['useybb'] ?								// process ybb
			$YBB->OP_CODE .
//			($PHPVer->compare(new PHPVer("4.0.0")) == 1 ? $YBB->OP_PHP : "") .				// only enable syntax highlighting in PHP4+
			(floor(phpversion()) > 3 ? $YBB->OP_PHP : "") .									// only enable syntax highlighting in PHP4+
			$YBB->OP_QUOTE .
			$YBB->OP_LIST .
			$YBB->OP_SIMPLE .
			$YBB->OP_REVERSE .
			($sessionUserGroup > 1 ? $YBB->OP_APPEARANCE : "") .							// moderators get to use color/size markup
			$YBB->OP_URLS .
			$YBB->OP_MISC .
			$YBB->OP_PERSONAL .
			$YBB->OP_IMAGES
		:
			""
		) .
		$YBB->OP_NBSP .																		// always convert spaces & tabs to &nbsp;
		$YBB->OP_NL2BR																		// always line breaks
	);
	$text = $YBB->getText();

//////////////// NEW

	$text = eregi_replace("(\{)(([A-Z0-9]|_)+)(\})", "&#123;\\2&#125;", $text);				// shield template engine markers

	${$loop}[$reactieNr]['USERNICKNAME'] = htmlspecialchars($postRes[$teller]['nickname']);

//=====================================================================================================================
// POSTTEXT *must* be the last field in the array (for proper processing by the template engine)
//=====================================================================================================================

	${$loop}[$reactieNr]['POSTTEXT'] = $text;
}


//=====================================================================================================================
// Update views counter
//=====================================================================================================================

if ($cfgCountViews)
{
	$teller = new MySQL;
	$teller->query("UPDATE " . $cfgDatabase['topic'] . " SET views = views + 1 WHERE id = $topicID");
	unset($teller);
}


//=====================================================================================================================
// Build '<< Previous' and 'Next >>' markers (if applicable)
//=====================================================================================================================

//$POST_NAVIGATION .= "<option value='0' class='empty'>" . ($postQuery->rows % $count == 0?$postQuery->rows / $count:(1 + Floor($postQuery->rows / $count))) . " " . $lang['pages'] . "</option>";
if ($areNext = ($begin + $count <= $postQuery->rows && $begin > 0))		// if there are more posts in the list (next page)
{
	$POST_NAVIGATION .= "<option value='" . ($begin + $count) . "' class='empty'>";
	$POST_NAVIGATION .= $lang['next']  . " " . $lang['page'];
	$POST_NAVIGATION .= "</option>";
}
if ($arePrev = ($begin > 1 && $begin <= $postQuery->rows))		// if there are more posts in the list (previous page)
{
	$POST_NAVIGATION .= "<option value='" . ($begin - $count) . "' class='empty'>";
	$POST_NAVIGATION .= $lang['previous']  . " " . $lang['page'];
	$POST_NAVIGATION .= "</option>";
}
if ($areNext || $arePrev)
	$POST_NAVIGATION .= "<option value='0' class='seperator'>------</option>";
$pageCounter = 0;
for ($i = 1; $i <= $postQuery->rows; $i = $i + $count)
{
	$pageCounter++;
	$POST_NAVIGATION .= "<option value='$i' class='empty'>";
	$POST_NAVIGATION .= ucfirst($lang['page']) . " " . $pageCounter;//((($i - 1) / $count) + 1);
	$POST_NAVIGATION .= "</option>";
}
if ($pageCounter == 0) $pageCounter++;
$POST_NAVIGATION = "<option value='0' class='empty'>" . ucfirst($lang['page']) . " " . ($count > 0 ? (($begin - 1) / $count) + 1 : 1) . " / $pageCounter</option>" . 
					"<option value='0' class='seperator'>------</option>" . $POST_NAVIGATION;


//=====================================================================================================================
// Template stuff
//=====================================================================================================================

if (!$template->load_file("templateControls", "$cfgTemplateDirectory$cfgTemplateName/topicControls.ybt"))
	if (!$template->load_file("templateControls", $cfgTemplateDirectory . "Default/topicControls.ybt"))
		sendError("pe: Could not load template (topicControls.ybt)!");

if (!$template->load_file("templateAdminControls", "$cfgTemplateDirectory$cfgTemplateName/topicAdminControls.ybt"))
	if (!$template->load_file("templateAdminControls", $cfgTemplateDirectory . "Default/topicAdminControls.ybt"))
		sendError("pe: Could not load template (topicAdminControls.ybt)!");

$POSTNEXTAFTERLASTREACTION = $reactieNr + 2;
$template->register($templateHandler, "topicDescription, POSTNEXTAFTERLASTREACTION, forumID, topicID, POST_NAVIGATION");
$template->parse_loop($templateHandler, $loop);
$template->parse($templateHandler);


//=====================================================================================================================
// Send output to client
//=====================================================================================================================

echo $template->return_file($templateHandler);
if ($cfgUseCompression) gzdocout();

require($cfgIncludeDirectory . "cleanup.php");
?>
