<?php require("./config.inc.php");

/*

YapBB, a fully functional bulletin board system
Copyright (C) 2000/01  Arno van der Kolk
http://yapbb.sourceforge.net/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

//=====================================================================================================================
// Description: shows the profile of a specified user
//=====================================================================================================================


//=====================================================================================================================
// Initialize
//=====================================================================================================================
$userID++; $userID--;
$userDB = new MySQL;
$usrRes = $userDB->select("SELECT u.* FROM " . $cfgDatabase['user'] . " AS u WHERE u.id = $userID");
if ($userDB->rows == 0)
	sendError("User ID ($userID) not found.");

if ($auth = $templateLoggedIn && $sessionUserGroup > 2)
{
	if (!empty($HTTP_POST_VARS['submit']))
	{
//=====================================================================================================================
// Action-branch: when user is an admin, and has submitted a form, process it now
//=====================================================================================================================
	
	
//=====================================================================================================================
// Gather info
//=====================================================================================================================
		$userid = 0 + $HTTP_POST_VARS['userID'];
		$userPosts = 0 + $HTTP_POST_VARS['modPostCount'];
		$userActive = 0 + ($HTTP_POST_VARS['modActive'] == "on");
		$userNotes = $HTTP_POST_VARS['userNotes'];
		$userGroupid = 0 + $HTTP_POST_VARS['modStatus'];
		$userShowProfile = 0 + ($HTTP_POST_VARS['modShowProfile'] == "on");
		$userEmail = $HTTP_POST_VARS['modEmail'];
		$userNickname = trim($HTTP_POST_VARS['modNickname']);
	
		$usrRes[$i]['email'] = stripslashes($usrRes[$i]['email']);
		$usrRes[$i]['bio'] = stripslashes($usrRes[$i]['bio']);
		$usrRes[$i]['homepage'] = stripslashes($usrRes[$i]['homepage']);
		$usrRes[$i]['notes'] = stripslashes($usrRes[$i]['notes']);
		$usrRes[$i]['wherefrom'] = stripslashes($usrRes[$i]['wherefrom']);
		$usrRes[$i]['signature'] = stripslashes($usrRes[$i]['signature']);
		$usrRes[$i]['nickname'] = stripslashes($usrRes[$i]['nickname']);
		$usrRes[$i]['password'] = stripslashes($usrRes[$i]['password']);
	

//=====================================================================================================================
// Checks
//=====================================================================================================================
		if ($userGroupid != $usrRes[$i]['groupid'])								//compare new value vs old one
		{
			if ($usrRes[$i]['groupid'] >= $sessionUserGroup)
				sendError("You can't alter the rank of users with higher or equal ranks.");
			else if ($userGroupid < 2)											//user is nolonger moderator, so remove him from table 'moderator'
				$userDB->query("DELETE FROM " . $cfgDatabase['moderator'] . " WHERE userid = $userid");
		}

		if ($sessionUserGroup <= 3)
		{
			if ($userGroupid >= 3 XOR $usrRes[$i]['groupid'] >= 3)	//(($userGroupid >= 3 && $usrRes[$i]['groupid'] < 3) || ($userGroupid < 3 && $usrRes[$i]['groupid'] >= 3))
				sendError("ue: Only super-users can give/take someone admin or super-user status!");
			elseif ($userGroupid >= 3)
				sendError("ue: You can't update the profile of admins or super-users!");
		}

//		if ($sessionUserID == $userid)
//			sendError("ue: You can't update your own profile!");
	
	
//=====================================================================================================================
// Execute update
//=====================================================================================================================

		$len = strlen($userNickname);

		$userDB->query(
			"UPDATE " . $cfgDatabase['user'] . " SET " .
			(check_email($userEmail) ? "email = '" . addslashes($userEmail) . "', " : "") .
			"homepage = '" . addslashes($HTTP_POST_VARS['modHomepage']) . "', " .
			"groupid = " . (empty($userGroupid) ? 1 : $userGroupid) . ", " .
			"icq = " . (0 + $HTTP_POST_VARS['modICQ']) . ", " .
			"posts = " . (0 + $HTTP_POST_VARS['modPostCount']) . ", " .
			"wherefrom = '" . addslashes($HTTP_POST_VARS['modLocation']) . "', " .
			"bio = '" . addslashes($HTTP_POST_VARS['modBio']) . "', " .
			"avatarurl = '" . addslashes($HTTP_POST_VARS['modAvatar']) . "', " .
			"active = " . (0 + $HTTP_POST_VARS['modActive']) . ", " .
			"activated = " . (0 + $HTTP_POST_VARS['modActivated']) . ", " .
			"showemail = " . (0 + $HTTP_POST_VARS['modShowEmail']) . ", " .
			"signature = '" . addslashes($HTTP_POST_VARS['modSignature']) . "', " .
			(
				$len >= $cfgMinLengthNickname && $len <= $cfgMaxLengthNickname
				?
				"nickname = '" . addslashes($userNickname) . "', "
				:
				""
			) .
			"displayprofile = " . (0 + $HTTP_POST_VARS['modShowProfile']) . ", " .
			(
				(!($HTTP_POST_VARS['modActivated']))
				?
				"activated = 0, activationkey = '" . addslashes(randomPassword($userEmail) . randomPassword(time())) . "', "
				:
				""
			) .
			"notes = '" . addslashes($HTTP_POST_VARS['modNotes']) . "' " .
			"WHERE id = $userID"
		);

		// re-retrieve all information for further processing (normal 'course')
		$usrRes = $userDB->select("SELECT u.* FROM " . $cfgDatabase['user'] . " AS u WHERE u.id = $userid");
	}

}


$USERSHOWPROFILE_ADMIN = $usrRes[0]['displayprofile'];
if ($auth)
	$usrRes[0]['displayprofile'] = TRUE;

$USERSHOWPROFILE = $usrRes[0]['displayprofile'];

$regs = "USERLASTPOSTDATE, USERLASTPOSTDESCRIPTION, USERLASTPOSTTOPICID, USERLASTPOSTPOSTID, USERAVATAR, USERNAME, loggedIn, USERID, USERREGDATE, USERSTATUS, USERPOSTCOUNT, USERLASTPOST, USERHOMEPAGE, USERICQ, USERBIO, USERWHEREFROM, USERPOSTAVERAGE";
if ($USERSHOWPROFILE)				//user wil profile wel tonen
{
//=====================================================================================================================
// User has a public profile - prep it
//=====================================================================================================================
	$usrRes[0]['nickname'] = stripslashes($usrRes[0]['nickname']);
	$usrRes[0]['email'] = stripslashes($usrRes[0]['email']);
	$usrRes[0]['homepage'] = stripslashes($usrRes[0]['homepage']);
	$usrRes[0]['wherefrom'] = stripslashes($usrRes[0]['wherefrom']);
	$usrRes[0]['bio'] = stripslashes($usrRes[0]['bio']);
	$usrRes[0]['avatarurl'] = stripslashes($usrRes[0]['avatarurl']);
	$usrRes[0]['signature'] = stripslashes($usrRes[0]['signature']);
	$usrRes[0]['notes'] = stripslashes($usrRes[0]['notes']);


//=====================================================================================================================
// Retrieve basic info
//=====================================================================================================================
	$USERNAME = htmlspecialchars($usrRes[0]['nickname']);
	$loggedIn = (sess_is_registered("sessionUserID") && $sessionUserID == $usrRes[0]['id']);
	$USERID = $usrRes[0]['id'];
	$USERREGDATE = getDateTime($usrRes[0]['registerdate']);
	if ($isAnonymous = $usrRes[0]['nickname'] == $cfgAnonymousUser)
		$USERSTATUS = $lang['guest'];
	else
		$USERSTATUS = getUserStatus($usrRes[0], TRUE);
	$USERPOSTCOUNT = $usrRes[0]['posts'];
	$USERPOSTAVERAGE = ceil($usrRes[0]['posts'] / ((time() - $usrRes[0]['registerdate']) / (60 * 60 * 24)));


//=====================================================================================================================
// Retrieve avatar
//=====================================================================================================================
	$USERAVATAR = $usrRes[0]['avatarurl'];
	$ERROR_IN_AVATAR_URL = !eregi("^http://([A-Z0-9-]+\.)+[A-Z0-9-]+/.+", $USERAVATAR);


//=====================================================================================================================
// Retrieve last post
//=====================================================================================================================
	$tmp = "";
	$db = new MySQL;
	$res = $db->select("SELECT t.description, p.id, p.topicid, p.date FROM " . $cfgDatabase['topic'] . " AS t, " . $cfgDatabase['post'] . " AS p WHERE t.id = p.topicid AND p.posterid = $userID ORDER BY p.date DESC LIMIT 1");
	if ($USERLASTPOST = $db->rows == 1)
	{
		$USERLASTPOSTDESCRIPTION = $res[0]['description'] = htmlspecialchars(stripslashes($res[0]['description']));
		$USERLASTPOSTDATE = getDateTime($res[0]['date']);
		$USERLASTPOSTPOSTID = $res[0]['id'];
		$USERLASTPOSTTOPICID = $res[0]['topicid'];
	}
	unset($db);
	unset($res);


//=====================================================================================================================
// More basic info
//=====================================================================================================================
	$USERSHOWEMAIL = $usrRes[0]['showemail'];
	//$USEREMAIL = (($cfgMaskEmail)?str_replace("@", " at ", $usrRes[0]['email']):$usrRes[0]['email']);
	if ($auth)
	{
		$USERACTIVE = $usrRes[0]['active'];
		$USERACTIVATED = $usrRes[0]['activated'];
		$USEREMAIL = htmlspecialchars($usrRes[0]['email']);
		$USERSIGNATURE = htmlspecialchars($usrRes[0]['signature']);
		$USERNOTES = htmlspecialchars($usrRes[0]['notes']);
		$userstati = array();
		for ($i = 0; $i < count($cfgStrOperator); $i++)
		{
			$userstati[$i]['text'] = htmlspecialchars($cfgStrOperator[$i]);
			$userstati[$i]['value'] = $i + 1;
			$userstati[$i]['selected'] = ($i + 1 == $usrRes[0]['groupid'] ? "selected" : "");
		}
		$regs .= ", USEREMAIL, USERSIGNATURE, USERNOTES, LASTKNOWNIP";

		$db = new MySQL();
		$res = $db->select("SELECT ip FROM " . $cfgDatabase['post'] . " WHERE posterid = $userID ORDER BY date DESC LIMIT 1");
		$LASTKNOWNIP = $res[0]['ip'];
		unset($db);
		unset($res);
	}

	$tmp = trim($usrRes[0]['homepage']);
	if ($tmp != "" && !eregi("^((http(s)?|ftp)://)", $tmp)) $tmp = "http://$tmp";
	$USERHOMEPAGE = $tmp;
	unset($tmp);

	$USERSHOWICQ = ($usrRes[0]['icq'] > 0);
	$USERICQ = $usrRes[0]['icq'];
	$USERBIO = htmlspecialchars($usrRes[0]['bio']);
	$USERWHEREFROM = htmlspecialchars($usrRes[0]['wherefrom']);
}
else
{
//=====================================================================================================================
// User's profile is hidden
//=====================================================================================================================
	//mod:mod
}


//=====================================================================================================================
// Template stuff
//=====================================================================================================================
$template->register($templateHandler, $regs);
if (!$template->load_file($templateHandler, "$cfgTemplateDirectory$cfgTemplateName/viewProfile.ybt"))
	if (!$template->load_file($templateHandler, $cfgTemplateDirectory . "Default/viewProfile.ybt"))
		sendError("pe: Could not load template (viewProfile.ybt)!");

if ($auth && is_array($userstati))
	$template->parse_loop($templateHandler, "userstati");

$template->parse($templateHandler);
$template->print_file($templateHandler);

if ($cfgUseCompression) gzdocout();

require($cfgIncludeDirectory . "cleanup.php");
?>
