<?php require("./config.inc.php");

/*

YapBB, a fully functional bulletin board system
Copyright (C) 2000/01  Sven Vintges
http://yapbb.sourceforge.net/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/*
	This is a conversion script to convert the v1.0 Database to the v1.1 Database.
*/

if (floor(phpversion()) < 4) die("<h1>This script only runs on PHP4 systems or better!</h1>");

function doNotes()
{
echo "	<h3>Notes:</h3>
	<ul>
	<li>An anonymous user account will also be created, by the name of 'Guest'.<br>
	Please edit this script file to change this name if there's already an account by that name.</li>
	<li>If something fails during this upgrade, send the FULL output text to: <a href='mailto:contact@yapbb.net'>contact@yapbb.net</a><br>
	You should then NOT attempt to re-run this script.<br>
	However, your old installation should be fine nonetheless.</li>
	<li>New fields will be added, but existing fields that were originally supposed to be added, will be left unchanged.<br>
	(As a result of a possible previous failure, this script will not try to add these fields again.)</li>
	</ul>
	";
}

function conditionalAddField($table, $field, $query)
{
	global $cfgDatabaseDatabase, $convertQuery;
	$fields = mysql_list_fields($cfgDatabaseDatabase, $table);
	$columns = mysql_num_fields($fields);
	$found = false;
	for ($i = 0; $i < $columns && !$found; $i++)
		if (strtoupper(mysql_field_name($fields, $i)) == strtoupper($field))
			$found =  TRUE;
	if (!$found)
		$convertQuery->query("ALTER TABLE ".$table." ADD ".$field." ".$query);
}

?>
<HTML>
<HEAD>
<meta name="MSSmartTagsPreventParsing" content="TRUE">
<TITLE>
YapBB v 1.1 Conversion script......
</TITLE>
</HEAD>
<BODY>
<?
if (empty($HTTP_POST_VARS['administratorName']) || empty($HTTP_POST_VARS['submitted']))
{
	?>
	<h1>Welcome!</h1>
	<p>
	<tt><b>The existing YapBB 1.0x tables will be updated, no information will be lost.<br>
	However, do make sure you have a proper backup of your data.<br>
	We are not responsible for any loss of information.<br></b></tt>
	</p>
<?
	if ((isset($HTTP_POST_VARS) || !empty($HTTP_POST_VARS)) && strtoupper($REQUEST_METHOD) == "POST")
	{
		echo '<hr><h2>Error</h2><p>You must specify all the required information!</p><hr>';
	}
?>
	<hr>
	<form method="post" action="<?php echo $PHP_SELF; ?>">
	<h2>Specify names for new tables:</h2>
	<small>Leave any of these fields empty to not create the respective tables. This option exists for those installations that already have these tables.<br>
	Note that you in fact *MUST HAVE* these tables for YapBB to work.</small>
	<p>
	Database to use: <?php echo $cfgDatabaseDatabase; ?><br>
	Session table: <input type="text" name="databaseSession" value="forum_session"> (session support)<br>
	User_vars table: <input type="text" name="databaseUser_vars" value="forum_user_vars"> (session support)<br>
	Announcement table: <input type="text" name="databaseAnnouncement" value="forum_announcement"><br>
	<h2>Warning: existing tables with these specified names WILL BE DELETED!</h2>
	</p>
	<hr>
	<h2>Administrator:</h2>
	<p>
	Enter the name of the administrator account: <input type="text" name="administratorName"><br>
	<small>All administrator accounts except for the specified account are converted to 'global moderator'.<br>
	Use this account to access the members list and promote other users back to administrator.</small>
	</p>
	<hr>
	<h2>Options</h2>
	<p>
	Check this box to clear the 'banned email' table: <input type="checkbox" checked name="clearBannedemail"><br>
	<small>As of yet there is no management system for this feature, so there's no point in having any entries.<br>
	You may also remove these entries manually through e.g. phpMyAdmin.</small>
	</p>
	<input type="submit" name="submitted" value="Submit">
	<input type="reset" value="Reset to defaults"><br>
	</form>
	<hr>
	<?
	doNotes();
}
else
{
	doNotes();
	echo "<hr>";
	// in YapBB 1.0, there was no means of specifying table names, therefore this code is solely for 1.0 versions

	if (empty($cfgDatabaseAvatar)) $cfgDatabaseAvatar = "avatar";
	if (empty($cfgDatabaseCategory)) $cfgDatabaseCategory = "category";
	if (empty($cfgDatabaseForum)) $cfgDatabaseForum = "forum";
	if (empty($cfgDatabaseIpban)) $cfgDatabaseIpban = "ipban";
	if (empty($cfgDatabaseModerator)) $cfgDatabaseModerator = "moderator";
	if (empty($cfgDatabasePost)) $cfgDatabasePost = "post";
	if (empty($cfgDatabaseStatus)) $cfgDatabaseStatus = "status";
	if (empty($cfgDatabaseTopic)) $cfgDatabaseTopic = "topic";
	if (empty($cfgDatabaseUser)) $cfgDatabaseUser = "user";
	if (empty($cfgDatabaseUseronline)) $cfgDatabaseUseronline = "useronline";
	if (empty($cfgDatabaseBannedemail)) $cfgDatabaseBannedemail = "bannedemail";
	if (empty($cfgDatabaseSubscription)) $cfgDatabaseSubscription = "subscription";

	// end

	flush();

	$convertQuery = new MySQLQuery;
	$convertQuery->query("SELECT id FROM ".$cfgDatabaseUser." WHERE nickname = '" . addslashes($HTTP_POST_VARS['administratorName']) . "' AND groupid = 3");
	if ($convertQuery->rows != 1)
		die("<h2>Ambiguous username (" . $HTTP_POST_VARS['administratorName'] . ") or is not an administrator!</h2>");

	$convertQuery->query("ALTER TABLE ".$cfgDatabaseAvatar." CHANGE id id SMALLINT (6) DEFAULT '0' not null AUTO_INCREMENT");
	$convertQuery->query("ALTER TABLE ".$cfgDatabaseAvatar." CHANGE url url TEXT");
	$convertQuery->query("SELECT * FROM ".$cfgDatabaseAvatar." WHERE id = 1");
	if ($convertQuery->rows == 0)
		$convertQuery->query("INSERT INTO ".$cfgDatabaseAvatar." (id, url) VALUES (1, '')");
	else
	{
		$res = mysql_fetch_array($convertQuery->query);
		$convertQuery->query("INSERT INTO ".$cfgDatabaseAvatar." (url) VALUES ('" . $res['url'] . "')");
		$convertQuery->query("UPDATE ".$cfgDatabaseAvatar." SET url = '' WHERE id = 1");
	}
	$convertQuery->query("INSERT INTO ".$cfgDatabaseAvatar." (url) VALUES ('menm.jpg')");
	$convertQuery->query("INSERT INTO ".$cfgDatabaseAvatar." (url) VALUES ('usericon.gif')");

	?>
	AVATAR table updated...
	<br>
	<?
	flush();
			$convertQuery->query("ALTER TABLE ".$cfgDatabaseCategory." CHANGE id id smallint(9) not null AUTO_INCREMENT ");
			$convertQuery->query("ALTER TABLE ".$cfgDatabaseCategory." CHANGE Description description MEDIUMTEXT not null ");
			conditionalAddField($cfgDatabaseCategory, "position", "mediumint(9) DEFAULT '0' NOT NULL")
		?>
	CATEGORY table updated......
	<br>
	<?
	flush();
		$convertQuery->query("ALTER TABLE ".$cfgDatabaseForum." CHANGE id id mediumint(11) unsigned NOT NULL auto_INCREMENT");
		conditionalAddField($cfgDatabaseForum, "position", "mediumint(11) unsigned DEFAULT '0' NOT NULL");
		$convertQuery->query("ALTER TABLE ".$cfgDatabaseForum." CHANGE name name tinytext NOT NULL");
		$convertQuery->query("ALTER TABLE ".$cfgDatabaseForum." CHANGE category category smallint(11) unsigned DEFAULT '0' NOT NULL");
		$convertQuery->query("ALTER TABLE ".$cfgDatabaseForum." CHANGE password password tinyint(4) unsigned DEFAULT'1' NOT NULL");
		$convertQuery->query("ALTER TABLE ".$cfgDatabaseForum." CHANGE usehtml usehtml tinyint(4) unsigned DEFAULT'1' NOT NULL");
		$convertQuery->query("ALTER TABLE ".$cfgDatabaseForum." CHANGE useybb useybb tinyint(4) unsigned DEFAULT'1' NOT NULL");
	?>
	FORUM TABLE updated......
	<br>
	<?
	flush();
		$convertQuery->query("ALTER TABLE ".$cfgDatabaseIpban." CHANGE id id mediumint(20) unsigned NOT NULL Auto_Increment");
		$convertQuery->query("ALTER TABLE ".$cfgDatabaseIpban." CHANGE ip ip tinytext NOT NULL");
	?>
	IPBAN Table updated......
	<br>
	<?
	flush();
		$convertQuery->query("ALTER TABLE ".$cfgDatabaseModerator." CHANGE forumid forumid mediumint(20) DEFAULT '0' NOT NULL");
		$convertQuery->query("ALTER TABLE ".$cfgDatabaseModerator." CHANGE userid userid int(20) DEFAULT '0' NOT NULL");
	?>
	MODERATOR Table Updated.....
	<br>
	<?
	flush();
		$convertQuery->query("ALTER TABLE ".$cfgDatabasePost." CHANGE id id bigint(20) unsigned NOT NULL auto_increment");
		$convertQuery->query("ALTER TABLE ".$cfgDatabasePost." CHANGE topicid topicid int(20) unsigned DEFAULT '0' NOT NULL");
		$convertQuery->query("ALTER TABLE ".$cfgDatabasePost." CHANGE posterid posterid int(20) DEFAULT '0' NOT NULL");
		$convertQuery->query("ALTER TABLE ".$cfgDatabasePost." CHANGE ip ip tinytext");
		$convertQuery->query("ALTER TABLE ".$cfgDatabasePost." CHANGE editorid editorid int(20) unsigned DEFAULT '0' NOT NULL");
		conditionalAddField($cfgDatabasePost, "usesmilies", "tinyint(4) DEFAULT '1' NOT NULL");
		conditionalAddField($cfgDatabasePost, "usehtml", "tinyint(4) DEFAULT '1' NOT NULL");
		conditionalAddField($cfgDatabasePost, "useybb", "tinyint(4) DEFAULT '1' NOT NULL");
	?>
	POST Table updated......
	<br>
	<?
	if (!empty($HTTP_POST_VARS['databaseSession'])) {
		flush();
		$convertQuery->query("DROP TABLE IF EXISTS " . $HTTP_POST_VARS['databaseSession']);
		$convertQuery->query("CREATE TABLE " . $HTTP_POST_VARS['databaseSession'] . " ( id char(20) NOT NULL, lastAction datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
													ip char(15) NOT NULL, userID mediumint(9), PRIMARY KEY (id), KEY id (id), UNIQUE id_2 (id))");

	?>
		SESSION TABLE added name: session
		<br>
	<?
		flush();
	}
		$convertQuery->query("ALTER TABLE ".$cfgDatabaseStatus." CHANGE id id smallint(11) unsigned NOT NULL auto_increment");
		$convertQuery->query("ALTER TABLE ".$cfgDatabaseStatus." CHANGE description description text NOT NULL");
		$convertQuery->query("ALTER TABLE ".$cfgDatabaseStatus." CHANGE requirements requirements mediumint(20) DEFAULT '0'NOT NULL");

	?>
	Status Table updated.....
	<br>
	<?
	flush();
		$convertQuery->query("ALTER TABLE ".$cfgDatabaseTopic." CHANGE id id bigint(20) unsigned NOT NULL auto_increment");
		$convertQuery->query("ALTER TABLE ".$cfgDatabaseTopic." CHANGE description description text NOT NULL");
		$convertQuery->query("ALTER TABLE ".$cfgDatabaseTopic." CHANGE forumid forumid mediumint(20) unsigned DEFAULT '0' NOT NULL");


	?>
	Topic table updated......
	<br>
	<?
	if (!empty($HTTP_POST_VARS['databaseAnnouncement'])) {
		flush();
		$convertQuery->query("DROP TABLE IF EXISTS " . $HTTP_POST_VARS['databaseAnnouncement']);
		$convertQuery->query("CREATE TABLE " . $HTTP_POST_VARS['databaseAnnouncement'] . " (
	   topicid int(10) unsigned DEFAULT '0' NOT NULL,
	   sticky tinyint(4) DEFAULT '0' NOT NULL,
	   PRIMARY KEY (topicid),
	   KEY topicid (topicid),
	   UNIQUE topicid_2 (topicid)
	);");

	?>
		TABLE ADDED NAME: announcement
		<br>
	<?
		flush();
	}
		$convertQuery->query("ALTER TABLE ".$cfgDatabaseUser." CHANGE nickname nickname tinyText NOT NULL");
		$convertQuery->query("ALTER TABLE ".$cfgDatabaseUser." CHANGE password password tinyText NOT NULL");
		$convertQuery->query("ALTER TABLE ".$cfgDatabaseUser." CHANGE icq icq int(20) unsigned DEFAULT '0' NOT NULL");
		$convertQuery->query("ALTER TABLE ".$cfgDatabaseUser." CHANGE email email tinytext NOT NULL");
		$convertQuery->query("ALTER TABLE ".$cfgDatabaseUser." CHANGE homepage homepage text NOT NULL");
		$convertQuery->query("ALTER TABLE ".$cfgDatabaseUser." CHANGE posts posts mediumint(20) unsigned DEFAULT '0' NOT NULL");
		$convertQuery->query("ALTER TABLE ".$cfgDatabaseUser." CHANGE signature signature tinytext NOT NULL");
		$convertQuery->query("ALTER TABLE ".$cfgDatabaseUser." CHANGE avatarid avatarid smallint(4) unsigned DEFAULT '1' NOT NULL");
		conditionalAddField($cfgDatabaseUser, "activated", "tinyint(4) DEFAULT '0' NOT NULL");
		conditionalAddField($cfgDatabaseUser, "activationkey", "tinytext NOT NULL");
		$convertQuery->query("UPDATE ".$cfgDatabaseUser." SET avatarid = 1, activated = 1");
		$convertQuery->query("UPDATE ".$cfgDatabaseUser." SET groupid = 4 WHERE nickname = '" . addslashes($HTTP_POST_VARS['administratorName']) . "'");
		$convertQuery->query("INSERT INTO ".$cfgDatabaseUser." (password, nickname, avatarid, activated, active, signature, displayprofile, showemail, groupid, notes) VALUES ('', 'Guest', 1, 1, 1, 'Want your own account? [url=register.php]Register![/url]', 0, 0, 1, 'Anonymous user account: it has NO password!')");
	?>
	User table updated
	<br>
	<?
	if (!empty($HTTP_POST_VARS['databaseUser_vars'])) {
		flush();
		$convertQuery->query("DROP TABLE IF EXISTS " . $HTTP_POST_VARS['databaseUser_vars']);
		$convertQuery->query("CREATE TABLE " . $HTTP_POST_VARS['databaseUser_vars'] . " (name varchar(30) NOT NULL,
													session varchar(20) NOT NULL, intval int(10) unsigned, strval varchar(100),
													id mediumint(8) unsigned NOT NULL auto_increment, PRIMARY KEY(id), KEY sessionID(session), UNIQUE id (id))");
	?>
		TABLE ADDED NAME: user_vars
		<br>
	<?
	}
	if ($HTTP_POST_VARS['clearBannedemail']) {
		flush();
			$convertQuery->query("DELETE FROM ".$cfgDatabaseBannedemail);
		?>
		TABLE bannedemail cleared.....
		<br>
		<?
	}
	flush();
		$convertQuery->query("ALTER TABLE ".$cfgDatabaseUseronline." CHANGE userid userid int(20) unsigned DEFAULT '0' NOT NULL");
		conditionalAddField($cfgDatabaseUseronline, "ip", "TEXT not null");

	?>
	Useronline table updated.....
	<br>
	<?
	flush();
		$convertQuery->query("ALTER TABLE ".$cfgDatabaseBannedemail." CHANGE host host tinytext NOT NULL");

	?>
	BannedEmail table updated.....
	<br>
	<hr>
	All done.
	<br>
	<br>
	<p><b>The conversion script will now try to delete itself. If this fails, you must manually delete this file.<br>
	Leaving it visible on the webserver is a very bad idea, as it might be abused by visitors.</b></p>
<?
	$tmp = getenv("PATH_TRANSLATED");
	if ($tmp == "")
		$tmp = $HTTP_SERVER_VARS["PATH_TRANSLATED"];
	if ($tmp == "" || !unlink($tmp))
		echo "<p><b>WARNING: DELETION FAILED! YOU MUST DELETE THIS FILE MANUALLY!</b></p>";
	else
		echo "<p><b>Delete of file '$tmp' succeeded.</b></p>";
}
?>
</BODY>

</HTML>

