<?php require("./config.inc.php");

/*

YapBB, a fully functional bulletin board system
Copyright (C) 2000/01  Arno van der Kolk
http://yapbb.sourceforge.net/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/*
	This is a conversion script to convert the v1.1 Database to the v1.2 Database.
*/

//if (floor(phpversion()) < 4) die("<h1>This script only runs on PHP4 systems or better!</h1>");

function doNotes()
{
echo "	<h3>Notes: (must read)</h3>
	<ul>
	<li>Before running this script, please copy the new files from the zip file into this directory, so that all required<br>
	    files are properly updated and this script can function properly. (Make sure you <b>ALSO</b> overwrite <tt>config.inc.php</tt><br>
	    and that it is properly configured afterwards.)</li>
	<li>If you are <u>upgrading</u> from YapBB 1.0 or 1.0a, you MUST first run the other conversion script (convert1011.php).<br>
	    Copy it into the same directory as this script is in and then execute it in your browser. After that has<br>
	    completed, and as mentioned at the previous pointer, you have to replace your existing files with the ones in the<br>
	    zipfile. After that, re-run this script.</li>
	<li>If something fails during this upgrade, send the FULL output text to: <a href='mailto:contact@yapbb.net'>contact@yapbb.net</a><br>
	    You should then NOT attempt to re-run this script.<br>
	    However, apart from the search capabilities, your old installation should be fine nonetheless.</li>
	<li>New fields will be added, but existing fields that were originally supposed to be added, will be left unchanged.<br>
	    (As a result of a possible previous failure, this script will not try to add these fields again.)</li>
	</ul>
	";
}

function conditionalAddField($table, $field, $query)
{
	global $cfgDatabase, $convertQuery;
	$fields = mysql_list_fields($cfgDatabase['database'], $table);
	$columns = mysql_num_fields($fields);
	$found = false;
	for ($i = 0; $i < $columns && !$found; $i++)
		if (strtoupper(mysql_field_name($fields, $i)) == strtoupper($field))
			$found =  TRUE;
	if (!$found)
		$convertQuery->query("ALTER TABLE ".$table." ADD ".$field." ".$query);
}

function conditionalDropField($table, $field)
{
	global $cfgDatabase, $convertQuery;
	$fields = mysql_list_fields($cfgDatabase['database'], $table);
	$columns = mysql_num_fields($fields);
	$found = false;
	for ($i = 0; $i < $columns && !$found; $i++)
		if (strtoupper(mysql_field_name($fields, $i)) == strtoupper($field))
			$found =  TRUE;
	if ($found)
		$convertQuery->query("ALTER TABLE ".$table." DROP ".$field);
}

?>
<HTML>
<HEAD>
<meta name="MSSmartTagsPreventParsing" content="TRUE">
<TITLE>
YapBB v 1.2 Conversion script......
</TITLE>
</HEAD>
<BODY>
<font face="arial, verdana">
<?

if ($importOK = function_exists("set_time_limit") && !get_cfg_var('safe_mode'))
	set_time_limit(0);
else
	echo "<tt><b><u>Warning</u></b>: It is not recommended to import your current database into the search index as
	I was unable to disable PHP's timeout function. The import can take very long and your script may timout
	before the conversion has completed.</tt><hr>";

if (empty($HTTP_POST_VARS['submitted']))
{
	?>
	<h1>Welcome!</h1>
	<p>
	<tt><b>The existing YapBB 1.1 tables will be updated, no information will be lost.<br>
	However, do make sure you have a proper backup of your data.<br>
	We are not responsible for any loss of information.<br></b></tt>
	</p>
<?
	doNotes();
	if ((isset($HTTP_POST_VARS) || !empty($HTTP_POST_VARS)) && strtoupper($REQUEST_METHOD) == "POST")
	{
		echo '<hr><h2>Error</h2><p>You must specify all the required information!</p><hr>';
	}
?>
	<hr>
	<form method="post" action="<?php echo $PHP_SELF; ?>">
	<h2>Specify names for new tables:</h2>
	Search index table: <input type="text" value="forum_search_index" name="databaseSearch_index"><br>
	<?php
		if ($importOK)
			echo 'Import existing topics into the search index: <input type="checkbox" value="on" checked name="importIndex"><br><small>(This can also be performed later, in the control panel.)</small>';
	?>
	<h2>Warning: existing tables with the specified names WILL BE DELETED!</h2>
	If any particular field is left empty, the respective table will not be created.
	<hr>
	<input type="submit" name="submitted" value="Submit">
	<input type="reset" value="Reset to defaults"><br>
	</form>
	<hr>
	<?
}
else
{
	doNotes();
	echo "<hr>";

	// end

	flush();

	$convertQuery = new MySQL;
	conditionalAddField($cfgDatabase['user'], "avatarurl", " MEDIUMTEXT not null");
	conditionalDropField($cfgDatabase['user'], "avatarid");

	?>
	USER table updated...<BR>

	<?php
	$convertQuery->query("ALTER TABLE " . $cfgDatabase['session'] . " CHANGE id id CHAR (32) not null");
	$convertQuery->query("ALTER TABLE " . $cfgDatabase['user_vars'] . " CHANGE session session VARCHAR (32) not null");
	?>
	SESSION tables updated...<BR>

	<?php
	if (!empty($HTTP_POST_VARS['databaseSearch_index'])) {
		flush();
		$convertQuery->query("DROP TABLE IF EXISTS " . $HTTP_POST_VARS['databaseSearch_index']);
		$convertQuery->query("CREATE TABLE " . $HTTP_POST_VARS['databaseSearch_index'] . " (
							word VARCHAR(50), 
							qid INT	);");

	?>
		TABLE ADDED NAME: search_index<BR>
	<?php
		if ($importOK && $HTTP_POST_VARS['importIndex'])
		{
			$res = $convertQuery->select("SELECT text, id FROM " . $cfgDatabase['post']);
			$searcher = new Searcher();
			if (empty($cfgDatabase['search_index']))
				$cfgDatabase['search_index'] = $HTTP_POST_VARS['databaseSearch_index'];
			for ($i = 0; $i < $convertQuery->rows; $i++)
				$searcher->insert_post(stripslashes($res[$i]['text']), $res[$i]['id']);
		?>
			TABLE FILLED: search_index<BR>
		<?php
		}
	?>
		<br>
	<?
		flush();
	}
	?>
	<br>
	<hr>
	All done.<BR>
	<br>
	<br>
	<p><b>The conversion script will now try to delete itself. If this fails, you must manually delete this file.<br>
	Leaving it visible on the webserver is a very bad idea, as it might be abused by visitors.</b></p>
<?
	$tmp = getenv("PATH_TRANSLATED");
	if ($tmp == "")
		$tmp = $HTTP_SERVER_VARS["PATH_TRANSLATED"];
	if ($tmp == "" || !unlink($tmp))
		echo "<p><b>WARNING: DELETION OF THIS FILE FAILED! YOU MUST DELETE IT MANUALLY!</b></p>";
	else
		echo "<p><b>Delete of file '<tt>$tmp</tt>' succeeded.</b> - <a href='$cfgBaseURL'>Proceed to the board</a></p>";
}
?>
</font>
</BODY>

</HTML>

