<?php
  // $Id: function.pnphpbbstylesheet.php,v 1.2 2004/09/15 23:16:44 carls Exp $
  // ----------------------------------------------------------------------
  // PostNuke Content Management System
  // Copyright (C) 2002 by the PostNuke Development Team.
  // http://www.postnuke.com/
  // ----------------------------------------------------------------------
  // Based on:
  // PHP-NUKE Web Portal System - http://phpnuke.org/
  // Thatware - http://thatware.org/
  // ----------------------------------------------------------------------
  // LICENSE
  //
  // This program is free software; you can redistribute it and/or
  // modify it under the terms of the GNU General Public License (GPL)
  // as published by the Free Software Foundation; either version 2
  // of the License, or (at your option) any later version.
  //
  // This program is distributed in the hope that it will be useful,
  // but WITHOUT ANY WARRANTY; without even the implied warranty of
  // MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  // GNU General Public License for more details.
  //
  // To read the license please visit http://www.gnu.org/copyleft/gpl.html
  // ----------------------------------------------------------------------
  /**
  * Xanthia plugin
  *
  * This file is a plugin for Xanthia, the PostNuke theme engine
  *
  * @package      Xanthia_Templating_Environment
  * @subpackage   Xanthia
  * @version      $Id: function.pnphpbbstylesheet.php,v 1.2 2004/09/15 23:16:44 carls Exp $
  * @author       The PNphpBB development team
  * @link         http://www.pnphpbb.com  The PNphpBB Home Page
  * @copyright    Copyright (C) 2004 by the PNphpBB Development Team
  * @license      http://www.gnu.org/copyleft/gpl.html GNU General Public License
  */


  /**
  * Smarty function to load PNphpBB style data
  *
  * The function will return the full source path to the apropriot PNphpBB2 style
  * information based on the seesion varible passed from PNphpBB.
  *
  * available parameters:
  *
  * Example: <!--[pnphpbbstylesheet]-->
  * Output:  <link rel="stylesheet" href="modules/PNphpBB2/templates/styles/PNTHEME_style.css" type="text/css">
  *
  * @author       Carl Slaughter
  * @since        07. May. 2004
  * @param        array       $params      All attributes passed to this function from the template
  * @param        object      &$smarty     Reference to the Smarty object
  * @return       string      The tag
  */
  function smarty_function_pnphpbbstylesheet($params, &$smarty)
  {
    // get the parameters
    extract($params);
    unset($params['xhtml']);

    // default for the module
    if (!isset($modname)) {
      $modname = pnModGetName();
    }

    if ($modname == "PNphpBB2" || pnSessionGetVar('pnphpbbmodule'))
    {
      $stylesheet = pnSessionGetVar('pnphpbbstylesheet');

      // default for the style sheet
      if (isset($stylesheet))
      {
        $osstylesheet = pnVarPrepForOS($stylesheet);

        if (file_exists($stylesheet) && is_readable($stylesheet))
        {
          $csssrc = $stylesheet;
        }
      }

      // if no module stylesheet is present then return no content
      if ($csssrc == '')
      {
        $tag='';
      }
      else
      {
        $tag = '<link rel="stylesheet" href="' . $csssrc . '" type="text/css">';
      }

      return $tag;
    }
    else
    {
      return;
    }
  }
?>