<?php
/***************************************************************************
 *                                common.php
 *                            -------------------
 *   begin                : Saturday, Feb 23, 2001
 *   copyright            : (C) 2001 The phpBB Group
 *   email                : support@phpbb.com
 *
 *   $Id: common.php,v 1.10 2004/11/05 17:35:38 carls Exp $
 *
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

if ( !defined('IN_PHPBB') )
{
	die("Hacking attempt");
}

//
function unset_vars(&$var)
{
	while (list($var_name, $null) = @each($var))
	{
		unset($GLOBALS[$var_name]);
	}
	return;
}

//
error_reporting  (E_ERROR | E_WARNING | E_PARSE); // This will NOT report uninitialized variables
set_magic_quotes_runtime(0); // Disable magic_quotes_runtime

//
$ini_val = (@phpversion() >= '4.0.0') ? 'ini_get' : 'get_cfg_var';

// Unset globally registered vars - PHP5 ... hhmmm
if (@$ini_val('register_globals') == '1' || strtolower(@$ini_val('register_globals')) == 'on')
{
	$var_prefix = 'HTTP';
	$var_suffix = '_VARS';
	
	$test = array('_GET', '_POST', '_SERVER', '_COOKIE', '_ENV');

	foreach ($test as $var)
	{
		if (is_array(${$var_prefix . $var . $var_suffix}))
		{
			unset_vars(${$var_prefix . $var . $var_suffix});
			@reset(${$var_prefix . $var . $var_suffix});
		}

		if (is_array(${$var}))
		{
			unset_vars(${$var});
			@reset(${$var});
		}
	}

	if (is_array(${'_FILES'}))
	{
		unset_vars(${'_FILES'});
		@reset(${'_FILES'});
	}

	if (is_array(${'HTTP_POST_FILES'}))
	{
		unset_vars(${'HTTP_POST_FILES'});
		@reset(${'HTTP_POST_FILES'});
	}
}

// PHP5 with register_long_arrays off?
if (!isset($HTTP_POST_VARS) && isset($_POST))
{
	$HTTP_POST_VARS = $_POST;
	$HTTP_GET_VARS = $_GET;
	$HTTP_SERVER_VARS = $_SERVER;
	$HTTP_COOKIE_VARS = $_COOKIE;
	$HTTP_ENV_VARS = $_ENV;
	$HTTP_POST_FILES = $_FILES;
}

//
// addslashes to vars if magic_quotes_gpc is off
// this is a security precaution to prevent someone
// trying to break out of a SQL statement.
//
if( !get_magic_quotes_gpc() )
{
	if( is_array($HTTP_GET_VARS) )
	{
		while( list($k, $v) = each($HTTP_GET_VARS) )
		{
			if( is_array($HTTP_GET_VARS[$k]) )
			{
				while( list($k2, $v2) = each($HTTP_GET_VARS[$k]) )
				{
					$HTTP_GET_VARS[$k][$k2] = addslashes($v2);
				}
				@reset($HTTP_GET_VARS[$k]);
			}
			else
			{
				$HTTP_GET_VARS[$k] = addslashes($v);
			}
		}
		@reset($HTTP_GET_VARS);
	}

	if( is_array($HTTP_POST_VARS) )
	{
		while( list($k, $v) = each($HTTP_POST_VARS) )
		{
			if( is_array($HTTP_POST_VARS[$k]) )
			{
				while( list($k2, $v2) = each($HTTP_POST_VARS[$k]) )
				{
					$HTTP_POST_VARS[$k][$k2] = addslashes($v2);
				}
				@reset($HTTP_POST_VARS[$k]);
			}
			else
			{
				$HTTP_POST_VARS[$k] = addslashes($v);
			}
		}
		@reset($HTTP_POST_VARS);
	}

	if( is_array($HTTP_COOKIE_VARS) )
	{
		while( list($k, $v) = each($HTTP_COOKIE_VARS) )
		{
			if( is_array($HTTP_COOKIE_VARS[$k]) )
			{
				while( list($k2, $v2) = each($HTTP_COOKIE_VARS[$k]) )
				{
					$HTTP_COOKIE_VARS[$k][$k2] = addslashes($v2);
				}
				@reset($HTTP_COOKIE_VARS[$k]);
			}
			else
			{
				$HTTP_COOKIE_VARS[$k] = addslashes($v);
			}
		}
		@reset($HTTP_COOKIE_VARS);
	}
}

//
// Define some basic configuration arrays this also prevents
// malicious rewriting of language and otherarray values via
// URI params
//
$board_config = array();
$userdata = array();
// Begin PNphpBB2 Module
$phpbb_theme = array();
// End PNphpBB2 Module
$images = array();
$lang = array();
$nav_links = array();
// $phpbb_theme['gen_simple_header'] = false;

// Begin PNphpBB2 Module
// include($phpbb_root_path . 'config.'.$phpEx);
$dbms = $pnconfig['dbtype'];
$dbhost = $pnconfig['dbhost'];
$dbname = $pnconfig['dbname'];
$dbuser = $pnconfig['dbuname'];
$dbpasswd = $pnconfig['dbpass'];
// Begin PNphpBB2 Multi-Site Support
$table_prefix = $pnconfig[prefix] . "_phpbb_";
// End PNphpBB2 Multi-Site Support

// Begin PNphpBB2 Module (PN750)
list($dbconn) = pnDBGetConn(); 
$pntable = pnDBGetTables(); 
// End PNphpBB2 Module (PN750)

// Can we find the users table?
$test = $dbconn->Execute("SELECT user_id FROM " . $table_prefix . "users LIMIT 1");
if ($test) {
   define('PHPBB_INSTALLED', true);
	 $test->Close();
}
// End PNphpBB2 Module

if( !defined("PHPBB_INSTALLED") )
{
// Begin PNphpBB2 Module
//	header("Location: install/install.$phpEx");
  die("Unable to acsess " . $table_prefix . "users table, Instalation was either not completed or table is missing.");
// End PNphpBB2 Module

	exit;
}

include($phpbb_root_path . 'includes/constants.'.$phpEx);
include($phpbb_root_path . 'includes/sessions.'.$phpEx);
include($phpbb_root_path . 'includes/auth.'.$phpEx);
include($phpbb_root_path . 'includes/functions.'.$phpEx);
include($phpbb_root_path . 'includes/db.'.$phpEx);

//
// Obtain and encode users IP
//
// I'm removing HTTP_X_FORWARDED_FOR ... this may well cause other problems such as
// private range IP's appearing instead of the guilty routable IP, tough, don't
// even bother complaining ... go scream and shout at the idiots out there who feel
// "clever" is doing harm rather than good ... karma is a great thing ... :)
//
$client_ip = ( !empty($HTTP_SERVER_VARS['REMOTE_ADDR']) ) ? $HTTP_SERVER_VARS['REMOTE_ADDR'] : ( ( !empty($HTTP_ENV_VARS['REMOTE_ADDR']) ) ? $HTTP_ENV_VARS['REMOTE_ADDR'] : $REMOTE_ADDR );
$user_ip = encode_ip($client_ip);

//
// Setup forum wide options, if this fails
// then we output a CRITICAL_ERROR since
// basic forum information is not available
//
$sql = "SELECT *
	FROM " . CONFIG_TABLE;
if( !($result = $db->sql_query($sql)) )
{
	message_die(CRITICAL_ERROR, "Could not query config information", "", __LINE__, __FILE__, $sql);
}

while ( $row = $db->sql_fetchrow($result) )
{
	$board_config[$row['config_name']] = $row['config_value'];
}
// Begin PNphpBB2 Module
// Set defaults that can not be used with PN
if ($board_config['pnphpbb2_template_compiler'] == 1)
{
 	 include($phpbb_root_path . 'includes/xs_template.'.$phpEx);
}
else
{
 	 include($phpbb_root_path . 'includes/template.'.$phpEx);
}
$board_config['default_dateformat'] = _DATETIMEBRIEF;

// if (empty($HTTP_SERVER_VARS['HTTP_HOST']))
// {
//   $board_config['server_name'] = getenv('HTTP_HOST');
// }
// else
// {
//   $board_config['server_name'] = $HTTP_SERVER_VARS['HTTP_HOST'];
// }
$board_config['server_name'] = pnGetBaseURL();
$board_config['module_url'] = "index." . $phpEx . "?name=" . $ModName . "&file=";
// $board_config['module_url'] = "modules." . $phpEx . "?op=modload&name=" . $ModName . "&file=";

$board_config['sitename'] = $pnconfig[sitename];
$board_config['site_desc'] = $pnconfig[slogan];
$board_config['require_activation'] = 0;
$board_config['gzip_compress'] = pnConfigGetVar('UseCompression');
$board_config['allow_namechange'] = 0;
$board_config['cookie_secure'] = 0;
$board_config['default_lang'] = getPNlanguage();
$board_config['board_timezone'] = pnConfigGetVar('timezone_offset') - 12;
$board_config['board_email'] = $pnconfig[adminmail];
@include_once($phpbb_root_path . 'pnversion.'.$phpEx);
// $board_config['version'] = $modversion['version'];

$fullpage = pnSessionGetVar('fullpage');
if ($fullpage === false)
{
 	 pnSessionSetVar('fullpage', $board_config['pnphpbb2_full_page']);
}
$subforum = pnSessionGetVar('subforum');
if ($subforum === false)
{
 	 pnSessionSetVar('subforum', $board_config['pnphpbb2_sub_forum']);
}
$board_config['avatar_gallery_path']= $phpbb_root_path. $board_config['avatar_gallery_path'];
$board_config['avatar_path']= $phpbb_root_path. $board_config['avatar_path'];

//-- mod : File Attachment Mod v2 Version 2.3.10 ----------------------------------------------------
include($phpbb_root_path . 'attach_mod/attachment_mod.'.$phpEx);
//-- fin : File Attachment Mod v2 Version 2.3.10 ----------------------------------------------------

// Check to see if admin removed the install directory

if (!DEBUG && file_exists($phpbb_root_path . 'install'))
{
	message_die(GENERAL_MESSAGE, 'Please ensure the install/ directory is deleted.');
}
// End PNphpBB2 Module

//
// Show 'Board is disabled' message if needed.
//
if( $board_config['board_disable'] && !defined("IN_ADMIN") && !defined("IN_LOGIN") )
{
	message_die(GENERAL_MESSAGE, 'Board_disable', 'Information');
}

?>
