<?php
/*
    **THIS NOTICE MUST APPEAR ON ALL PAGES AND VERSIONS OF BACONMAP**
       
    BaconMap - Resources Defined.
    Copyright 2008 NMSU Research IT, New Mexico State University
    Originally developed by Ed Zenisek, Denis Elkanov, and Abel Sanchez.
    
    Other open source projects used in BaconMap are copyright 
    their respective owners:
    jsTree is copyright 2003-2004 Tobias Bender (tobias@phpXplorer.org)
    wz_tooltip is copyright 2002-2008 Walter Zorn. All rights reserved.
    DHTMLGrid is copyright DHTMLX LTD. http://www.dhtmlx.com 
    
    This file is the functions file for BaconMap.
    
    BaconMap is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BaconMap is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
    */
    
/* Functions.php
/ Part of the baconmap Application
/ The purpose of this file is to hold all the functions used by the baconmap
/ application in one place and is called via an include statement on each page.
/
/ Author: Ed Zenisek 
/ Date: 04/22/2008
*/
session_name("baconmap");
session_start();
function dbConnect($dbhost,$database,$username,$password)
  {
      // This function connects to the BaconMap database and returns the connection.
      // The varaibles here are loaded from includes/settings.php     
        $conn = mysql_connect($dbhost,$username,$password) or die("1  Could not connect to $database because " . mysql_error());
        $getdatabase = mysql_select_db($database) or die("2 Could not connect to $database because " . mysql_error());
        return $conn;
  }

function formatPhone($number)
  {
      // This function will return a formatted phone number ie (888)555-1212 or 555-1212
      // If the length of the number is other than 10 or 7 it will return false. 
        
      if(strlen($number) == 10)
      {  
      $area = substr($number,0,3);
      $prefix = substr($number,3,3);
      $extension = substr($number,6,4);
      $number = '('.$area.')'.$prefix.'-'.$extension;
      return($number);
      }
      elseif(strlen($number) == 7)
      {
      $prefix = substr($number,0,3);
      $extension = substr($number,3,4);
      $number = $prefix.'-'.$extension;
      return($number);
      }     
      return false;
  }    

function cleanNumber($number)
  {
      // This function takes in a value that is supposed to be numeric only (like a ssn or phone number)
      // and strips all non-numeric characters from it.  If the new value is empty it returns false, otherwise
      // it returns the newly stripped value.  
    
        $newnumber = ereg_replace("[^0-9]", "", $number);
        if(!empty($newnumber))
          return $newnumber;
        else
          return false;
  }

function resetPassword($userid)
  {
    // This function creates a new random password and e-mails it to the specified user
    // Create the random string
    $chars = "abcdefghijkmnopqrstuvwxyz023456789";
    srand((double)microtime()*1000000);
    $i = 0;
    $pass = '';
    
    while ($i <= 7) {
      $num = rand() % 33;
      $tmp = substr($chars, $num, 1);
      $pass = $pass . $tmp;
      $i++;
    }
    
    // Encrypt it
    $query = "SELECT email FROM tbl_user WHERE user_id = '$userid'";
    $result = mysql_query($query);
    $user = mysql_result($result,0);
    $epass = md5($user.$pass);
    $query = "UPDATE tbl_user SET password = '$epass' WHERE user_id = '$userid'";
    //echo "Password is $pass.  Encrypted is $epass.<br />";
    if(!mysql_query($query))
      {
        return false;
      }
    
    // Email it
    $subject = "BaconMap Password Reset";
    //$from = "baconmap@".$_SERVER['SERVER_NAME'];
    $body = "This email is to inform you that your password for BaconMap has\n";
    $body .= "successfully reset.  Please login to BaconMap using the following\n";
    $body .= "password, and change your password at the earlist opportunity.\n\n";
    $body .= "New Password: $pass\n\n";
    $body .= "Thanks, BaconMap User Admin\n\n";
    $body .= "-----------------------------------------------------------------\n";
    $body .= "This email was automatically generated by the BaconMap user system,\n";
    $body .= "please do not reply.  If you feel this message is in error, please\n";
    $body .= "contact your system administrator.";
    
    //echo "Mailing to $user.<br />";
    if(!mail($user,$subject,$body))
      return false;
    else
      return true;   
    
  }

function php_multisort($data,$keys){
   // Sorts a multi-dimensional array
  // List As Columns
  $sort = '';
  foreach ($data as $key => $row) {
    foreach ($keys as $k){
      $cols[$k['key']][$key] = $row[$k['key']];
    }
  }
  // List original keys
  $idkeys=array_keys($data);
  // Sort Expression
  $i=0;
  foreach ($keys as $k){
    if($i>0){$sort.=',';}
    $sort.='$cols['.$k['key'].']';
    if(isset($k['sort'])){$sort.=',SORT_'.strtoupper($k['sort']);}
    if(isset($k['type'])){$sort.=',SORT_'.strtoupper($k['type']);}
    $i++;
  }
  $sort.=',$idkeys';
  // Sort Funct
  $sort='array_multisort('.$sort.');';
  eval($sort);
  // Rebuild Full Array
  foreach($idkeys as $idkey){
    $result[$idkey]=$data[$idkey];
  }
  return $result;
}

function sec2Time($time){
  if(is_numeric($time)){
    $value = array(
      "years" => 0, "days" => 0, "hours" => 0,
      "minutes" => 0, "seconds" => 0,
    );
    if($time >= 31556926){
      $value["years"] = floor($time/31556926);
      $time = ($time%31556926);
    }
    if($time >= 86400){
      $value["days"] = floor($time/86400);
      $time = ($time%86400);
    }
    if($time >= 3600){
      $value["hours"] = floor($time/3600);
      $time = ($time%3600);
    }
    if($time >= 60){
      $value["minutes"] = floor($time/60);
      $time = ($time%60);
    }
    $value["seconds"] = floor($time);
    return (array) $value;
  }else{
    return (bool) FALSE;
  }
}

function testgraphviz(){
/*  This is the script that will check ig graphviz works by creating a test image 
    returns false if it can`t create due to bad missing "dot" utility or insufficient privileges on ./image dir
*/
 global $graphvizpath;
 if(file_exists("image/tmp.gif")) unlink("image/tmp.gif");
 if(file_exists("image/tmp.gif")){ // can`t delete: insufficient privileges
  return false;
 }
 $handle=popen("$graphvizpath -Tgif -o image/tmp.gif","w");
 fwrite($handle,"digraph G {\na->b\n}\n");
 pclose($handle);
 if(!file_exists("image/tmp.gif")){ // can`t create: either insufficient privileges, or bad $graphvizpath, or graphviz does not do gifs
  return false;
 }
 unlink("image/tmp.gif");
 return true;
} 

function getRoles()
  {
    // This function gets a list of roles from all the resource tables.
    $resources = array();
    $types = array('box','device','server','service','database','application');
    $i = 0;
    $roles = array();
    foreach($types as $type)
      {
        $query = 'SELECT role FROM tbl_'.$type;
        $result = mysql_query($query);
        while($row = mysql_fetch_row($result))
          {
            $roles[] = $row[0];
          }
      }
    $roles = array_unique($roles);
    return $roles;
  }
  
function getRoleResources($role)
  {
    // This function returns all resources in the database of the specified role
    // type.
    $resources = array();
    $types = array('box','device','server','service','database','application');
    $i = 0;
      foreach($types as $type)
      {
        $query = 'SELECT '.$type.'_id FROM tbl_'.$type.' WHERE role = \''.$role.'\'';
        //echo $query;
        $result = mysql_query($query);
        while($row = mysql_fetch_row($result))
          {
            $resources[$i]['type'] = $type;
            $resources[$i]['id'] = $row[0];
            $i++;
          }
      }
    return $resources;
  }     
 
function getPrettyImpact($impact)
  {
    // Returns a string representation of an impact number
    
    switch($impact) {
          case '1':
            $impacttext = 'Foreign Only'; 
          break;
          case '2':
            $impacttext = 'External Only';
          break;
          case '3':
            $impacttext = 'External and Foreign'; 
          break;
          case '4':
            $impacttext = 'Internal Only';
          break;
          case '5': 
            $impacttext = 'Internal and Foreign';
          break;
          case '6':
            $impacttext = 'Internal and External';
          break;
          case '7':
            $impacttext = 'Internal, External, and Foreign';
          default:
            $impacttext = 'No Impact Specified';
          break;
          }
    return $impacttext;
  }
   
function getChildren($type, $cid)
  {  
    // This function returns an array of children for the given type and id of a resource.
    // Type is like 'box', 'server', 'application' etc.
    // Returns false if no children exist.
    
    $query = "SELECT c_table, c_id FROM tbl_dep WHERE p_table = '$type' and p_id = '$cid'";
    $result = mysql_query($query);
    $children = array();
    $i = 0;
    if(mysql_num_rows($result) == 0)
      return false;
    while($row = mysql_fetch_row($result))
      {
        $children[$i]['type'] = $row[0];
        $children[$i]['id'] = $row[1];
        $i++;      
      }
    return $children;
  }

function getChildrenRecursive($type, $cid)
  {
    // This function returns an array of children for the given type and id of a resource.
    // Type is like 'box', 'server', 'application' etc.
    // This is the recursive version which will get all children of this resource, all
    // the way down until the final child is found.
    // Returns false if no children exist.
    
    $query = "SELECT c_table, c_id FROM tbl_dep WHERE p_table = '$type' and p_id = '$cid'";
    $result = mysql_query($query);
    $children = array();
    $i = 0;
    if(mysql_num_rows($result) == 0)
      return false;
    while($row = mysql_fetch_row($result))
      {
        $children[$i]['type'] = $row[0];
        $children[$i]['id'] = $row[1];
        if($child = getChildrenRecursive($row[0],$row[1]))
          $children[$i]['children'] = $child;
        $i++;      
      }
    return $children;
  }

function getParents($type, $pid)
  {  
    // This function returns an array of parents for the given type and id of a resource.
    // Type is like 'box', 'server', 'application' etc.
    // Returns false if no parents exist.
    
    $query = "SELECT P_table, p_id FROM tbl_dep WHERE c_table = '$type' and c_id = '$pid'";
    $result = mysql_query($query);
    $parents = array();
    $i = 0;
    if(mysql_num_rows($result) == 0)
      return false;
    while($row = mysql_fetch_row($result))
      {
        $parents[$i]['type'] = $row[0];
        $parents[$i]['id'] = $row[1];
        $i++;      
      }
    return $parents;
  }

function getParentsRecursive($type, $pid)
  {
    // This function returns an array of parents for the given type and id of a resource.
    // Type is like 'box', 'server', 'application' etc.
    // This is the recursive version which will get all children of this resource, all
    // the way down until the final child is found.
    // Returns false if no parents exist.
    
    $query = "SELECT p_table, p_id FROM tbl_dep WHERE c_table = '$type' and c_id = '$pid'";
    $result = mysql_query($query);
    $parents = array();
    $i = 0;
    if(mysql_num_rows($result) == 0)
      return false;
    while($row = mysql_fetch_row($result))
      {
        $parents[$i]['type'] = $row[0];
        $parents[$i]['id'] = $row[1];
        if($parent = getParentsRecursive($row[0],$row[1]))
          $parents[$i]['parents'] = $parent;
        $i++;      
      }
    return $parents;
  }

function getPOCResources($pid)
  {
    // This function gets all resources that are tied to the given point of contact id
    $resources = array();
    $types = array('box','device','server','service','database','application');
    $i = 0;
    foreach($types as $type)
      {
        $query = 'SELECT '.$type.'_id, name, role FROM tbl_'.$type.' WHERE poc_id = '.$pid;
        //echo $query.'<br>';
        $result = mysql_query($query);
          if(mysql_num_rows($result) != 0)
            {
              while($row = mysql_fetch_assoc($result))
                {
                  $resources[$i]['type'] = $type;
                  $resources[$i]['name'] = $row['name'];
                  $resources[$i]['role'] = $row['role'];
                  $resources[$i]['id'] = $row[$type.'_id'];
                  $i++;
                }
            }
      }
    return $resources;
  }

function breakDown($array,$PorC)
  {
    // This function takes an array created by one of the recursive functions above
    // and breaks it down into a flat one dimensional array of values.
    $output = array();
    if(is_array($array))
    foreach($array as $key => $value)
      {
          $output[] = $value['type'].'_'.$value['id'];
          if(isset($value[$PorC]))
            {
              $output = array_merge($output,breakDown($value[$PorC],$PorC));
            } 
      }
    return $output;
  }  
    
function createTree($how, $what)
  {
   /* This function builds the javascript output for the tree menu, and returns
      it as text.  The tree menu has some fairly specific rules it needs to follow
      in order to render correctly.  I'll try to explain it here.
      The whole tree is defined as an overall folder definition, and a folder 
      definition looks like so:
      [
        Node Definition: node1,
        Node Definition: node2
      ]
      
      Each node definition looks like this:
      [
        String: node name,
        [
          String: href,
          String: target,
          String: image,
          String: tooltip,
          Folder definition: node context menu,
          String: background image
        ],
        Folder definition: sub folder
      ]
      
      In BaconMap, the top node of the tree is always named after the type of
      resource we have at the top level (Box, Server, Application, Etc).  It will
      look much like this:
      ['Boxes', ['javascript:_foo()',,'server','Sorted by Box'],
        [REST OF TREE]
      ]
      
      We use javascript:_foo() for the link because we don't want anything to 
      happen when it gets clicked on.
      
      Other rules:
      Each actual resource has resource types directly underneath it in the tree,
      not the actual resources.  A server, for instance, won't be directly under
      a box, but will instead be under a listing for servers for that box.  This 
      is to make the tree easer to read.
      
      Clicking on an actual resource will open up the edit page for that resource.
      
      Clicking on a resource type will open up the tree for that resource type.
      
      The context menu for an actual resource will include links to view more
      information, edit, delete, and add children.
      
      The context menu for a resource type will only include a link to add 
      children for the parent of the type.
      
      The tooltip for a resource will include some basic information about it
      depending on what type of resource it is.
      
      The tooltip for a resource type will state who the type's parent is and how
      many resources of this type exist.
   */
   
   // Set up tree title
   $title = '';
   switch($what) {
    case 'box':
      $title .= 'Boxes';
      $pic = 'server';
      break;
    case 'server':
      $title .= 'Servers';
      $pic = 'computer';
      break;
    case 'device':
      $title .= 'Devices';
      $pic = 'drive';
      break;
    case 'application':
      $title .= 'Applications';
      $pic = 'application';
      break;
    case 'database':
      $title .= 'Databases';
      $pic = 'database';
      break;
    case 'service':
      $title .= 'Services';
      $pic = 'cog';
      break;
    }
    
   switch($how) {
    case 'child':
      $title .= ' and Children';
      break;
    case 'parent':
      $title .= ' and Parents';
      break;
     }  
   
   $query = 'SELECT '.$what.'_id, poc_id, name from tbl_'.$what.' order by name ASC';
   $result = mysql_query($query);
   $output = "[
   ['$title', ['javascript:_foo()',,'$pic','Click on the icons for more options'],
   [
   ";
   $new = true;
   while($row = mysql_fetch_row($result))
    {
      if(!$new)
      {
        $output .= ',
        ';
      }
      else
        $new = false;
       if($how == 'child') 
        $output .= createChildBranch($what,$row[0],$title);
       else
        $output .= createParentBranch($what,$row[0],$title);
    }
   $output .= ']
   ]]';
   return $output;   
  }

function createChildBranch($type,$cid,$level)
{
    // This function takes the type and id of a resource and builds a tree menu
    // for it.  The level variable is used to denote what level of the tree we're
    // in so that we can use it for linking and navigation.  
    
    global $rootdir;
    global $defaultclick;
    
    $pic = getPic($type);
    
    $output = '';
    $query = 'SELECT name, poc_id, role FROM tbl_'.$type.' WHERE '.$type."_id = '$cid'";
    $result = mysql_query($query);
    $row = mysql_fetch_row($result);
      $thisname = trim($row[0]);
      $thispoc = trim($row[1]);
      $thisrole = trim($row[2]);
    $query = "SELECT c_table, c_id FROM tbl_dep WHERE p_table = '$type' AND p_id = '$cid' order by c_table";
    $result = mysql_query($query);
    $numchildren = mysql_num_rows($result); 
    $level = $level . '|' . $thisname;
    
    $query = "SELECT first, last FROM tbl_poc WHERE poc_id = '$thispoc'";
    $pocresult = mysql_query($query);
    $pocrow = mysql_fetch_row($pocresult);
      
    $tip = "<strong>$thisname<\/strong><br />Role: <i>$thisrole<\/i><br />Contact: <i>".trim($pocrow[0]).' '.trim($pocrow[1]).'<\/i>';  
    $tip = trim($tip);  
    $output .= "['$thisname', ['".defaultClick($type,$cid,$numchildren)."','main','$pic','$tip',
    [";
    
    // Build context menu. Applications cannot add children, so we don't put the
    // add child portion of the context menu on an application node.
    
    $output .= makeContext($type,$cid,$numchildren);
      
    $output .= ']';
    
    $foundbox = false;
    $foundserver = false;
    $founddevice = false;
    $foundapp = false;
    $founddatabase = false;
    $foundservice = false;  
      
    if($numchildren != 0)
      {
        $output .= '],
        [
        ';
        $previous = 0;
        while($row = mysql_fetch_row($result))
          {   
             $thislevel = $level;
             if(!$foundbox && $row[0] == 'box') {
              $thislevel .= '|Boxes';
              if($previous) $output.=']],';
              $output .= "['Boxes',['javascript:setState(\"$thislevel\")',,'folder','Box Children of $thisname',
              [['Add Child&nbsp;', ['add.php?new=1&type=box&parent=".$type."_".$cid."','main','add']]]],
              [";
              $foundbox = true;
              $new = true;
             }
             if(!$foundserver && $row[0] == 'server') {
              $thislevel .= '|Servers';
              if($previous) $output.=']],';
              $output .= "['Servers',['javascript:setState(\"$thislevel\")',,'folder','Server Children of $thisname',
              [['Add Child&nbsp;', ['add.php?new=1&type=server&parent=".$type."_".$cid."','main','add']]]],
              [";
              $foundserver = true;
              $new = true;
             }
             if(!$founddevice && $row[0] == 'device') {
              $thislevel .= '|Devices';
              if($previous) $output.=']],';
              $output .= "['Devices',['javascript:setState(\"$thislevel\")',,'folder','Device Children of $thisname',
              [['Add Child&nbsp;', ['add.php?new=1&type=device&parent=".$type."_".$cid."','main','add']]]],
              [";
              $founddevice = true;
              $new = true;
             }
             if(!$foundapp && $row[0] == 'application') {
              $thislevel .= '|Applications';
              if($previous) $output.=']],';
              $output .= "['Applications',['javascript:setState(\"$thislevel\")',,'folder','Application Children of $thisname',
              [['Add Child&nbsp;', ['add.php?new=1&type=application&parent=".$type."_".$cid."','main','add']]]],
              [";
              $foundapp = true;
              $new = true;
             }
             if(!$founddatabase && $row[0] == 'database') {
              $thislevel .= '|Databases';
              if($previous) $output.=']],';
              $output .= "['Databases',['javascript:setState(\"$thislevel\")',,'folder','Database Children of $thisname',
              [['Add Child&nbsp;', ['add.php?new=1&type=database&parent=".$type."_".$cid."','main','add']]]],
              [";
              $founddatabase = true;
              $new = true;
             }
             if(!$foundservice && $row[0] == 'service') {
              $thislevel .= '|Services';
              if($previous) $output.=']],';
              $output .= "['Services',['javascript:setState(\"$thislevel\")',,'folder','Service Children of $thisname',
              [['Add Child&nbsp;', ['add.php?new=1&type=service&parent=".$type."_".$cid."','main','add']]]],
              [";
              $foundservice = true;
              $new = true;
             }
            $previous = true;
            if(!$new)
              { 
                $output .= ',
                ';
              }
            else
              $new = false;
               
            $output .= createChildBranch($row[0],$row[1],$thislevel);
            //$output .= ']';
          }
        $output .= ']]]';
      }
    else
      $output .= ']';
    
    $output .= ']';  
    return $output; 
}

function createParentBranch($type,$pid,$level)
{
    // This function takes the type and id of a resource and builds a tree menu
    // for it.  The level variable is used to denote what level of the tree we're
    // in so that we can use it for linking and navigation.  
    
    global $rootdir;
    global $defaultclick;
    
    $pic = getPic($type);
    
    $output = '';
    $query = 'SELECT name, poc_id, role FROM tbl_'.$type.' WHERE '.$type."_id = '$pid'";
    $result = mysql_query($query);
    $row = mysql_fetch_row($result);
      $thisname = trim($row[0]);
      $thispoc = trim($row[1]);
      $thisrole = trim($row[2]);
    $query = "SELECT p_table, p_id FROM tbl_dep WHERE c_table = '$type' AND c_id = '$pid' order by p_table";
    $result = mysql_query($query);
    $numparents = mysql_num_rows($result); 
    $level = $level . '|' . $thisname;
      
    $query = "SELECT first, last FROM tbl_poc WHERE poc_id = '$thispoc'";
    $pocresult = mysql_query($query);
    $pocrow = mysql_fetch_row($pocresult);
      
    $tip = "<strong>$thisname</strong><br />Role: <i>$thisrole</i><br />Contact: <i>".trim($pocrow[0]).' '.trim($pocrow[1]).'</i>';  
    //$tip = 'tip';
    $tip = trim($tip);  
      
    $output .= "['$thisname', ['".defaultClick($type,$pid,$numparents)."','main','$pic','$tip',[";
    
    // Build context menu. Applications cannot add children, so we don't put the
    // add child portion of the context menu on an application node.
    
    //$output .= makeContext($type,$id,$numchildren);
    $output .= makeContext($type,$pid,0);  
      
    $output .= ']';
    
    $foundbox = false;
    $foundserver = false;
    $founddevice = false;
    $foundapp = false;
    $founddatabase = false;
    $foundservice = false;
      
    if($numparents != 0)
      {
        $output .= '],
        [
        ';
        $previous = 0;
        while($row = mysql_fetch_row($result))
          {   
             $thislevel = $level; 
             if(!$foundbox && $row[0] == 'box') {
              $thislevel .= '|Boxes';
              if($previous) $output.=']],';
              $output .= "['Boxes',['javascript:setState(\"$thislevel\")',,'folder','Box Parents of $thisname'],
              [";
              $foundbox = true;
              $new = true;
             }
             if(!$foundserver && $row[0] == 'server') {
              $thislevel .= '|Servers';
              if($previous) $output.=']],';
              $output .= "['Servers',['javascript:setState(\"$thislevel\")',,'folder','Server Parents of $thisname'],
              [";
              $foundserver = true;
              $new = true;
             }
             if(!$founddevice && $row[0] == 'device') {
              $thislevel .= '|Devices';
              if($previous) $output.=']],';
              $output .= "['Devices',['javascript:setState(\"$thislevel\")',,'folder','Device Parents of $thisname'],
              [";
              $founddevice = true;
              $new = true;
             }
             if(!$foundapp && $row[0] == 'application') {
              $thislevel .= '|Applications';
              if($previous) $output.=']],';
              $output .= "['Applications',['javascript:setState(\"$thislevel\")',,'folder','Application Parents of $thisname'],
              [";
              $foundapp = true;
              $new = true;
             }
             if(!$founddatabase && $row[0] == 'database') {
              $thislevel .= '|Databases';
              if($previous) $output.=']],';
              $output .= "['Databases',['javascript:setState(\"$thislevel\")',,'folder','Database Parents of $thisname'],
              [";
              $founddatabase = true;
              $new = true;
             }
             if(!$foundservice && $row[0] == 'service') {
              $thislevel .= '|Services';
              if($previous) $output.=']],';
              $output .= "['Services',['javascript:setState(\"$thislevel\")',,'folder','Service Parents of $thisname'],
              [";
              $foundservice = true;
              $new = true;
             }
            $previous = true;
            if(!$new)
              { 
                $output .= ',
                ';
              }
            else
              $new = false;
               
            $output .= createParentBranch($row[0],$row[1],$thislevel);
            //$output .= ']';
          }
        $output .= ']]]';
      }
    else
      $output .= ']';
    
    $output .= ']';  
    return $output; 
}
  
function getResources($type) {
      
      // Returns all resources of the given type
      $res = array();
      $query = 'SELECT name, '.$type.'_id FROM tbl_'.$type;
      $result = mysql_query($query);
      if(mysql_num_rows($result) == 0)
         return 0;
      $i = 0;
      while($row = mysql_fetch_row($result))
        {
          $res[$i]['name'] = $row[0];
          $res[$i]['id'] = $row[1];
          $res[$i]['type'] = $type;
          $res[$i]['typeid'] = $type.'_'.$row[1];
          $i++;
        }
      return $res;
}

function getGroups($types)  {
      
      // Returns an array of all groups of the given types.
      $res = array();
      $typelist = implode("','",$types);
      $query = "SELECT DISTINCT group_id, name, mtype FROM tbl_group WHERE mtype in ('$typelist') ORDER BY mtype";
      $result = mysql_query($query);
      if(mysql_num_rows($result) == 0)
         return 0;
      $i = 0;
      while($row = mysql_fetch_row($result))
        {
          $res[$i]['name'] = $row[1];
          $res[$i]['id'] = $row[0];
          $res[$i]['type'] = $row[2];
          $res[$i]['typeid'] = 'group_'.$row[0];
          $i++;
        }
      return $res;
} 

function groupCombine($resources) {
  
      // Takes an array of resources and determines if there are any whole groups
      // within the array.  If so, the members of the group are removed from the 
      // array and replaced with the group reference.
      
      // Singles is a list of single entities that we'll eventually return. 
      // Accountedfor lists all the entities we've already determined the status of.
      // The group array contains the current group members to compare against, if they exist.
      
      // Lots of array merging, diffing, and intersections going on in order to determine
      // who belongs in what array.  As we find complete groups in the given array, we
      // take the members out of resources, put them in accounted for, and add their
      // group designation to singles.
      
      $singles = array();
      $accountedfor = array();
      
      foreach($resources as $res)
        {
          if(!in_array($res,$accountedfor))
          {
           $bits = explode('_',$res);
           $type = $bits[0]; $rid = $bits[1];
           $query = "SELECT mid, group_id FROM tbl_group WHERE group_id = (SELECT group_id FROM tbl_group WHERE mid = '$rid' AND mtype = '$type')";
           $result = mysql_query($query);
           if(mysql_num_rows($result) == 0)
            {
             $singles[] = $res;
             //echo 'I is single<br>';
            }
           else
            {
              $group = array();
              //echo 'I has group!  Here it be: ';
              while($row = mysql_fetch_row($result))
                {
                  $group[] = $type.'_'.$row[0];
                  $group_id = $row[1];
                 }
              if(array_diff($group,$resources))
                {
                  $singles = array_merge($singles, array_intersect($group,$resources));
                  $accountedfor = array_merge($accountedfor,array_intersect($group,$resources));
                }
              else
                {
                  $singles[] = 'group_'.$group_id;
                  $resources = array_diff($resources,$group);
                  $accountedfor = array_merge($accountedfor,$group);
                }
            }
            $resources = array_diff($resources,$singles);
          }
        }
    return $singles;
}

function scrub($content)  {
      // This function takes a string and returns an eqivalent string that has been scrubbed
      // for use in javascript.
      
      $content = htmlspecialchars($content,ENT_QUOTES);
      $content = nl2br($content);
      $content = str_replace("\n",'',$content);
      $content = str_replace("\r",'',$content);
      return $content;     
}

function makeContext($type,$rid,$numchildren) {
  
  global $defaultclick;
  global $rootdir;
  $output = '';
  $docs = false;
  $query = "SELECT name FROM tbl_upload where objtype = '$type' and objid = '$rid'";
  $result = mysql_query($query);
  if(mysql_num_rows($result))
    $docs = true;
  if($type == 'application')
      {
       $output .= "['Tell Me More&nbsp;', ['javascript:var sd = \"{@strData}\";parent.GB_myShow(\"More Details\", \"$rootdir/details.php?id=".$type."_".$rid."\",550,550);',,'comment']],
       ";
       if($docs)
       $output .= "['View Documents&nbsp;', ['javascript:var sd = \"{@strData}\";parent.GB_myShow(\"Documents\", \"$rootdir/documents.php?id=".$type."_".$rid."\",550,550);',,'book_open']],
       "; 
       //$output .= "['Add Child&nbsp;', ['add.php?parent=".$type."_".$id."','main','add']],";
       if($_SESSION['level'] < 2)
       $output .= "['Delete This&nbsp;', ['javascript:doDelete(\"$numchildren\",\"".$type.'_'.$rid."\")',,'cancel']],
       ";
       if($_SESSION['level'] < 2)
       $output .= "['Edit This&nbsp;', ['edit.php?id=".$type."_".$rid."','main','font']],
       ";
       // Old way, opening in main frame
       //$output .= "['Map it!&nbsp;', ['picture.php?type=".$type."&id=".$rid."','main','chart']]
       //";     
       // New way, opening in seperate GreyBox
       $output .= "['Map it!&nbsp;', ['javascript:var sd = \"{@strData}\";parent.GB_myShow(\"Map It!\", \"$rootdir/picture.php?type=".$type."&id=".$rid."\",550,900);',,'chart']],
       ";
      }
    else
      {
       $output .= "['Tell Me More&nbsp;', ['javascript:var sd = \"{@strData}\";parent.GB_myShow(\"More Details\", \"$rootdir/details.php?id=".$type."_".$rid."\",550,550);',,'comment']],
       ";
       if($docs)
       $output .= "['View Documents&nbsp;', ['javascript:var sd = \"{@strData}\";parent.GB_myShow(\"Documents\", \"$rootdir/documents.php?id=".$type."_".$rid."\",550,550);',,'book_open']],
       "; 
       if($_SESSION['level'] < 2)
       $output .= "['Add Child&nbsp;', ['add.php?new=1&parent=".$type."_".$rid."','main','add']],
       ";
       if($_SESSION['level'] < 2)
       $output .= "['Delete This&nbsp;', ['javascript:doDelete(\"$numchildren\",\"".$type.'_'.$rid."\")',,'cancel']],
       ";
       if($_SESSION['level'] < 2)
       $output .= "['Edit This&nbsp;', ['edit.php?id=".$type."_".$rid."','main','font']],
       ";
       // Old way, opening in main frame
       //$output .= "['Map it!&nbsp;', ['picture.php?type=".$type."&id=".$rid."','main','chart']]
       //";     
       // New way, opening in seperate GreyBox
       $output .= "['Map it!&nbsp;', ['javascript:var sd = \"{@strData}\";parent.GB_myShow(\"Map It!\", \"$rootdir/picture.php?type=".$type."&id=".$rid."\",550,900);',,'chart']],
       ";
      }
      
    return $output;
  }

function defaultClick($type,$rid,$numchildren=0) 
{
  // reurns the code for the default click action on any item in the tree menu
  global $defaultclick;
  global $rootdir;
  
  switch($defaultclick) {
  case 'tell':
  $output = 'javascript:var sd = "{@strData}";parent.GB_myShow("More Details", "'.$rootdir.'/details.php?id='.$type.'_'.$rid.'",550,530)';
  break;
  case 'edit':
  $output = 'edit.php?id='.$type.'_'.$rid;
  break;
  case 'delete':
  $output = 'javascript:doDelete("'.$numchildren.'","'.$type.'_'.$rid.'")';
  break;
  case 'add':
  $output = 'add.php?new=1&parent='.$type.'_'.$rid;
  break;
  case 'map':
  $output = 'picture.php?type='.$type.'&id='.$rid;
  break;
  }
  return $output;
}

function getPic($type)
  { 
    // Returns the name of the picture file for a given resource.    
    switch($type) {
    case 'box':
      $pic = 'server';
      break;
    case 'server':
      $pic = 'computer';
      break;
    case 'device';
      $pic = 'drive';
      break;
    case 'application':
      $pic = 'application';
      break;
    case 'database':
      $pic = 'database';
      break;
    case 'service':
      $pic = 'cog';
      break;
    }
    return $pic;
  }
  
function buildReference($resource,$how = 0)
  {
    // Builds a pipe delimited list of parents or children for the setState() function on the tree
    // menu.
     function doLevel($p)
      {
        $level = '';
        $query = 'SELECT name FROM tbl_'.$p['type'].' WHERE '.$p['type'].'_id = '.$p['id'];
        if($result = mysql_query($query))
          {
            $row = mysql_fetch_row($result);
            $name = $row[0];
            if(isset($p['parents']))
              {
                $level .= doLevel($p['parents'][0]);
                switch($p['type']) {
                case 'box':
                  $title = 'Boxes';
                  break;
                case 'server':
                  $title = 'Servers';
                  break;
                case 'device';
                  $title = 'Devices';
                  break;
                case 'application':
                  $title = 'Applications';
                  break;
                case 'database':
                  $title = 'Databases';
                  break;
                case 'service':
                  $title = 'Services';
                  break;
                }
               $level .= $title;
            }
            $level .='|'.$name.'|';  
        }
        return $level;
      } 
     
     $rbits = explode('_',$resource);
     $parents = getParentsRecursive($rbits[0],$rbits[1]);
     //print_r($parents);
     switch($rbits[0]) {
            case 'box':
              $title = 'Boxes';
              break;
            case 'server':
              $title = 'Servers';
              break;
            case 'device';
              $title = 'Devices';
              break;
            case 'application':
              $title = 'Applications';
              break;
            case 'database':
              $title = 'Databases';
              break;
            case 'service':
              $title = 'Services';
              break;
          }
     $output = doLevel($parents[0]).$title;
      
     return $output;
  }
  
function getOrphans($resource) 
  {
      // This function finds all children of the given resource that would be orphans if this
      // resource is deleted.  An orphan is a resource, that is not a box or device, which does not
      // have any parents or direct parentage to a box or device.  
      
      // What we'll do is grab all the children of this resource and check their parentage.
      // Confirmed Orphans are moved to an orphan array.  Confirmed non-orphans are taken out of the
      // children list as they are found.  The resource we're drilling down from, the one included
      // in the function call, is called the 'Bad Parent' for reference purposes.  If a resource has
      // only the bad parent as a parent, then we know it's going to be an orphan.  Likewise,
      // if we find a box or device as a direct parent, other than the bad parent, then the resource 
      // is NOT an orphan.  If the resource has a parent that is not the bad parent, and is not a box
      // or device, then we need to look further.  What we do is recursively grab all their 
      // parents, find the bad parent, take it out of the list along with all of it's parents, and 
      // then scour the list for a box or device.  If no box or device is found in that list after
      // all that, then this resource is an orphan.  
      
      $bits = explode('_',$resource);
      $type = $bits[0]; $rid = $bits[1];
      $children = getChildrenRecursive($type,$rid);
      $children = breakDown($children,'children');
      //echo 'My Children: ';
      //print_r($children);
      $orphans = array();
      foreach($children as $key => $child)
        {
          $bits = explode('_',$child);
          $ctype = $bits[0]; $cid = $bits[1];
          $parents = getParents($ctype,$cid);
          //echo '<br />These are parents: ';
          //print_r($parents);
          // Remove the parent we're checking for, if it exists.
          // Then check for device or box parents.  If we find one, we can totally disregard the 
          // entire line of children, because they'll be ok.
          $found = false;
          foreach($parents as $key => $thisparent)
            {
              $checkvalue = $thisparent['type'].'_'.$thisparent['id'];
              if($checkvalue == $resource)
                {
                  if(count($parents) == 1)
                    {
                      $orphans[] = $child;
                      //echo ' The only one is the Bad Parent, so we set an orphan.';
                    }
                  else
                    {
                      unset($parents[$key]);
                      //echo ' More than one.  One was the bad parent.';
                    }
                }
              elseif($thisparent['type'] == 'box' || $thisparent['type'] == 'device')
                  $found = true;
                
            }             
            if($found)
            {
              unset($children[$key]);
              //echo ' We found at least one is a box or device, so this kid is ok.';
            }    
        }
      // Take the orphans out
      $children = array_diff($children,$orphans);
      //echo '<br />These are my children after eliminating single parent orphans: ';
      //print_r($children);
      
      // Now we've weeded out all the single bad parent orphans, and taken all children with a direct
      // link to a box or device, other than the bad parent, out of the orphan running.
      // Time to get a litte more detail for the guys with mutliple parents.
       
      function removeParent($array,$parent)
        {
          // This function goes recursively through the partantage list ($array) and removes all 
          // instances of the given parent
          foreach($array as $key => $value)
            {
              //echo '<br>value = '; print_r($value);
              // Remove the starting resource from the parent pool.
              $checkvalue = $value['type'].'_'.$value['id'];
              if($checkvalue == $parent)
                {
                //echo '<br>BAD PARENT FOUND';
                unset($array[$key]);
                $output = $array;
                }
              else
                {
                  if(isset($value['parents']))
                  {
                    $array[$key]['parents'] = removeParent($value['parents'],$parent);
                  }
                  $output = $array;
                }
            }
          return $output;
        } 
      foreach($children as $child)
        {  
            // Get all recursive parents
            $bits = explode('_',$child);
            $ctype = $bits[0]; $cid = $bits[1];
            $parents = getParentsRecursive($ctype,$cid);
            //echo '<br />Parents for orphan: ';
            //print_r($parents);
            $parents = removeParent($parents,$resource);
            $parents = breakDown($parents,'parents');
            //echo '<br />These are all of the parents of the children that are left: ';
            //print_r($parents);
              
            // Find any direct parents that are already orphans and get rid of them.
            $parents = array_diff($parents,$orphans);  
            //echo '<br />After I gots rid of the parents who were orphans: ';
            //print_r($parents);
            
            // What we're left with is a clear list of parents for this child that are not 
            // out of the running.  If there's a box or a device in here, this kid is ok.
            // If not, it's an orphan.
            $found = false;
            foreach($parents as $thisparent)
            {
              $bits = explode('_',$thisparent);
              $ptype = $bits[0]; $pid = $bits[1];
              if($ptype == 'box' || $ptype == 'device')
                $found = true;
            }        
            if(!$found)
              $orphans[] = $child;
        }
      if(!empty($orphans))
      return $orphans;
      else
      return false; 
  }

function mergeScenario ($one,$two)
  {
    $dead = array_merge($one['dead'],$two['dead']);
    $saved = array_merge($one['saved'],$two['saved']);
    
    $out = array();
    $out['dead'] = $dead;
    $out['saved'] = $saved;
    return $out;   
  }
  
function getNames()
  {
    // This function simply returns a list of all resource names in the database.
    $types = array('device','server','service','database','box','application');
    $names = array();
    foreach($types as $type)
      {
        $query = 'SELECT name FROM tbl_'.$type;
        $result = mysql_query($query);
        while($row = mysql_fetch_row($result))
          {
            $names[] = $row[0];
          }
      }
    return $names;
  }
  
$dead = array();
function runScenario($resources)
  {
    // This function takes an array of resources and kills them off to see
    // what will happen to their children.  As we go through the list, we
    // add members to the $dead array and, as each member is added, we check
    // the member's children to see if they have any un-grouped parents who 
    // are dead.  If they do, they die.  If the dead parent is in a group, 
    // we check to see if any of the other members of the group are alive.
    // If not, the child dies.  If there are no ungrouped dead parents, and there
    // are grouped parents who are still alive, then the child is considered to be
    // saved by the group (alive because members of the group covered for each other).
    // If that's the case, we put them in the $saved array.
    
    // First things first.  Add the resources we have to the dead array.
    global $dead;
    if(is_array($dead))
      $dead = array_merge($dead,$resources);
    else
      $dead = $resources;
      
    $scenario['dead'] = $resources;
    $scenario['saved'] = array();
    foreach($scenario['dead'] as $x)
      {
        $xbits = explode('_',$x);
        $xid = $xbits[1];
        $xtype = $xbits[0];
        
        // Get the dead thing's children
        if($children = getChildren($xtype,$xid))
        {
        // Check if this dead thing is in a group.  If not, we can kill all of
        // its children without mercy.  (I have lots of pent up rage... sorry)
        // We do that by sticking them in another runScenario, and run it on them.
        $query = "SELECT group_id FROM tbl_group WHERE mid = '$xid' AND mtype = '$xtype'";
        $result = mysql_query($query);
        if(mysql_num_rows($result) == 0)
          {
            $children = breakDown($children,'children');           
            $temp = runScenario($children);           
            $scenario = mergeScenario($scenario,$temp);
          }
        else
          {
            // This dead thing is in a group.  The group might be covering for it.
            // Let's see.  We'll start by finding what groups it's in.
            $query = "SELECT DISTINCT group_id, name FROM tbl_group WHERE mid = '$xid' AND mtype = '$xtype'";
            $result = mysql_query($query);
            $i = 0;
            while($row = mysql_fetch_row($result))
              {
                $groups[$i]['id'] = $row[0];
                $groups[$i]['name'] = $row[1];
                $groups[$i]['dead'] = false;
                $i++;
              }
            // Now let's check all the group members to see if they're still livin'
            $groupdeaths = 0;
            foreach($groups as $key => $group)
              {
                $query = "SELECT mid, mtype FROM tbl_group WHERE group_id = ".$group['id'];
                $result = mysql_query($query);
                $livin = false;
                // We assume they're all dead, and if we find a live one we
                // can say this whole group is ok.  
                while($row = mysql_fetch_row($result))
                  {
                    $member = $row[1].'_'.$row[0];
                    if(!in_array($member,$dead))
                      {
                        $livin = true;
                      }
                  }
                // If none of the group members are alive, the whole group is
                // dead.
                if(!$livin) 
                  {
                    $groups[$key]['dead'] = true;
                    $groupdeaths++;
                  }
              }
              // Are all the groups totally dead?
              if($groupdeaths == count($groups))
                {
                  // If they're all dead, then the children must die!
                  // Mwa hah hah ha... Ahem.
                  $children = breakDown($children,'children');
                  $scenario = mergeScenario($scenario,runScenario($children));
                }
              else
                {
                  // The kiddies might still have a chance at life.
                  // We know that the dead thing is part of a group
                  // and that at least one of the groups are still alive and 
                  // covering for it. What we don't know is if the groups that 
                  // are still alive are covering for this thing's children.
                  // Let's ask the kids and find out.
                  $killem = array();
                  foreach($children as $kid)
                    {
                      // Get the parents as groups and singles.
                      $groupparents = groupCombine(breakDown(getParents($kid['type'],$kid['id']),'parents'));
                      
                      // Now see if the groups who are still alive are covering
                      // for this kid.
                      foreach($groups as $group)
                        {
                          $gname = 'group_'.$group['id'];
                          if(in_array($gname,$groupparents) && $group['dead'])
                            {
                               // The group does cover for this kid, but the 
                               // group is dead.  If the group is dead, the kid
                               // must also perish.
                               $killem[] = $kid;
                            }
                          elseif(in_array($gname,$groupparents))
                            {
                               // We've tried and tried to do in this 
                               // little brat, but the group that the dead
                               // parent is in is still alive and covering
                               // for this little guy.
                               // Saved by the group, Hallelujah!
                               $scenario['saved'][] = $kid['type'].'_'.$kid['id'];
                            }
                        }
                    }
                   
                   if(count($killem))
                    {
                      // Dirty deeds, done dirt cheap.
                      $killem = breakDown($killem,'children');
                      $scenario = mergeScenario($scenario,runScenario($killem));              
                    }
                } // End if all groups are not dead.
            
             } // End if groups exist. 
          } // End if children.  
      } // End Foreach
      $scenario['dead'] = array_unique($scenario['dead']);
      $scenario['saved'] = array_unique($scenario['saved']);
      
      // Even if they've been saved before, if they're dead now, they're still dead.
      foreach($scenario['saved'] as $key => $prospect)
        {
          if(in_array($prospect,$dead))
            {
              unset($scenario['saved'][$key]);
            }
        }
        
      //echo '<br>Returning: ';print_r($scenario);
      return $scenario;
  }
      
     

function cleanOrphans($verbose = false) 
  {
    // This function is a quick and dirty way to get rid of all resources in the database who do 
    // not have a parent.  It's dirty because all it does is run over and over until there are no
    // results, and there are a ton of queries.  If there are a lot of records, it might take awhile.  
    // If it finds no orphans, it returns 0.  If it found some, it returns how many.
    
    // This function really should be optimized sometime in the future, if possible.
    // Some queries could probably be combined.
    
    // All the types to check.  We don't check boxes or devices because they can't be orphans.
    $types = array('server','application','service','database');
    $foundorphan = 0;
    foreach($types as $type)
      {
        if($verbose) echo 'Checking For '.ucwords($type).' Orphans';
        $query = 'SELECT '.$type.'_id FROM tbl_'.$type;
        $result = mysql_query($query);
        while($row = mysql_fetch_row($result))
          {
            if($verbose) echo '.';
            $query = 'SELECT p_id, p_table FROM tbl_dep WHERE c_id = '.$row[0].' AND c_table = \''.$type.'\'';
            //echo '<br />'.$query;
            $depresult = mysql_query($query);
            if(mysql_num_rows($depresult) == 0)
              {
                $query = 'DELETE FROM tbl_'.$type.' WHERE '.$type.'_id = '.$row[0];
                //echo '<br />'.$query;
                mysql_query($query);
                if($verbose) echo '<br />Orphan '.$type.'_'.$row[0].' Found and Deleted<br />';
                $foundorphan++;
              }
          }
        echo '<br />';
      }
    if($foundorphan)
      $foundorphan = $foundorphan + cleanOrphans();
    else
      {
        echo 'Done.<br />';
        return $foundorphan;
      } 
  }

function checkGroups($verbose = false)
  {
    // This function runs through all the groups in the databse and ensures
    // they have integrity.  We check that there are no single member groups,
    // and that all listed group members actually exist.
    
    $error = false;
    
    // Find any groups with only one member.
    if($verbose) echo 'Checking for single member groups....';
    $query = 'SELECT group_id, name, count(*) AS n FROM tbl_group GROUP BY group_id HAVING n < 2';
    $result = mysql_query($query);
    if(mysql_num_rows($result) != 0)
      {
        // We have singles.  Delete them without mercy!
        if($verbose) echo 'Found!';
        while($row = mysq_fetch_row($result))
          {
            $query = "DELETE FROM tbl_group WHERE group_id = ".$row[0];
            mysql_query($query);
            $message = 'Single member group found: '.$row[1].' | Deleted';
            $error .= $message."<br />";
            writeLog('error',$message);
            if($verbose) echo '<br /><span id="warning">'.$message.'</span><br />';
          }
      }
    else
      {
        if($verbose) echo 'None Found.<br />';
      }
    
    // Check that all group members exist
    if($verbose) echo 'Checking that all group members exist';
    $query = "SELECT mtype,mid,name FROM tbl_group";
    $result = mysql_query($query);
    while($row = mysql_fetch_row($result))
      {
        if($verbose) echo '.';
        $query = 'SELECT name FROM tbl_'.$row[0].' WHERE '.$row[0].'_id = '.$row[1];
        $checkresult = mysql_query($query);
        if(mysql_num_rows($checkresult) != 1)
          {
            $query = 'DELETE FROM tbl_group WHERE mid = '.$row[1].' AND mtype = \''.$row[0].'\'';
            mysql_query($query);
            $message = 'Missing group member found: '.$row[0].'_'.$row[1].' | Deleted from group: '.$row[2];
            $error .= $message."<br />";
            writeLog('error',$message);
            if($verbose) echo '<br /><span id="warning">'.$message.'</span><br />';
          }
      }
    if($verbose) echo 'Done<br />';
    return $error;
     
  }
function checkDBRelationships($verbose = false)
  {
    // This function checks the databases and dependencies for consistency and
    // ensures that all the relationships and children numbers are correct.
    // It checks to ensure that there are no double lineage problems, and that
    // every child is accounted for in the parent numchildren field.  
    // It makes sure that every resource other than a box or device has 
    // parents that are of the proper type.  It also checks that each entry in the
    // dependency table has a corresponding parent and child. Any errors are recorded and
    // will be, if possible, automatically corrected.  If not, an error report
    // will be generated that details what the problem is and how it should be
    // fixed by the user.
    
    $types = array('device','server','service','database','box','application');
    $error = false;
    foreach($types as $type)
      {
        // Check for valid parents
        if($err = checkGoodParents($type,$verbose))
          $error .= $err;
           
        // Check for double parentage.
        if($err = checkDoubleParents($type,$verbose))
          $error .= $err; 
          
        // Check number of children
        if($err = verifyChildren($type,$verbose))
          $error .= $err;     
      }
    
    // Check that all dependencies exist
    if($err = checkGoodDependencies($verbose))
    $error .= $err;
    
    if($verbose) echo 'Relationship checks complete.<br />';  
    return $error;            
  }

function checkGoodDependencies($verbose = false)
  {
    // Checks all entries in the dependency table and verifies that they actually
    // have matching records in the related resource table.
    if($verbose) echo 'Checking For Non-Existing Dependants';
    $error = false;
    $query = "SELECT * FROM tbl_dep";
    $result = mysql_query($query);
    $types = array();
    while($row = mysql_fetch_assoc($result))
      {
        echo '.';
        $cid = $row['c_id'];
        $pid = $row['p_id'];
        $ctype = $row['c_table'];
        $ptype = $row['p_table'];
        $query = 'SELECT name FROM tbl_'.$ctype.' WHERE '.$ctype.'_id = '.$cid;
        $chk = mysql_query($query);
        if(mysql_num_rows($chk) == 0)
          {
              $query = 'DELETE FROM tbl_dep WHERE c_table = \''.$ctype.'\' AND c_id = '.$cid;
              mysql_query($query); 
              $types[] = $ctype;
              $message = 'Dependency Found for Non-Existant Resource: '.$ctype.'_'.$cid.' - Relationship removed.';
              $error .= $message."<br />";
              writeLog('error',$message);
              if($verbose) echo '<br /><span id="warning">'.$message.'</span><br />';
          }
        $query = 'SELECT name FROM tbl_'.$ptype.' WHERE '.$ptype.'_id = '.$pid;
        $chk = mysql_query($query);
        if(mysql_num_rows($chk) == 0)
          {
              $query = 'DELETE FROM tbl_dep WHERE p_table = \''.$ptype.'\' AND p_id = '.$pid;
              echo '<br>'.$query;
              $types[] = $ptype; 
              $message = 'Dependency Found for Non-Existant Resource: '.$ptype.'_'.$pid.' - Relationship removed.';
              $error .= $message."<br />";
              writeLog('error',$message);
              if($verbose) echo '<br /><span id="warning">'.$message.'</span><br />';
          }
        
      }
      if($error)
        {
          $types = array_unique($types);
          foreach($types as $type)
            {
              verifyChildren($type,$verbose);
            }
        }
      if($verbose) echo 'Done<br />';
      return $error;
  }
function checkGoodParents($type,$verbose = false)
{
        // Takes the type of resource and checks each of those types
        // to ensure that they have the correct types of parents.
        if($verbose) echo 'Checking '.ucwords($type).' Parent Types';
        $error = false;
        $mainquery = 'SELECT '.$type.'_id, name, children FROM tbl_'.$type;
        $mainresult = mysql_query($mainquery);
        $goodp = array();
        switch($type)
          {
            case 'box':
            $goodp = array('device');
            break;
            case 'device':
            $goodp = array('device','server','service','database','box');
            break;
            case 'server':
            $goodp = array('device','server','box');
            break;
            case 'service':
            $goodp = array('device','server','service','database');
            break;
            case 'database':
            $goodp = array('device','server','service');
            break;
            case 'application':
            $goodp = array('device','service','database');
          }
        while($mainrow = mysql_fetch_row($mainresult))
          {
            if($verbose) echo '.';
            // Check that parents of this thing are the correct type(s)
            $parents = getParents($type,$mainrow[0]);
            if(is_array($parents))
            foreach($parents as $parent)
              {
                if(!in_array($parent['type'],$goodp))
                  {
                    // The current parent of this resource is NOT in the
                    // good parents array for this type of resource.  This is 
                    // NOT GOOD.  Generate an error and log it to file.
                    $message = 'Incorrect parent type found for resource: '.$type.'_'.$mainrow[0].' - '.$mainrow[1];
                    $error .= $message."<br />";
                    writeLog('error',$message);
                    if($verbose) echo '<br /><span id="warning">'.$message.'</span><br />';
                  }
              }
          }
      if($verbose) echo 'Done<br />';
      return $error;
}

function checkDoubleParents($type,$verbose = false)
{
        $error = false;
        if($verbose) echo 'Checking '.ucwords($type).' Double Lineage';
        $mainquery = 'SELECT '.$type.'_id, name, children FROM tbl_'.$type;
        $mainresult = mysql_query($mainquery);
        while($mainrow = mysql_fetch_row($mainresult))
          {  
             if($verbose) echo '.';
             $parents = breakDown(getParentsRecursive($type,$mainrow[0]),'parents');
             //echo '<br>'.$mainrow[1].': ';print_r($parents);
             if(count(array_unique($parents) < count($parents)))
              {
                // We may have found a problem.  There is a parent listed twice, which means
                // it's doubled up somewhere.  Let's pull it out and find out more.
                // We only care about doubles where one is a DIRECT parent of this thing.
                // If all doubles (or multiples) are higher than that we can 
                // ignore them because having the same parent twice is ok so long
                // as they aren't in DIRECT lineage.
                $doubles = array();
                natcasesort($parents);
                reset($parents);
                $old_key = '';
                $old_value = '';
                foreach($parents as $key=>$value)
                  {
                    if($value == $old_value)
                      {
                        //$doubles[$old_key] = $old_value;
                        $doubles[$key] = $value;
                      }
                    $old_value = $value;
                    $old_key = $key;
                  }
                
                // Now we need to go and check if any of the doubles are a 
                // direct parent.  If so, we move on to the next step, if not,
                // we can ignore it.
                $dparents = breakDown(getParents($type,$mainrow[0]),'parents');
                $dpdoubles = array_intersect($doubles,$dparents);
                //echo '<br>'.$mainrow[1].': ';print_r($dpdoubles);
                if(count($dpdoubles))
                  {    
                    $message = 'Duplicate parentage found for resource: '.$type.'_'.$mainrow[0].' - '.$mainrow[1];
                    foreach($dpdoubles as $dpd)
                      {
                        $message .= ' | '.$dpd;
                      }
                    $error .= $message."<br />";
                    writeLog('error',$message);
                    if($verbose) echo '<br /><span id="warning">'.$message.'</span><br />';
                  }
     
              }
          }
      if($verbose) echo 'Done<br />';
      return $error;
}

function verifyChildren($type,$verbose = false)
  {
        $error = false;
        if($verbose) echo 'Checking '.ucwords($type).' Children';
        $mainquery = 'SELECT '.$type.'_id, name, children FROM tbl_'.$type;
        $mainresult = mysql_query($mainquery);
        
        // Now we check to make sure that the numchildren attribute of this thing
        // is correct.  Shouldn't be too hard, just get all the children and count
        // them up.
        if(mysql_num_rows($mainresult)) 
        {
            @mysql_data_seek($mainresult,0);
            while($mainrow = mysql_fetch_row($mainresult))
              {
                  $children = breakDown(getChildrenRecursive($type,$mainrow[0]),'children');
                  $numchildren = count($children);
                  
                  if($numchildren != $mainrow[2])
                    {
                      // The number of children field is incorrect!  We should update it and write an
                      // error report.
                      $query = 'UPDATE tbl_'.$type.' SET children = '.$numchildren.' WHERE '.$type.'_id = '.$mainrow[0];
                      mysql_query($query);
                      $message = 'Note: Incorrect number of children for resource: '.$type.'_'.$mainrow[0].' - '.$mainrow[1].' | Children Updated';
                      $error .= $message."<br />";
                      writeLog('error',$message);
                      if($verbose) echo '<br />'.$message.'<br />';
                    }
                  elseif($verbose) echo '.';
              }
        }
      if($verbose) echo 'Done<br />';
      return $error;
    }

function writeLog($type,$message)
  {
    global $rootdir;
    if($type = 'error');
      {
        $logfile = $_SERVER['DOCUMENT_ROOT'].$rootdir.'/logs/errorlogs/'.date('Ymd').'.txt';
      }
    if(!$fp = fopen($logfile,'a+'))
      {
        echo '<span id="warning">COULD NOT OPEN ERRORLOG FOR WRITING. THE FOLLOWING ERROR WAS FOUND: '.$message.'</span>';
      }
    fwrite($fp,$message."\n");
    fclose($fp);
  }
  
function createPDFReport($reportdata,$title = 'BaconMapReport',$fontsize=10)
  {
    
      class PDF extends FPDF
      {
        //Page header
        function Header()
        {
            global $rootdir;
            //Logo
            $this->Image($_SERVER['DOCUMENT_ROOT'].$rootdir.'/images/baconmap2.jpg',10,8,50);
            //Arial bold 15
            $this->SetFont('Arial','B',15);
            //Move to the right
            $this->Cell(50);
            //Title
            $title = $this->title;
            $width = (strlen($title)*2.8);
            $this->Cell($width,10,$title,'B',0,'C');
            //Line break
            $this->Ln(20);
        }
          
        //Page footer
        function Footer()
        {
            //Position at 1.5 cm from bottom
            $this->SetY(-15);
            //Arial italic 8
            $this->SetFont('Arial','I',8);
            //Page number
            $ftext = 'Report Generated by BaconMap - www.baconmap.org          Page '.$this->PageNo().'/{nb}';
            $this->Cell(0,10,$ftext,0,0,'C');
        }
        
        function DoSection($section,$subnumber,$pagewidth,$defaultfontsize)
	  	{
	     // This is the section handler function for PDF Reports
	       // Set up fonts
	       $largefont = $defaultfontsize;
	       $smallfont = $defaultfontsize - 1;
	       $maximumfieldsize = 75;
	            
	       // Indent for subsections
	       if($subnumber)
	       $this->Cell($subnumber*10);
	
	       // Get Max Length
	       $maxlength = array();
	       $maxlength[0] = '';
	       $fontsize = $smallfont - $subnumber;
	       $this->SetFont('Times','',$fontsize);
	       //print_r($section['data']);
	       if(isset($section['data']))
	       foreach($section['data'] as $linenum => $line)
	         {
	         	$i = 0;
	           foreach($line as $colnum => $col)
	             {
	               if(!is_array($col)) // If it is an array, it is a sub, and we ignore it.
	               {	             	
	               if(!isset($maxlength[$i]) || $maxlength[$i] <= $this->GetStringWidth($col))
	                 {
	                    if($this->GetStringWidth($col) > $maximumfieldsize)
	                      {
	                        // This field breaks the mold.  Trim it down so it doesn't overflow.
	                        $section['data'][$linenum][$colnum] = substr($col,0,$maximumfieldsize);
	                        $maxlength[$i] = 75;
	                      }
	                     else
	                       {
	                         $maxlength[$i] = $this->GetStringWidth($col);
	                       }
	                  }
	                $i++;
	                }
	              }
	         }
	         $i = 0;
	         $fontsize = $largefont - $subnumber;
	         $this->SetFont('Arial','',$fontsize);  
	         //print_r($maxlength);
	         
	         foreach($section['header'] as $key => $head)
	           {
	             if($maxlength[$i] < $this->GetStringWidth($head))
	                $maxlength[$i] = $this->GetStringWidth($head);
	             $i++;
	           }
	         $i = 0;
	                
	         // Max lengths are all figured out.  Now we need to distribute
	         // the columns evenly across the page based on that.
	         // To do so, we take the total page width, subtract the sum of 
	         // all the maxwidths, divide by the number of columns, and add the
	         // resulting number to each column as additional space.
	         $totalmax = array_sum($maxlength);
	         $pagewidth = $pagewidth - ($subnumber*20);
	         if($totalmax > $pagewidth)
	           {
	             echo "Error... report data too large";
	           }
	         $leftover = $pagewidth - $totalmax;
	         $addtoeach = $leftover / count($section['header']);
	         foreach($maxlength as $key => $value)
	           {
	             $maxlength[$key] = $value+$addtoeach;
	           }
	              
	         // Set font according to subsection depth
	         $fontsize = $largefont - $subnumber;
	         $this->SetFont('Arial','',$fontsize);  
	         foreach($section['header'] as $head)
	           {
	             $this->Cell($maxlength[$i],5,$head,'B',0);
	             $i++;
	           }              
	         $this->Ln(5);
	         // Indent for subsections
	         if($subnumber)
	         $this->Cell($subnumber*10);
	              
	         if(isset($section['data']))
	         foreach($section['data'] as $line)
	           {
	             $i = 0;
	             $fontsize = $smallfont - $subnumber;
	             $this->SetFont('Times','',$fontsize);
	             foreach($line as $col)
	               {
	                 // If it's an array, then it's a subsection
	                 if(!is_array($col))
	                   {
	                     $this->Cell($maxlength[$i],6,$col,0,0);    
	                     $i++;
	                   }
	               }
	             $this->Ln(4);
	             // Indent for subsections
	             if($subnumber)
	             $this->Cell($subnumber*10);
	             
	             // Check for subsection
	             if(isset($line['sub']))
	               {
	                 $this->Ln(2);
	                 foreach($line['sub'] as $sub)
	                 {
	                   $this->DoSection($sub,$subnumber+1,$pagewidth,$defaultfontsize);
	                 }
	               }
	           }
	            
	       $this->Ln(6);
	   }
	  }

      $pdf=new PDF();
      $pdf->AliasNbPages();
      $pdf->SetTitle($reportdata[0]);
      $pdf->AddPage();
      $pagewidth = $pdf->w - 20;
      foreach($reportdata as $key => $section)
        {
          if($key != 0)
            {
              $pdf->DoSection($section,0,$pagewidth,$fontsize);
            }
        }
          
      header('Content-type: application/pdf');
      header('Content-Disposition: attachment; filename="'.$title.'.pdf"');
    
      $pdf->Output($title.'.pdf','D');
  }

function createExcelReport($reportdata)
  {
  
  }

// User authorization
function authorize($level,$redir="index.php")
  {
   global $rootdir;
   mysql_query("delete from tbl_session where date < '".date("Y-m-d G:i:s",time()-3600)."';"); // delete all sessions idle for more than an hour
   $query="select level from tbl_session where sessionid='".$_SESSION['baconid']."'"; // Get the currently logged user`s privilege level
   $result = mysql_query($query) or die("Could not select: $query<BR>error:".mysql_error());
   if($row = mysql_fetch_row($result))
    {
      if($row[0]>$level)
        { // The user does not have required privilege
          header("Location: $rootdir/login.php?error=Not%20enough%20privileges.%20Please%20login%20as%20an%20admin.&redir=$rootdir/$redir");
        }
      mysql_query("update tbl_session set date='".date("Y-m-d G:i:s")."' where sessionid='".$_SESSION["baconid"]."';");
      $_SESSION['level'] = $row[0]; // Refresh login
    }
   else
    { // session expired
      header("Location: $rootdir/login.php?error=You%20are%20not%20currently%20logged%20in.%20Please%20login.&redir=$rootdir/$redir");
    }
   // refresh the session
   // session_write_close();
}
?>
